/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.components.impl;

import es.bsc.compss.api.TaskMonitor;
import es.bsc.compss.components.impl.DataInfoProvider;
import es.bsc.compss.components.monitor.impl.EdgeType;
import es.bsc.compss.components.monitor.impl.GraphGenerator;
import es.bsc.compss.types.AbstractTask;
import es.bsc.compss.types.CommutativeGroupTask;
import es.bsc.compss.types.CommutativeIdentifier;
import es.bsc.compss.types.Task;
import es.bsc.compss.types.TaskDescription;
import es.bsc.compss.types.TaskGroup;
import es.bsc.compss.types.TaskState;
import es.bsc.compss.types.annotations.parameter.DataType;
import es.bsc.compss.types.annotations.parameter.OnFailure;
import es.bsc.compss.types.data.DataAccessId;
import es.bsc.compss.types.data.DataInfo;
import es.bsc.compss.types.data.DataInstanceId;
import es.bsc.compss.types.data.accessid.RAccessId;
import es.bsc.compss.types.data.accessid.RWAccessId;
import es.bsc.compss.types.data.accessid.WAccessId;
import es.bsc.compss.types.data.accessparams.AccessParams;
import es.bsc.compss.types.data.operation.ResultListener;
import es.bsc.compss.types.implementations.TaskType;
import es.bsc.compss.types.parameter.BindingObjectParameter;
import es.bsc.compss.types.parameter.CollectionParameter;
import es.bsc.compss.types.parameter.DependencyParameter;
import es.bsc.compss.types.parameter.ExternalPSCOParameter;
import es.bsc.compss.types.parameter.ExternalStreamParameter;
import es.bsc.compss.types.parameter.FileParameter;
import es.bsc.compss.types.parameter.ObjectParameter;
import es.bsc.compss.types.parameter.Parameter;
import es.bsc.compss.types.parameter.StreamParameter;
import es.bsc.compss.types.request.ap.BarrierGroupRequest;
import es.bsc.compss.types.request.ap.BarrierRequest;
import es.bsc.compss.types.request.ap.CancelApplicationTasksRequest;
import es.bsc.compss.types.request.ap.EndOfAppRequest;
import es.bsc.compss.types.request.ap.WaitForConcurrentRequest;
import es.bsc.compss.types.request.ap.WaitForTaskRequest;
import es.bsc.compss.util.ErrorManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.Semaphore;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import storage.StubItf;

public class TaskAnalyser {
    private static final Logger LOGGER = LogManager.getLogger("es.bsc.compss.Components.TaskProcessor.TaskAnalyser");
    private static final boolean DEBUG = LOGGER.isDebugEnabled();
    private static final String TASK_FAILED = "Task failed: ";
    private static final String TASK_CANCELED = "Task canceled: ";
    private DataInfoProvider dip;
    private GraphGenerator gm;
    private Map<Integer, WritersInfo> writers;
    private Map<Integer, Integer> currentTaskCount = new HashMap<Integer, Integer>();
    private Map<Long, Integer> appIdToTotalTaskCount;
    private Map<Long, Integer> appIdToTaskCount;
    private Map<Long, Semaphore> appIdToSemaphore;
    private Set<Long> appIdBarrierFlags;
    private Map<Long, Set<Integer>> appIdToWrittenFiles;
    private Map<Long, Set<Integer>> appIdToSCOWrittenIds;
    private Hashtable<AbstractTask, List<Semaphore>> waitedTasks;
    private Map<Integer, List<Task>> concurrentAccessMap;
    private Map<String, CommutativeGroupTask> commutativeGroup;
    private Map<String, LinkedList<Task>> pendingToDrawCommutative;
    private Map<Long, TreeMap<String, TaskGroup>> taskGroups;
    private Map<Long, Stack<TaskGroup>> currentTaskGroups;
    private static final boolean IS_DRAW_GRAPH = GraphGenerator.isEnabled();
    private int synchronizationId = 0;
    private boolean taskDetectedAfterSync = false;

    public TaskAnalyser() {
        this.writers = new TreeMap<Integer, WritersInfo>();
        this.appIdToTaskCount = new HashMap<Long, Integer>();
        this.appIdToTotalTaskCount = new HashMap<Long, Integer>();
        this.appIdToSemaphore = new HashMap<Long, Semaphore>();
        this.appIdBarrierFlags = new HashSet<Long>();
        this.appIdToWrittenFiles = new HashMap<Long, Set<Integer>>();
        this.appIdToSCOWrittenIds = new HashMap<Long, Set<Integer>>();
        this.waitedTasks = new Hashtable();
        this.concurrentAccessMap = new TreeMap<Integer, List<Task>>();
        this.commutativeGroup = new TreeMap<String, CommutativeGroupTask>();
        this.pendingToDrawCommutative = new TreeMap<String, LinkedList<Task>>();
        this.currentTaskGroups = new HashMap<Long, Stack<TaskGroup>>();
        this.taskGroups = new HashMap<Long, TreeMap<String, TaskGroup>>();
        LOGGER.info("Initialization finished");
    }

    public void setCoWorkers(DataInfoProvider dip) {
        this.dip = dip;
    }

    public void setGM(GraphGenerator gm) {
        this.gm = gm;
        if (IS_DRAW_GRAPH) {
            this.gm.addSynchroToGraph(0);
        }
    }

    public void processTask(Task currentTask) {
        Integer methodId;
        Integer actualCount;
        TaskDescription params = currentTask.getTaskDescription();
        LOGGER.info("New " + (params.getType() == TaskType.METHOD ? "method" : "service") + " task(" + params.getName() + "), ID = " + currentTask.getId());
        if (IS_DRAW_GRAPH) {
            this.addNewTask(currentTask);
        }
        if ((actualCount = this.currentTaskCount.get(methodId = Integer.valueOf(params.getCoreElement().getCoreId()))) == null) {
            actualCount = 0;
        }
        this.currentTaskCount.put(methodId, actualCount + 1);
        Long appId = currentTask.getAppId();
        Integer taskCount = this.appIdToTaskCount.get(appId);
        if (taskCount == null) {
            taskCount = 0;
        }
        Integer n = taskCount;
        Integer n2 = taskCount = Integer.valueOf(taskCount + 1);
        this.appIdToTaskCount.put(appId, taskCount);
        Integer totalTaskCount = this.appIdToTotalTaskCount.get(appId);
        if (totalTaskCount == null) {
            totalTaskCount = 0;
        }
        n2 = totalTaskCount;
        Integer n3 = totalTaskCount = Integer.valueOf(totalTaskCount + 1);
        this.appIdToTotalTaskCount.put(appId, totalTaskCount);
        int constrainingParam = -1;
        if (params.getType() == TaskType.SERVICE && params.hasTargetObject()) {
            constrainingParam = params.getParameters().size() - 1 - params.getNumReturns();
        }
        if (!this.applicationHasGroups(currentTask.getAppId())) {
            this.setCurrentTaskGroup("App" + currentTask.getAppId(), true, currentTask.getAppId());
        }
        for (TaskGroup nextGroup : this.currentTaskGroups.get(currentTask.getAppId())) {
            currentTask.setTaskGroup(nextGroup);
            nextGroup.addTask(currentTask);
        }
        List<Parameter> parameters = params.getParameters();
        boolean taskHasEdge = false;
        for (int paramIdx = 0; paramIdx < parameters.size(); ++paramIdx) {
            boolean isConstraining = paramIdx == constrainingParam;
            boolean paramHasEdge = this.registerParameterAccessAndAddDependencies(currentTask, parameters.get(paramIdx), isConstraining);
            taskHasEdge = taskHasEdge || paramHasEdge;
        }
        if (IS_DRAW_GRAPH && !taskHasEdge) {
            this.addEdgeFromMainToTask(currentTask);
        }
    }

    public void findWaitedTask(WaitForTaskRequest request) {
        int dataId = request.getDataId();
        AccessParams.AccessMode am = request.getAccessMode();
        Semaphore sem = request.getSemaphore();
        WritersInfo wi = this.writers.get(dataId);
        if (wi != null) {
            switch (wi.getDataType()) {
                case STREAM_T: 
                case EXTERNAL_STREAM_T: {
                    List<AbstractTask> lastStreamWriters = wi.getStreamWriters();
                    for (AbstractTask lastWriter : lastStreamWriters) {
                        this.treatDataAccess(lastWriter, am, dataId);
                    }
                    sem.release();
                    break;
                }
                default: {
                    AbstractTask lastWriter = wi.getDataWriter();
                    if (lastWriter != null) {
                        this.treatDataAccess(lastWriter, am, dataId);
                    }
                    if (lastWriter == null || lastWriter.getStatus() == TaskState.FINISHED || lastWriter.getStatus() == TaskState.CANCELED || lastWriter.getStatus() == TaskState.FAILED) {
                        sem.release();
                        break;
                    }
                    List<Semaphore> list = this.waitedTasks.get(lastWriter);
                    if (list == null) {
                        list = new LinkedList<Semaphore>();
                    }
                    list.add(sem);
                    this.waitedTasks.put(lastWriter, list);
                    break;
                }
            }
        } else {
            sem.release();
        }
    }

    public void endTask(AbstractTask aTask) {
        int taskId = aTask.getId();
        if (aTask instanceof Task) {
            List<Semaphore> sems;
            Task task = (Task)aTask;
            boolean isFree = task.isFree();
            TaskState taskState = task.getStatus();
            OnFailure onFailure = task.getOnFailure();
            LOGGER.info("Notification received for task " + taskId + " with end status " + (Object)((Object)taskState));
            if (!isFree) {
                LOGGER.debug("Task " + taskId + " is not registered as free. Waiting for other executions to end");
                return;
            }
            TaskMonitor registeredMonitor = task.getTaskMonitor();
            switch (taskState) {
                case FAILED: {
                    registeredMonitor.onFailure();
                    if (onFailure == OnFailure.RETRY || onFailure == OnFailure.FAIL) {
                        ErrorManager.error(TASK_FAILED + task);
                        return;
                    }
                    if (onFailure != OnFailure.IGNORE && onFailure != OnFailure.CANCEL_SUCCESSORS) break;
                    ErrorManager.warn(TASK_FAILED + task);
                    break;
                }
                case CANCELED: {
                    registeredMonitor.onCancellation();
                    ErrorManager.warn(TASK_CANCELED + task);
                    break;
                }
                default: {
                    registeredMonitor.onCompletion();
                }
            }
            if (DEBUG) {
                LOGGER.debug("Freeing barriers for task " + taskId);
                LOGGER.debug("Ending task " + taskId);
            }
            Long appId = task.getAppId();
            Integer taskCount = this.appIdToTaskCount.get(appId) - 1;
            this.appIdToTaskCount.put(appId, taskCount);
            if (taskCount == 0) {
                this.appIdBarrierFlags.remove(appId);
                Semaphore sem = this.appIdToSemaphore.remove(appId);
                if (sem != null) {
                    this.appIdToTaskCount.remove(appId);
                    sem.release();
                }
            }
            if (DEBUG) {
                LOGGER.debug("Releasing waiting tasks for task " + taskId);
            }
            if ((sems = this.waitedTasks.remove(task)) != null) {
                for (Semaphore sem : sems) {
                    sem.release();
                }
            }
            if (DEBUG) {
                LOGGER.debug("Marking accessed parameters for task " + taskId);
            }
            for (Parameter param : task.getTaskDescription().getParameters()) {
                this.updateParameterAccess(task, param);
                this.updateLastWritters(task, param);
            }
            if (DEBUG) {
                LOGGER.debug("Checking result file transfers for task " + taskId);
            }
            if (this.appIdToSemaphore.get(appId) != null && !this.appIdBarrierFlags.contains(appId)) {
                this.checkResultFileTransfer(task);
            }
            this.releaseTaskGroups(task);
            this.releaseCommutativeGroups(task);
        }
        if (DEBUG) {
            LOGGER.debug("Releasing data dependant tasks for task " + taskId);
        }
        aTask.releaseDataDependents();
    }

    public String getTaskStateRequest() {
        StringBuilder sb = new StringBuilder("\t").append("<TasksInfo>").append("\n");
        for (Map.Entry<Long, Integer> e : this.appIdToTotalTaskCount.entrySet()) {
            Long appId = e.getKey();
            Integer totalTaskCount = e.getValue();
            Integer taskCount = this.appIdToTaskCount.get(appId);
            if (taskCount == null) {
                taskCount = 0;
            }
            int completed = totalTaskCount - taskCount;
            sb.append("\t\t").append("<Application id=\"").append(appId).append("\">").append("\n");
            sb.append("\t\t\t").append("<TotalCount>").append(totalTaskCount).append("</TotalCount>").append("\n");
            sb.append("\t\t\t").append("<InProgress>").append(taskCount).append("</InProgress>").append("\n");
            sb.append("\t\t\t").append("<Completed>").append(completed).append("</Completed>").append("\n");
            sb.append("\t\t").append("</Application>").append("\n");
        }
        sb.append("\t").append("</TasksInfo>").append("\n");
        return sb.toString();
    }

    public void barrier(BarrierRequest request) {
        Long appId = request.getAppId();
        Integer count = this.appIdToTaskCount.get(appId);
        if (IS_DRAW_GRAPH) {
            this.addMissingCommutativeTasksToGraph();
            this.addNewBarrier();
            this.gm.commitGraph();
        }
        if (count == null || count == 0) {
            request.getSemaphore().release();
        } else {
            this.appIdBarrierFlags.add(appId);
            this.appIdToSemaphore.put(appId, request.getSemaphore());
        }
    }

    public void noMoreTasks(EndOfAppRequest request) {
        Long appId = request.getAppId();
        Integer count = this.appIdToTaskCount.get(appId);
        if (IS_DRAW_GRAPH) {
            this.addMissingCommutativeTasksToGraph();
            this.gm.commitGraph();
        }
        if (count == null || count == 0) {
            this.appIdToTaskCount.remove(appId);
            request.getSemaphore().release();
        } else {
            this.appIdToSemaphore.put(appId, request.getSemaphore());
        }
    }

    public void deleteData(DataInfo dataInfo) {
        block8: {
            int dataId;
            block7: {
                dataId = dataInfo.getDataId();
                LOGGER.info("Deleting data " + dataId);
                WritersInfo wi = this.writers.remove(dataId);
                if (wi == null) break block7;
                switch (wi.getDataType()) {
                    case STREAM_T: 
                    case EXTERNAL_STREAM_T: {
                        break;
                    }
                    case FILE_T: {
                        for (Set<Integer> files : this.appIdToWrittenFiles.values()) {
                            if (!files.remove(dataId)) continue;
                            LOGGER.info(" Removed data " + dataId + " from written files");
                        }
                        break block8;
                    }
                    case PSCO_T: {
                        for (Set<Integer> pscos : this.appIdToSCOWrittenIds.values()) {
                            if (!pscos.remove(dataId)) continue;
                            LOGGER.info(" Removed data " + dataId + " from written pscos");
                        }
                        break block8;
                    }
                }
                break block8;
            }
            LOGGER.warn("Writters info for data " + dataId + " not found.");
        }
    }

    public boolean applicationHasGroups(Long appId) {
        return this.currentTaskGroups.containsKey(appId);
    }

    public void cancelApplicationTasks(CancelApplicationTasksRequest request) {
        LOGGER.debug("Cancelling tasks of application " + request.getAppId());
        Semaphore sem = request.getSemaphore();
        Long appId = request.getAppId();
        String groupName = "App" + appId;
        if (this.taskGroups.containsKey(appId) && this.taskGroups.get(appId).containsKey(groupName)) {
            TaskGroup tg = this.taskGroups.get(appId).get(groupName);
            tg.cancelTasks();
            this.taskGroups.remove(appId);
        }
        sem.release();
    }

    public Set<Integer> getAndRemoveWrittenFiles(Long appId) {
        return this.appIdToWrittenFiles.remove(appId);
    }

    public void shutdown() {
        if (IS_DRAW_GRAPH) {
            GraphGenerator.removeTemporaryGraph();
        }
    }

    public boolean dataWasAccessedConcurrent(int daId) {
        List<Task> concurrentAccess = this.concurrentAccessMap.get(daId);
        return concurrentAccess != null;
    }

    public void findWaitedConcurrent(WaitForConcurrentRequest request) {
        int dataId = request.getDataId();
        AccessParams.AccessMode am = request.getAccessMode();
        List<Task> concurrentAccess = this.concurrentAccessMap.get(dataId);
        if (concurrentAccess != null) {
            this.concurrentAccessMap.put(dataId, null);
        }
        Semaphore semTasks = request.getTaskSemaphore();
        int n = 0;
        for (Task task : concurrentAccess) {
            this.treatDataAccess(task, am, dataId);
            if (task.getStatus() == TaskState.FINISHED) continue;
            ++n;
            List<Semaphore> list = this.waitedTasks.get(task);
            if (list == null) {
                list = new LinkedList<Semaphore>();
            }
            list.add(semTasks);
            this.waitedTasks.put(task, list);
        }
        request.setNumWaitedTasks(n);
        request.getSemaphore().release();
    }

    public void removeFromConcurrentAccess(int dataId) {
        List<Task> returnedValue = this.concurrentAccessMap.remove(dataId);
        if (returnedValue == null) {
            LOGGER.debug("The concurrent list could not be removed");
        }
    }

    public void setCurrentTaskGroup(String groupName, boolean barrier, Long appId) {
        LOGGER.debug("Adding group " + groupName + " to the current groups stack.");
        if (!this.currentTaskGroups.containsKey(appId)) {
            Stack currentTaskGroups = new Stack();
            this.currentTaskGroups.put(appId, currentTaskGroups);
        }
        TaskGroup tg = new TaskGroup(groupName, appId);
        this.currentTaskGroups.get(appId).push(tg);
        if (!this.taskGroups.containsKey(appId)) {
            TreeMap taskGroups = new TreeMap();
            this.taskGroups.put(appId, taskGroups);
        }
        this.taskGroups.get(appId).put(groupName, tg);
        if (IS_DRAW_GRAPH) {
            if (!tg.isAppGroup(appId)) {
                this.gm.addTaskGroupToGraph(tg.getName());
                LOGGER.debug("Group " + groupName + " added to graph");
            }
            tg.setGraphDrawn();
        }
    }

    public void closeCurrentTaskGroup(Long appId) {
        TaskGroup tg = this.currentTaskGroups.get(appId).pop();
        tg.setClosed();
        if (IS_DRAW_GRAPH) {
            this.gm.closeGroupInGraph();
        }
    }

    private void releaseTaskGroups(Task task) {
        for (TaskGroup group2 : task.getTaskGroupList()) {
            group2.removeTask(task);
            LOGGER.debug("Group " + group2.getName() + " released a task");
            if (group2.hasPendingTasks() || !group2.isClosed() || !group2.hasBarrier()) continue;
            group2.releaseBarrier();
            if (group2.getBarrierDrawn()) {
                this.taskGroups.get(task.getAppId()).remove(group2.getName());
                LOGGER.debug("All tasks of group " + group2.getName() + " have finished execution");
            }
            LOGGER.debug("All tasks of group " + group2.getName() + " have finished execution");
        }
    }

    private void releaseCommutativeGroups(Task task) {
        if (!task.getCommutativeGroupList().isEmpty()) {
            for (CommutativeGroupTask group2 : task.getCommutativeGroupList()) {
                group2.setStatus(TaskState.FINISHED);
                group2.removePredecessor(task);
                if (!group2.getPredecessors().isEmpty()) continue;
                group2.releaseDataDependents();
                List<Semaphore> sems = this.waitedTasks.remove(group2);
                if (sems != null) {
                    for (Semaphore sem : sems) {
                        sem.release();
                    }
                }
                if (!DEBUG) continue;
                LOGGER.debug("Group " + group2.getId() + " ended execution");
                LOGGER.debug("Data dependents of group " + group2.getCommutativeIdentifier() + " released ");
            }
        }
    }

    public void barrierGroup(BarrierGroupRequest request) {
        String groupName = request.getGroupName();
        Long appId = request.getAppId();
        TaskGroup tg = this.taskGroups.get(request.getAppId()).get(groupName);
        Integer count = this.appIdToTaskCount.get(appId);
        if (IS_DRAW_GRAPH) {
            this.addMissingCommutativeTasksToGraph();
            this.addNewGroupBarrier(tg);
            this.gm.commitGraph();
        }
        if (count == null || count == 0) {
            if (tg != null && !tg.hasPendingTasks()) {
                if (tg.hasException()) {
                    request.setException(tg.getException());
                }
                request.getSemaphore().release();
            } else {
                request.getSemaphore().release();
            }
        } else if (tg != null && !tg.hasPendingTasks()) {
            if (tg.hasException()) {
                request.setException(tg.getException());
            }
            request.getSemaphore().release();
        } else {
            tg.addBarrier(request);
        }
    }

    private void addMissingCommutativeTasksToGraph() {
        LinkedList<String> identifiers = new LinkedList<String>();
        for (String identifier : this.pendingToDrawCommutative.keySet()) {
            this.addCommutativeGroupTaskToGraph(identifier);
            identifiers.add(identifier);
        }
        for (String identifier : identifiers) {
            this.pendingToDrawCommutative.remove(identifier);
        }
    }

    private boolean registerParameterAccessAndAddDependencies(Task currentTask, Parameter p, boolean isConstraining) {
        DataAccessId daId;
        AccessParams.AccessMode am = AccessParams.AccessMode.R;
        switch (p.getDirection()) {
            case IN: {
                am = AccessParams.AccessMode.R;
                break;
            }
            case OUT: {
                am = AccessParams.AccessMode.W;
                break;
            }
            case INOUT: {
                am = AccessParams.AccessMode.RW;
                break;
            }
            case CONCURRENT: {
                am = AccessParams.AccessMode.C;
                break;
            }
            case COMMUTATIVE: {
                am = AccessParams.AccessMode.CV;
            }
        }
        DataAccessId firstRegistered = null;
        boolean hasParamEdge = false;
        switch (p.getType()) {
            case FILE_T: {
                FileParameter fp = (FileParameter)p;
                daId = this.dip.registerFileAccess(am, fp.getLocation());
                break;
            }
            case PSCO_T: {
                ObjectParameter pscop = (ObjectParameter)p;
                pscop.setType(DataType.PSCO_T);
                daId = this.dip.registerObjectAccess(am, pscop.getValue(), pscop.getCode());
                break;
            }
            case EXTERNAL_PSCO_T: {
                ExternalPSCOParameter externalPSCOparam = (ExternalPSCOParameter)p;
                externalPSCOparam.setType(DataType.EXTERNAL_PSCO_T);
                daId = this.dip.registerExternalPSCOAccess(am, externalPSCOparam.getId(), externalPSCOparam.getCode());
                break;
            }
            case BINDING_OBJECT_T: {
                BindingObjectParameter bindingObjectparam = (BindingObjectParameter)p;
                bindingObjectparam.setType(DataType.BINDING_OBJECT_T);
                daId = this.dip.registerBindingObjectAccess(am, bindingObjectparam.getBindingObject(), bindingObjectparam.getCode());
                break;
            }
            case OBJECT_T: {
                ObjectParameter op = (ObjectParameter)p;
                if (op.getValue() instanceof StubItf && ((StubItf)op.getValue()).getID() != null) {
                    op.setType(DataType.PSCO_T);
                }
                daId = this.dip.registerObjectAccess(am, op.getValue(), op.getCode());
                break;
            }
            case STREAM_T: {
                StreamParameter sp = (StreamParameter)p;
                daId = this.dip.registerStreamAccess(am, sp.getValue(), sp.getCode());
                break;
            }
            case EXTERNAL_STREAM_T: {
                ExternalStreamParameter esp = (ExternalStreamParameter)p;
                daId = this.dip.registerExternalStreamAccess(am, esp.getLocation());
                break;
            }
            case COLLECTION_T: {
                CollectionParameter cp = (CollectionParameter)p;
                for (Parameter content : cp.getParameters()) {
                    boolean hasCollectionParamEdge = this.registerParameterAccessAndAddDependencies(currentTask, content, isConstraining);
                    hasParamEdge = hasParamEdge || hasCollectionParamEdge;
                }
                daId = this.dip.registerCollectionAccess(am, cp);
                DataInfo ci = this.dip.deleteCollection(cp.getCollectionId(), true);
                this.deleteData(ci);
                break;
            }
            default: {
                daId = null;
            }
        }
        if (daId != null) {
            DependencyParameter dp = (DependencyParameter)p;
            if (am == AccessParams.AccessMode.CV) {
                Integer coreId = currentTask.getTaskDescription().getCoreElement().getCoreId();
                CommutativeIdentifier comId = new CommutativeIdentifier(coreId, daId.getDataId());
                CommutativeGroupTask com = null;
                for (CommutativeGroupTask cgt : this.commutativeGroup.values()) {
                    if (cgt.getCommutativeIdentifier().compareTo(comId) != 1) continue;
                    com = cgt;
                }
                if (com == null) {
                    firstRegistered = daId;
                    LOGGER.debug("The FIRST registered daId in the commutative group " + comId.toString() + " is " + daId);
                } else {
                    com.addVersionToList(daId);
                    daId = com.getRegisteredVersion();
                    LOGGER.debug("Registering daId " + daId + " in commutative group " + comId.toString());
                }
                dp.setDataAccessId(daId);
                hasParamEdge = this.addCommutativeDependencies(currentTask, dp, firstRegistered, coreId);
            } else {
                dp.setDataAccessId(daId);
                hasParamEdge = this.addDependencies(am, currentTask, isConstraining, dp, firstRegistered);
            }
        }
        return hasParamEdge;
    }

    private boolean addDependencies(AccessParams.AccessMode am, Task currentTask, boolean isConstraining, DependencyParameter dp, DataAccessId firstRegistered) {
        boolean hasParamEdge = false;
        DataAccessId daId = dp.getDataAccessId();
        block0 : switch (am) {
            case R: {
                WritersInfo wi;
                RAccessId raId;
                DataInstanceId dependingDataId;
                hasParamEdge = !this.dataWasAccessedConcurrent(daId.getDataId()) ? this.checkDependencyForRead(currentTask, dp) : this.checkDependencyForConcurrent(currentTask, dp);
                if (!isConstraining || (dependingDataId = (raId = (RAccessId)dp.getDataAccessId()).getReadDataInstance()) == null || dependingDataId.getVersionId() <= 1 || (wi = this.writers.get(dependingDataId.getDataId())) == null) break;
                switch (wi.getDataType()) {
                    case STREAM_T: 
                    case EXTERNAL_STREAM_T: {
                        List<AbstractTask> lastWriters = wi.getStreamWriters();
                        if (lastWriters.isEmpty()) break block0;
                        currentTask.setEnforcingTask((Task)lastWriters.get(0));
                        break block0;
                    }
                    default: {
                        AbstractTask lastWriter = wi.getDataWriter();
                        if (lastWriter == null) break block0;
                        currentTask.setEnforcingTask((Task)lastWriter);
                    }
                }
                break;
            }
            case RW: {
                WritersInfo wi;
                RWAccessId raId;
                DataInstanceId dependingDataId;
                if (!this.dataWasAccessedConcurrent(daId.getDataId())) {
                    hasParamEdge = this.checkDependencyForRead(currentTask, dp);
                } else {
                    hasParamEdge = this.checkDependencyForConcurrent(currentTask, dp);
                    this.removeFromConcurrentAccess(dp.getDataAccessId().getDataId());
                }
                if (isConstraining && (dependingDataId = (raId = (RWAccessId)dp.getDataAccessId()).getReadDataInstance()) != null && dependingDataId.getVersionId() > 1 && (wi = this.writers.get(dependingDataId.getDataId())) != null) {
                    switch (wi.getDataType()) {
                        case STREAM_T: {
                            List<AbstractTask> lastWriters = wi.getStreamWriters();
                            if (lastWriters.isEmpty()) break;
                            currentTask.setEnforcingTask((Task)lastWriters.get(0));
                            break;
                        }
                        default: {
                            AbstractTask lastWriter = wi.getDataWriter();
                            if (lastWriter == null) break;
                            currentTask.setEnforcingTask((Task)lastWriter);
                        }
                    }
                }
                this.registerOutputValues(currentTask, dp);
                break;
            }
            case W: {
                if (this.dataWasAccessedConcurrent(daId.getDataId())) {
                    this.removeFromConcurrentAccess(dp.getDataAccessId().getDataId());
                }
                this.registerOutputValues(currentTask, dp);
                break;
            }
            case C: {
                hasParamEdge = this.checkDependencyForRead(currentTask, dp);
                List<Task> tasks = this.concurrentAccessMap.get(daId.getDataId());
                if (tasks == null) {
                    tasks = new LinkedList<Task>();
                    this.concurrentAccessMap.put(daId.getDataId(), tasks);
                }
                tasks.add(currentTask);
                break;
            }
        }
        return hasParamEdge;
    }

    private boolean checkDependencyForRead(Task currentTask, DependencyParameter dp) {
        WritersInfo wi;
        int dataId = dp.getDataAccessId().getDataId();
        if (DEBUG) {
            LOGGER.debug("Checking READ dependency for datum " + dataId + " and task " + currentTask.getId());
        }
        if ((wi = this.writers.get(dataId)) != null) {
            switch (wi.getDataType()) {
                case STREAM_T: 
                case EXTERNAL_STREAM_T: {
                    this.addStreamDependency(currentTask, dp, wi);
                    break;
                }
                default: {
                    this.addRegularDependency(currentTask, dp, wi);
                    break;
                }
            }
        } else {
            if (DEBUG) {
                LOGGER.debug("There is no last writer for datum " + dataId);
            }
            if (IS_DRAW_GRAPH) {
                this.drawEdges(currentTask, dp, null);
            }
        }
        return true;
    }

    private boolean checkDependencyForCommutative(Task currentTask, DependencyParameter dp, CommutativeGroupTask commutativeGroup) {
        AbstractTask t = commutativeGroup.getParentDataDependency();
        if (t != null) {
            LOGGER.debug("Adding dependency with parent task of commutative group");
            currentTask.addDataDependency(t);
        }
        if (IS_DRAW_GRAPH) {
            this.drawEdges(currentTask, dp, t);
        }
        commutativeGroup.addDataDependency(currentTask);
        commutativeGroup.addCommutativeTask(currentTask);
        currentTask.setCommutativeGroup(commutativeGroup, dp.getDataAccessId());
        return true;
    }

    private boolean checkDependencyForConcurrent(Task currentTask, DependencyParameter dp) {
        int dataId = dp.getDataAccessId().getDataId();
        List<Task> tasks = this.concurrentAccessMap.get(dataId);
        if (!tasks.contains(currentTask)) {
            if (DEBUG) {
                LOGGER.debug("There was a concurrent access for datum " + dataId);
                LOGGER.debug("Adding dependency between list and task " + currentTask.getId());
            }
            for (Task t : tasks) {
                currentTask.addDataDependency(t);
                if (!IS_DRAW_GRAPH) continue;
                this.drawEdges(currentTask, dp, t);
            }
        } else {
            if (DEBUG) {
                LOGGER.debug("There is no last writer for datum " + dataId);
            }
            if (IS_DRAW_GRAPH) {
                this.drawEdges(currentTask, dp, null);
            }
        }
        return true;
    }

    private void addRegularDependency(Task currentTask, DependencyParameter dp, WritersInfo wi) {
        int dataId = dp.getDataAccessId().getDataId();
        AbstractTask lastWriter = wi.getDataWriter();
        if (lastWriter != null && lastWriter != currentTask) {
            if (DEBUG) {
                LOGGER.debug("Last writer for datum " + dataId + " is task " + lastWriter.getId());
                LOGGER.debug("Adding dependency between task " + lastWriter.getId() + " and task " + currentTask.getId());
            }
            if (lastWriter instanceof Task && ((Task)lastWriter).getCommutativeGroup(dp.getDataAccessId().getDataId()) != null) {
                currentTask.addDataDependency(((Task)lastWriter).getCommutativeGroup(dp.getDataAccessId().getDataId()));
            }
            currentTask.addDataDependency(lastWriter);
        } else if (DEBUG) {
            LOGGER.debug("There is no last writer for datum " + dataId);
        }
        if (IS_DRAW_GRAPH) {
            this.drawEdges(currentTask, dp, lastWriter);
            this.checkIfPreviousGroupInGraph(dataId, currentTask);
        }
    }

    private void addStreamDependency(Task currentTask, DependencyParameter dp, WritersInfo wi) {
        int dataId = dp.getDataAccessId().getDataId();
        List<AbstractTask> lastStreamWriters = wi.getStreamWriters();
        if (!lastStreamWriters.isEmpty()) {
            if (DEBUG) {
                StringBuilder sb = new StringBuilder();
                if (lastStreamWriters.size() > 1) {
                    sb.append("Last writers for stream datum ");
                    sb.append(dataId);
                    sb.append(" are tasks ");
                } else {
                    sb.append("Last writer for stream datum ");
                    sb.append(dataId);
                    sb.append(" is task ");
                }
                for (AbstractTask lastWriter : lastStreamWriters) {
                    sb.append(lastWriter.getId());
                    sb.append(" ");
                }
                LOGGER.debug(sb.toString());
            }
            for (AbstractTask lastWriter : lastStreamWriters) {
                if (DEBUG) {
                    LOGGER.debug("Adding stream dependency between task " + lastWriter.getId() + " and task " + currentTask.getId());
                }
                currentTask.addStreamDataDependency(lastWriter);
            }
        } else if (DEBUG) {
            LOGGER.debug("There is no last stream writer for datum " + dataId);
        }
        if (IS_DRAW_GRAPH) {
            this.drawStreamEdge(currentTask, dp, false);
            this.checkIfPreviousGroupInGraph(dataId, currentTask);
        }
    }

    private boolean addCommutativeDependencies(Task currentTask, DependencyParameter dp, DataAccessId firstRegistered, int coreId) {
        DataAccessId daId = dp.getDataAccessId();
        CommutativeIdentifier comId = new CommutativeIdentifier(coreId, daId.getDataId());
        CommutativeGroupTask com = null;
        LinkedList<Task> pendingToDraw = null;
        for (CommutativeGroupTask cgt : this.commutativeGroup.values()) {
            if (cgt.getCommutativeIdentifier().compareTo(comId) != 1) continue;
            com = cgt;
            if (!IS_DRAW_GRAPH) continue;
            pendingToDraw = this.pendingToDrawCommutative.get(comId.toString());
        }
        if (IS_DRAW_GRAPH) {
            if (pendingToDraw == null) {
                pendingToDraw = new LinkedList<Task>();
            }
            pendingToDraw.add(currentTask);
            this.pendingToDrawCommutative.put(comId.toString(), pendingToDraw);
        }
        if (com == null) {
            WritersInfo wi;
            LOGGER.info("Creating a new commutative group " + comId);
            com = new CommutativeGroupTask(currentTask.getAppId(), comId);
            if (IS_DRAW_GRAPH) {
                LOGGER.debug("Checking if previous group in graph");
                this.checkIfPreviousGroupInGraph(daId.getDataId(), currentTask);
            }
            if ((wi = this.writers.get(daId.getDataId())) != null) {
                AbstractTask predecessor = wi.getDataWriter();
                com.setParentDataDependency(predecessor);
                LOGGER.debug("Setting parent data dependency");
            }
            this.commutativeGroup.put(comId.toString(), com);
            com.setRegisteredVersion(firstRegistered);
            this.registerOutputValues(com, dp);
        }
        com.setFinalVersion(((RWAccessId)daId).getWVersionId());
        boolean hasParamEdge = this.checkDependencyForCommutative(currentTask, dp, com);
        this.registerOutputValues(com, dp);
        return hasParamEdge;
    }

    private void updateLastWritters(AbstractTask task, Parameter p) {
        DependencyParameter dp;
        int dataId;
        WritersInfo wi;
        DataType type = p.getType();
        int currentTaskId = task.getId();
        if (type == DataType.COLLECTION_T) {
            CollectionParameter cp = (CollectionParameter)p;
            for (Parameter sp : cp.getParameters()) {
                this.updateLastWritters(task, sp);
            }
        }
        if ((type == DataType.FILE_T || type == DataType.OBJECT_T || type == DataType.PSCO_T || type == DataType.EXTERNAL_PSCO_T || type == DataType.BINDING_OBJECT_T || type == DataType.COLLECTION_T) && (wi = this.writers.get(dataId = (dp = (DependencyParameter)p).getDataAccessId().getDataId())) != null) {
            if (DEBUG) {
                LOGGER.debug("Removing writters info for datum " + dataId + " and task " + currentTaskId);
            }
            switch (dp.getDirection()) {
                case OUT: 
                case INOUT: {
                    if (wi.getDataWriter() == null || wi.getDataWriter().getId() != currentTaskId) break;
                    wi.setDataWriter(null);
                    break;
                }
            }
        }
    }

    private void treatDataAccess(AbstractTask lastWriter, AccessParams.AccessMode am, int dataId) {
        if (am == AccessParams.AccessMode.RW) {
            WritersInfo wi = this.writers.get(dataId);
            if (wi != null) {
                switch (wi.getDataType()) {
                    case STREAM_T: 
                    case EXTERNAL_STREAM_T: {
                        break;
                    }
                    default: {
                        wi.setDataWriter(null);
                        break;
                    }
                }
            } else {
                LOGGER.warn("Adding null writer info for data " + dataId);
                this.writers.put(dataId, null);
            }
        }
        if (IS_DRAW_GRAPH) {
            TreeSet<Integer> toPass = new TreeSet<Integer>();
            toPass.add(dataId);
            DataInstanceId dii = this.dip.getLastVersions(toPass).get(0);
            int dataVersion = dii.getVersionId();
            this.addEdgeFromTaskToMain(lastWriter, EdgeType.DATA_DEPENDENCY, dataId, dataVersion);
        }
    }

    private void updateParameterAccess(Task t, Parameter p) {
        DataType type = p.getType();
        if (type == DataType.COLLECTION_T) {
            for (Parameter subParam : ((CollectionParameter)p).getParameters()) {
                this.updateParameterAccess(t, subParam);
            }
        }
        if (type == DataType.FILE_T || type == DataType.OBJECT_T || type == DataType.PSCO_T || type == DataType.STREAM_T || type == DataType.EXTERNAL_STREAM_T || type == DataType.EXTERNAL_PSCO_T || type == DataType.BINDING_OBJECT_T || type == DataType.COLLECTION_T) {
            DependencyParameter dPar = (DependencyParameter)p;
            DataAccessId dAccId = dPar.getDataAccessId();
            if (DEBUG) {
                LOGGER.debug("Treating that data " + dAccId + " has been accessed at " + dPar.getDataTarget());
            }
            boolean canceledByException = false;
            if (t.hasTaskGroups()) {
                for (TaskGroup tg : t.getTaskGroupList()) {
                    if (!tg.hasException() || t.getStatus() != TaskState.CANCELED) continue;
                    canceledByException = true;
                }
            }
            if (t.getOnFailure() == OnFailure.CANCEL_SUCCESSORS && (t.getStatus() == TaskState.FAILED || t.getStatus() == TaskState.CANCELED) || canceledByException) {
                this.dip.dataAccessHasBeenCanceled(dAccId);
            } else {
                this.dip.dataHasBeenAccessed(dAccId);
            }
        }
    }

    private void registerOutputValues(AbstractTask currentTask, DependencyParameter dp) {
        int currentTaskId = currentTask.getId();
        int dataId = dp.getDataAccessId().getDataId();
        Long appId = currentTask.getAppId();
        if (DEBUG) {
            LOGGER.debug("Checking WRITE dependency for datum " + dataId + " and task " + currentTaskId);
        }
        switch (dp.getType()) {
            case STREAM_T: 
            case EXTERNAL_STREAM_T: {
                WritersInfo wi = this.writers.get(dataId);
                if (wi != null) {
                    wi.addStreamWriter(currentTask);
                } else {
                    wi = new WritersInfo(dp.getType(), Arrays.asList(currentTask));
                }
                this.writers.put(dataId, wi);
                if (!IS_DRAW_GRAPH) break;
                this.drawStreamEdge(currentTask, dp, true);
                break;
            }
            default: {
                WritersInfo newWi = new WritersInfo(dp.getType(), currentTask);
                LOGGER.info("Setting writer for data " + dataId);
                this.writers.put(dataId, newWi);
            }
        }
        switch (dp.getType()) {
            case FILE_T: {
                Set<Integer> fileIdsWritten = this.appIdToWrittenFiles.get(appId);
                if (fileIdsWritten == null) {
                    fileIdsWritten = new TreeSet<Integer>();
                    this.appIdToWrittenFiles.put(appId, fileIdsWritten);
                }
                fileIdsWritten.add(dataId);
                break;
            }
            case PSCO_T: {
                Set<Integer> pscoIdsWritten = this.appIdToSCOWrittenIds.get(appId);
                if (pscoIdsWritten == null) {
                    pscoIdsWritten = new TreeSet<Integer>();
                    this.appIdToSCOWrittenIds.put(appId, pscoIdsWritten);
                }
                pscoIdsWritten.add(dataId);
                break;
            }
        }
        if (DEBUG) {
            LOGGER.debug("New writer for datum " + dataId + " is task " + currentTaskId);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void checkResultFileTransfer(Task t) {
        LinkedList<DataInstanceId> fileIds = new LinkedList<DataInstanceId>();
        block14: for (Parameter p : t.getTaskDescription().getParameters()) {
            switch (p.getType()) {
                case FILE_T: {
                    FileParameter fp = (FileParameter)p;
                    switch (fp.getDirection()) {
                        case IN: 
                        case CONCURRENT: {
                            continue block14;
                        }
                        case INOUT: 
                        case COMMUTATIVE: {
                            DataInstanceId dId = ((RWAccessId)fp.getDataAccessId()).getWrittenDataInstance();
                            WritersInfo wi = this.writers.get(dId.getDataId());
                            if (wi == null) break;
                            switch (wi.getDataType()) {
                                case STREAM_T: 
                                case EXTERNAL_STREAM_T: {
                                    continue block14;
                                }
                            }
                            AbstractTask lastWriter = wi.getDataWriter();
                            if (lastWriter == null || lastWriter != t) continue block14;
                            fileIds.add(dId);
                            continue block14;
                        }
                        case OUT: {
                            DataInstanceId dId = ((WAccessId)fp.getDataAccessId()).getWrittenDataInstance();
                            WritersInfo wi = this.writers.get(dId.getDataId());
                            if (wi == null) break;
                            switch (wi.getDataType()) {
                                case STREAM_T: {
                                    continue block14;
                                }
                            }
                            AbstractTask lastWriter = wi.getDataWriter();
                            if (lastWriter == null || lastWriter != t) break;
                            fileIds.add(dId);
                        }
                    }
                    continue block14;
                }
            }
        }
        int numFT = fileIds.size();
        if (numFT > 0) {
            if (DEBUG) {
                LOGGER.debug("Ordering transfers for result files of task " + t.getId());
            }
            for (DataInstanceId fileId : fileIds) {
                int id = fileId.getDataId();
                if (DEBUG) {
                    LOGGER.debug("- Requesting result file " + id + " because of task " + t.getId());
                }
                this.dip.blockDataAndGetResultFile(id, new ResultListener(new Semaphore(0)));
                this.dip.unblockDataId(id);
            }
        }
    }

    private void drawEdges(Task currentTask, DependencyParameter dp, AbstractTask lastWriter) {
        int dataVersion;
        int dataId = dp.getDataAccessId().getDataId();
        DataAccessId.Direction d = dp.getDataAccessId().getDirection();
        switch (d) {
            case C: 
            case R: {
                dataVersion = ((RAccessId)dp.getDataAccessId()).getRVersionId();
                break;
            }
            case W: {
                dataVersion = ((WAccessId)dp.getDataAccessId()).getWVersionId();
                break;
            }
            default: {
                dataVersion = ((RWAccessId)dp.getDataAccessId()).getRVersionId();
            }
        }
        switch (dp.getType()) {
            case STREAM_T: 
            case EXTERNAL_STREAM_T: {
                this.drawStreamEdge(currentTask, dp, !d.equals((Object)DataAccessId.Direction.R));
                break;
            }
            default: {
                if (lastWriter != null && lastWriter != currentTask) {
                    if (lastWriter instanceof Task) {
                        if (lastWriter.getSuccessors().contains(currentTask.getCommutativeGroup(dataId))) {
                            this.addEdgeFromCommutativeToTask(currentTask, dataId, dataVersion, (CommutativeGroupTask)lastWriter, false);
                            break;
                        }
                        this.addDataEdgeFromTaskToTask((Task)lastWriter, currentTask, dataId, dataVersion);
                        break;
                    }
                    if (lastWriter instanceof Task && !currentTask.hasCommutativeParams()) break;
                    this.addEdgeFromCommutativeToTask(currentTask, dataId, dataVersion, (CommutativeGroupTask)lastWriter, true);
                    break;
                }
                this.addDataEdgeFromMainToTask(currentTask, dataId, dataVersion);
            }
        }
    }

    private void drawStreamEdge(AbstractTask currentTask, DependencyParameter dp, boolean isWrite) {
        String stream = "Stream" + dp.getDataAccessId().getDataId();
        this.addStreamToGraph(stream);
        this.addStreamEdge(currentTask, stream, isWrite);
    }

    private void addNewTask(Task task) {
        task.setSynchronizationId(this.synchronizationId);
        this.taskDetectedAfterSync = true;
        if (!task.hasCommutativeParams()) {
            this.addTaskToGraph(task);
        }
    }

    private void addTaskToGraph(Task task) {
        this.gm.addTaskToGraph(task);
    }

    private void addStreamToGraph(String stream) {
        this.gm.addStreamToGraph(stream);
    }

    private void checkIfPreviousGroupInGraph(int dataId, Task currentTask) {
        AbstractTask lastWriter;
        WritersInfo wi = this.writers.get(dataId);
        if (wi != null && (lastWriter = wi.getDataWriter()) instanceof CommutativeGroupTask && !((CommutativeGroupTask)lastWriter).getGraphDrawn()) {
            CommutativeIdentifier comId = ((CommutativeGroupTask)lastWriter).getCommutativeIdentifier();
            this.addCommutativeGroupTaskToGraph(comId.toString());
            ((CommutativeGroupTask)lastWriter).setGraphDrawn();
            this.pendingToDrawCommutative.remove(((CommutativeGroupTask)lastWriter).getCommutativeIdentifier().toString());
        }
    }

    private void addCommutativeGroupTaskToGraph(String identifier) {
        LOGGER.debug("Adding commutative group to graph");
        this.gm.addCommutativeGroupToGraph(identifier);
        for (Task t : this.pendingToDrawCommutative.get(identifier)) {
            this.addTaskToGraph(t);
        }
        this.gm.closeGroupInGraph();
    }

    private void addDataEdgeFromTaskToTask(Task source, Task dest, int dataId, int dataVersion) {
        if (source.getSynchronizationId() == dest.getSynchronizationId()) {
            String src = String.valueOf(source.getId());
            String dst = String.valueOf(dest.getId());
            String dep = String.valueOf(dataId) + "v" + String.valueOf(dataVersion);
            this.gm.addEdgeToGraph(src, dst, EdgeType.DATA_DEPENDENCY, dep);
        } else {
            String src = "Synchro" + dest.getSynchronizationId();
            String dst = String.valueOf(dest.getId());
            String dep = String.valueOf(dataId) + "v" + String.valueOf(dataVersion);
            this.gm.addEdgeToGraph(src, dst, EdgeType.DATA_DEPENDENCY, dep);
        }
    }

    private void addDataEdgeFromMainToTask(Task dest, int dataId, int dataVersion) {
        String src = "Synchro" + dest.getSynchronizationId();
        String dst = String.valueOf(dest.getId());
        String dep = String.valueOf(dataId) + "v" + String.valueOf(dataVersion);
        this.gm.addEdgeToGraph(src, dst, EdgeType.DATA_DEPENDENCY, dep);
    }

    private void addEdgeFromMainToTask(Task dest) {
        String src = "Synchro" + dest.getSynchronizationId();
        String dst = String.valueOf(dest.getId());
        String dep = "";
        this.gm.addEdgeToGraph(src, dst, EdgeType.DATA_DEPENDENCY, dep);
    }

    private void addEdgeFromTaskToMain(AbstractTask task, EdgeType edgeType, int dataId, int dataVersion) {
        if (this.taskDetectedAfterSync) {
            this.taskDetectedAfterSync = false;
            int oldSyncId = this.synchronizationId++;
            this.gm.addSynchroToGraph(this.synchronizationId);
            String oldSync = "Synchro" + oldSyncId;
            String currentSync = "Synchro" + this.synchronizationId;
            this.gm.addEdgeToGraph(oldSync, currentSync, edgeType, "");
        }
        String dest = "Synchro" + this.synchronizationId;
        if (task instanceof CommutativeGroupTask && !((CommutativeGroupTask)task).getCommutativeTasks().isEmpty()) {
            CommutativeGroupTask commGroupTask = (CommutativeGroupTask)task;
            String src = String.valueOf(commGroupTask.getCommutativeTasks().get(0).getId());
            String groupId = commGroupTask.getCommutativeIdentifier().toString();
            this.gm.addEdgeToGraphFromGroup(src, dest, String.valueOf(dataId) + "v" + String.valueOf(dataVersion), groupId, "clusterCommutative", edgeType);
        } else {
            String src = String.valueOf(task.getId());
            this.gm.addEdgeToGraph(src, dest, edgeType, String.valueOf(dataId) + "v" + String.valueOf(dataVersion));
        }
    }

    private void addStreamEdge(AbstractTask task, String stream, boolean isWrite) {
        String taskId = String.valueOf(task.getId());
        if (isWrite) {
            this.gm.addEdgeToGraph(taskId, stream, EdgeType.STREAM_DEPENDENCY, "");
        } else {
            this.gm.addEdgeToGraph(stream, taskId, EdgeType.STREAM_DEPENDENCY, "");
        }
    }

    private void addEdgeFromCommutativeToTask(Task dest, int dataId, int dataVersion, CommutativeGroupTask cgt, boolean comToTask) {
        String src = String.valueOf(cgt.getCommutativeTasks().get(0).getId());
        String dst = String.valueOf(dest.getId());
        String dep = String.valueOf(dataId) + "v" + String.valueOf(dataVersion);
        String comId = cgt.getCommutativeIdentifier().toString();
        if (comToTask) {
            this.gm.addEdgeToGraphFromGroup(src, dst, dep, comId, "clusterCommutative", EdgeType.DATA_DEPENDENCY);
        } else {
            this.gm.addEdgeToGraphFromGroup(dst, src, dep, comId, "clusterCommutative", EdgeType.DATA_DEPENDENCY);
        }
    }

    private void addNewBarrier() {
        int oldSync = this.synchronizationId++;
        String oldSyncStr = "Synchro" + oldSync;
        String newSyncStr = "Synchro" + this.synchronizationId;
        this.gm.addBarrierToGraph(this.synchronizationId);
        this.gm.addEdgeToGraph(oldSyncStr, newSyncStr, EdgeType.USER_DEPENDENCY, "");
        this.taskDetectedAfterSync = false;
        HashSet<AbstractTask> uniqueWriters = new HashSet<AbstractTask>();
        for (WritersInfo wi : this.writers.values()) {
            if (wi == null) continue;
            AbstractTask dataWriter = wi.getDataWriter();
            if (dataWriter != null) {
                uniqueWriters.add(dataWriter);
            }
            uniqueWriters.addAll(wi.getStreamWriters());
        }
        for (AbstractTask writer : uniqueWriters) {
            if (writer == null || writer.getSynchronizationId() != oldSync) continue;
            String taskId = String.valueOf(writer.getId());
            this.gm.addEdgeToGraph(taskId, newSyncStr, EdgeType.USER_DEPENDENCY, "");
        }
    }

    private void addNewGroupBarrier(TaskGroup tg) {
        int oldSync = this.synchronizationId++;
        String oldSyncStr = "Synchro" + oldSync;
        String newSyncStr = "Synchro" + this.synchronizationId;
        this.gm.addBarrierToGraph(this.synchronizationId);
        this.gm.addEdgeToGraph(oldSyncStr, newSyncStr, EdgeType.USER_DEPENDENCY, "");
        this.taskDetectedAfterSync = false;
        String src = String.valueOf(tg.getLastTaskId());
        tg.setBarrierDrawn();
        if (!tg.hasPendingTasks() && tg.isClosed() && tg.hasBarrier()) {
            this.taskGroups.get(tg.getAppId()).remove(tg.getName());
        }
        this.gm.addEdgeToGraphFromGroup(src, newSyncStr, "", tg.getName(), "clusterTasks", EdgeType.USER_DEPENDENCY);
    }

    private static class WritersInfo {
        private final DataType dataType;
        private AbstractTask dataWriter;
        private final List<AbstractTask> streamWriters;

        public WritersInfo(DataType dataType, AbstractTask dataWriter) {
            this.dataType = dataType;
            this.dataWriter = dataWriter;
            this.streamWriters = new ArrayList<AbstractTask>();
        }

        public void setDataWriter(AbstractTask dataWriter) {
            this.dataWriter = dataWriter;
        }

        public WritersInfo(DataType dataType, List<AbstractTask> streamWriters) {
            this.dataType = dataType;
            this.dataWriter = null;
            this.streamWriters = new ArrayList<AbstractTask>();
            if (streamWriters != null) {
                this.streamWriters.addAll(streamWriters);
            }
        }

        public DataType getDataType() {
            return this.dataType;
        }

        public AbstractTask getDataWriter() {
            return this.dataWriter;
        }

        public List<AbstractTask> getStreamWriters() {
            return this.streamWriters;
        }

        public void addStreamWriter(AbstractTask writerTask) {
            if (writerTask != null) {
                this.streamWriters.add(writerTask);
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("WI [ ");
            sb.append("dataType = ").append((Object)this.dataType).append(", ");
            sb.append("dataWriter = ").append(this.dataWriter != null ? Integer.valueOf(this.dataWriter.getId()) : "null").append(", ");
            sb.append("streamWriters = [");
            for (AbstractTask t : this.streamWriters) {
                sb.append(t.getId()).append(" ");
            }
            sb.append("]");
            sb.append("]");
            return sb.toString();
        }
    }
}

