/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.CommonFields;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.requests.AbstractResponse;

public class ListGroupsResponse
extends AbstractResponse {
    private static final String GROUPS_KEY_NAME = "groups";
    private static final String PROTOCOL_TYPE_KEY_NAME = "protocol_type";
    private static final Schema LIST_GROUPS_RESPONSE_GROUP_V0 = new Schema(CommonFields.GROUP_ID, new Field("protocol_type", Type.STRING));
    private static final Schema LIST_GROUPS_RESPONSE_V0 = new Schema(CommonFields.ERROR_CODE, new Field("groups", new ArrayOf(LIST_GROUPS_RESPONSE_GROUP_V0)));
    private static final Schema LIST_GROUPS_RESPONSE_V1;
    private static final Schema LIST_GROUPS_RESPONSE_V2;
    private final Errors error;
    private final int throttleTimeMs;
    private final List<Group> groups;

    public static Schema[] schemaVersions() {
        return new Schema[]{LIST_GROUPS_RESPONSE_V0, LIST_GROUPS_RESPONSE_V1, LIST_GROUPS_RESPONSE_V2};
    }

    public ListGroupsResponse(Errors error, List<Group> groups) {
        this(0, error, groups);
    }

    public ListGroupsResponse(int throttleTimeMs, Errors error, List<Group> groups) {
        this.throttleTimeMs = throttleTimeMs;
        this.error = error;
        this.groups = groups;
    }

    public ListGroupsResponse(Struct struct) {
        this.throttleTimeMs = struct.getOrElse(CommonFields.THROTTLE_TIME_MS, 0);
        this.error = Errors.forCode(struct.get(CommonFields.ERROR_CODE));
        this.groups = new ArrayList<Group>();
        for (Object groupObj : struct.getArray(GROUPS_KEY_NAME)) {
            Struct groupStruct = (Struct)groupObj;
            String groupId = groupStruct.get(CommonFields.GROUP_ID);
            String protocolType = groupStruct.getString(PROTOCOL_TYPE_KEY_NAME);
            this.groups.add(new Group(groupId, protocolType));
        }
    }

    @Override
    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public List<Group> groups() {
        return this.groups;
    }

    public Errors error() {
        return this.error;
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        return this.errorCounts(this.error);
    }

    @Override
    protected Struct toStruct(short version) {
        Struct struct = new Struct(ApiKeys.LIST_GROUPS.responseSchema(version));
        struct.setIfExists(CommonFields.THROTTLE_TIME_MS, (Object)this.throttleTimeMs);
        struct.set(CommonFields.ERROR_CODE, this.error.code());
        ArrayList<Struct> groupList = new ArrayList<Struct>();
        for (Group group2 : this.groups) {
            Struct groupStruct = struct.instance(GROUPS_KEY_NAME);
            groupStruct.set(CommonFields.GROUP_ID, group2.groupId);
            groupStruct.set(PROTOCOL_TYPE_KEY_NAME, (Object)group2.protocolType);
            groupList.add(groupStruct);
        }
        struct.set(GROUPS_KEY_NAME, (Object)groupList.toArray());
        return struct;
    }

    public static ListGroupsResponse parse(ByteBuffer buffer, short version) {
        return new ListGroupsResponse(ApiKeys.LIST_GROUPS.parseResponse(version, buffer));
    }

    @Override
    public boolean shouldClientThrottle(short version) {
        return version >= 2;
    }

    static {
        LIST_GROUPS_RESPONSE_V2 = LIST_GROUPS_RESPONSE_V1 = new Schema(CommonFields.THROTTLE_TIME_MS, CommonFields.ERROR_CODE, new Field(GROUPS_KEY_NAME, new ArrayOf(LIST_GROUPS_RESPONSE_GROUP_V0)));
    }

    public static class Group {
        private final String groupId;
        private final String protocolType;

        public Group(String groupId, String protocolType) {
            this.groupId = groupId;
            this.protocolType = protocolType;
        }

        public String groupId() {
            return this.groupId;
        }

        public String protocolType() {
            return this.protocolType;
        }
    }
}

