/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.agent.comm;

import es.bsc.comm.Connection;
import es.bsc.comm.TransferManager;
import es.bsc.comm.nio.NIONode;
import es.bsc.compss.agent.AppMonitor;
import es.bsc.compss.agent.comm.CommAgentAdaptor;
import es.bsc.compss.agent.comm.messages.types.CommResource;
import es.bsc.compss.agent.comm.messages.types.CommTask;
import es.bsc.compss.agent.types.ApplicationParameter;
import es.bsc.compss.nio.NIOTaskResult;
import es.bsc.compss.nio.commands.CommandDataReceived;
import es.bsc.compss.nio.commands.CommandNIOTaskDone;
import es.bsc.compss.types.annotations.parameter.DataType;

class TaskMonitor
extends AppMonitor {
    private static final TransferManager TM = CommAgentAdaptor.getTransferManager();
    private final CommResource orchestrator;
    private final CommTask task;
    private boolean successful;

    public TaskMonitor(ApplicationParameter[] args, ApplicationParameter target, ApplicationParameter[] results, CommResource orchestrator, CommTask request) {
        super(args, target, results);
        this.orchestrator = orchestrator;
        this.successful = false;
        this.task = request;
    }

    public void onDataReception() {
        super.onDataReception();
        if (this.orchestrator != null) {
            NIONode n = new NIONode(this.orchestrator.getName(), this.orchestrator.getPort());
            int transferGroupId = this.task.getTransferGroupId();
            Connection c = TM.startConnection(n);
            CommandDataReceived cmd = new CommandDataReceived(transferGroupId);
            c.sendCommand(cmd);
            c.finishConnection();
        }
    }

    public void valueGenerated(int paramId, String paramName, DataType paramType, String dataId, Object dataLocation) {
        super.valueGenerated(paramId, paramName, paramType, dataId, dataLocation);
    }

    public void onSuccesfulExecution() {
        super.onSuccesfulExecution();
        this.successful = true;
    }

    public void onCompletion() {
        super.onCompletion();
        if (this.orchestrator != null) {
            this.notifyEnd();
        }
    }

    public void onFailure() {
        super.onFailure();
        if (this.orchestrator != null) {
            this.notifyEnd();
        }
    }

    public void notifyEnd() {
        NIONode n = new NIONode(this.orchestrator.getName(), this.orchestrator.getPort());
        int jobId = this.task.getJobId();
        NIOTaskResult tr = new NIOTaskResult(jobId, super.getParamTypes(), super.getParamLocations());
        Connection c = TM.startConnection(n);
        CommandNIOTaskDone cmd = new CommandNIOTaskDone(tr, this.successful, this.task.getHistory().toString(), null);
        c.sendCommand(cmd);
        c.finishConnection();
    }
}

