/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.implementations.definition;

import es.bsc.compss.types.CollectionLayout;
import es.bsc.compss.types.implementations.Implementation;
import es.bsc.compss.types.implementations.PythonMPIImplementation;
import es.bsc.compss.types.implementations.definition.ImplementationDefinition;
import es.bsc.compss.types.resources.MethodResourceDescription;

public class PythonMPIDefinition
extends ImplementationDefinition<MethodResourceDescription> {
    private final String declaringClass;
    private final String methodName;
    private final String workingDir;
    private final String mpiRunner;
    private final String mpiFlags;
    private final boolean scaleByCU;
    private final boolean failByEV;
    private final CollectionLayout[] cls;

    public PythonMPIDefinition(String implSignature, String declaringClass, String methodName, String workingDir, String mpiRunner, String mpiFlags, boolean scaleByCU, boolean failByEV, CollectionLayout[] cls, MethodResourceDescription implConstraints) {
        super(implSignature, implConstraints);
        this.workingDir = workingDir;
        this.mpiRunner = mpiRunner;
        this.mpiFlags = mpiFlags;
        this.declaringClass = declaringClass;
        this.methodName = methodName;
        this.scaleByCU = scaleByCU;
        this.failByEV = failByEV;
        this.cls = cls;
    }

    @Override
    public Implementation getImpl(int coreId, int implId) {
        return new PythonMPIImplementation(this.declaringClass, this.methodName, this.workingDir, this.mpiRunner, this.mpiFlags, this.scaleByCU, this.failByEV, this.cls, coreId, implId, this.getSignature(), (MethodResourceDescription)this.getConstraints());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("PYTHON MPI Implementation \n");
        sb.append("\t Signature: ").append(this.getSignature()).append("\n");
        sb.append("\t Declaring class: ").append(this.declaringClass).append("\n");
        sb.append("\t Method name: ").append(this.methodName).append("\n");
        sb.append("\t MPI runner: ").append(this.mpiRunner).append("\n");
        sb.append("\t MPI flags: ").append(this.mpiFlags).append("\n");
        sb.append("\t IO: ").append(!((MethodResourceDescription)this.getConstraints()).usesCPUs()).append("\n");
        sb.append("\t Working directory: ").append(this.workingDir).append("\n");
        sb.append("\t Scale by Computing Units: ").append(this.scaleByCU).append("\n");
        sb.append("\t Fail by EV: ").append(this.failByEV).append("\n");
        sb.append("\t Collection Layouts: ").append("\n");
        for (CollectionLayout cl : this.cls) {
            sb.append("\t\t").append(cl).append("\n");
        }
        sb.append("\t Constraints: ").append(this.getConstraints());
        return sb.toString();
    }
}

