/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.agent.types;

import es.bsc.compss.agent.types.RemoteDataLocation;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.LinkedList;

public class RemoteDataInformation
implements Externalizable {
    private String renaming;
    private Collection<RemoteDataLocation> sources = new LinkedList<RemoteDataLocation>();

    public RemoteDataInformation() {
    }

    public RemoteDataInformation(String renaming) {
        this.renaming = renaming;
    }

    public String getRenaming() {
        return this.renaming;
    }

    public void addSource(RemoteDataLocation location) {
        this.sources.add(location);
    }

    public Collection<RemoteDataLocation> getSources() {
        return this.sources;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("RemoteData " + this.renaming + " @ {");
        for (RemoteDataLocation source : this.sources) {
            sb.append("[" + source.toString() + "] ");
        }
        sb.append(" }");
        return sb.toString();
    }

    @Override
    public void writeExternal(ObjectOutput oo) throws IOException {
        oo.writeUTF(this.renaming);
        oo.writeObject(this.sources);
    }

    @Override
    public void readExternal(ObjectInput oi) throws IOException, ClassNotFoundException {
        this.renaming = oi.readUTF();
        this.sources = (Collection)oi.readObject();
    }
}

