/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.agent.comm;

import es.bsc.comm.Connection;
import es.bsc.comm.TransferManager;
import es.bsc.comm.nio.NIONode;
import es.bsc.compss.agent.AppMonitor;
import es.bsc.compss.agent.comm.CommAgentAdaptor;
import es.bsc.compss.agent.comm.messages.types.CommResource;
import es.bsc.compss.agent.comm.messages.types.CommTask;
import es.bsc.compss.agent.types.ApplicationParameter;
import es.bsc.compss.api.TaskMonitor;
import es.bsc.compss.nio.NIOTaskResult;
import es.bsc.compss.nio.commands.CommandDataReceived;
import es.bsc.compss.nio.commands.CommandNIOTaskDone;

class TaskMonitor
extends AppMonitor {
    private static final TransferManager TM = CommAgentAdaptor.getTransferManager();
    private final CommResource orchestrator;
    private final CommTask task;
    private boolean successful;

    public TaskMonitor(ApplicationParameter[] args, ApplicationParameter target, ApplicationParameter[] results, CommResource orchestrator, CommTask request) {
        super(args, target, results);
        this.orchestrator = orchestrator;
        this.successful = false;
        this.task = request;
        this.task.profileArrival();
    }

    public void onDataReception() {
        super.onDataReception();
        this.task.profileFetchedData();
        if (this.orchestrator != null) {
            NIONode n = new NIONode(this.orchestrator.getName(), this.orchestrator.getPort());
            int transferGroupId = this.task.getTransferGroupId();
            Connection c = TM.startConnection(n);
            CommandDataReceived cmd = new CommandDataReceived(transferGroupId);
            c.sendCommand(cmd);
            c.finishConnection();
        }
    }

    public void valueGenerated(int paramId, TaskMonitor.TaskResult param) {
        super.valueGenerated(paramId, param);
    }

    public void onExecutionStart() {
        this.task.getProfile().executionStarts();
    }

    public void onExecutionStartAt(long ts) {
        this.task.getProfile().executionStartsAt(ts);
    }

    public void onExecutionEnd() {
        this.task.getProfile().executionEnds();
    }

    public void onExecutionEndAt(long ts) {
        this.task.getProfile().executionEndsAt(ts);
    }

    public void onSuccesfulExecution() {
        super.onSuccesfulExecution();
        this.successful = true;
    }

    public void onCompletion() {
        super.onCompletion();
        this.task.profileEndNotification();
        if (this.orchestrator != null) {
            this.notifyEnd();
        }
    }

    public void onFailure() {
        super.onFailure();
        if (this.orchestrator != null) {
            this.notifyEnd();
        }
    }

    public void notifyEnd() {
        NIONode n = new NIONode(this.orchestrator.getName(), this.orchestrator.getPort());
        int jobId = this.task.getJobId();
        NIOTaskResult tr = new NIOTaskResult(jobId, super.getResults());
        Connection c = TM.startConnection(n);
        CommandNIOTaskDone cmd = new CommandNIOTaskDone(tr, this.successful, this.task.getProfile(), this.task.getHistory().toString(), this.getException());
        c.sendCommand(cmd);
        c.finishConnection();
    }
}

