/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.agent.comm;

import es.bsc.comm.Connection;
import es.bsc.comm.TransferManager;
import es.bsc.comm.nio.NIONode;
import es.bsc.compss.agent.AppMonitor;
import es.bsc.compss.agent.comm.CommAgentAdaptor;
import es.bsc.compss.agent.comm.messages.types.CommResource;
import es.bsc.compss.agent.comm.messages.types.CommResult;
import es.bsc.compss.agent.comm.messages.types.CommTask;
import es.bsc.compss.agent.types.ApplicationParameter;
import es.bsc.compss.nio.NIOResult;
import es.bsc.compss.nio.NIOResultCollection;
import es.bsc.compss.nio.NIOTaskResult;
import es.bsc.compss.nio.commands.CommandDataReceived;
import es.bsc.compss.nio.commands.CommandNIOTaskDone;
import es.bsc.compss.worker.COMPSsException;
import java.util.LinkedList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TaskMonitor
extends AppMonitor {
    private static final Logger LOGGER = LogManager.getLogger("es.bsc.compss.Agent");
    private static final TransferManager TM = CommAgentAdaptor.getTransferManager();
    private final CommResource orchestrator;
    private final CommTask task;
    private boolean successful;

    public TaskMonitor(ApplicationParameter[] args, ApplicationParameter target, ApplicationParameter[] results, CommResource orchestrator, CommTask request) {
        super(args, target, results);
        this.orchestrator = orchestrator;
        this.successful = false;
        this.task = request;
        this.task.profileArrival();
    }

    protected void specificOnCreation() {
    }

    protected void specificOnAccessesProcessed() {
    }

    protected void specificOnSchedule() {
    }

    protected void specificOnSubmission() {
    }

    protected void specificOnDataReception() {
        this.task.profileFetchedData();
        if (this.orchestrator != null) {
            NIONode n = new NIONode(this.orchestrator.getName(), this.orchestrator.getPort());
            int transferGroupId = this.task.getTransferGroupId();
            Connection c = TM.startConnection(n);
            CommandDataReceived cmd = new CommandDataReceived(transferGroupId);
            c.sendCommand(cmd);
            c.finishConnection();
        }
    }

    protected void specificOnExecutionStart() {
        this.task.getProfile().executionStarts();
    }

    protected void specificOnExecutionStartAt(long ts) {
        this.task.getProfile().executionStartsAt(ts);
    }

    protected void specificOnExecutionEnd() {
        this.task.getProfile().executionEnds();
    }

    protected void specificOnExecutionEndAt(long ts) {
        this.task.getProfile().executionEndsAt(ts);
    }

    protected void specificOnAbortedExecution() {
    }

    protected void specificOnErrorExecution() {
    }

    protected void specificOnFailedExecution() {
    }

    protected void specificOnSuccessfulExecution() {
        this.successful = true;
    }

    protected void specificOnCancellation() {
    }

    protected void specificOnException(COMPSsException e) {
    }

    public void specificOnCompletion() {
        this.task.profileEndNotification();
        if (this.orchestrator != null) {
            this.notifyEnd();
        }
    }

    public void specificOnFailure() {
        if (this.orchestrator != null) {
            this.notifyEnd();
        }
    }

    private void notifyEnd() {
        NIONode n = new NIONode(this.orchestrator.getName(), this.orchestrator.getPort());
        int jobId = this.task.getJobId();
        NIOTaskResult tr = new NIOTaskResult(jobId);
        for (AppMonitor.TaskResult param : this.getResults()) {
            tr.addParamResult(this.createCommResult(param));
        }
        Connection c = TM.startConnection(n);
        CommandNIOTaskDone cmd = new CommandNIOTaskDone(tr, this.successful, this.task.getProfile(), this.task.getHistory().toString(), this.getException());
        c.sendCommand(cmd);
        c.finishConnection();
    }

    private NIOResult createCommResult(AppMonitor.TaskResult taskRes) {
        NIOResult res;
        if (taskRes == null) {
            return new CommResult();
        }
        if (taskRes.isCollective()) {
            LinkedList<NIOResult> elements = new LinkedList<NIOResult>();
            AppMonitor.CollectionTaskResult cResult = (AppMonitor.CollectionTaskResult)taskRes;
            for (AppMonitor.TaskResult subResult : cResult.getSubelements()) {
                elements.add(this.createCommResult(subResult));
            }
            res = new NIOResultCollection(elements);
        } else {
            CommResult commRes = new CommResult();
            if (taskRes.getLocations() != null) {
                commRes.setRemoteData(taskRes.getLocations());
            }
            res = commRes;
        }
        return res;
    }
}

