/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.nio;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class NIOTaskProfile
implements Externalizable {
    private long arrivalTS;
    private long fetchedDataTS;
    private long executionStartTS;
    private long executionEndTS;
    private long resultNotificationTS;

    public void arrived() {
        this.arrivalTS = System.currentTimeMillis();
    }

    public long getArrivalTime() {
        return this.arrivalTS;
    }

    public void dataFetched() {
        this.fetchedDataTS = System.currentTimeMillis();
    }

    public long getFetchedDataTime() {
        return this.fetchedDataTS;
    }

    public void executionStarts() {
        this.executionStartTS = System.currentTimeMillis();
    }

    public void executionStartsAt(long ts) {
        this.executionStartTS = ts;
    }

    public long getExecutionStartTime() {
        return this.executionStartTS;
    }

    public void executionEnds() {
        this.executionEndTS = System.currentTimeMillis();
    }

    public void executionEndsAt(long ts) {
        this.executionEndTS = ts;
    }

    public long getExecutionEndTime() {
        return this.executionEndTS;
    }

    public void end() {
        this.resultNotificationTS = System.currentTimeMillis();
    }

    public long getEndTime() {
        return this.resultNotificationTS;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(this.arrivalTS);
        out.writeLong(this.fetchedDataTS);
        out.writeLong(this.executionStartTS);
        out.writeLong(this.executionEndTS);
        out.writeLong(this.resultNotificationTS);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.arrivalTS = in.readLong();
        this.fetchedDataTS = in.readLong();
        this.executionStartTS = in.readLong();
        this.executionEndTS = in.readLong();
        this.resultNotificationTS = in.readLong();
    }
}

