/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.implementations;

import es.bsc.compss.types.implementations.ImplementationDescription;
import es.bsc.compss.types.implementations.TaskType;
import es.bsc.compss.types.implementations.definition.ImplementationDefinition;
import es.bsc.compss.types.resources.WorkerResourceDescription;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public abstract class Implementation
implements Externalizable {
    private static final long serialVersionUID = 1L;
    protected Integer coreId;
    protected Integer implementationId;
    protected boolean localProcessing;
    protected boolean io;
    protected ImplementationDescription<? extends WorkerResourceDescription, ? extends ImplementationDefinition> implDescription;

    public Implementation() {
    }

    public Implementation(Integer coreId, Integer implementationId, ImplementationDescription<? extends WorkerResourceDescription, ? extends ImplementationDefinition> implDesc) {
        this.coreId = coreId;
        this.implementationId = implementationId;
        this.implDescription = implDesc;
        this.io = implDesc.getConstraints() != null ? !implDesc.getConstraints().usesCPUs() : false;
        this.localProcessing = implDesc.isLocal();
    }

    public Integer getCoreId() {
        return this.coreId;
    }

    public Integer getImplementationId() {
        return this.implementationId;
    }

    public boolean isIO() {
        return this.io;
    }

    public boolean isLocalProcessing() {
        return this.localProcessing;
    }

    public ImplementationDescription<? extends WorkerResourceDescription, ? extends ImplementationDefinition> getDescription() {
        return this.implDescription;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Implementation ").append(this.implementationId);
        sb.append(" for core ").append(this.coreId);
        sb.append(":").append(this.implDescription);
        return sb.toString();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.coreId = (Integer)in.readObject();
        this.implementationId = (Integer)in.readObject();
        this.implDescription = (ImplementationDescription)in.readObject();
        this.io = (Boolean)in.readObject();
        this.localProcessing = in.readBoolean();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.coreId);
        out.writeObject(this.implementationId);
        out.writeObject(this.implDescription);
        out.writeObject(this.io);
        out.writeBoolean(this.localProcessing);
    }

    public abstract TaskType getTaskType();

    public abstract WorkerResourceDescription getRequirements();

    public String getSignature() {
        return this.implDescription.getSignature();
    }
}

