/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.nio;

import es.bsc.comm.Connection;
import es.bsc.comm.MessageHandler;
import es.bsc.comm.exceptions.CommException;
import es.bsc.comm.nio.exceptions.NIOException;
import es.bsc.comm.stage.Transfer;
import es.bsc.compss.nio.NIOAgent;
import es.bsc.compss.nio.commands.Command;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NIOMessageHandler
implements MessageHandler {
    protected static final Logger LOGGER = LogManager.getLogger("es.bsc.compss.Communication");
    private final NIOAgent agent;

    public NIOMessageHandler(NIOAgent agent) {
        this.agent = agent;
    }

    @Override
    public void init() throws CommException {
    }

    @Override
    public void errorHandler(Connection c, Transfer t, CommException ce) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Received error of type " + (Object)((Object)ce.getError()));
            if (ce.getError().equals((Object)CommException.ErrorType.NIO)) {
                NIOException ne = (NIOException)ce;
                LOGGER.debug("- NIOException of type " + (Object)((Object)ne.getSpecificErrorType()));
            }
        }
        String errorText = "NIO Error: " + ce.getMessage() + " processing " + (t == null ? "null" : Integer.valueOf(t.hashCode())) + "\n";
        LOGGER.error(errorText, (Throwable)ce);
        boolean managed = this.agent.checkAndHandleRequestedDataNotAvailableError(c);
        if (!managed && !(managed = this.agent.checkAndHandleCommandError(c))) {
            this.agent.unhandeledError(c);
        }
    }

    @Override
    public void dataReceived(Connection c, Transfer t) {
        LOGGER.debug("Received data " + (t.isFile() ? t.getFileName() : t.getObject()) + " through connection " + c.hashCode());
        if (t.isArray()) {
            this.agent.receivedPartialBindingObjects(c, t);
        } else {
            this.agent.receivedData(c, t);
        }
    }

    @Override
    public void commandReceived(Connection c, Transfer t) {
        try {
            Command cmd = (Command)t.getObject();
            LOGGER.debug("Received Command " + cmd + " through connection " + c.hashCode());
            cmd.handle(this.agent, c);
        }
        catch (Exception e) {
            LOGGER.error("Error receving command. Finishing connection.", (Throwable)e);
            c.finishConnection();
        }
    }

    @Override
    public void writeFinished(Connection c, Transfer t) {
        LOGGER.debug("Finished sending " + (t.isFile() ? t.getFileName() : t.getObject()) + " through connection " + c.hashCode());
        this.agent.releaseSendSlot(c);
    }

    @Override
    public void connectionFinished(Connection c) {
        LOGGER.debug("Connection " + c.hashCode() + " finished");
        if (!c.hasErrors()) {
            this.agent.unregisterConnectionInOngoingCommands(c);
        }
    }

    @Override
    public void shutdown() {
    }
}

