/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.util;

import es.bsc.compss.util.ErrorManager;
import java.io.File;

public class EnvironmentLoader {
    private static final String PREFIX_ENV_VAR = "$";
    private static final String BEGIN_ENV_VAR = "}";
    private static final String END_ENV_VAR = "}";
    private static final String PREFIX_ENV_VAR_SCAPED = "\\$";
    private static final String BEGIN_ENV_VAR_SCAPED = "\\{";
    private static final String END_ENV_VAR_SCAPED = "\\}";

    public static String loadFromEnvironment(String expression) {
        String expressionValue = expression;
        int beginIndex = EnvironmentLoader.findNextValidToken(expressionValue, 0);
        while (beginIndex >= 0) {
            boolean isScaped;
            boolean bl = isScaped = beginIndex >= 1 && expressionValue.charAt(beginIndex - 1) == '\\';
            if (isScaped) {
                StringBuilder sb = new StringBuilder(expressionValue);
                sb.deleteCharAt(beginIndex - 1);
                expressionValue = sb.toString();
            } else {
                int endIndex = EnvironmentLoader.findEndIndex(expressionValue, beginIndex);
                String variableFullName = expressionValue.substring(beginIndex, endIndex);
                String variableValue = EnvironmentLoader.loadEnvVariable(variableFullName);
                if (variableValue != null) {
                    expressionValue = expressionValue.replace(variableFullName, variableValue);
                } else {
                    ErrorManager.warn("[WARNING] Null value obtained while loading " + variableFullName + " from environment");
                    expressionValue = expressionValue.replace(variableFullName, "");
                }
            }
            beginIndex = EnvironmentLoader.findNextValidToken(expressionValue, beginIndex);
        }
        return expressionValue;
    }

    private static int findNextValidToken(String expressionValue, int beginIndex) {
        return expressionValue.indexOf(PREFIX_ENV_VAR, beginIndex);
    }

    private static int findEndIndex(String expressionValue, int beginIndex) {
        int endIndex;
        if (beginIndex + 1 < expressionValue.length()) {
            if (expressionValue.substring(beginIndex, beginIndex + 1).equals("}")) {
                endIndex = expressionValue.indexOf("}", beginIndex) + 1;
            } else {
                endIndex = expressionValue.indexOf(File.separator, beginIndex);
                if (endIndex == -1) {
                    endIndex = expressionValue.length();
                }
            }
        } else {
            endIndex = expressionValue.length();
        }
        return endIndex;
    }

    private static String loadEnvVariable(String variableFullName) {
        String variableLoadName = variableFullName.replaceAll(PREFIX_ENV_VAR_SCAPED, "");
        variableLoadName = variableLoadName.replaceAll(BEGIN_ENV_VAR_SCAPED, "");
        variableLoadName = variableLoadName.replaceAll(END_ENV_VAR_SCAPED, "");
        String variableValue = System.getenv(variableLoadName);
        return variableValue;
    }
}

