/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.agent.comm;

import es.bsc.comm.nio.NIONode;
import es.bsc.compss.COMPSsConstants;
import es.bsc.compss.agent.Agent;
import es.bsc.compss.agent.AgentException;
import es.bsc.compss.agent.AgentInterface;
import es.bsc.compss.agent.AgentInterfaceConfig;
import es.bsc.compss.agent.AppMonitor;
import es.bsc.compss.agent.comm.CommAgent;
import es.bsc.compss.agent.comm.CommAgentAdaptor;
import es.bsc.compss.agent.comm.CommAgentConfig;
import es.bsc.compss.agent.comm.CommAppMonitor;
import es.bsc.compss.agent.comm.messages.types.CommParam;
import es.bsc.compss.agent.comm.messages.types.CommParamCollection;
import es.bsc.compss.agent.comm.messages.types.CommResource;
import es.bsc.compss.agent.comm.messages.types.CommTask;
import es.bsc.compss.agent.types.ApplicationParameter;
import es.bsc.compss.comm.Comm;
import es.bsc.compss.comm.CommAdaptor;
import es.bsc.compss.nio.NIOParam;
import es.bsc.compss.types.CoreElementDefinition;
import es.bsc.compss.types.annotations.parameter.DataType;
import es.bsc.compss.types.annotations.parameter.OnFailure;
import es.bsc.compss.types.implementations.AbstractMethodImplementation;
import es.bsc.compss.types.implementations.Implementation;
import es.bsc.compss.types.implementations.ImplementationDescription;
import es.bsc.compss.types.implementations.definition.ImplementationDefinition;
import es.bsc.compss.types.resources.MethodResourceDescription;
import es.bsc.compss.types.resources.Resource;
import es.bsc.compss.types.resources.WorkerResourceDescription;
import es.bsc.compss.util.EnvironmentLoader;
import es.bsc.compss.util.ErrorManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONObject;

public class CommAgentImpl
implements AgentInterface<CommAgentConfig>,
CommAgent {
    private static final Logger LOGGER = LogManager.getLogger("es.bsc.compss.Agent");
    private CommAgentAdaptor adaptor = null;

    public CommAgentConfig configure(JSONObject confJSON) throws AgentException {
        CommAgentConfig conf;
        try {
            String portSTR = confJSON.getString("PORT");
            portSTR = EnvironmentLoader.loadFromEnvironment(portSTR);
            int port = Integer.valueOf(portSTR);
            if (port <= 0) {
                throw new AgentException("Invalid port number for Comm agent's interface.");
            }
            conf = new CommAgentConfig(this, port);
        }
        catch (Exception e) {
            LOGGER.error("Error configuring agent", (Throwable)e);
            throw new AgentException(e);
        }
        return conf;
    }

    public void start(CommAgentConfig conf) throws AgentException {
        int port = conf.getPort();
        System.setProperty("compss.masterPort", Integer.toString(port));
        CommAgentAdaptor nioAdaptor = (CommAgentAdaptor)Comm.getAdaptors().get(CommAgentAdaptor.ID);
        CommAgentAdaptor commAgentAdaptor = (CommAgentAdaptor)Comm.getAdaptors().get(CommAgentAdaptor.class.getCanonicalName());
        if (nioAdaptor == null && commAgentAdaptor == null) {
            this.adaptor = new CommAgentAdaptor(this);
            LOGGER.info("Starting CommAgent on port " + port);
            this.adaptor.init();
            Comm.registerAdaptor((String)CommAgentAdaptor.ID, (CommAdaptor)this.adaptor);
            Comm.registerAdaptor((String)CommAgentAdaptor.class.getCanonicalName(), (CommAdaptor)this.adaptor);
        } else if (nioAdaptor == null) {
            this.adaptor = commAgentAdaptor;
            Comm.registerAdaptor((String)CommAgentAdaptor.class.getCanonicalName(), (CommAdaptor)this.adaptor);
        } else {
            this.adaptor = nioAdaptor;
            Comm.registerAdaptor((String)CommAgentAdaptor.ID, (CommAdaptor)this.adaptor);
        }
    }

    public void stop() {
    }

    @Override
    public void print(Object o) {
        System.out.println(o);
    }

    @Override
    public void addResources(es.bsc.compss.agent.types.Resource<?, ?> res) {
        try {
            Agent.addResources(res);
        }
        catch (AgentException ex) {
            ErrorManager.warn("Could not add the new server", ex);
        }
    }

    @Override
    public void removeResources(es.bsc.compss.agent.types.Resource<?, ?> resource) {
        try {
            Agent.removeResources((String)resource.getName(), (MethodResourceDescription)resource.getDescription());
        }
        catch (AgentException ae) {
            ae.printStackTrace();
        }
    }

    @Override
    public void removeNode(String node) {
        try {
            Agent.removeNode((String)node);
        }
        catch (AgentException ae) {
            ae.printStackTrace();
        }
    }

    @Override
    public void lostNode(String node) {
        try {
            Agent.lostNode((String)node);
        }
        catch (AgentException ae) {
            ae.printStackTrace();
        }
    }

    @Override
    public void receivedNewTask(NIONode master, CommTask request) {
        COMPSsConstants.Lang lang = request.getLang();
        AbstractMethodImplementation impl = request.getMethodImplementation();
        String ceiClass = request.getParallelismSource();
        int argsCount = request.getParams().size();
        int resultsCount = request.getResults().size();
        ApplicationParameter[] arguments = new ApplicationParameter[argsCount];
        int paramId = 0;
        for (NIOParam np : request.getParams()) {
            arguments[paramId] = np.getType() == DataType.COLLECTION_T ? (CommParamCollection)np : (CommParam)np;
            ++paramId;
        }
        CommParam target = (CommParam)request.getTarget();
        ApplicationParameter[] results = new ApplicationParameter[resultsCount];
        paramId = 0;
        for (NIOParam np : request.getResults()) {
            results[paramId] = (CommParam)np;
            ++paramId;
        }
        CommResource orchestrator = request.getOrchestrator();
        CommAppMonitor monitor = new CommAppMonitor(arguments, target, results, orchestrator, request);
        CoreElementDefinition ced = new CoreElementDefinition();
        ced.setCeSignature(request.getCeSignature());
        ImplementationDescription<? extends WorkerResourceDescription, ? extends ImplementationDefinition> implDef = ((Implementation)impl).getDescription();
        ced.addImplementation(implDef);
        OnFailure onFail = request.getOnFailure();
        try {
            long appId = Agent.runTask((COMPSsConstants.Lang)lang, (CoreElementDefinition)ced, (String)ceiClass, (ApplicationParameter[])arguments, (ApplicationParameter)target, (ApplicationParameter[])results, (AppMonitor)monitor, (OnFailure)onFail);
            LOGGER.info("External job " + request.getJobId() + " is app " + appId);
        }
        catch (AgentException ae) {
            monitor.onFailure();
        }
    }

    public static void main(String[] args) throws Exception {
        int port = Integer.parseInt(args[0]);
        CommAgentImpl cai = new CommAgentImpl();
        CommAgentConfig config = new CommAgentConfig(cai, port);
        Agent.startInterface((AgentInterfaceConfig)config);
        Agent.start();
    }

    @Override
    public Resource getNodeFromResource(es.bsc.compss.agent.types.Resource<?, ?> r) {
        try {
            return Agent.getNodeForResource(r);
        }
        catch (AgentException e) {
            LOGGER.error("Exception raised fetching host for remote data", (Throwable)e);
            return null;
        }
    }
}

