/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.agent.comm;

import es.bsc.comm.nio.NIONode;
import es.bsc.compss.agent.comm.CommAgentAdaptor;
import es.bsc.compss.agent.comm.CommAgentJob;
import es.bsc.compss.agent.comm.CommAgentURI;
import es.bsc.compss.agent.comm.CommData;
import es.bsc.compss.agent.comm.messages.types.CommResource;
import es.bsc.compss.agent.types.PrivateRemoteDataLocation;
import es.bsc.compss.agent.types.RemoteDataLocation;
import es.bsc.compss.agent.types.SharedRemoteDataLocation;
import es.bsc.compss.comm.Comm;
import es.bsc.compss.exceptions.InitNodeException;
import es.bsc.compss.exceptions.UnstartedNodeException;
import es.bsc.compss.nio.NIOAgent;
import es.bsc.compss.nio.NIOData;
import es.bsc.compss.nio.NIOUri;
import es.bsc.compss.nio.master.NIOWorkerNode;
import es.bsc.compss.types.COMPSsNode;
import es.bsc.compss.types.NodeMonitor;
import es.bsc.compss.types.TaskDescription;
import es.bsc.compss.types.annotations.parameter.DataType;
import es.bsc.compss.types.data.LogicalData;
import es.bsc.compss.types.data.location.DataLocation;
import es.bsc.compss.types.data.location.ProtocolType;
import es.bsc.compss.types.data.location.SharedDisk;
import es.bsc.compss.types.implementations.Implementation;
import es.bsc.compss.types.job.Job;
import es.bsc.compss.types.job.JobListener;
import es.bsc.compss.types.resources.ExecutorShutdownListener;
import es.bsc.compss.types.resources.Resource;
import es.bsc.compss.types.resources.ResourceDescription;
import es.bsc.compss.types.resources.ShutdownListener;
import es.bsc.compss.types.uri.MultiURI;
import es.bsc.compss.types.uri.SimpleURI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CommAgentWorker
extends NIOWorkerNode {
    private final CommResource remoteResource;

    public CommAgentWorker(String name, int port, CommAgentAdaptor adaptor, NodeMonitor monitor) {
        super(null, adaptor, monitor);
        this.remoteResource = new CommResource(name, port);
        this.node = new NIONode(name, port);
        this.started = true;
    }

    @Override
    public String getHost() {
        return this.remoteResource.getName();
    }

    @Override
    public String getUser() {
        return "";
    }

    @Override
    public String getClasspath() {
        return "";
    }

    @Override
    public String getPythonpath() {
        return "";
    }

    @Override
    public void updateTaskCount(int processorCoreCount) {
    }

    @Override
    public void announceDestruction() {
    }

    @Override
    public void announceCreation() {
    }

    @Override
    public String getName() {
        return this.remoteResource.getName();
    }

    @Override
    public void start() throws InitNodeException {
    }

    @Override
    public void setInternalURI(MultiURI u) throws UnstartedNodeException {
        CommAgentURI nu = new CommAgentURI(this.remoteResource, this.node, u.getPath(), ProtocolType.ANY_URI);
        u.setInternalURI(CommAgentAdaptor.ID, (Object)nu);
    }

    @Override
    public Job<?> newJob(int taskId, TaskDescription taskParams, Implementation impl, Resource res, List<String> slaveWorkersNodeNames, JobListener listener, List<Integer> predecessors, Integer numSuccessors) {
        return new CommAgentJob(taskId, taskParams, impl, res, slaveWorkersNodeNames, listener, predecessors, numSuccessors);
    }

    @Override
    public void stop(ShutdownListener sl) {
        sl.notifyEnd();
    }

    @Override
    protected NIOData getNIODatafromLogicalData(LogicalData ld) {
        CommData data = new CommData(ld.getName());
        for (MultiURI uri : ld.getURIs()) {
            try {
                NIOUri o = (NIOUri)uri.getInternalURI(NIOAgent.ID);
                if (o == null) continue;
                data.addSource(o);
            }
            catch (UnstartedNodeException unstartedNodeException) {}
        }
        this.appendRDLfromLD(ld, data.getRemoteLocations());
        return data;
    }

    private void appendRDLfromLD(LogicalData ld, Collection<RemoteDataLocation> locations) {
        boolean isLocal = false;
        for (DataLocation loc : ld.getLocations()) {
            boolean localLocation = this.isLocal(loc);
            boolean bl = isLocal = isLocal || localLocation;
            RemoteDataLocation rdl = this.createRemoteDLFromLocation(loc, localLocation);
            if (rdl == null) continue;
            locations.add(rdl);
        }
        boolean done = false;
        if (isLocal) {
            while (!done) {
                ArrayList<PrivateRemoteDataLocation> localLocations = new ArrayList<PrivateRemoteDataLocation>();
                try {
                    for (String alias : ld.getKnownAlias()) {
                        localLocations.add(new PrivateRemoteDataLocation(CommAgentAdaptor.LOCAL_RESOURCE, alias));
                    }
                }
                catch (ConcurrentModificationException cme) {
                    LOGGER.warn("Logical data was modified while constructing it's remote data location to send as a result");
                }
                locations.addAll(localLocations);
                done = true;
            }
        }
    }

    private RemoteDataLocation createRemoteDLFromLocation(DataLocation loc, boolean isLocal) {
        RemoteDataLocation rdl = null;
        switch (loc.getType()) {
            case PRIVATE: {
                if (isLocal) break;
                for (MultiURI uri : loc.getURIs()) {
                    es.bsc.compss.agent.types.Resource hostResource = uri.getHost() == Comm.getAppHost() ? CommAgentAdaptor.LOCAL_RESOURCE : this.createRemoteResourceFromResource(uri.getHost());
                    String pathInHost = uri.getPath();
                    if (hostResource == null) continue;
                    rdl = new PrivateRemoteDataLocation(hostResource, pathInHost);
                }
                break;
            }
            case SHARED: {
                SharedDisk sd = loc.getSharedDisk();
                String diskName = sd.getName();
                Map sdMountpoints = sd.getAllMountpoints();
                SharedRemoteDataLocation.Mountpoint[] srdlMountpoints = new SharedRemoteDataLocation.Mountpoint[sdMountpoints.size()];
                int i = 0;
                for (Map.Entry sdMp : sdMountpoints.entrySet()) {
                    Resource host = (Resource)sdMp.getKey();
                    es.bsc.compss.agent.types.Resource r = host == Comm.getAppHost() ? CommAgentAdaptor.LOCAL_RESOURCE : this.createRemoteResourceFromResource(host);
                    String mountpoint = (String)sdMp.getValue();
                    srdlMountpoints[i++] = new SharedRemoteDataLocation.Mountpoint(r, mountpoint);
                }
                rdl = new SharedRemoteDataLocation(diskName, loc.getPath(), srdlMountpoints);
                break;
            }
        }
        return rdl;
    }

    private es.bsc.compss.agent.types.Resource<?, ?> createRemoteResourceFromResource(Resource res) {
        COMPSsNode node = res.getNode();
        String name = node.getName();
        String adaptor = node.getAdaptor();
        Object project = node.getProjectProperties();
        Object resources = node.getResourcesProperties();
        if (resources == null) {
            return null;
        }
        es.bsc.compss.agent.types.Resource<Object, Object> remoteResource = new es.bsc.compss.agent.types.Resource<Object, Object>(name, null, adaptor, project, resources);
        return remoteResource;
    }

    private boolean isLocal(DataLocation dl) {
        for (Resource host : dl.getHosts()) {
            if (host != Comm.getAppHost()) continue;
            return true;
        }
        return false;
    }

    @Override
    public SimpleURI getCompletePath(DataType type, String name) {
        SimpleURI uri = new SimpleURI(name);
        return uri;
    }

    @Override
    public void deleteTemporary() {
    }

    @Override
    public Set<String> generateWorkerAnalysisFiles() {
        return null;
    }

    @Override
    public void shutdownExecutionManager(ExecutorShutdownListener sl) {
        sl.notifyEnd();
    }

    @Override
    public Set<String> generateWorkerDebugFiles() {
        return null;
    }

    @Override
    public void increaseComputingCapabilities(ResourceDescription description) {
    }

    @Override
    public void reduceComputingCapabilities(ResourceDescription description) {
    }

    @Override
    public String getAdaptor() {
        return this.remoteResource.getAdaptor();
    }

    @Override
    public Object getProjectProperties() {
        return this.remoteResource.getProjectConf();
    }

    @Override
    public Object getResourcesProperties() {
        return this.remoteResource.getResourceConf();
    }

    public String toString() {
        return "CommAgentWorker=[remoteResource=" + this.remoteResource.toString() + "; node" + this.node.toString() + "]";
    }
}

