/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.agent.comm;

import es.bsc.comm.Connection;
import es.bsc.comm.TransferManager;
import es.bsc.comm.nio.NIONode;
import es.bsc.compss.agent.AppMonitor;
import es.bsc.compss.agent.comm.CommAgentAdaptor;
import es.bsc.compss.agent.comm.messages.types.CommResource;
import es.bsc.compss.agent.comm.messages.types.CommResult;
import es.bsc.compss.agent.comm.messages.types.CommTask;
import es.bsc.compss.agent.types.ApplicationParameter;
import es.bsc.compss.nio.NIOResult;
import es.bsc.compss.nio.NIOResultCollection;
import es.bsc.compss.nio.NIOTaskResult;
import es.bsc.compss.nio.commands.CommandDataReceived;
import es.bsc.compss.nio.commands.CommandNIOTaskDone;
import es.bsc.compss.worker.COMPSsException;
import java.util.Collection;
import java.util.LinkedList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CommAppMonitor
extends AppMonitor {
    private static final Logger LOGGER = LogManager.getLogger("es.bsc.compss.Agent");
    private static final TransferManager TM = CommAgentAdaptor.getTransferManager();
    private final CommResource orchestrator;
    private final CommTask task;
    private boolean successful;

    public CommAppMonitor(ApplicationParameter[] args, ApplicationParameter target, ApplicationParameter[] results, CommResource orchestrator, CommTask request) {
        super(args, target, results);
        this.orchestrator = orchestrator;
        this.successful = false;
        this.task = request;
        this.task.profileArrival();
    }

    private NIOResult createCommResult(AppMonitor.TaskResult taskRes) {
        NIOResult res;
        if (taskRes == null) {
            return new CommResult();
        }
        if (taskRes.isCollective()) {
            LinkedList<NIOResult> elements = new LinkedList<NIOResult>();
            AppMonitor.CollectionTaskResult cResult = (AppMonitor.CollectionTaskResult)taskRes;
            for (AppMonitor.TaskResult subResult : cResult.getSubelements()) {
                elements.add(this.createCommResult(subResult));
            }
            res = new NIOResultCollection(elements);
        } else {
            CommResult commRes = new CommResult();
            Collection rdl = taskRes.getLocations();
            if (rdl != null) {
                commRes.setRemoteData(rdl);
            }
            res = commRes;
        }
        return res;
    }

    public CommTaskMonitor getTaskMonitor() {
        return new CommTaskMonitor();
    }

    public void stalledApplication() {
        super.stalledApplication();
    }

    protected void specificOnCancellation() {
    }

    protected void specificOnException(COMPSsException e) {
    }

    protected void specificOnCompletion() {
        if (this.orchestrator != null) {
            this.notifyEnd();
        }
    }

    protected void specificOnFailure() {
        if (this.orchestrator != null) {
            this.notifyEnd();
        }
    }

    private void notifyEnd() {
        int jobId = this.task.getJobId();
        NIOTaskResult tr = new NIOTaskResult(jobId);
        for (AppMonitor.TaskResult param : this.getResults()) {
            tr.addParamResult(this.createCommResult(param));
        }
        NIONode n = new NIONode(this.orchestrator.getName(), this.orchestrator.getPort());
        Connection c = TM.startConnection(n);
        CommandNIOTaskDone cmd = new CommandNIOTaskDone(tr, this.successful, this.task.getProfile(), this.task.getHistory().toString(), this.getException());
        c.sendCommand(cmd);
        c.finishConnection();
    }

    protected class CommTaskMonitor
    extends AppMonitor.UniqueTaskMonitor {
        protected CommTaskMonitor() {
            super((AppMonitor)CommAppMonitor.this);
        }

        protected void specificOnCreation() {
        }

        protected void specificOnAccessesProcessed() {
        }

        protected void specificOnSchedule() {
        }

        protected void specificOnSubmission() {
        }

        protected void specificOnDataReception() {
            CommAppMonitor.this.task.profileFetchedData();
            if (CommAppMonitor.this.orchestrator != null) {
                NIONode n = new NIONode(CommAppMonitor.this.orchestrator.getName(), CommAppMonitor.this.orchestrator.getPort());
                int transferGroupId = CommAppMonitor.this.task.getTransferGroupId();
                Connection c = TM.startConnection(n);
                CommandDataReceived cmd = new CommandDataReceived(transferGroupId);
                c.sendCommand(cmd);
                c.finishConnection();
            }
        }

        protected void specificOnExecutionStart() {
            CommAppMonitor.this.task.getProfile().executionStarts();
        }

        protected void specificOnExecutionStartAt(long ts) {
            CommAppMonitor.this.task.getProfile().executionStartsAt(ts);
        }

        protected void specificOnExecutionEnd() {
            CommAppMonitor.this.task.getProfile().executionEnds();
        }

        protected void specificOnExecutionEndAt(long ts) {
            CommAppMonitor.this.task.getProfile().executionEndsAt(ts);
        }

        protected void specificOnAbortedExecution() {
        }

        protected void specificOnErrorExecution() {
        }

        protected void specificOnFailedExecution() {
        }

        protected void specificOnSuccessfulExecution() {
            CommAppMonitor.this.successful = true;
        }

        protected void specificOnCancellation() {
        }

        protected void specificOnException(COMPSsException e) {
        }

        public void specificOnCompletion() {
            CommAppMonitor.this.task.profileEndNotification();
        }

        public void specificOnFailure() {
        }
    }
}

