/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.implementations.definition;

import es.bsc.compss.types.implementations.MethodType;
import es.bsc.compss.types.implementations.TaskType;
import es.bsc.compss.types.implementations.definition.AbstractMethodImplementationDefinition;
import es.bsc.compss.util.EnvironmentLoader;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.List;

public class OpenCLDefinition
implements AbstractMethodImplementationDefinition {
    private static final long serialVersionUID = 1L;
    public static final int NUM_PARAMS = 2;
    public static final String SIGNATURE = "opencl.OPENCL";
    private String kernel;
    private String workingDir;

    public OpenCLDefinition() {
    }

    public OpenCLDefinition(String kernel, String workingDir) {
        this.kernel = kernel;
        this.workingDir = workingDir;
    }

    public OpenCLDefinition(String[] implTypeArgs, int offset) {
        this.kernel = EnvironmentLoader.loadFromEnvironment(implTypeArgs[offset]);
        this.workingDir = EnvironmentLoader.loadFromEnvironment(implTypeArgs[offset + 1]);
        if (this.kernel == null || this.kernel.isEmpty()) {
            throw new IllegalArgumentException("Empty kernel annotation for OpenCL method ");
        }
    }

    @Override
    public void appendToArgs(List<String> lArgs, String auxParam) {
        lArgs.add(this.kernel);
        lArgs.add(this.workingDir);
    }

    public String getKernel() {
        return this.kernel;
    }

    public String getWorkingDir() {
        return this.workingDir;
    }

    @Override
    public MethodType getMethodType() {
        return MethodType.OPENCL;
    }

    @Override
    public String toJSON() {
        StringBuilder sb = new StringBuilder("{\"type\":\"OPENCL\",");
        sb.append("\"kernel\":\"").append(this.kernel).append("\"");
        sb.append("}");
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("OpenCL Implementation \n");
        sb.append("\t Kernel: ").append(this.kernel).append("\n");
        sb.append("\t Working directory: ").append(this.workingDir).append("\n");
        return sb.toString();
    }

    @Override
    public String toShortFormat() {
        return " OpenCL Method with kernel " + this.kernel;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.kernel = (String)in.readObject();
        this.workingDir = (String)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.kernel);
        out.writeObject(this.workingDir);
    }

    @Override
    public TaskType getTaskType() {
        return TaskType.METHOD;
    }
}

