/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.distrostreamlib.api.impl;

import es.bsc.distrostreamlib.api.DistroStream;
import es.bsc.distrostreamlib.client.DistroStreamClient;
import es.bsc.distrostreamlib.exceptions.RegistrationException;
import es.bsc.distrostreamlib.requests.CloseStreamRequest;
import es.bsc.distrostreamlib.requests.RegisterStreamRequest;
import es.bsc.distrostreamlib.requests.StreamStatusRequest;
import es.bsc.distrostreamlib.types.ConsumerMode;
import es.bsc.distrostreamlib.types.StreamType;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class DistroStreamImpl<T>
implements DistroStream<T> {
    private static final Logger LOGGER = LogManager.getLogger("es.bsc.distroStreamLib.stream.DistroStream");
    protected static final String ERR_CODE_PREFIX = "  - Error Code: ";
    protected static final String ERR_MSG_PREFIX = "  - Nested Error Message: ";
    protected String alias;
    protected String id;
    protected StreamType streamType;
    protected ConsumerMode mode;

    public DistroStreamImpl() {
    }

    public DistroStreamImpl(String alias, StreamType streamType, ConsumerMode accessMode, List<String> internalStreamInfo) throws RegistrationException {
        this.alias = alias;
        this.streamType = streamType;
        LOGGER.info("Registering new Stream...");
        RegisterStreamRequest req = new RegisterStreamRequest(alias, streamType, accessMode, internalStreamInfo);
        DistroStreamClient.request(req);
        req.waitProcessed();
        int error = req.getErrorCode();
        if (error != 0) {
            StringBuilder sb = new StringBuilder();
            sb.append("ERROR: Cannot register stream").append("\n");
            sb.append(ERR_CODE_PREFIX).append(error).append("\n");
            sb.append(ERR_MSG_PREFIX).append(req.getErrorMessage()).append("\n");
            throw new RegistrationException(sb.toString());
        }
        this.id = req.getResponseMessage();
        this.mode = accessMode;
        LOGGER.info("New Stream registered with ID = " + this.id);
    }

    @Override
    public final String getId() {
        return this.id;
    }

    @Override
    public final String getAlias() {
        return this.alias;
    }

    @Override
    public final StreamType getStreamType() {
        return this.streamType;
    }

    @Override
    public final boolean isClosed() {
        StreamStatusRequest req = new StreamStatusRequest(this.id);
        DistroStreamClient.request(req);
        req.waitProcessed();
        int error = req.getErrorCode();
        if (error != 0) {
            StringBuilder sb = new StringBuilder();
            sb.append("ERROR: Cannot retrieve stream status").append("\n");
            sb.append(ERR_CODE_PREFIX).append(error).append("\n");
            sb.append(ERR_MSG_PREFIX).append(req.getErrorMessage()).append("\n");
            LOGGER.error(sb.toString());
            return false;
        }
        return Boolean.parseBoolean(req.getResponseMessage());
    }

    @Override
    public final void close() {
        CloseStreamRequest req = new CloseStreamRequest(this.id);
        DistroStreamClient.request(req);
        req.waitProcessed();
        int error = req.getErrorCode();
        if (error != 0) {
            StringBuilder sb = new StringBuilder();
            sb.append("ERROR: Cannot close stream").append("\n");
            sb.append(ERR_CODE_PREFIX).append(error).append("\n");
            sb.append(ERR_MSG_PREFIX).append(req.getErrorMessage()).append("\n");
            LOGGER.error(sb.toString());
            return;
        }
    }

    @Override
    public void readExternal(ObjectInput oi) throws IOException, ClassNotFoundException {
        this.alias = (String)oi.readObject();
        this.id = (String)oi.readObject();
        this.streamType = (StreamType)((Object)oi.readObject());
        this.mode = (ConsumerMode)((Object)oi.readObject());
    }

    @Override
    public void writeExternal(ObjectOutput oo) throws IOException {
        oo.writeObject(this.alias);
        oo.writeObject(this.id);
        oo.writeObject((Object)this.streamType);
        oo.writeObject((Object)this.mode);
    }
}

