/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types;

import es.bsc.compss.types.implementations.AbstractMethodImplementation;
import es.bsc.compss.types.implementations.BinaryImplementation;
import es.bsc.compss.types.implementations.COMPSsImplementation;
import es.bsc.compss.types.implementations.DecafImplementation;
import es.bsc.compss.types.implementations.Implementation;
import es.bsc.compss.types.implementations.MPIImplementation;
import es.bsc.compss.types.implementations.MethodImplementation;
import es.bsc.compss.types.implementations.MultiNodeImplementation;
import es.bsc.compss.types.implementations.OmpSsImplementation;
import es.bsc.compss.types.implementations.OpenCLImplementation;
import es.bsc.compss.types.implementations.ServiceImplementation;
import es.bsc.compss.types.resources.MethodResourceDescription;
import es.bsc.compss.util.EnvironmentLoader;

public abstract class ImplementationDefinition {
    private final String signature;

    public static final ImplementationDefinition defineImplementation(String implType, String implSignature, MethodResourceDescription implConstraints, String ... implTypeArgs) throws IllegalArgumentException {
        ImplementationDefinition id = null;
        if (implType.toUpperCase().compareTo(Implementation.TaskType.SERVICE.toString()) == 0) {
            if (implTypeArgs.length != 4) {
                throw new IllegalArgumentException("Incorrect parameters for type SERVICE on " + implSignature);
            }
            String namespace = EnvironmentLoader.loadFromEnvironment(implTypeArgs[0]);
            String serviceName = EnvironmentLoader.loadFromEnvironment(implTypeArgs[1]);
            String operation = EnvironmentLoader.loadFromEnvironment(implTypeArgs[2]);
            String port = EnvironmentLoader.loadFromEnvironment(implTypeArgs[3]);
            id = new ServiceDefinition(implSignature, namespace, serviceName, operation, port);
        } else {
            AbstractMethodImplementation.MethodType mt;
            try {
                mt = AbstractMethodImplementation.MethodType.valueOf(implType);
            }
            catch (IllegalArgumentException iae) {
                throw new IllegalArgumentException("Unrecognised method type " + implType);
            }
            switch (mt) {
                case METHOD: {
                    if (implTypeArgs.length != 2) {
                        throw new IllegalArgumentException("Incorrect parameters for type METHOD on " + implSignature);
                    }
                    String declaringClass = EnvironmentLoader.loadFromEnvironment(implTypeArgs[0]);
                    String methodName = EnvironmentLoader.loadFromEnvironment(implTypeArgs[1]);
                    if (declaringClass == null || declaringClass.isEmpty()) {
                        throw new IllegalArgumentException("Empty declaringClass annotation for method " + implSignature);
                    }
                    if (methodName == null || methodName.isEmpty()) {
                        throw new IllegalArgumentException("Empty methodName annotation for method " + implSignature);
                    }
                    id = new MethodDefinition(implSignature, declaringClass, methodName, implConstraints);
                    break;
                }
                case BINARY: {
                    if (implTypeArgs.length != 2) {
                        throw new IllegalArgumentException("Incorrect parameters for type BINARY on " + implSignature);
                    }
                    String binary = EnvironmentLoader.loadFromEnvironment(implTypeArgs[0]);
                    String binaryWorkingDir = EnvironmentLoader.loadFromEnvironment(implTypeArgs[1]);
                    if (binary == null || binary.isEmpty()) {
                        throw new IllegalArgumentException("Empty binary annotation for BINARY method " + implSignature);
                    }
                    id = new BinaryDefinition(implSignature, binary, binaryWorkingDir, implConstraints);
                    break;
                }
                case MPI: {
                    if (implTypeArgs.length != 3) {
                        throw new IllegalArgumentException("Incorrect parameters for type MPI on " + implSignature);
                    }
                    String mpiBinary = EnvironmentLoader.loadFromEnvironment(implTypeArgs[0]);
                    String mpiWorkingDir = EnvironmentLoader.loadFromEnvironment(implTypeArgs[1]);
                    String mpiRunner = EnvironmentLoader.loadFromEnvironment(implTypeArgs[2]);
                    if (mpiRunner == null || mpiRunner.isEmpty()) {
                        throw new IllegalArgumentException("Empty mpiRunner annotation for MPI method " + implSignature);
                    }
                    if (mpiBinary == null || mpiBinary.isEmpty()) {
                        throw new IllegalArgumentException("Empty binary annotation for MPI method " + implSignature);
                    }
                    id = new MPIDefinition(implSignature, mpiBinary, mpiWorkingDir, mpiRunner, implConstraints);
                    break;
                }
                case COMPSs: {
                    if (implTypeArgs.length != 4) {
                        throw new IllegalArgumentException("Incorrect parameters for type MPI on " + implSignature);
                    }
                    String runcompss = EnvironmentLoader.loadFromEnvironment(implTypeArgs[0]);
                    String flags = EnvironmentLoader.loadFromEnvironment(implTypeArgs[1]);
                    String appName = EnvironmentLoader.loadFromEnvironment(implTypeArgs[2]);
                    String compssWorkingDir = EnvironmentLoader.loadFromEnvironment(implTypeArgs[3]);
                    if (appName == null || appName.isEmpty()) {
                        throw new IllegalArgumentException("Empty appName annotation for COMPSs method " + implSignature);
                    }
                    id = new COMPSsDefinition(implSignature, runcompss, flags, appName, compssWorkingDir, implConstraints);
                    break;
                }
                case DECAF: {
                    if (implTypeArgs.length != 5) {
                        throw new IllegalArgumentException("Incorrect parameters for type DECAF on " + implSignature);
                    }
                    String dfScript = EnvironmentLoader.loadFromEnvironment(implTypeArgs[0]);
                    String dfExecutor = EnvironmentLoader.loadFromEnvironment(implTypeArgs[1]);
                    String dfLib = EnvironmentLoader.loadFromEnvironment(implTypeArgs[2]);
                    String decafWorkingDir = EnvironmentLoader.loadFromEnvironment(implTypeArgs[3]);
                    String decafRunner = EnvironmentLoader.loadFromEnvironment(implTypeArgs[4]);
                    if (decafRunner == null || decafRunner.isEmpty()) {
                        throw new IllegalArgumentException("Empty mpiRunner annotation for DECAF method " + implSignature);
                    }
                    if (dfScript == null || dfScript.isEmpty()) {
                        throw new IllegalArgumentException("Empty dfScript annotation for DECAF method " + implSignature);
                    }
                    id = new DecafDefinition(implSignature, dfScript, dfExecutor, dfLib, decafWorkingDir, decafRunner, implConstraints);
                    break;
                }
                case OMPSS: {
                    if (implTypeArgs.length != 2) {
                        throw new IllegalArgumentException("Incorrect parameters for type OMPSS on " + implSignature);
                    }
                    String ompssBinary = EnvironmentLoader.loadFromEnvironment(implTypeArgs[0]);
                    String ompssWorkingDir = EnvironmentLoader.loadFromEnvironment(implTypeArgs[1]);
                    if (ompssBinary == null || ompssBinary.isEmpty()) {
                        throw new IllegalArgumentException("Empty binary annotation for OmpSs method " + implSignature);
                    }
                    id = new OmpSsDefinition(implSignature, ompssBinary, ompssWorkingDir, implConstraints);
                    break;
                }
                case OPENCL: {
                    if (implTypeArgs.length != 2) {
                        throw new IllegalArgumentException("Incorrect parameters for type OPENCL on " + implSignature);
                    }
                    String openclKernel = EnvironmentLoader.loadFromEnvironment(implTypeArgs[0]);
                    String openclWorkingDir = EnvironmentLoader.loadFromEnvironment(implTypeArgs[1]);
                    if (openclKernel == null || openclKernel.isEmpty()) {
                        throw new IllegalArgumentException("Empty kernel annotation for OpenCL method " + implSignature);
                    }
                    id = new OpenCLDefinition(implSignature, openclKernel, openclWorkingDir, implConstraints);
                    break;
                }
                case MULTI_NODE: {
                    if (implTypeArgs.length != 2) {
                        throw new IllegalArgumentException("Incorrect parameters for type MultiNode on " + implSignature);
                    }
                    String multiNodeClass = EnvironmentLoader.loadFromEnvironment(implTypeArgs[0]);
                    String multiNodeName = EnvironmentLoader.loadFromEnvironment(implTypeArgs[1]);
                    if (multiNodeClass == null || multiNodeClass.isEmpty()) {
                        throw new IllegalArgumentException("Empty declaringClass annotation for method " + implSignature);
                    }
                    if (multiNodeName == null || multiNodeName.isEmpty()) {
                        throw new IllegalArgumentException("Empty methodName annotation for method " + implSignature);
                    }
                    id = new MultiNodeDefinition(implSignature, multiNodeClass, multiNodeName, implConstraints);
                }
            }
        }
        return id;
    }

    private ImplementationDefinition(String signature) {
        this.signature = signature;
    }

    public String getSignature() {
        return this.signature;
    }

    public abstract Implementation getImpl(int var1, int var2);

    private static class MultiNodeDefinition
    extends ImplementationDefinition {
        private final String multiNodeClass;
        private final String multiNodeName;
        private final MethodResourceDescription implConstraints;

        private MultiNodeDefinition(String signature, String multiNodeClass, String multiNodeName, MethodResourceDescription implConstraints) {
            super(signature);
            this.multiNodeClass = multiNodeClass;
            this.multiNodeName = multiNodeName;
            this.implConstraints = implConstraints;
        }

        @Override
        public Implementation getImpl(int coreId, int implId) {
            return new MultiNodeImplementation(this.multiNodeClass, this.multiNodeName, coreId, implId, this.implConstraints);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("MultiNode Implementation \n");
            sb.append("\t Signature: ").append(this.getSignature()).append("\n");
            sb.append("\t Class: ").append(this.multiNodeClass).append("\n");
            sb.append("\t Name: ").append(this.multiNodeName).append("\n");
            sb.append("\t Constraints: ").append(this.implConstraints);
            return sb.toString();
        }
    }

    private static class BinaryDefinition
    extends ImplementationDefinition {
        private final String binary;
        private final String workingDir;
        private final MethodResourceDescription implConstraints;

        private BinaryDefinition(String signature, String binary, String workingDir, MethodResourceDescription implConstraints) {
            super(signature);
            this.binary = binary;
            this.workingDir = workingDir;
            this.implConstraints = implConstraints;
        }

        @Override
        public Implementation getImpl(int coreId, int implId) {
            return new BinaryImplementation(this.binary, this.workingDir, coreId, implId, this.implConstraints);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("Binary Implementation \n");
            sb.append("\t Signature: ").append(this.getSignature()).append("\n");
            sb.append("\t Binary: ").append(this.binary).append("\n");
            sb.append("\t Working directory: ").append(this.workingDir).append("\n");
            sb.append("\t Constraints: ").append(this.implConstraints);
            return sb.toString();
        }
    }

    private static class OpenCLDefinition
    extends ImplementationDefinition {
        private final String kernel;
        private final String workingDir;
        private final MethodResourceDescription implConstraints;

        private OpenCLDefinition(String signature, String kernel, String workingDir, MethodResourceDescription implConstraints) {
            super(signature);
            this.kernel = kernel;
            this.workingDir = workingDir;
            this.implConstraints = implConstraints;
        }

        @Override
        public Implementation getImpl(int coreId, int implId) {
            return new OpenCLImplementation(this.kernel, this.workingDir, coreId, implId, this.implConstraints);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("OpenCL Implementation \n");
            sb.append("\t Signature: ").append(this.getSignature()).append("\n");
            sb.append("\t Kernel: ").append(this.kernel).append("\n");
            sb.append("\t Working directory: ").append(this.workingDir).append("\n");
            sb.append("\t Constraints: ").append(this.implConstraints);
            return sb.toString();
        }
    }

    private static class OmpSsDefinition
    extends ImplementationDefinition {
        private final String binary;
        private final String workingDir;
        private final MethodResourceDescription implConstraints;

        private OmpSsDefinition(String signature, String binary, String workingDir, MethodResourceDescription implConstraints) {
            super(signature);
            this.binary = binary;
            this.workingDir = workingDir;
            this.implConstraints = implConstraints;
        }

        @Override
        public Implementation getImpl(int coreId, int implId) {
            return new OmpSsImplementation(this.binary, this.workingDir, coreId, implId, this.implConstraints);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("OmpSs Implementation \n");
            sb.append("\t Signature: ").append(this.getSignature()).append("\n");
            sb.append("\t Binary: ").append(this.binary).append("\n");
            sb.append("\t Working directory: ").append(this.workingDir).append("\n");
            sb.append("\t Constraints: ").append(this.implConstraints);
            return sb.toString();
        }
    }

    private static class COMPSsDefinition
    extends ImplementationDefinition {
        private final String runcompss;
        private final String flags;
        private final String appName;
        private final String workingDir;
        private final MethodResourceDescription implConstraints;

        private COMPSsDefinition(String signature, String runcompss, String flags, String appName, String workingDir, MethodResourceDescription implConstraints) {
            super(signature);
            this.runcompss = runcompss;
            this.flags = flags;
            this.appName = appName;
            this.workingDir = workingDir;
            this.implConstraints = implConstraints;
        }

        @Override
        public Implementation getImpl(int coreId, int implId) {
            return new COMPSsImplementation(this.runcompss, this.flags, this.appName, this.workingDir, coreId, implId, this.implConstraints);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("COMPSs Implementation \n");
            sb.append("\t Signature: ").append(this.getSignature()).append("\n");
            sb.append("\t Flags: ").append(this.flags).append("\n");
            sb.append("\t Application name: ").append(this.appName).append("\n");
            sb.append("\t Working directory: ").append(this.workingDir).append("\n");
            sb.append("\t Constraints: ").append(this.implConstraints);
            return sb.toString();
        }
    }

    private static class DecafDefinition
    extends ImplementationDefinition {
        private final String dfScript;
        private final String dfExecutor;
        private final String dfLib;
        private final String workingDir;
        private final String mpiRunner;
        private final MethodResourceDescription implConstraints;

        private DecafDefinition(String signature, String dfScript, String dfExecutor, String dfLib, String workingDir, String mpiRunner, MethodResourceDescription implConstraints) {
            super(signature);
            this.dfScript = dfScript;
            this.dfExecutor = dfExecutor;
            this.dfLib = dfLib;
            this.workingDir = workingDir;
            this.mpiRunner = mpiRunner;
            this.implConstraints = implConstraints;
        }

        @Override
        public Implementation getImpl(int coreId, int implId) {
            return new DecafImplementation(this.dfScript, this.dfExecutor, this.dfLib, this.workingDir, this.mpiRunner, coreId, implId, this.implConstraints);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("DECAF Implementation \n");
            sb.append("\t Signature: ").append(this.getSignature()).append("\n");
            sb.append("\t Decaf script: ").append(this.dfScript).append("\n");
            sb.append("\t Decaf executor: ").append(this.dfExecutor).append("\n");
            sb.append("\t Decaf lib: ").append(this.dfLib).append("\n");
            sb.append("\t MPI runner: ").append(this.mpiRunner).append("\n");
            sb.append("\t Working directory: ").append(this.workingDir).append("\n");
            sb.append("\t Constraints: ").append(this.implConstraints);
            return sb.toString();
        }
    }

    private static class MPIDefinition
    extends ImplementationDefinition {
        private final String binary;
        private final String workingDir;
        private final String mpiRunner;
        private final MethodResourceDescription implConstraints;

        private MPIDefinition(String signature, String binary, String workingDir, String mpiRunner, MethodResourceDescription implConstraints) {
            super(signature);
            this.binary = binary;
            this.workingDir = workingDir;
            this.mpiRunner = mpiRunner;
            this.implConstraints = implConstraints;
        }

        @Override
        public Implementation getImpl(int coreId, int implId) {
            return new MPIImplementation(this.binary, this.workingDir, this.mpiRunner, coreId, implId, this.implConstraints);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("MPI Implementation \n");
            sb.append("\t Signature: ").append(this.getSignature()).append("\n");
            sb.append("\t Binary: ").append(this.binary).append("\n");
            sb.append("\t MPI runner: ").append(this.mpiRunner).append("\n");
            sb.append("\t Working directory: ").append(this.workingDir).append("\n");
            sb.append("\t Constraints: ").append(this.implConstraints);
            return sb.toString();
        }
    }

    private static class ServiceDefinition
    extends ImplementationDefinition {
        private final String namespace;
        private final String serviceName;
        private final String operation;
        private final String port;

        private ServiceDefinition(String signature, String namespace, String serviceName, String operation, String port) {
            super(signature);
            this.namespace = namespace;
            this.serviceName = serviceName;
            this.operation = operation;
            this.port = port;
        }

        @Override
        public Implementation getImpl(int coreId, int implId) {
            return new ServiceImplementation(coreId, this.namespace, this.serviceName, this.port, this.operation);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("SERVICE Implementation \n");
            sb.append("\t Signature: ").append(this.getSignature()).append("\n");
            sb.append("\t Namespace: ").append(this.namespace).append("\n");
            sb.append("\t Service name: ").append(this.serviceName).append("\n");
            sb.append("\t Operation: ").append(this.operation).append("\n");
            sb.append("\t Port: ").append(this.port).append("\n");
            return sb.toString();
        }
    }

    private static class MethodDefinition
    extends ImplementationDefinition {
        private final String declaringClass;
        private final String methodName;
        private final MethodResourceDescription implConstraints;

        private MethodDefinition(String implSignature, String declaringClass, String methodName, MethodResourceDescription implConstraints) {
            super(implSignature);
            this.declaringClass = declaringClass;
            this.methodName = methodName;
            this.implConstraints = implConstraints;
        }

        @Override
        public Implementation getImpl(int coreId, int implId) {
            return new MethodImplementation(this.declaringClass, this.methodName, coreId, implId, this.implConstraints);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("METHOD Implementation \n");
            sb.append("\t Signature: ").append(this.getSignature()).append("\n");
            sb.append("\t Declaring class: ").append(this.declaringClass).append("\n");
            sb.append("\t Method name: ").append(this.methodName).append("\n");
            sb.append("\t Constraints: ").append(this.implConstraints);
            return sb.toString();
        }
    }
}

