/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.weaving;

import java.security.AccessController;
import org.eclipse.persistence.internal.localization.LoggingLocalization;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedGetSystemProperty;
import org.eclipse.persistence.logging.AbstractSessionLog;
import org.eclipse.persistence.logging.SessionLog;

public class WeaverLogger {
    private static final SessionLog LOGGER = AbstractSessionLog.getLog();
    private static final String PROPERTY_NAME = "org.eclipse.persistence.jpa.weaving.log.stderr";
    private static final String CATEGORY_SEPARATOR = ": ";
    private static final String STACK_TRACE_PREFIX = " - ";
    private static final boolean doLogStdErr = WeaverLogger.initDoLogStdErr();

    private static boolean initDoLogStdErr() {
        if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
            return Boolean.valueOf(AccessController.doPrivileged(new PrivilegedGetSystemProperty(PROPERTY_NAME)));
        }
        return Boolean.valueOf(System.getProperty(PROPERTY_NAME));
    }

    public static final boolean shouldLog(int level) {
        return doLogStdErr || LOGGER.shouldLog(level, "weaver");
    }

    public static final boolean shouldLog(int level, String category) {
        return doLogStdErr || LOGGER.shouldLog(level, category);
    }

    private static void logStdErr(String category, String messageKey, Object ... arguments) {
        String message = arguments == null || arguments.length == 0 ? LoggingLocalization.buildMessage(messageKey) : LoggingLocalization.buildMessage(messageKey, arguments);
        int messageLength = message != null ? message.length() : 0;
        StringBuilder sb = new StringBuilder(category.length() + CATEGORY_SEPARATOR.length() + messageLength);
        sb.append(category);
        sb.append(CATEGORY_SEPARATOR);
        if (messageLength > 0) {
            sb.append(message);
        }
        System.err.println(sb.toString());
    }

    private static void logThrowableStdErr(String category, Throwable throwable) {
        int categoryLength = category != null ? category.length() + CATEGORY_SEPARATOR.length() : 0;
        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        int n = stackTraceElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement ste = stackTraceElementArray[n2];
            String message = ste.toString();
            StringBuilder sb = new StringBuilder(categoryLength + STACK_TRACE_PREFIX.length() + message.length());
            if (categoryLength > 0) {
                sb.append(category);
                sb.append(CATEGORY_SEPARATOR);
            }
            sb.append(STACK_TRACE_PREFIX);
            sb.append(message);
            System.err.println(sb.toString());
            ++n2;
        }
    }

    public static final void log(int level, String messageKey) {
        LOGGER.log(level, "weaver", messageKey, null);
        if (doLogStdErr) {
            WeaverLogger.logStdErr("weaver", messageKey, new Object[0]);
        }
    }

    public static final void log(int level, String messageKey, Object ... arguments) {
        LOGGER.log(level, "weaver", messageKey, arguments);
        if (doLogStdErr) {
            WeaverLogger.logStdErr("weaver", messageKey, arguments);
        }
    }

    public static final void logThrowable(int level, Throwable throwable) {
        LOGGER.logThrowable(level, "weaver", throwable);
        if (doLogStdErr) {
            WeaverLogger.logThrowableStdErr("weaver", throwable);
        }
    }
}

