/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.agent.rest.types;

import es.bsc.compss.types.project.jaxb.ExternalAdaptorProperties;
import es.bsc.compss.types.project.jaxb.NIOAdaptorProperties;
import es.bsc.compss.types.resources.MethodResourceDescription;
import es.bsc.compss.types.resources.jaxb.ResourcesExternalAdaptorProperties;
import es.bsc.compss.types.resources.jaxb.ResourcesNIOAdaptorProperties;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

public abstract class Resource<P, R> {
    private String name;
    private MethodResourceDescription description;

    public static final Resource createResource(String name, MethodResourceDescription description, String adaptor, Object pConf, Object rConf) {
        switch (adaptor) {
            case "es.bsc.compss.nio.master.NIOAdaptor": {
                return new NIOAdaptorResource(name, description, (NIOAdaptorProperties)pConf, (ResourcesNIOAdaptorProperties)rConf);
            }
        }
        return new ExternalAdaptorResource(name, description, adaptor, (ExternalAdaptorProperties)pConf, (ResourcesExternalAdaptorProperties)rConf);
    }

    public Resource() {
    }

    public Resource(String name, MethodResourceDescription description) {
        this.name = name;
        this.description = description;
    }

    @XmlAttribute
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public MethodResourceDescription getDescription() {
        return this.description;
    }

    public void setDescription(MethodResourceDescription description) {
        this.description = description;
    }

    public abstract String getAdaptor();

    public abstract P getProjectConf();

    public abstract R getResourcesConf();

    public String toString() {
        return "\nName:" + this.name + "\nDescription:" + this.description;
    }

    @XmlRootElement(name="nioResource")
    public static class NIOAdaptorResource
    extends Resource<NIOAdaptorProperties, ResourcesNIOAdaptorProperties> {
        private NIOAdaptorProperties projectConf;
        private ResourcesNIOAdaptorProperties resourcesConf;

        public NIOAdaptorResource() {
        }

        public NIOAdaptorResource(String name, MethodResourceDescription description, NIOAdaptorProperties projectConf, ResourcesNIOAdaptorProperties resourcesConf) {
            super(name, description);
            this.projectConf = projectConf;
            this.resourcesConf = resourcesConf;
        }

        @Override
        public String getAdaptor() {
            return "es.bsc.compss.nio.master.NIOAdaptor";
        }

        @Override
        public NIOAdaptorProperties getProjectConf() {
            return this.projectConf;
        }

        public void setProjectConf(NIOAdaptorProperties projectConf) {
            this.projectConf = projectConf;
        }

        @Override
        public ResourcesNIOAdaptorProperties getResourcesConf() {
            return this.resourcesConf;
        }

        public void setResourcesConf(ResourcesNIOAdaptorProperties resourcesConf) {
            this.resourcesConf = resourcesConf;
        }
    }

    @XmlRootElement(name="externalResource")
    public static class ExternalAdaptorResource
    extends Resource<ExternalAdaptorProperties, ResourcesExternalAdaptorProperties> {
        @XmlElement
        private String adaptor;
        private ExternalAdaptorProperties projectConf;
        private ResourcesExternalAdaptorProperties resourcesConf;

        public ExternalAdaptorResource() {
        }

        public ExternalAdaptorResource(String name, MethodResourceDescription description, String adaptor, ExternalAdaptorProperties projectConf, ResourcesExternalAdaptorProperties resourcesConf) {
            super(name, description);
            this.adaptor = adaptor;
            this.projectConf = projectConf;
            this.resourcesConf = resourcesConf;
        }

        @Override
        public String getAdaptor() {
            return this.adaptor;
        }

        @Override
        public ExternalAdaptorProperties getProjectConf() {
            return this.projectConf;
        }

        public void setProjectConf(ExternalAdaptorProperties projectConf) {
            this.projectConf = projectConf;
        }

        @Override
        public ResourcesExternalAdaptorProperties getResourcesConf() {
            return this.resourcesConf;
        }

        public void setResourcesConf(ResourcesExternalAdaptorProperties resourcesConf) {
            this.resourcesConf = resourcesConf;
        }
    }
}

