/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.queries;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.persistence.core.queries.CoreAttributeItem;
import org.eclipse.persistence.queries.AttributeGroup;
import org.eclipse.persistence.queries.FetchGroup;
import org.eclipse.persistence.queries.LoadGroup;
import org.eclipse.persistence.sessions.CopyGroup;

public class AttributeItem
extends CoreAttributeItem<AttributeGroup>
implements Serializable {
    protected AttributeItem() {
    }

    public AttributeItem(AttributeGroup parent, String attributeName) {
        this.parent = parent;
        this.attributeName = attributeName;
    }

    @Override
    public String getAttributeName() {
        return this.attributeName;
    }

    public AttributeItem toCopyGroup(Map<AttributeGroup, CopyGroup> cloneMap, CopyGroup parentClone, Map copies) {
        AttributeItem clone = new AttributeItem();
        clone.attributeName = this.attributeName;
        if (this.group != null) {
            clone.group = ((AttributeGroup)this.group).toCopyGroup(cloneMap, copies);
        }
        if (clone.keyGroup != null) {
            clone.keyGroup = ((AttributeGroup)this.keyGroup).toCopyGroup(cloneMap, copies);
        }
        clone.parent = parentClone;
        if (this.subGroups != null) {
            clone.subGroups = new HashMap();
            for (Map.Entry group2 : this.subGroups.entrySet()) {
                clone.subGroups.put(group2.getKey(), ((AttributeGroup)group2.getValue()).toCopyGroup(cloneMap, copies));
            }
        }
        if (this.keyGroups != null) {
            clone.keyGroups = new HashMap();
            for (Map.Entry group2 : this.keyGroups.entrySet()) {
                clone.keyGroups.put(group2.getKey(), ((AttributeGroup)group2.getValue()).toCopyGroup(cloneMap, copies));
            }
        }
        return clone;
    }

    public AttributeItem toFetchGroup(Map<AttributeGroup, FetchGroup> cloneMap, FetchGroup parentClone) {
        AttributeItem clone = new AttributeItem();
        clone.attributeName = this.attributeName;
        if (this.group != null) {
            clone.group = ((AttributeGroup)this.group).toFetchGroup(cloneMap);
        }
        if (clone.keyGroup != null) {
            clone.keyGroup = ((AttributeGroup)this.keyGroup).toFetchGroup(cloneMap);
        }
        clone.parent = parentClone;
        if (this.subGroups != null) {
            clone.subGroups = new HashMap();
            for (Map.Entry group2 : this.subGroups.entrySet()) {
                clone.subGroups.put(group2.getKey(), ((AttributeGroup)group2.getValue()).toFetchGroup(cloneMap));
            }
        }
        if (this.keyGroups != null) {
            clone.keyGroups = new HashMap();
            for (Map.Entry group2 : this.keyGroups.entrySet()) {
                clone.keyGroups.put(group2.getKey(), ((AttributeGroup)group2.getValue()).toFetchGroup(cloneMap));
            }
        }
        return clone;
    }

    public AttributeItem toLoadGroup(Map<AttributeGroup, LoadGroup> cloneMap, LoadGroup parentClone, boolean loadOnly) {
        AttributeItem clone = new AttributeItem();
        clone.attributeName = this.attributeName;
        if (this.group != null) {
            clone.group = ((AttributeGroup)this.group).toLoadGroup(cloneMap, loadOnly);
        }
        if (clone.keyGroup != null) {
            clone.keyGroup = ((AttributeGroup)this.keyGroup).toLoadGroup(cloneMap, loadOnly);
        }
        clone.parent = parentClone;
        if (this.subGroups != null) {
            clone.subGroups = new HashMap();
            for (Map.Entry group2 : this.subGroups.entrySet()) {
                clone.subGroups.put(group2.getKey(), ((AttributeGroup)group2.getValue()).toLoadGroup(cloneMap, loadOnly));
            }
        }
        if (this.keyGroups != null) {
            clone.keyGroups = new HashMap();
            for (Map.Entry group2 : this.keyGroups.entrySet()) {
                clone.keyGroups.put(group2.getKey(), ((AttributeGroup)group2.getValue()).toLoadGroup(cloneMap, loadOnly));
            }
        }
        return clone;
    }

    @Override
    public AttributeGroup getParent() {
        return (AttributeGroup)super.getParent();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        AttributeGroup anotherGroup;
        if (this == obj) return true;
        if (obj == null) {
            return false;
        }
        AttributeItem anotherItem = null;
        try {
            anotherItem = (AttributeItem)obj;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        if (this.subGroups != null) {
            if (anotherItem.subGroups == null) {
                return false;
            }
            if (this.subGroups.size() != anotherItem.subGroups.size()) return false;
            for (Map.Entry entry : this.subGroups.entrySet()) {
                anotherGroup = (AttributeGroup)anotherItem.subGroups.get(entry.getKey());
                if (((AttributeGroup)entry.getValue()).equals(anotherGroup)) continue;
                return false;
            }
        } else if (anotherItem.subGroups != null) {
            return false;
        }
        if (this.keyGroups != null) {
            if (anotherItem.keyGroups == null) {
                return false;
            }
            if (this.keyGroups.size() != anotherItem.keyGroups.size()) return false;
            for (Map.Entry entry : this.keyGroups.entrySet()) {
                anotherGroup = (AttributeGroup)anotherItem.keyGroups.get(entry.getKey());
                if (((AttributeGroup)entry.getValue()).equals(anotherGroup)) continue;
                return false;
            }
            return true;
        } else {
            if (anotherItem.keyGroups == null) return true;
            return false;
        }
    }

    @Override
    public AttributeGroup getGroup() {
        return (AttributeGroup)super.getGroup();
    }

    public void setGroup(AttributeGroup group2) {
        this.group = group2;
    }
}

