/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server;

import javax.ws.rs.core.Application;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.jersey.internal.inject.Providers;
import org.glassfish.jersey.server.ApplicationHandler;
import org.glassfish.jersey.server.spi.ContainerProvider;

public final class ContainerFactory {
    private ContainerFactory() {
    }

    public static <T> T createContainer(Class<T> type, Application application) {
        T c;
        ApplicationHandler handler = new ApplicationHandler(application);
        ServiceLocator locator = handler.getServiceLocator();
        for (ContainerProvider cp : Providers.getCustomProviders(locator, ContainerProvider.class)) {
            c = cp.createContainer(type, handler);
            if (c == null) continue;
            return c;
        }
        for (ContainerProvider cp : Providers.getProviders(locator, ContainerProvider.class)) {
            c = cp.createContainer(type, handler);
            if (c == null) continue;
            return c;
        }
        throw new IllegalArgumentException("No container provider supports the type " + type);
    }
}

