/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.internal.monitoring;

import java.lang.annotation.Annotation;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.ProcessingException;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.jersey.server.ExtendedResourceContext;
import org.glassfish.jersey.server.internal.LocalizationMessages;
import org.glassfish.jersey.server.internal.RuntimeExecutorsBinder;
import org.glassfish.jersey.server.internal.monitoring.ApplicationStatisticsImpl;
import org.glassfish.jersey.server.internal.monitoring.ExceptionMapperStatisticsImpl;
import org.glassfish.jersey.server.internal.monitoring.MonitoringEventListener;
import org.glassfish.jersey.server.internal.monitoring.MonitoringStatisticsImpl;
import org.glassfish.jersey.server.model.ResourceMethod;
import org.glassfish.jersey.server.model.ResourceModel;
import org.glassfish.jersey.server.monitoring.ApplicationEvent;
import org.glassfish.jersey.server.monitoring.MonitoringStatisticsListener;
import org.glassfish.jersey.server.monitoring.RequestEvent;

class MonitoringStatisticsProcessor {
    private static final Logger LOGGER = Logger.getLogger(MonitoringStatisticsProcessor.class.getName());
    public static final int SHUTDOWN_TIMEOUT = 10;
    private final MonitoringEventListener monitoringEventListener;
    private final MonitoringStatisticsImpl.Builder statisticsBuilder;
    private final List<MonitoringStatisticsListener> statisticsCallbackList;
    private final ScheduledExecutorService scheduler;

    MonitoringStatisticsProcessor(ServiceLocator serviceLocator, MonitoringEventListener monitoringEventListener) {
        this.monitoringEventListener = monitoringEventListener;
        ResourceModel resourceModel = serviceLocator.getService(ExtendedResourceContext.class, new Annotation[0]).getResourceModel();
        this.statisticsBuilder = new MonitoringStatisticsImpl.Builder(resourceModel);
        this.statisticsCallbackList = serviceLocator.getAllServices(MonitoringStatisticsListener.class, new Annotation[0]);
        this.scheduler = serviceLocator.getService(ScheduledExecutorService.class, new RuntimeExecutorsBinder.BackgroundSchedulerLiteral());
    }

    public void startMonitoringWorker() {
        this.scheduler.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                try {
                    MonitoringStatisticsProcessor.this.processApplicationEvents();
                    MonitoringStatisticsProcessor.this.processRequestItems();
                    MonitoringStatisticsProcessor.this.processResponseCodeEvents();
                    MonitoringStatisticsProcessor.this.processExceptionMapperEvents();
                }
                catch (Throwable t) {
                    LOGGER.log(Level.SEVERE, LocalizationMessages.ERROR_MONITORING_STATISTICS_GENERATION(), t);
                    throw new ProcessingException(LocalizationMessages.ERROR_MONITORING_STATISTICS_GENERATION(), t);
                }
                MonitoringStatisticsImpl immutableStats = MonitoringStatisticsProcessor.this.statisticsBuilder.build();
                Iterator iterator = MonitoringStatisticsProcessor.this.statisticsCallbackList.iterator();
                while (iterator.hasNext() && !Thread.currentThread().isInterrupted()) {
                    MonitoringStatisticsListener monitoringStatisticsListener = (MonitoringStatisticsListener)iterator.next();
                    try {
                        monitoringStatisticsListener.onStatistics(immutableStats);
                    }
                    catch (Throwable t) {
                        LOGGER.log(Level.SEVERE, LocalizationMessages.ERROR_MONITORING_STATISTICS_LISTENER(monitoringStatisticsListener.getClass()), t);
                        iterator.remove();
                    }
                }
            }
        }, 0L, 500L, TimeUnit.MILLISECONDS);
    }

    private void processApplicationEvents() {
        while (!this.monitoringEventListener.getApplicationEvents().isEmpty()) {
            ApplicationEvent appEvent = this.monitoringEventListener.getApplicationEvents().remove();
            switch (appEvent.getType()) {
                case INITIALIZATION_FINISHED: 
                case RELOAD_FINISHED: {
                    ApplicationStatisticsImpl initStatistics = new ApplicationStatisticsImpl(appEvent.getResourceConfig(), new Date(this.monitoringEventListener.getApplicationStartTime()), appEvent.getRegisteredClasses(), appEvent.getRegisteredInstances(), appEvent.getProviders());
                    this.statisticsBuilder.setApplicationStatisticsImpl(initStatistics);
                }
            }
        }
    }

    private void processExceptionMapperEvents() {
        Queue<RequestEvent> eventQueue = this.monitoringEventListener.getExceptionMapperEvents();
        while (!eventQueue.isEmpty()) {
            RequestEvent event = eventQueue.remove();
            ExceptionMapperStatisticsImpl.Builder mapperStats = this.statisticsBuilder.getExceptionMapperStatisticsBuilder();
            if (event.getExceptionMapper() != null) {
                mapperStats.addExceptionMapperExecution(event.getExceptionMapper().getClass(), 1);
            }
            mapperStats.addMapping(event.isResponseSuccessfullyMapped(), 1);
        }
    }

    private void processRequestItems() {
        Queue<MonitoringEventListener.RequestStats> requestQueuedItems = this.monitoringEventListener.getRequestQueuedItems();
        while (!requestQueuedItems.isEmpty()) {
            MonitoringEventListener.RequestStats event = requestQueuedItems.remove();
            MonitoringEventListener.TimeStats requestStats = event.getRequestStats();
            this.statisticsBuilder.getRequestStatisticsBuilder().addExecution(requestStats.getStartTime(), requestStats.getDuration());
            MonitoringEventListener.MethodStats methodStat = event.getMethodStats();
            if (methodStat == null) continue;
            ResourceMethod method = methodStat.getMethod();
            this.statisticsBuilder.addExecution(event.getRequestUri(), method, methodStat.getStartTime(), methodStat.getDuration(), requestStats.getStartTime(), requestStats.getDuration());
        }
    }

    private void processResponseCodeEvents() {
        Queue<Integer> responseEvents = this.monitoringEventListener.getResponseStatuses();
        while (!responseEvents.isEmpty()) {
            Integer code = responseEvents.remove();
            this.statisticsBuilder.addResponseCode(code);
        }
    }

    void shutDown() throws InterruptedException {
        this.scheduler.shutdown();
        boolean success = this.scheduler.awaitTermination(10L, TimeUnit.SECONDS);
        if (!success) {
            LOGGER.warning(LocalizationMessages.ERROR_MONITORING_SCHEDULER_DESTROY_TIMEOUT());
        }
    }
}

