/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.internal.routing;

import java.lang.annotation.Annotation;
import java.util.List;
import jersey.repackaged.com.google.common.collect.Lists;
import org.glassfish.hk2.api.Factory;
import org.glassfish.hk2.api.ServiceHandle;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.jersey.internal.inject.Providers;
import org.glassfish.jersey.server.internal.routing.Route;
import org.glassfish.jersey.server.internal.routing.Router;
import org.glassfish.jersey.server.internal.routing.RouterBinder;

abstract class AbstractRouteToPathBuilder<T>
implements RouterBinder.RouteToPathBuilder<T> {
    private final ServiceLocator serviceLocator;
    private final List<Route<T>> acceptedRoutes = Lists.newLinkedList();
    private List<Factory<Router>> currentRouters;

    protected AbstractRouteToPathBuilder(ServiceLocator serviceLocator, T pattern) {
        this.serviceLocator = serviceLocator;
        this._route(pattern);
    }

    protected final RouterBinder.RouteToBuilder<T> _route(T pattern) {
        this.currentRouters = Lists.newLinkedList();
        this.acceptedRoutes.add(Route.of(pattern, this.currentRouters));
        return this;
    }

    protected final RouterBinder.RouteToPathBuilder<T> _to(Factory<? extends Router> pa) {
        this.currentRouters.add(pa);
        return this;
    }

    protected List<Route<T>> acceptedRoutes() {
        return this.acceptedRoutes;
    }

    @Override
    public final RouterBinder.RouteToPathBuilder<T> to(Router.Builder ab) {
        return this.to(ab.build());
    }

    @Override
    public final RouterBinder.RouteToPathBuilder<T> to(Router a) {
        return this.to(Providers.factoryOf(a));
    }

    @Override
    public final RouterBinder.RouteToPathBuilder<T> to(Class<? extends Router> ca) {
        final ServiceHandle<? extends Router> serviceHandle = this.serviceLocator.getServiceHandle(ca, new Annotation[0]);
        Factory<Router> factory = new Factory<Router>(){

            @Override
            public Router provide() {
                return (Router)serviceHandle.getService();
            }

            @Override
            public void dispose(Router instance) {
            }
        };
        return this.to((Factory<Router>)factory);
    }

    @Override
    public final RouterBinder.RouteToPathBuilder<T> to(Factory<? extends Router> pa) {
        return this._to(pa);
    }

    @Override
    public abstract RouterBinder.RouteToBuilder<T> route(String var1);

    @Override
    public RouterBinder.RouteToBuilder<T> route(T pattern) {
        return this._route(pattern);
    }

    @Override
    public Router.Builder child(Router child) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public abstract Router build();
}

