/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.servlet.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.Proxy;
import java.util.Enumeration;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceUnit;
import javax.servlet.ServletConfig;
import jersey.repackaged.com.google.common.collect.Maps;
import org.glassfish.hk2.api.Injectee;
import org.glassfish.hk2.api.InjectionResolver;
import org.glassfish.hk2.api.ServiceHandle;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.api.TypeLiteral;
import org.glassfish.hk2.utilities.binding.AbstractBinder;
import org.glassfish.jersey.server.ContainerException;
import org.glassfish.jersey.servlet.internal.LocalizationMessages;
import org.glassfish.jersey.servlet.internal.ThreadLocalNamedInvoker;

public class PersistenceUnitBinder
extends AbstractBinder {
    public static final String PERSISTENCE_UNIT_PREFIX = "unit:";

    @Override
    protected void configure() {
        this.bind(PersistenceUnitInjectionResolver.class).to(new TypeLiteral<InjectionResolver<PersistenceUnit>>(){}).in(Singleton.class);
    }

    @Singleton
    private static class PersistenceUnitInjectionResolver
    implements InjectionResolver<PersistenceUnit> {
        private final Map<String, String> persistenceUnits = Maps.newHashMap();

        @Inject
        private PersistenceUnitInjectionResolver(ServiceLocator locator) {
            ServletConfig servletConfig = locator.getService(ServletConfig.class, new Annotation[0]);
            Enumeration<String> parameterNames = servletConfig.getInitParameterNames();
            while (parameterNames.hasMoreElements()) {
                String key = parameterNames.nextElement();
                if (!key.startsWith(PersistenceUnitBinder.PERSISTENCE_UNIT_PREFIX)) continue;
                this.persistenceUnits.put(key.substring(PersistenceUnitBinder.PERSISTENCE_UNIT_PREFIX.length()), "java:comp/env/" + servletConfig.getInitParameter(key));
            }
        }

        @Override
        public Object resolve(Injectee injectee, ServiceHandle<?> root) {
            if (!injectee.getRequiredType().equals(EntityManagerFactory.class)) {
                return null;
            }
            PersistenceUnit annotation2 = injectee.getParent().getAnnotation(PersistenceUnit.class);
            String unitName = annotation2.unitName();
            if (!this.persistenceUnits.containsKey(unitName)) {
                throw new ContainerException(LocalizationMessages.PERSISTENCE_UNIT_NOT_CONFIGURED(unitName));
            }
            return Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{EntityManagerFactory.class}, new ThreadLocalNamedInvoker(this.persistenceUnits.get(unitName)));
        }

        @Override
        public boolean isConstructorParameterIndicator() {
            return false;
        }

        @Override
        public boolean isMethodParameterIndicator() {
            return false;
        }
    }
}

