/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.data.operation.copy;

import es.bsc.compss.types.data.DataAccessId;
import es.bsc.compss.types.data.LogicalData;
import es.bsc.compss.types.data.Transferable;
import es.bsc.compss.types.data.listener.EventListener;
import es.bsc.compss.types.data.location.DataLocation;
import es.bsc.compss.types.data.operation.DataOperation;
import es.bsc.compss.types.parameter.DependencyParameter;

public class StorageCopy
extends DataOperation {
    private final LogicalData srcData;
    private final DataLocation srcLoc;
    private final LogicalData tgtData;
    private DataLocation tgtLoc;
    private Transferable reason;
    private final boolean preserveSourceData;

    public StorageCopy(LogicalData srcData, DataLocation prefSrc, DataLocation prefTgt, LogicalData tgtData, Transferable reason, EventListener listener) {
        super(srcData, listener);
        this.srcData = srcData;
        this.srcLoc = prefSrc;
        this.tgtData = tgtData;
        this.tgtLoc = prefTgt;
        this.reason = reason;
        DependencyParameter dPar = (DependencyParameter)reason;
        DataAccessId dAccId = dPar.getDataAccessId();
        this.preserveSourceData = dAccId instanceof DataAccessId.RAccessId ? ((DataAccessId.RAccessId)dAccId).isPreserveSourceData() : (dAccId instanceof DataAccessId.RWAccessId ? ((DataAccessId.RWAccessId)dAccId).isPreserveSourceData() : false);
        if (DEBUG) {
            LOGGER.debug("Created StorageCopy " + this.getName() + " (id: " + this.getId() + ")");
        }
    }

    public LogicalData getSourceData() {
        return this.srcData;
    }

    public DataLocation getPreferredSource() {
        return this.srcLoc;
    }

    public void setProposedSource(Object source) {
        this.reason.setDataSource(source);
    }

    public DataLocation getTargetLoc() {
        return this.tgtLoc;
    }

    public LogicalData getTargetData() {
        return this.tgtData;
    }

    public boolean mustPreserveSourceData() {
        return this.preserveSourceData;
    }

    public void setFinalTarget(String targetAbsolutePath) {
        if (DEBUG) {
            LOGGER.debug(" Setting StorageCopy final target to : " + targetAbsolutePath);
        }
        this.reason.setDataTarget(targetAbsolutePath);
    }

    public boolean isRegistered() {
        return this.tgtData != null;
    }

    @Override
    public void perform() {
    }
}

