/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.jetty;

import java.net.URI;
import javax.ws.rs.ProcessingException;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.glassfish.jersey.jetty.JettyHttpContainer;
import org.glassfish.jersey.server.ApplicationHandler;
import org.glassfish.jersey.server.ContainerFactory;
import org.glassfish.jersey.server.ResourceConfig;

public final class JettyHttpContainerFactory {
    private JettyHttpContainerFactory() {
    }

    public static Server createServer(URI uri) throws ProcessingException {
        return JettyHttpContainerFactory.createServer(uri, null, null, true);
    }

    public static Server createServer(URI uri, boolean start) throws ProcessingException {
        return JettyHttpContainerFactory.createServer(uri, null, null, start);
    }

    public static Server createServer(URI uri, ResourceConfig config) throws ProcessingException {
        JettyHttpContainer container = ContainerFactory.createContainer(JettyHttpContainer.class, config);
        return JettyHttpContainerFactory.createServer(uri, null, container, true);
    }

    public static Server createServer(URI uri, ResourceConfig configuration, boolean start) throws ProcessingException {
        return JettyHttpContainerFactory.createServer(uri, null, ContainerFactory.createContainer(JettyHttpContainer.class, configuration), start);
    }

    public static Server createServer(URI uri, SslContextFactory sslContextFactory, ResourceConfig config) throws ProcessingException {
        JettyHttpContainer container = ContainerFactory.createContainer(JettyHttpContainer.class, config);
        return JettyHttpContainerFactory.createServer(uri, sslContextFactory, container, true);
    }

    public static Server createServer(URI uri, ApplicationHandler appHandler) throws ProcessingException {
        return JettyHttpContainerFactory.createServer(uri, null, new JettyHttpContainer(appHandler), true);
    }

    public static Server createServer(URI uri, ApplicationHandler appHandler, boolean start) throws ProcessingException {
        return JettyHttpContainerFactory.createServer(uri, null, new JettyHttpContainer(appHandler), start);
    }

    public static Server createServer(URI uri, SslContextFactory sslContextFactory, ApplicationHandler appHandler) throws ProcessingException {
        return JettyHttpContainerFactory.createServer(uri, sslContextFactory, new JettyHttpContainer(appHandler), true);
    }

    public static Server createServer(URI uri, SslContextFactory sslContextFactory, JettyHttpContainer handler, boolean start) throws ProcessingException {
        if (uri == null) {
            throw new IllegalArgumentException("The URI must not be null");
        }
        String scheme = uri.getScheme();
        int defaultPort = 80;
        if (sslContextFactory == null) {
            if (!scheme.equalsIgnoreCase("http")) {
                throw new IllegalArgumentException("The URI scheme should be 'http' when not using SSL");
            }
        } else {
            if (!scheme.equalsIgnoreCase("https")) {
                throw new IllegalArgumentException("The URI scheme should be 'https' when using SSL");
            }
            defaultPort = 143;
        }
        int port = uri.getPort() == -1 ? defaultPort : uri.getPort();
        Server server = new Server();
        HttpConfiguration config = new HttpConfiguration();
        if (sslContextFactory != null) {
            config.setSecureScheme("https");
            config.setSecurePort(port);
            config.addCustomizer(new SecureRequestCustomizer());
            ServerConnector https = new ServerConnector(server, new SslConnectionFactory(sslContextFactory, "http/1.1"), new HttpConnectionFactory(config));
            https.setPort(port);
            server.setConnectors(new Connector[]{https});
        } else {
            ServerConnector http = new ServerConnector(server, new HttpConnectionFactory(config));
            http.setPort(port);
            server.setConnectors(new Connector[]{http});
        }
        if (handler != null) {
            server.setHandler(handler);
        }
        if (start) {
            try {
                server.start();
            }
            catch (Exception e) {
                throw new ProcessingException("Exception thrown when trying to create jetty server", e);
            }
        }
        return server;
    }
}

