/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.internal.routing;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Provider;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.internal.routing.Route;
import org.glassfish.jersey.server.internal.routing.Router;
import org.glassfish.jersey.server.internal.routing.RoutingContext;

class PatternRouter
implements Router {
    private final Provider<RoutingContext> contextProvider;
    private final List<Route<Pattern>> acceptedRoutes;

    private PatternRouter(Provider<RoutingContext> contextProvider, List<Route<Pattern>> routes) {
        this.contextProvider = contextProvider;
        this.acceptedRoutes = routes;
    }

    @Override
    public Router.Continuation apply(ContainerRequest request) {
        RoutingContext rc = this.contextProvider.get();
        String path = rc.getFinalMatchingGroup();
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        for (Route<Pattern> acceptedRoute : this.acceptedRoutes) {
            Matcher m = acceptedRoute.routingPattern().matcher(path);
            if (!m.matches()) continue;
            rc.pushMatchResult(m.toMatchResult());
            return Router.Continuation.of(request, acceptedRoute.next());
        }
        return Router.Continuation.of(request);
    }

    public static class Builder {
        @Inject
        private Provider<RoutingContext> contextProvider;

        public PatternRouter build(List<Route<Pattern>> routes) {
            return new PatternRouter(this.contextProvider, routes);
        }
    }
}

