/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.data;

import es.bsc.compss.types.data.DataInstanceId;

public class DataVersion {
    private final DataInstanceId dataInstanceId;
    private int readers = 0;
    private int writters;
    private boolean toDelete;
    private boolean used;

    public DataVersion(int dataId, int versionId) {
        this.dataInstanceId = new DataInstanceId(dataId, versionId);
        this.writters = 0;
        this.toDelete = false;
        this.used = false;
    }

    public DataInstanceId getDataInstanceId() {
        return this.dataInstanceId;
    }

    public void willBeRead() {
        ++this.readers;
    }

    public void willBeWritten() {
        ++this.writters;
    }

    public boolean hasPendingLectures() {
        return this.readers > 0;
    }

    public boolean hasMoreReaders() {
        return this.readers > 1;
    }

    public boolean hasBeenRead() {
        --this.readers;
        return this.checkDeletion();
    }

    public boolean hasBeenWritten() {
        --this.writters;
        return this.checkDeletion();
    }

    public boolean markToDelete() {
        this.toDelete = true;
        return this.readers == 0 && this.writters == 0;
    }

    public boolean isToDelete() {
        return this.toDelete;
    }

    private boolean checkDeletion() {
        return this.toDelete && this.writters == 0 && this.readers == 0;
    }

    public void versionUsed() {
        this.used = true;
    }

    public boolean hasBeenUsed() {
        return this.used;
    }
}

