/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.agent.rest.master;

import es.bsc.compss.agent.rest.master.RemoteRESTAgent;
import es.bsc.compss.agent.rest.types.Orchestrator;
import es.bsc.compss.agent.rest.types.RemoteJobListener;
import es.bsc.compss.agent.rest.types.messages.StartApplicationRequest;
import es.bsc.compss.agent.util.RemoteJobsRegistry;
import es.bsc.compss.comm.Comm;
import es.bsc.compss.types.TaskDescription;
import es.bsc.compss.types.annotations.parameter.DataType;
import es.bsc.compss.types.data.DataAccessId;
import es.bsc.compss.types.data.accessid.RAccessId;
import es.bsc.compss.types.data.accessid.RWAccessId;
import es.bsc.compss.types.data.accessid.WAccessId;
import es.bsc.compss.types.data.location.DataLocation;
import es.bsc.compss.types.execution.exceptions.JobExecutionException;
import es.bsc.compss.types.implementations.Implementation;
import es.bsc.compss.types.implementations.MethodImplementation;
import es.bsc.compss.types.job.Job;
import es.bsc.compss.types.job.JobListener;
import es.bsc.compss.types.parameter.BasicTypeParameter;
import es.bsc.compss.types.parameter.DependencyParameter;
import es.bsc.compss.types.parameter.Parameter;
import es.bsc.compss.types.resources.Resource;
import es.bsc.compss.types.uri.SimpleURI;
import java.io.IOException;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;

public class RemoteRESTAgentJob
extends Job<RemoteRESTAgent> {
    private static final String REST_AGENT_URL = "http://" + System.getProperty("compss.agent.name") + ":" + System.getProperty("compss.agent.port") + "/";

    public RemoteRESTAgentJob(RemoteRESTAgent executor, int taskId, TaskDescription task, Implementation impl, Resource res, JobListener listener) {
        super(taskId, task, impl, res, listener);
    }

    @Override
    public void submit() throws Exception {
        StartApplicationRequest sar = new StartApplicationRequest();
        Resource executorResource = this.getResource();
        RemoteRESTAgent executorNode = (RemoteRESTAgent)this.getResourceNode();
        WebTarget wt = executorNode.getTarget();
        wt = wt.path("/COMPSs/startApplication/");
        MethodImplementation mImpl = (MethodImplementation)this.impl;
        String className = mImpl.getDeclaringClass();
        String methodName = mImpl.getAlternativeMethodName();
        if (methodName == null || methodName.isEmpty()) {
            methodName = this.taskParams.getName();
            mImpl.setAlternativeMethodName(this.taskParams.getName());
        }
        sar.setClassName(className);
        sar.setMethodName(methodName);
        sar.setCeiClass(null);
        Parameter[] params = this.taskParams.getParameters();
        int numParams = params.length;
        boolean hasReturn = this.taskParams.getNumReturns() > 0;
        Object retValue = null;
        boolean hasTarget = this.taskParams.hasTargetObject();
        Object target = null;
        if (hasReturn) {
            sar.setHasResult(true);
            --numParams;
        }
        if (hasTarget) {
            String renaming;
            Parameter param;
            DependencyParameter dPar;
            DataAccessId faId;
            if ((faId = (dPar = (DependencyParameter)(param = params[--numParams])).getDataAccessId()) instanceof WAccessId) {
                WAccessId waId = (WAccessId)faId;
                renaming = waId.getWrittenDataInstance().getRenaming();
            } else if (faId instanceof RWAccessId) {
                RWAccessId rwaId = (RWAccessId)faId;
                renaming = rwaId.getWrittenDataInstance().getRenaming();
            } else {
                RAccessId raId = (RAccessId)faId;
                renaming = raId.getReadDataInstance().getRenaming();
            }
            target = Comm.getData(renaming).getValue();
            throw new UnsupportedOperationException("Instance methods not supported yet.");
        }
        System.out.println("SUBMISSION[" + this.getJobId() + "] Remote Agent :" + executorNode.getName());
        System.out.println("SUBMISSION[" + this.getJobId() + "] Parameters:");
        block3: for (int parIdx = 0; parIdx < numParams; ++parIdx) {
            System.out.println("SUBMISSION[" + this.getJobId() + "]     * Parameter " + parIdx + ": ");
            Parameter param = params[parIdx];
            DataType type = param.getType();
            System.out.println("SUBMISSION[" + this.getJobId() + "]         Type " + (Object)((Object)type));
            switch (type) {
                case FILE_T: 
                case OBJECT_T: 
                case EXTERNAL_PSCO_T: 
                case PSCO_T: {
                    String pscoId;
                    String renaming;
                    String inRenaming;
                    DependencyParameter dPar = (DependencyParameter)param;
                    DataAccessId dAccId = dPar.getDataAccessId();
                    if (dAccId instanceof WAccessId) {
                        throw new JobExecutionException("Target parameter is a Write access", null);
                    }
                    if (dAccId instanceof RWAccessId) {
                        RWAccessId rwaId = (RWAccessId)dAccId;
                        inRenaming = rwaId.getReadDataInstance().getRenaming();
                        renaming = rwaId.getWrittenDataInstance().getRenaming();
                    } else {
                        RAccessId raId = (RAccessId)dAccId;
                        renaming = inRenaming = raId.getReadDataInstance().getRenaming();
                    }
                    if (inRenaming != null && (pscoId = Comm.getData(inRenaming).getPscoId()) != null) {
                        if (type.equals((Object)DataType.OBJECT_T)) {
                            param.setType(DataType.PSCO_T);
                        }
                        if (type.equals((Object)DataType.FILE_T)) {
                            param.setType(DataType.EXTERNAL_PSCO_T);
                        }
                        type = param.getType();
                    }
                    if (type == DataType.PSCO_T || type == DataType.EXTERNAL_PSCO_T) {
                        System.out.println("SUBMISSION[" + this.getJobId() + "]         Access " + dAccId);
                        String value = dPar.getDataTarget();
                        System.out.println("SUBMISSION[" + this.getJobId() + "]         ID " + value);
                        sar.addPersistedParameter(value, param.getDirection());
                        continue block3;
                    }
                    throw new UnsupportedOperationException("Non-persisted DependencyParameters are not supported yet");
                }
                default: {
                    BasicTypeParameter btParB = (BasicTypeParameter)param;
                    Object value = btParB.getValue();
                    System.out.println("SUBMISSION[" + this.getJobId() + "]         Value " + value);
                    sar.addParameter(btParB, value);
                }
            }
        }
        System.out.println("SUBMISSION[" + this.getJobId() + "] Stage in completed.");
        sar.setOrchestrator(REST_AGENT_URL, Orchestrator.HttpMethod.PUT, "COMPSs/endApplication/");
        Response response = wt.request("application/json").put(Entity.xml(sar), Response.class);
        if (response.getStatusInfo().getStatusCode() != 200) {
            System.out.println(response.readEntity(String.class));
            this.getListener().jobFailed(this, JobListener.JobEndStatus.SUBMISSION_FAILED);
        } else {
            System.out.println("SUBMISSION[" + this.getJobId() + "] Job submitted.");
            String jobId = response.readEntity(String.class);
            RemoteJobsRegistry.registerJobListener(jobId, new RemoteJobListener(){

                @Override
                public void finishedExecution(JobListener.JobEndStatus endStatus, DataType[] paramTypes, String[] paramLocations) {
                    System.out.println("SUBMISSION[" + RemoteRESTAgentJob.this.getJobId() + "] Job completed.");
                    RemoteRESTAgentJob.this.stageout(paramTypes, paramLocations);
                    if (endStatus == JobListener.JobEndStatus.OK) {
                        RemoteRESTAgentJob.this.getListener().jobCompleted(RemoteRESTAgentJob.this);
                    } else {
                        RemoteRESTAgentJob.this.getListener().jobFailed(RemoteRESTAgentJob.this, endStatus);
                    }
                }
            });
        }
    }

    @Override
    public void stop() throws Exception {
    }

    private void stageout(DataType[] paramTypes, String[] paramLocations) {
        String pscoId;
        DataLocation loc;
        SimpleURI uri;
        String locString;
        DataType type;
        Parameter[] params = this.taskParams.getParameters();
        int numParams = params.length;
        boolean hasReturn = this.taskParams.getNumReturns() > 0;
        boolean hasTarget = this.taskParams.hasTargetObject();
        if (hasReturn) {
            DependencyParameter returnParameter = (DependencyParameter)this.taskParams.getParameters()[--numParams];
            type = paramTypes[numParams];
            locString = paramLocations[numParams];
            System.out.println("STAGE OUT[" + this.getJobId() + "]         * Return type: " + (Object)((Object)type) + " Value: " + locString);
            if (locString != null) {
                uri = new SimpleURI(locString);
                try {
                    loc = DataLocation.createLocation(this.worker, uri);
                    if (loc.getProtocol() == DataLocation.Protocol.PERSISTENT_URI) {
                        pscoId = loc.getLocationKey();
                        type = returnParameter.getType();
                        if (type == DataType.OBJECT_T) {
                            type = DataType.PSCO_T;
                        }
                        returnParameter.setType(type);
                        returnParameter.setDataTarget(pscoId);
                        System.out.println("STAGE OUT[" + this.getJobId() + "]         * Return : ");
                        System.out.println("STAGE OUT[" + this.getJobId() + "]             Type: " + (Object)((Object)type));
                        System.out.println("STAGE OUT[" + this.getJobId() + "]             ID: " + pscoId);
                    } else {
                        returnParameter.setType(type);
                        System.out.println("STAGE OUT[" + this.getJobId() + "]         * Return : ");
                        System.out.println("STAGE OUT[" + this.getJobId() + "]             Type: " + (Object)((Object)type));
                        System.out.println("STAGE OUT[" + this.getJobId() + "]             Value location: " + loc);
                    }
                }
                catch (IOException ioe) {
                    System.err.println("STAGE OUT[" + this.getJobId() + "] ERROR PROCESSING TASK RESULT");
                }
            }
        }
        if (hasTarget) {
            DependencyParameter targetParameter = (DependencyParameter)this.taskParams.getParameters()[--numParams];
            type = paramTypes[numParams];
            locString = paramLocations[numParams];
            if (locString != null) {
                uri = new SimpleURI(locString);
                try {
                    loc = DataLocation.createLocation(this.worker, uri);
                    if (loc.getProtocol() == DataLocation.Protocol.PERSISTENT_URI) {
                        pscoId = loc.getLocationKey();
                        type = targetParameter.getType();
                        if (type == DataType.OBJECT_T) {
                            type = DataType.PSCO_T;
                        }
                        targetParameter.setType(type);
                        targetParameter.setDataTarget(pscoId);
                        System.out.println("STAGE OUT[" + this.getJobId() + "]         * Return : ");
                        System.out.println("STAGE OUT[" + this.getJobId() + "]             Type: " + (Object)((Object)type));
                        System.out.println("STAGE OUT[" + this.getJobId() + "]             ID: " + pscoId);
                    } else {
                        targetParameter.setType(type);
                        System.out.println("STAGE OUT[" + this.getJobId() + "]         * Return : ");
                        System.out.println("STAGE OUT[" + this.getJobId() + "]             Type: " + (Object)((Object)type));
                        System.out.println("STAGE OUT[" + this.getJobId() + "]             Value location: " + loc);
                    }
                }
                catch (IOException ioe) {
                    System.err.println("STAGE OUT[" + this.getJobId() + "] ERROR PROCESSING TASK TARGET");
                }
            }
        }
        System.out.println("STAGE OUT[" + this.getJobId() + "]     Parameters:");
        block17: for (int parIdx = 0; parIdx < numParams; ++parIdx) {
            type = paramTypes[parIdx];
            switch (type) {
                case FILE_T: 
                case OBJECT_T: 
                case EXTERNAL_PSCO_T: 
                case PSCO_T: {
                    DependencyParameter dp = (DependencyParameter)params[parIdx];
                    String locString2 = paramLocations[parIdx];
                    if (locString2 == null) continue block17;
                    SimpleURI uri2 = new SimpleURI(locString2);
                    try {
                        DataLocation loc2 = DataLocation.createLocation(this.worker, uri2);
                        if (loc2.getProtocol() == DataLocation.Protocol.PERSISTENT_URI) {
                            String pscoId2 = loc2.getLocationKey();
                            switch (type) {
                                case FILE_T: {
                                    type = DataType.EXTERNAL_PSCO_T;
                                    break;
                                }
                                case OBJECT_T: {
                                    type = DataType.PSCO_T;
                                }
                            }
                            dp.setType(type);
                            dp.setDataTarget(pscoId2);
                            System.out.println("STAGE OUT[" + this.getJobId() + "]         * Parameter " + parIdx + ": ");
                            System.out.println("STAGE OUT[" + this.getJobId() + "]             Type: " + (Object)((Object)type));
                            System.out.println("STAGE OUT[" + this.getJobId() + "]             ID: " + pscoId2);
                            continue block17;
                        }
                        switch (type) {
                            case EXTERNAL_PSCO_T: {
                                type = DataType.FILE_T;
                                break;
                            }
                            case PSCO_T: {
                                type = DataType.OBJECT_T;
                                break;
                            }
                        }
                        dp.setType(type);
                        System.out.println("STAGE OUT[" + this.getJobId() + "]          * Parameter " + parIdx + ": ");
                        System.out.println("STAGE OUT[" + this.getJobId() + "]              Type: " + (Object)((Object)type));
                        System.out.println("STAGE OUT[" + this.getJobId() + "]              Value location: " + loc2);
                    }
                    catch (IOException ioe) {
                        System.err.println("STAGE OUT[" + this.getJobId() + "] ERROR PROCESSING TASK PARAMETER " + parIdx);
                    }
                    continue block17;
                }
            }
        }
    }

    @Override
    public String getHostName() {
        return ((RemoteRESTAgent)this.getResourceNode()).getName();
    }

    @Override
    public Implementation.TaskType getType() {
        return Implementation.TaskType.METHOD;
    }

    @Override
    public String toString() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

