/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm.record;

import java.lang.reflect.Modifier;
import javax.xml.namespace.QName;
import org.eclipse.persistence.core.descriptors.CoreInheritancePolicy;
import org.eclipse.persistence.core.queries.CoreAttributeGroup;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.core.descriptors.CoreObjectBuilder;
import org.eclipse.persistence.internal.core.sessions.CoreAbstractSession;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.oxm.Context;
import org.eclipse.persistence.internal.oxm.Root;
import org.eclipse.persistence.internal.oxm.Unmarshaller;
import org.eclipse.persistence.internal.oxm.XMLConversionManager;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.XPathQName;
import org.eclipse.persistence.internal.oxm.mappings.Descriptor;
import org.eclipse.persistence.internal.oxm.mappings.UnmarshalKeepAsElementPolicy;
import org.eclipse.persistence.internal.oxm.record.ExtendedContentHandler;
import org.eclipse.persistence.internal.oxm.record.UnmappedContentHandlerWrapper;
import org.eclipse.persistence.internal.oxm.record.UnmarshalRecord;
import org.eclipse.persistence.internal.oxm.record.UnmarshalRecordImpl;
import org.eclipse.persistence.internal.oxm.record.XMLReader;
import org.eclipse.persistence.internal.oxm.record.namespaces.StackUnmarshalNamespaceResolver;
import org.eclipse.persistence.internal.oxm.record.namespaces.UnmarshalNamespaceResolver;
import org.eclipse.persistence.internal.security.PrivilegedNewInstanceFromClass;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.unmapped.UnmappedContentHandler;
import org.eclipse.persistence.platform.xml.SAXDocumentBuilder;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.Locator2;

public class SAXUnmarshallerHandler
implements ExtendedContentHandler {
    private XMLReader xmlReader;
    private Context xmlContext;
    private UnmarshalRecord rootRecord;
    private Object object;
    private Descriptor descriptor;
    private Unmarshaller unmarshaller;
    private CoreAbstractSession session;
    private UnmarshalNamespaceResolver unmarshalNamespaceResolver;
    private UnmarshalKeepAsElementPolicy keepAsElementPolicy = new UnmarshalKeepAsElementPolicy(){

        @Override
        public boolean isKeepAllAsElement() {
            return false;
        }

        @Override
        public boolean isKeepNoneAsElement() {
            return true;
        }

        @Override
        public boolean isKeepUnknownAsElement() {
            return false;
        }
    };
    private SAXDocumentBuilder documentBuilder;
    private Locator2 locator;
    private boolean isNil;

    public SAXUnmarshallerHandler(Context xmlContext) {
        this.xmlContext = xmlContext;
        this.unmarshalNamespaceResolver = new StackUnmarshalNamespaceResolver();
    }

    public XMLReader getXMLReader() {
        return this.xmlReader;
    }

    public void setXMLReader(XMLReader xmlReader) {
        this.xmlReader = xmlReader;
    }

    public Object getObject() {
        if (this.object == null) {
            if (this.descriptor != null) {
                this.object = this.descriptor.wrapObjectInXMLRoot(this.rootRecord, this.unmarshaller.isResultAlwaysXMLRoot());
            } else if (this.documentBuilder != null) {
                Element node = this.documentBuilder.getDocument().getDocumentElement();
                Object root = this.unmarshaller.createRoot();
                ((Root)root).setLocalName(node.getLocalName());
                ((Root)root).setNamespaceURI(node.getNamespaceURI());
                ((Root)root).setObject(node);
                this.object = root;
            } else if (this.rootRecord != null) {
                this.object = this.rootRecord.getCurrentObject();
            }
        }
        return this.object;
    }

    public void setObject(Object object) {
        this.object = object;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        if (locator instanceof Locator2) {
            this.locator = (Locator2)locator;
            if (this.xmlReader != null) {
                this.xmlReader.setLocator(locator);
            }
        }
    }

    public UnmarshalNamespaceResolver getUnmarshalNamespaceResolver() {
        return this.unmarshalNamespaceResolver;
    }

    public void setUnmarshalNamespaceResolver(UnmarshalNamespaceResolver unmarshalNamespaceResolver) {
        this.unmarshalNamespaceResolver = unmarshalNamespaceResolver;
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.unmarshalNamespaceResolver.push(prefix, uri);
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        this.unmarshalNamespaceResolver.pop(prefix);
    }

    public void resolveReferences() {
        if (this.rootRecord != null) {
            this.rootRecord.resolveReferences(this.session, this.unmarshaller.getIDResolver());
        }
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        try {
            UnmarshalRecord unmarshalRecord;
            Descriptor xmlDescriptor = null;
            boolean isPrimitiveType = false;
            Class primitiveWrapperClass = null;
            String type = null;
            type = this.xmlReader.isNamespaceAware() ? atts.getValue("http://www.w3.org/2001/XMLSchema-instance", "type") : atts.getValue("", "type");
            if (type != null) {
                XPathFragment typeFragment = new XPathFragment(type, this.xmlReader.namespaceSeparator, this.xmlReader.isNamespaceAware());
                if (this.xmlReader.isNamespaceAware() && this.unmarshalNamespaceResolver != null) {
                    typeFragment.setNamespaceURI(this.unmarshalNamespaceResolver.getNamespaceURI(typeFragment.getPrefix()));
                }
                if ((xmlDescriptor = this.xmlContext.getDescriptorByGlobalType(typeFragment)) == null) {
                    QName lookupQName = null;
                    lookupQName = typeFragment.getNamespaceURI() == null ? new QName("http://www.w3.org/2001/XMLSchema", typeFragment.getLocalName()) : new QName(typeFragment.getNamespaceURI(), typeFragment.getLocalName());
                    primitiveWrapperClass = (Class)XMLConversionManager.getDefaultXMLTypes().get(lookupQName);
                }
            }
            if (xmlDescriptor == null) {
                String name = localName == null || localName.length() == 0 ? qName : localName;
                XPathQName rootQName = namespaceURI == null || namespaceURI.length() == 0 ? new XPathQName(name, this.xmlReader.isNamespaceAware()) : new XPathQName(namespaceURI, name, this.xmlReader.isNamespaceAware());
                xmlDescriptor = this.xmlContext.getDescriptor(rootQName);
                if (xmlDescriptor == null) {
                    Object obj = this.xmlReader.getCurrentObject(this.session, null);
                    if (obj != null) {
                        xmlDescriptor = (Descriptor)this.xmlContext.getSession(obj.getClass()).getDescriptor(obj.getClass());
                    }
                    if (xmlDescriptor == null) {
                        boolean bl = isPrimitiveType = primitiveWrapperClass != null;
                    }
                }
                if (xmlDescriptor == null && !isPrimitiveType) {
                    UnmappedContentHandler unmappedContentHandler;
                    if (!this.keepAsElementPolicy.isKeepNoneAsElement()) {
                        this.documentBuilder = new SAXDocumentBuilder();
                        this.documentBuilder.startDocument();
                        for (String prefix : this.unmarshalNamespaceResolver.getPrefixes()) {
                            this.documentBuilder.startPrefixMapping(prefix, this.unmarshalNamespaceResolver.getNamespaceURI(prefix));
                        }
                        this.documentBuilder.startElement(namespaceURI, localName, qName, atts);
                        this.xmlReader.setContentHandler(this.documentBuilder);
                        return;
                    }
                    Class unmappedContentHandlerClass = this.unmarshaller.getUnmappedContentHandlerClass();
                    if (unmappedContentHandlerClass == null) {
                        throw XMLMarshalException.noDescriptorWithMatchingRootElement(rootQName.toString());
                    }
                    try {
                        PrivilegedNewInstanceFromClass privilegedNewInstanceFromClass = new PrivilegedNewInstanceFromClass(unmappedContentHandlerClass);
                        unmappedContentHandler = (UnmappedContentHandler)privilegedNewInstanceFromClass.run();
                    }
                    catch (ClassCastException e) {
                        throw XMLMarshalException.unmappedContentHandlerDoesntImplement(e, unmappedContentHandlerClass.getName());
                    }
                    catch (IllegalAccessException e) {
                        throw XMLMarshalException.errorInstantiatingUnmappedContentHandler(e, unmappedContentHandlerClass.getName());
                    }
                    catch (InstantiationException e) {
                        throw XMLMarshalException.errorInstantiatingUnmappedContentHandler(e, unmappedContentHandlerClass.getName());
                    }
                    UnmappedContentHandlerWrapper unmappedContentHandlerWrapper = new UnmappedContentHandlerWrapper(unmappedContentHandler, this);
                    unmappedContentHandler.startElement(namespaceURI, localName, qName, atts);
                    this.xmlReader.setContentHandler(unmappedContentHandler);
                    this.setObject(unmappedContentHandlerWrapper.getCurrentObject());
                    return;
                }
            }
            this.session = this.xmlContext.getSession(xmlDescriptor);
            if (isPrimitiveType) {
                unmarshalRecord = this.unmarshaller.createRootUnmarshalRecord(primitiveWrapperClass);
                unmarshalRecord.setSession((CoreAbstractSession)((Context)this.unmarshaller.getContext()).getSession());
                unmarshalRecord.setXMLReader(this.getXMLReader());
            } else if (xmlDescriptor.hasInheritance()) {
                Object indicator;
                QName leafElementType;
                unmarshalRecord = new UnmarshalRecordImpl(null);
                unmarshalRecord.setUnmarshaller(this.unmarshaller);
                unmarshalRecord.setUnmarshalNamespaceResolver(this.unmarshalNamespaceResolver);
                unmarshalRecord.setXMLReader(this.getXMLReader());
                unmarshalRecord.setAttributes(atts);
                Class classValue = ((CoreInheritancePolicy)xmlDescriptor.getInheritancePolicy()).classFromRow((org.eclipse.persistence.oxm.record.UnmarshalRecord)new org.eclipse.persistence.oxm.record.UnmarshalRecord(unmarshalRecord), (CoreAbstractSession)this.session);
                if (classValue == null && (leafElementType = xmlDescriptor.getDefaultRootElementType()) != null && (indicator = ((CoreInheritancePolicy)xmlDescriptor.getInheritancePolicy()).getClassIndicatorMapping().get(leafElementType)) != null) {
                    classValue = (Class)indicator;
                }
                if (classValue != null) {
                    xmlDescriptor = (Descriptor)this.session.getDescriptor(classValue);
                } else if (Modifier.isAbstract(xmlDescriptor.getJavaClass().getModifiers())) {
                    throw DescriptorException.missingClassIndicatorField(unmarshalRecord, (ClassDescriptor)((XMLDescriptor)((CoreInheritancePolicy)xmlDescriptor.getInheritancePolicy()).getDescriptor()));
                }
                org.eclipse.persistence.oxm.record.UnmarshalRecord wrapper = (org.eclipse.persistence.oxm.record.UnmarshalRecord)((CoreObjectBuilder)xmlDescriptor.getObjectBuilder()).createRecord((CoreAbstractSession)this.session);
                unmarshalRecord = wrapper.getUnmarshalRecord();
            } else {
                org.eclipse.persistence.oxm.record.UnmarshalRecord wrapper = (org.eclipse.persistence.oxm.record.UnmarshalRecord)((CoreObjectBuilder)xmlDescriptor.getObjectBuilder()).createRecord((CoreAbstractSession)this.session);
                unmarshalRecord = wrapper.getUnmarshalRecord();
                unmarshalRecord.setXMLReader(this.getXMLReader());
            }
            this.descriptor = xmlDescriptor;
            this.rootRecord = unmarshalRecord;
            unmarshalRecord.setUnmarshaller(this.unmarshaller);
            unmarshalRecord.setXMLReader(this.getXMLReader());
            if (this.locator != null) {
                unmarshalRecord.setDocumentLocator(this.xmlReader.getLocator());
            }
            unmarshalRecord.setAttributes(atts);
            boolean hasNilAttribute = atts != null && atts.getValue("http://www.w3.org/2001/XMLSchema-instance", "nil") != null;
            unmarshalRecord.setNil(this.isNil || hasNilAttribute);
            unmarshalRecord.setUnmarshalNamespaceResolver(this.unmarshalNamespaceResolver);
            unmarshalRecord.startDocument();
            unmarshalRecord.initializeRecord(null);
            this.xmlReader.setContentHandler(unmarshalRecord);
            this.xmlReader.setLexicalHandler(unmarshalRecord);
            Object attributeGroup = this.unmarshaller.getUnmarshalAttributeGroup();
            if (attributeGroup != null) {
                if (attributeGroup.getClass() == ClassConstants.STRING) {
                    CoreAttributeGroup group2 = this.descriptor.getAttributeGroup((String)attributeGroup);
                    if (group2 != null) {
                        unmarshalRecord.setUnmarshalAttributeGroup(group2);
                    }
                } else if (attributeGroup instanceof CoreAttributeGroup) {
                    unmarshalRecord.setUnmarshalAttributeGroup((CoreAttributeGroup)attributeGroup);
                }
            }
            unmarshalRecord.startElement(namespaceURI, localName, qName, atts);
        }
        catch (EclipseLinkException e) {
            if (this.xmlReader.getErrorHandler() == null) {
                throw e;
            }
            SAXParseException saxParseException = new SAXParseException(null, null, null, 0, 0, e);
            this.xmlReader.getErrorHandler().error(saxParseException);
        }
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public void characters(CharSequence characters) throws SAXException {
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
    }

    public void setUnmarshaller(Unmarshaller unmarshaller) {
        this.unmarshaller = unmarshaller;
    }

    public Unmarshaller getUnmarshaller() {
        return this.unmarshaller;
    }

    public void setKeepAsElementPolicy(UnmarshalKeepAsElementPolicy policy) {
        this.keepAsElementPolicy = policy;
    }

    public UnmarshalKeepAsElementPolicy getKeepAsElementPolicy() {
        return this.keepAsElementPolicy;
    }

    @Override
    public void setNil(boolean isNil) {
        this.isNil = isNil;
    }
}

