/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.internal.routing;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import jersey.repackaged.com.google.common.base.Function;
import org.glassfish.jersey.process.Inflector;
import org.glassfish.jersey.process.internal.Inflecting;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.ContainerResponse;
import org.glassfish.jersey.server.internal.routing.Router;

class Routers {
    private Routers() {
    }

    public static Router asTreeAcceptor(Inflector<ContainerRequest, ContainerResponse> inflector) {
        return new InflectingRouter(inflector);
    }

    public static Router.Builder acceptingTree(Function<ContainerRequest, ContainerRequest> transformation) {
        return new RouterBuilder(transformation);
    }

    private static class LinkedRouter
    implements Router {
        private final Function<ContainerRequest, ContainerRequest> transformation;
        private final List<Router> children;

        public LinkedRouter(Function<ContainerRequest, ContainerRequest> transformation, List<Router> children) {
            this.transformation = transformation;
            this.children = children;
        }

        public LinkedRouter(Function<ContainerRequest, ContainerRequest> transformation) {
            this.transformation = transformation;
            this.children = Collections.emptyList();
        }

        @Override
        public Router.Continuation apply(ContainerRequest data) {
            return Router.Continuation.of(this.transformation.apply(data), this.children);
        }
    }

    private static class RouterBuilder
    implements Router.Builder {
        private final Function<ContainerRequest, ContainerRequest> transformation;
        private List<Router> children;

        public RouterBuilder(Function<ContainerRequest, ContainerRequest> transformation) {
            this.transformation = transformation;
        }

        @Override
        public Router.Builder child(Router child) {
            if (this.children == null) {
                this.children = new LinkedList<Router>();
            }
            this.children.add(child);
            return this;
        }

        @Override
        public Router build() {
            return this.children == null ? new LinkedRouter(this.transformation) : new LinkedRouter(this.transformation, this.children);
        }
    }

    private static class InflectingRouter
    implements Router,
    Inflecting<ContainerRequest, ContainerResponse> {
        private final Inflector<ContainerRequest, ContainerResponse> inflector;

        public InflectingRouter(Inflector<ContainerRequest, ContainerResponse> inflector) {
            this.inflector = inflector;
        }

        @Override
        public Inflector<ContainerRequest, ContainerResponse> inflector() {
            return this.inflector;
        }

        @Override
        public Router.Continuation apply(ContainerRequest request) {
            return Router.Continuation.of(request);
        }
    }
}

