/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.resources;

import es.bsc.compss.types.resources.ResourcesFile;
import es.bsc.compss.types.resources.exceptions.InvalidElementException;
import es.bsc.compss.types.resources.exceptions.ResourcesFileValidationException;
import es.bsc.compss.types.resources.jaxb.AdaptorType;
import es.bsc.compss.types.resources.jaxb.AdaptorsListType;
import es.bsc.compss.types.resources.jaxb.AttachedDiskType;
import es.bsc.compss.types.resources.jaxb.AttachedDisksListType;
import es.bsc.compss.types.resources.jaxb.BatchType;
import es.bsc.compss.types.resources.jaxb.CloudProviderType;
import es.bsc.compss.types.resources.jaxb.ComputeNodeType;
import es.bsc.compss.types.resources.jaxb.DataNodeType;
import es.bsc.compss.types.resources.jaxb.EndpointType;
import es.bsc.compss.types.resources.jaxb.ImageType;
import es.bsc.compss.types.resources.jaxb.ImagesType;
import es.bsc.compss.types.resources.jaxb.InstanceTypeType;
import es.bsc.compss.types.resources.jaxb.InstanceTypesType;
import es.bsc.compss.types.resources.jaxb.InteractiveType;
import es.bsc.compss.types.resources.jaxb.MemoryType;
import es.bsc.compss.types.resources.jaxb.OSType;
import es.bsc.compss.types.resources.jaxb.PriceType;
import es.bsc.compss.types.resources.jaxb.ProcessorType;
import es.bsc.compss.types.resources.jaxb.ResourcesExternalAdaptorProperties;
import es.bsc.compss.types.resources.jaxb.ResourcesNIOAdaptorProperties;
import es.bsc.compss.types.resources.jaxb.ServiceType;
import es.bsc.compss.types.resources.jaxb.SharedDiskType;
import es.bsc.compss.types.resources.jaxb.SoftwareListType;
import es.bsc.compss.types.resources.jaxb.StorageType;
import es.bsc.compss.types.resources.jaxb.SubmissionSystemType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.apache.logging.log4j.Logger;

public class Validator {
    private ResourcesFile rf;
    private Logger logger;

    public Validator(ResourcesFile rf, Logger logger) {
        this.logger = logger;
        this.rf = rf;
    }

    public void validate() throws ResourcesFileValidationException {
        this.logger.info("Validating <ResourcesList> tag");
        List<Object> objList = this.rf.getResources().getSharedDiskOrDataNodeOrComputeNode();
        if (objList != null) {
            for (Object obj : objList) {
                if (obj instanceof SharedDiskType) {
                    this.validateSharedDisk((SharedDiskType)obj);
                    continue;
                }
                if (obj instanceof DataNodeType) {
                    this.validateDataNode((DataNodeType)obj);
                    continue;
                }
                if (obj instanceof ComputeNodeType) {
                    this.validateComputeNode((ComputeNodeType)obj);
                    continue;
                }
                if (obj instanceof ServiceType) {
                    this.validateService((ServiceType)obj);
                    continue;
                }
                if (obj instanceof CloudProviderType) {
                    this.validateCloudProvider((CloudProviderType)obj);
                    continue;
                }
                throw new InvalidElementException("Resources", "Attribute" + obj.getClass(), "Incorrect attribute");
            }
        } else {
            throw new ResourcesFileValidationException("Empty resources file");
        }
        this.logger.info("End validation");
    }

    public void validateSharedDisk(SharedDiskType sd) throws InvalidElementException {
        int num = 0;
        for (String s : this.rf.getSharedDisks_names()) {
            if (!s.equals(sd.getName())) continue;
            ++num;
        }
        if (num > 1) {
            throw new InvalidElementException("SharedDisk", sd.getName(), "Name already in use");
        }
        if (sd.getStorage() != null) {
            this.validateStorage(sd.getStorage());
        }
    }

    public void validateDataNode(DataNodeType dn) throws InvalidElementException {
        int num = 0;
        for (String d : this.rf.getDataNodes_names()) {
            if (!d.equals(dn.getName())) continue;
            ++num;
        }
        if (num > 1) {
            throw new InvalidElementException("DataNode", dn.getName(), "Name already in use");
        }
        List<JAXBElement<?>> innerElements = dn.getHostOrPathOrAdaptors();
        if (innerElements != null) {
            boolean hostTagFound = false;
            boolean pathTagFound = false;
            boolean adaptorsTagFound = false;
            boolean storageTagFound = false;
            boolean sharedDisksTagFound = false;
            for (JAXBElement<?> obj : innerElements) {
                if (obj.getName().equals(new QName("Host"))) {
                    if (hostTagFound) {
                        throw new InvalidElementException("DataNode " + dn.getName(), "Attribute " + obj.getName(), "Appears more than once");
                    }
                    hostTagFound = true;
                    continue;
                }
                if (obj.getName().equals(new QName("Path"))) {
                    if (pathTagFound) {
                        throw new InvalidElementException("DataNode " + dn.getName(), "Attribute " + obj.getName(), "Appears more than once");
                    }
                    pathTagFound = true;
                    continue;
                }
                if (obj.getName().equals(new QName("Adaptors"))) {
                    if (adaptorsTagFound) {
                        throw new InvalidElementException("DataNode " + dn.getName(), "Attribute " + obj.getName(), "Appears more than once");
                    }
                    adaptorsTagFound = true;
                    this.validateAdaptors((AdaptorsListType)obj.getValue());
                    continue;
                }
                if (obj.getName().equals(new QName("Storage"))) {
                    if (storageTagFound) {
                        throw new InvalidElementException("DataNode " + dn.getName(), "Attribute " + obj.getName(), "Appears more than once");
                    }
                    storageTagFound = true;
                    this.validateStorage((StorageType)obj.getValue());
                    continue;
                }
                if (obj.getName().equals(new QName("SharedDisks"))) {
                    if (sharedDisksTagFound) {
                        throw new InvalidElementException("DataNode " + dn.getName(), "Attribute " + obj.getName(), "Appears more than once");
                    }
                    sharedDisksTagFound = true;
                    this.validateAttachedDisksList((AttachedDisksListType)obj.getValue());
                    continue;
                }
                throw new InvalidElementException("DataNode " + dn.getName(), "Attribute " + obj.getName(), "Incorrect attribute");
            }
            if (!hostTagFound) {
                throw new InvalidElementException("DataNode " + dn.getName(), "Attribute Host", "Doesn't appear");
            }
            if (!pathTagFound) {
                throw new InvalidElementException("DataNode " + dn.getName(), "Attribute Path", "Doesn't appear");
            }
            if (!adaptorsTagFound) {
                throw new InvalidElementException("DataNode " + dn.getName(), "Attribute Adaptors", "Doesn't appear");
            }
        } else {
            throw new InvalidElementException("DataNode " + dn.getName(), "", "Content is empty");
        }
    }

    public void validateComputeNode(ComputeNodeType cn) throws InvalidElementException {
        int num = 0;
        for (String c : this.rf.getComputeNodes_names()) {
            if (!c.equals(cn.getName())) continue;
            ++num;
        }
        if (num > 1) {
            throw new InvalidElementException("ComputeNode", cn.getName(), "Name already in use");
        }
        List<Object> innerElements = cn.getProcessorOrAdaptorsOrMemory();
        if (innerElements != null) {
            ArrayList<String> processorNames = new ArrayList<String>();
            boolean processorTagFound = false;
            boolean adaptorsTagFound = false;
            boolean memoryTagFound = false;
            boolean storageTagFound = false;
            boolean osTagFound = false;
            boolean softwareTagFound = false;
            boolean sharedDisksTagFound = false;
            boolean priceTagFound = false;
            for (Object obj : innerElements) {
                if (obj instanceof ProcessorType) {
                    ProcessorType p = (ProcessorType)obj;
                    if (processorNames.contains(p.getName())) {
                        throw new InvalidElementException("ComputeNode " + cn.getName(), "Attribute Processor" + p.getName(), "Appears more than once");
                    }
                    processorTagFound = true;
                    processorNames.add(p.getName());
                    this.validateProcessor(p);
                    continue;
                }
                if (obj instanceof AdaptorsListType) {
                    if (adaptorsTagFound) {
                        throw new InvalidElementException("ComputeNode " + cn.getName(), "Attribute " + obj.getClass(), "Appears more than once");
                    }
                    adaptorsTagFound = true;
                    this.validateAdaptors((AdaptorsListType)obj);
                    continue;
                }
                if (obj instanceof MemoryType) {
                    if (memoryTagFound) {
                        throw new InvalidElementException("ComputeNode " + cn.getName(), "Attribute " + obj.getClass(), "Appears more than once");
                    }
                    memoryTagFound = true;
                    this.validateMemory((MemoryType)obj);
                    continue;
                }
                if (obj instanceof StorageType) {
                    if (storageTagFound) {
                        throw new InvalidElementException("ComputeNode " + cn.getName(), "Attribute " + obj.getClass(), "Appears more than once");
                    }
                    storageTagFound = true;
                    this.validateStorage((StorageType)obj);
                    continue;
                }
                if (obj instanceof OSType) {
                    if (osTagFound) {
                        throw new InvalidElementException("ComputeNode " + cn.getName(), "Attribute " + obj.getClass(), "Appears more than once");
                    }
                    osTagFound = true;
                    this.validateOS((OSType)obj);
                    continue;
                }
                if (obj instanceof SoftwareListType) {
                    if (softwareTagFound) {
                        throw new InvalidElementException("ComputeNode " + cn.getName(), "Attribute " + obj.getClass(), "Appears more than once");
                    }
                    softwareTagFound = true;
                    this.validateSoftwareList((SoftwareListType)obj);
                    continue;
                }
                if (obj instanceof AttachedDisksListType) {
                    if (sharedDisksTagFound) {
                        throw new InvalidElementException("ComputeNode " + cn.getName(), "Attribute " + obj.getClass(), "Appears more than once");
                    }
                    sharedDisksTagFound = true;
                    this.validateAttachedDisksList((AttachedDisksListType)obj);
                    continue;
                }
                if (obj instanceof PriceType) {
                    if (priceTagFound) {
                        throw new InvalidElementException("ComputeNode " + cn.getName(), "Attribute " + obj.getClass(), "Appears more than once");
                    }
                    priceTagFound = true;
                    this.validatePrice((PriceType)obj);
                    continue;
                }
                throw new InvalidElementException("ComputeNode " + cn.getName(), "Attribute " + obj.getClass(), "Incorrect attribute");
            }
            if (!processorTagFound) {
                throw new InvalidElementException("ComputeNode " + cn.getName(), "Attribute Processor", "Doesn't appear");
            }
            if (!adaptorsTagFound) {
                throw new InvalidElementException("ComputeNode " + cn.getName(), "Attribute Adaptors", "Doesn't appear");
            }
        } else {
            throw new InvalidElementException("ComputeNode " + cn.getName(), "", "Content is empty");
        }
    }

    public void validateService(ServiceType s) throws InvalidElementException {
        int num = 0;
        for (String s2 : this.rf.getServices_wsdls()) {
            if (!s2.equals(s.getWsdl())) continue;
            ++num;
        }
        if (num > 1) {
            throw new InvalidElementException("Service", s.getWsdl(), "WSDL already in use");
        }
        if (s.getName() == null || s.getName().isEmpty()) {
            throw new InvalidElementException("Service " + s.getWsdl(), "Attribute Name", "Doesn't appear");
        }
        if (s.getNamespace() == null || s.getNamespace().isEmpty()) {
            throw new InvalidElementException("Service " + s.getWsdl(), "Attribute Namespace", "Doesn't appear");
        }
        if (s.getPort() == null || s.getPort().isEmpty()) {
            throw new InvalidElementException("Service " + s.getWsdl(), "Attribute Port", "Doesn't appear");
        }
        if (s.getPrice() != null) {
            this.validatePrice(s.getPrice());
        }
    }

    public void validateCloudProvider(CloudProviderType cp) throws InvalidElementException {
        int num = 0;
        for (String cp2 : this.rf.getCloudProviders_names()) {
            if (!cp2.equals(cp.getName())) continue;
            ++num;
        }
        if (num > 1) {
            throw new InvalidElementException("CloudProvider", cp.getName(), "Name already in use");
        }
        if (cp.getEndpoint() == null) {
            throw new InvalidElementException("CloudProvider " + cp.getName(), "Attribute Endpoint", "Doesn't appear");
        }
        this.validateEndpoint(cp.getEndpoint());
        if (cp.getImages() == null) {
            throw new InvalidElementException("CloudProvider " + cp.getName(), "Attribute Images", "Doesn't appear");
        }
        this.validateImages(cp.getImages());
        if (cp.getInstanceTypes() == null) {
            throw new InvalidElementException("CloudProvider " + cp.getName(), "Attribute InstanceTypes", "Doesn't appear");
        }
        this.validateInstanceTypes(cp.getInstanceTypes());
    }

    private void validateStorage(StorageType s) throws InvalidElementException {
        List<Serializable> innerElements = s.getSizeOrType();
        if (innerElements != null) {
            boolean sizeTagFound = false;
            boolean typeTagFound = false;
            for (Serializable obj : innerElements) {
                if (obj instanceof Float) {
                    if (sizeTagFound) {
                        throw new InvalidElementException("Storage", "Attribute Size", "Appears more than once");
                    }
                    sizeTagFound = true;
                    Float val = (Float)obj;
                    if (!((double)val.floatValue() <= 0.0)) continue;
                    throw new InvalidElementException("Storage", "Attribute Size", "Must be greater than 0");
                }
                if (obj instanceof String) {
                    if (typeTagFound) {
                        throw new InvalidElementException("Storage", "Attribute Type", "Appears more than once");
                    }
                    typeTagFound = true;
                    continue;
                }
                throw new InvalidElementException("Storage", "Attribute " + obj.getClass(), "Incorrect attribute");
            }
            if (!sizeTagFound) {
                throw new InvalidElementException("Storage ", "Attribute Size", "Doesn't appear");
            }
        } else {
            throw new InvalidElementException("Storage", "", "Content is empty");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void validateAdaptors(AdaptorsListType adaptors) throws InvalidElementException {
        if (adaptors == null) throw new InvalidElementException("Adaptors", "", "Tag not present");
        List<AdaptorType> adaptorsList = adaptors.getAdaptor();
        if (adaptorsList == null) throw new InvalidElementException("Adaptors", "", "Content is empty");
        for (AdaptorType adaptor : adaptorsList) {
            this.validateAdaptor(adaptor);
        }
    }

    private void validateAdaptor(AdaptorType adaptor) throws InvalidElementException {
        List<JAXBElement<?>> innerElements = adaptor.getSubmissionSystemOrPortsOrBrokerAdaptor();
        if (innerElements != null) {
            boolean subsysTagFound = false;
            boolean portsTagFound = false;
            boolean brokerAdaptorTagFound = false;
            boolean propertiesTagFound = false;
            boolean userTagFound = false;
            for (JAXBElement<?> obj : innerElements) {
                if (obj.getName().equals(new QName("SubmissionSystem"))) {
                    if (subsysTagFound) {
                        throw new InvalidElementException("Adaptor", "Attribute " + obj.getName(), "Appears more than once");
                    }
                    subsysTagFound = true;
                    this.validateSubmissionSystem((SubmissionSystemType)obj.getValue());
                    continue;
                }
                if (obj.getName().equals(new QName("Ports"))) {
                    if (portsTagFound) {
                        throw new InvalidElementException("Adaptor", "Attribute " + obj.getName(), "Appears more than once");
                    }
                    if (brokerAdaptorTagFound) {
                        throw new InvalidElementException("Adaptor", "Attribute " + obj.getName(), "An adaptor property (GAT) was already defined");
                    }
                    portsTagFound = true;
                    this.validateNIOAdaptorProperties((ResourcesNIOAdaptorProperties)obj.getValue());
                    continue;
                }
                if (obj.getName().equals(new QName("BrokerAdaptor"))) {
                    if (brokerAdaptorTagFound) {
                        throw new InvalidElementException("Adaptor", "Attribute " + obj.getName(), "Appears more than once");
                    }
                    if (portsTagFound) {
                        throw new InvalidElementException("Adaptor", "Attribute " + obj.getName(), "An adaptor property (NIO) was already defined");
                    }
                    brokerAdaptorTagFound = true;
                    this.validateGATAdaptorProperties((String)obj.getValue());
                    continue;
                }
                if (obj.getName().equals(new QName("Properties"))) {
                    if (propertiesTagFound) {
                        throw new InvalidElementException("Adaptor", "Attribute " + obj.getName(), "Appears more than once");
                    }
                    propertiesTagFound = true;
                    this.validateExternalAdaptorProperties((ResourcesExternalAdaptorProperties)obj.getValue());
                    continue;
                }
                if (obj.getName().equals(new QName("User"))) {
                    if (userTagFound) {
                        throw new InvalidElementException("Adaptor", "Attribute " + obj.getName(), "Appears more than once");
                    }
                    userTagFound = true;
                    continue;
                }
                throw new InvalidElementException("Adaptor " + adaptor.getName(), "Attribute" + obj.getName(), "Incorrect attribute");
            }
            if (!subsysTagFound) {
                throw new InvalidElementException("Adaptor " + adaptor.getName(), "Attribute SubmissionSystem", "Doesn't appear");
            }
            if (!(portsTagFound || brokerAdaptorTagFound || propertiesTagFound)) {
                throw new InvalidElementException("Adaptor " + adaptor.getName(), "Attribute Adaptor properties (NIO, GAT or External)", "Doesn't appear");
            }
        } else {
            throw new InvalidElementException("Adaptor", "", "Content is empty");
        }
    }

    private void validateSubmissionSystem(SubmissionSystemType subSys) throws InvalidElementException {
        List<Object> innerElements = subSys.getBatchOrInteractive();
        if (innerElements != null) {
            boolean batchTagFound = false;
            boolean interactiveTagFound = false;
            for (Object obj : innerElements) {
                if (obj instanceof BatchType) {
                    if (batchTagFound) {
                        throw new InvalidElementException("SubmissionSystem", "Attribute Batch", "Appears more than once");
                    }
                    batchTagFound = true;
                    this.validateBatch((BatchType)obj);
                    continue;
                }
                if (obj instanceof InteractiveType) {
                    if (interactiveTagFound) {
                        throw new InvalidElementException("SubmissionSystem", "Attribute Interactive", "Appears more than once");
                    }
                    interactiveTagFound = true;
                    this.validateInteractive((InteractiveType)obj);
                    continue;
                }
                throw new InvalidElementException("SubmissionSystem", "Attribute " + obj.getClass(), "Invalid type");
            }
            if (!batchTagFound && !interactiveTagFound) {
                throw new InvalidElementException("SubmissionSystem", "Interactive/Batch", "At least 1 submission system must be defined");
            }
        } else {
            throw new InvalidElementException("SubmissionSystem", "", "Content is empty");
        }
    }

    private void validateBatch(BatchType batch) throws InvalidElementException {
    }

    private void validateInteractive(InteractiveType interactive) throws InvalidElementException {
    }

    private void validateNIOAdaptorProperties(ResourcesNIOAdaptorProperties props) throws InvalidElementException {
        if (props.getMaxPort() < 0) {
            throw new InvalidElementException("Properties of NIO Adaptor", "Attribute MaxPort", "Invalid value");
        }
        if (props.getMinPort() < 0) {
            throw new InvalidElementException("Properties of NIO Adaptor", "Attribute MinPort", "Invalid value");
        }
        if (props.getMaxPort() <= props.getMinPort()) {
            throw new InvalidElementException("Properties of NIO Adaptor", "Attribute MinPort-MaxPort", "Invalid range");
        }
    }

    private void validateGATAdaptorProperties(String broker) throws InvalidElementException {
        if (broker == null || broker.isEmpty()) {
            throw new InvalidElementException("GATAdaptor", "Attribute BrokerAdaptor", "Doesn't appear");
        }
    }

    private void validateExternalAdaptorProperties(ResourcesExternalAdaptorProperties props) throws InvalidElementException {
    }

    private void validateAttachedDisksList(AttachedDisksListType disks) throws InvalidElementException {
        List<AttachedDiskType> innerElements = disks.getAttachedDisk();
        if (innerElements != null) {
            for (AttachedDiskType disk : innerElements) {
                this.validateAttachedDisk(disk);
            }
        } else {
            throw new InvalidElementException("AttachedDisksList", "", "Content is empty");
        }
    }

    private void validateAttachedDisk(AttachedDiskType disk) throws InvalidElementException {
        if (disk.getName() == null || disk.getName().isEmpty()) {
            throw new InvalidElementException("AttachedDisk ", "Attribute Name", "Doesn't appear");
        }
        if (this.rf.getSharedDisk(disk.getName()) == null) {
            throw new InvalidElementException("AttachedDisk" + disk.getName(), "", "Not defined as SharedDisk");
        }
        if (disk.getMountPoint() == null || disk.getMountPoint().isEmpty()) {
            throw new InvalidElementException("AttachedDisk" + disk.getName(), "Attribute MountPoint", "Doesn't appear");
        }
    }

    private void validateProcessor(ProcessorType processor) throws InvalidElementException {
        List<JAXBElement<?>> innerElements = processor.getComputingUnitsOrArchitectureOrSpeed();
        if (innerElements != null) {
            boolean cuTagFound = false;
            boolean architectureTagFound = false;
            boolean speedTagFound = false;
            boolean typeTagFound = false;
            boolean memTagFound = false;
            boolean processorPropertyTagFound = false;
            for (JAXBElement<?> obj : innerElements) {
                if (obj.getName().equals(new QName("ComputingUnits"))) {
                    if (cuTagFound) {
                        throw new InvalidElementException("Processor", "Attribute ComputingUnits", "Appears more than once");
                    }
                    cuTagFound = true;
                    int val = (Integer)obj.getValue();
                    if (val > 0) continue;
                    throw new InvalidElementException("Processor", "Attribute ComputingUnits", "Must be greater than 0");
                }
                if (obj.getName().equals(new QName("Architecture"))) {
                    if (architectureTagFound) {
                        throw new InvalidElementException("Processor", "Attribute Architecture", "Appears more than once");
                    }
                    architectureTagFound = true;
                    continue;
                }
                if (obj.getName().equals(new QName("Speed"))) {
                    if (speedTagFound) {
                        throw new InvalidElementException("Processor", "Attribute Speed", "Appears more than once");
                    }
                    speedTagFound = true;
                    float val = ((Float)obj.getValue()).floatValue();
                    if (!((double)val <= 0.0)) continue;
                    throw new InvalidElementException("Processor", "Attribute Speed", "Must be greater than 0");
                }
                if (obj.getName().equals(new QName("Type"))) {
                    if (typeTagFound) {
                        throw new InvalidElementException("Processor", "Attribute Type", "Appears more than once");
                    }
                    typeTagFound = true;
                    continue;
                }
                if (obj.getName().equals(new QName("InternalMemorySize"))) {
                    if (memTagFound) {
                        throw new InvalidElementException("Processor", "Attribute InternalMemorySize", "Appears more than once");
                    }
                    memTagFound = true;
                    float val = ((Float)obj.getValue()).floatValue();
                    if (!((double)val <= 0.0)) continue;
                    throw new InvalidElementException("Processor", "Attribute InternalMemorySize", "Must be greater than 0");
                }
                if (obj.getName().equals(new QName("ProcessorProperty"))) {
                    if (processorPropertyTagFound) {
                        throw new InvalidElementException("Processor", "Attribute ProcessorProperty", "Appears more than once");
                    }
                    processorPropertyTagFound = true;
                    continue;
                }
                throw new InvalidElementException("Processor", "Attribute " + obj.getClass(), "Incorrect attribute");
            }
            if (!cuTagFound) {
                throw new InvalidElementException("Processor", "Attribute ComputingUnits", "Doesn't appear");
            }
        } else {
            throw new InvalidElementException("Processor", "", "Content is empty");
        }
    }

    private void validateMemory(MemoryType memory) throws InvalidElementException {
        List<Serializable> innerElements = memory.getSizeOrType();
        if (innerElements != null) {
            boolean sizeTagFound = false;
            boolean typeTagFound = false;
            for (Serializable obj : innerElements) {
                if (obj instanceof Float) {
                    if (sizeTagFound) {
                        throw new InvalidElementException("Memory", "Attribute Size", "Appears more than once");
                    }
                    sizeTagFound = true;
                    Float val = (Float)obj;
                    if (!((double)val.floatValue() <= 0.0)) continue;
                    throw new InvalidElementException("Memory", "Attribute Size", "Must be greater than 0");
                }
                if (obj instanceof String) {
                    if (typeTagFound) {
                        throw new InvalidElementException("Memory", "Attribute Type", "Appears more than once");
                    }
                    typeTagFound = true;
                    continue;
                }
                throw new InvalidElementException("Memory", "Attribute " + obj.getClass(), "Incorrect attribute");
            }
            if (!sizeTagFound) {
                throw new InvalidElementException("Memory ", "Attribute Size", "Doesn't appear");
            }
        } else {
            throw new InvalidElementException("Memory", "", "Content is empty");
        }
    }

    private void validateOS(OSType os) throws InvalidElementException {
    }

    private void validateSoftwareList(SoftwareListType software) throws InvalidElementException {
    }

    private void validatePrice(PriceType price) throws InvalidElementException {
        if (price.getTimeUnit() <= 0) {
            throw new InvalidElementException("Price", "Attribute TimeUnit", "Invalid value");
        }
        if (price.getPricePerUnit() < 0.0f) {
            throw new InvalidElementException("Price", "Attribute PricePerUnit", "Invalid value");
        }
    }

    private void validateEndpoint(EndpointType endpoint) throws InvalidElementException {
    }

    private void validateImages(ImagesType images) throws InvalidElementException {
        ArrayList<String> imageNames = new ArrayList<String>();
        List<ImageType> imagesList = images.getImage();
        if (imagesList != null) {
            for (ImageType im : imagesList) {
                if (imageNames.contains(im.getName())) {
                    throw new InvalidElementException("Images", "Attribute Image " + im.getName(), "Name already used");
                }
                imageNames.add(im.getName());
                this.validateImage(im);
            }
        } else {
            throw new InvalidElementException("Images", "", "Content is empty");
        }
    }

    private void validateImage(ImageType image) throws InvalidElementException {
        List<Object> innerElements = image.getAdaptorsOrOperatingSystemOrSoftware();
        if (innerElements != null) {
            boolean adaptorsTagFound = false;
            boolean osTagFound = false;
            boolean softwareTagFound = false;
            boolean sdTagFound = false;
            boolean priceTagFound = false;
            boolean creationTimeTagFound = false;
            for (Object obj : innerElements) {
                if (obj instanceof AdaptorsListType) {
                    if (adaptorsTagFound) {
                        throw new InvalidElementException("Image", "Attribute Adaptors", "Appears more than once");
                    }
                    adaptorsTagFound = true;
                    this.validateAdaptors((AdaptorsListType)obj);
                    continue;
                }
                if (obj instanceof OSType) {
                    if (osTagFound) {
                        throw new InvalidElementException("Image", "Attribute OperatingSystem", "Appears more than once");
                    }
                    osTagFound = true;
                    this.validateOS((OSType)obj);
                    continue;
                }
                if (obj instanceof SoftwareListType) {
                    if (softwareTagFound) {
                        throw new InvalidElementException("Image", "Attribute Software", "Appears more than once");
                    }
                    softwareTagFound = true;
                    this.validateSoftwareList((SoftwareListType)obj);
                    continue;
                }
                if (obj instanceof AttachedDisksListType) {
                    if (sdTagFound) {
                        throw new InvalidElementException("Image", "Attribute AttachedDisks", "Appears more than once");
                    }
                    sdTagFound = true;
                    this.validateAttachedDisksList((AttachedDisksListType)obj);
                    continue;
                }
                if (obj instanceof PriceType) {
                    if (priceTagFound) {
                        throw new InvalidElementException("Image", "Attribute Price", "Appears more than once");
                    }
                    priceTagFound = true;
                    this.validatePrice((PriceType)obj);
                    continue;
                }
                if (obj instanceof Integer) {
                    if (creationTimeTagFound) {
                        throw new InvalidElementException("Image", "Attribute CreationTime", "Appears more than once");
                    }
                    creationTimeTagFound = true;
                    continue;
                }
                throw new InvalidElementException("Image", "Attribute " + obj.getClass(), "Incorrect attribute");
            }
            if (!adaptorsTagFound) {
                throw new InvalidElementException("Image ", "Attribute Adaptors", "Doesn't appear");
            }
        } else {
            throw new InvalidElementException("Image", "", "Content is empty");
        }
    }

    private void validateInstanceTypes(InstanceTypesType instances) throws InvalidElementException {
        ArrayList<String> instanceNames = new ArrayList<String>();
        List<InstanceTypeType> instancesList = instances.getInstanceType();
        if (instancesList != null) {
            for (InstanceTypeType i : instances.getInstanceType()) {
                if (instanceNames.contains(i.getName())) {
                    throw new InvalidElementException("Instances", "Attribute Instance " + i.getName(), "Name already used");
                }
                instanceNames.add(i.getName());
                this.validateInstance(i);
            }
        } else {
            throw new InvalidElementException("InstanceTypes", "", "Content is empty");
        }
    }

    private void validateInstance(InstanceTypeType instance) throws InvalidElementException {
        List<Object> innerElements = instance.getProcessorOrMemoryOrStorage();
        if (innerElements != null) {
            ArrayList<String> processorNames = new ArrayList<String>();
            boolean processorTagFound = false;
            boolean memoryTagFound = false;
            boolean storageTagFound = false;
            boolean priceTagFound = false;
            for (Object obj : innerElements) {
                if (obj instanceof ProcessorType) {
                    processorTagFound = true;
                    ProcessorType p = (ProcessorType)obj;
                    if (processorNames.contains(p.getName())) {
                        throw new InvalidElementException("Instance", "Attribute Processor " + p.getName(), "Appears more than once");
                    }
                    processorNames.add(p.getName());
                    this.validateProcessor((ProcessorType)obj);
                    continue;
                }
                if (obj instanceof MemoryType) {
                    if (memoryTagFound) {
                        throw new InvalidElementException("Instance", "Attribute Memory", "Appears more than once");
                    }
                    memoryTagFound = true;
                    this.validateMemory((MemoryType)obj);
                    continue;
                }
                if (obj instanceof StorageType) {
                    if (storageTagFound) {
                        throw new InvalidElementException("Instance", "Attribute Storage", "Appears more than once");
                    }
                    storageTagFound = true;
                    this.validateStorage((StorageType)obj);
                    continue;
                }
                if (obj instanceof PriceType) {
                    if (priceTagFound) {
                        throw new InvalidElementException("Instance", "Attribute Price", "Appears more than once");
                    }
                    priceTagFound = true;
                    this.validatePrice((PriceType)obj);
                    continue;
                }
                throw new InvalidElementException("Instance", "Attribute " + obj.getClass(), "Incorrect attribute");
            }
            if (!processorTagFound) {
                throw new InvalidElementException("Insntace", "Attribute Processor", "Doesn't appear");
            }
        } else {
            throw new InvalidElementException("InstanceType", "", "Content is empty");
        }
    }
}

