/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.oxm.mappings;

import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.core.queries.CoreContainerPolicy;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.oxm.ConversionManager;
import org.eclipse.persistence.internal.oxm.XMLObjectBuilder;
import org.eclipse.persistence.internal.oxm.XPathEngine;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.XPathQName;
import org.eclipse.persistence.internal.oxm.mappings.CompositeCollectionMapping;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.queries.JoinedAttributeManager;
import org.eclipse.persistence.internal.queries.MapContainerPolicy;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.AttributeAccessor;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.mappings.foundation.AbstractCompositeCollectionMapping;
import org.eclipse.persistence.oxm.XMLContext;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.XMLMarshaller;
import org.eclipse.persistence.oxm.XMLUnmarshaller;
import org.eclipse.persistence.oxm.mappings.UnmarshalKeepAsElementPolicy;
import org.eclipse.persistence.oxm.mappings.XMLInverseReferenceMapping;
import org.eclipse.persistence.oxm.mappings.XMLMapping;
import org.eclipse.persistence.oxm.mappings.XMLNillableMapping;
import org.eclipse.persistence.oxm.mappings.converters.XMLConverter;
import org.eclipse.persistence.oxm.mappings.nullpolicy.AbstractNullPolicy;
import org.eclipse.persistence.oxm.mappings.nullpolicy.NullPolicy;
import org.eclipse.persistence.oxm.mappings.nullpolicy.XMLNullRepresentationType;
import org.eclipse.persistence.oxm.record.DOMRecord;
import org.eclipse.persistence.oxm.record.XMLRecord;
import org.eclipse.persistence.platform.xml.XMLPlatformFactory;
import org.eclipse.persistence.queries.ObjectBuildingQuery;
import org.eclipse.persistence.sessions.Session;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class XMLCompositeCollectionMapping
extends AbstractCompositeCollectionMapping
implements CompositeCollectionMapping<AbstractSession, AttributeAccessor, ContainerPolicy, Converter, ClassDescriptor, DatabaseField, XMLMarshaller, Session, UnmarshalKeepAsElementPolicy, XMLUnmarshaller, XMLRecord>,
XMLMapping,
XMLNillableMapping {
    AbstractNullPolicy nullPolicy = new NullPolicy();
    private AbstractNullPolicy wrapperNullPolicy;
    private UnmarshalKeepAsElementPolicy keepAsElementPolicy;
    private XMLInverseReferenceMapping inverseReferenceMapping;
    private boolean defaultEmptyContainer = true;
    private boolean isWriteOnly;
    private boolean reuseContainer = false;

    @Deprecated
    public AttributeAccessor getContainerAccessor() {
        if (this.inverseReferenceMapping == null) {
            return null;
        }
        return this.inverseReferenceMapping.getAttributeAccessor();
    }

    @Deprecated
    public void setContainerAccessor(AttributeAccessor anAttributeAccessor) {
        if (this.inverseReferenceMapping == null) {
            return;
        }
        this.inverseReferenceMapping.setAttributeAccessor(anAttributeAccessor);
    }

    @Deprecated
    public void setContainerAttributeName(String attributeName) {
        if (this.inverseReferenceMapping == null) {
            return;
        }
        this.inverseReferenceMapping.setAttributeName(attributeName);
    }

    @Deprecated
    public String getContainerAttributeName() {
        if (this.inverseReferenceMapping == null) {
            return null;
        }
        return this.inverseReferenceMapping.getAttributeName();
    }

    @Deprecated
    public void setContainerGetMethodName(String methodName) {
        if (this.inverseReferenceMapping == null) {
            return;
        }
        this.inverseReferenceMapping.setGetMethodName(methodName);
    }

    @Deprecated
    public String getContainerGetMethodName() {
        if (this.inverseReferenceMapping == null) {
            return null;
        }
        return this.inverseReferenceMapping.getGetMethodName();
    }

    @Deprecated
    public String getContainerSetMethodName() {
        if (this.inverseReferenceMapping == null) {
            return null;
        }
        return this.inverseReferenceMapping.getSetMethodName();
    }

    @Deprecated
    public void setContainerSetMethodName(String methodName) {
        if (this.inverseReferenceMapping == null) {
            return;
        }
        this.inverseReferenceMapping.setSetMethodName(methodName);
    }

    @Override
    public boolean isXMLMapping() {
        return true;
    }

    @Override
    public void convertClassNamesToClasses(ClassLoader classLoader) {
        if ("UNKNOWN_OR_TRANSIENT_CLASS".equals(this.referenceClassName)) {
            return;
        }
        super.convertClassNamesToClasses(classLoader);
    }

    @Override
    public void initialize(AbstractSession session) throws DescriptorException {
        String referenceClassName = this.getReferenceClassName();
        if (this.referenceClass == null && referenceClassName != null && !referenceClassName.equals("UNKNOWN_OR_TRANSIENT_CLASS")) {
            this.setReferenceClass(session.getDatasourcePlatform().getConversionManager().convertClassNameToClass(referenceClassName));
        }
        this.initializeReferenceDescriptorAndField(session);
        CoreContainerPolicy cp = this.getContainerPolicy();
        if (cp != null) {
            if (((ContainerPolicy)cp).getContainerClass() == null) {
                Class cls = session.getDatasourcePlatform().getConversionManager().convertClassNameToClass(((ContainerPolicy)cp).getContainerClassName());
                ((ContainerPolicy)cp).setContainerClass(cls);
            }
            if (cp instanceof MapContainerPolicy) {
                this.initializeMapContainerPolicy(session, (MapContainerPolicy)cp);
            }
        }
        if (this.getContainerAccessor() != null) {
            this.getContainerAccessor().initializeAttributes(this.referenceClass);
        }
    }

    protected void initializeMapContainerPolicy(AbstractSession session, MapContainerPolicy cp) {
        cp.setElementClass(this.referenceClass);
    }

    protected void initializeReferenceDescriptorAndField(AbstractSession session) {
        if (this.referenceClass != null) {
            super.initialize(session);
        } else {
            if (this.field == null) {
                throw DescriptorException.fieldNameNotSetInMapping(this);
            }
            this.setField(((ClassDescriptor)this.getDescriptor()).buildField(this.field));
            this.setFields(this.collectFields());
            if (this.hasConverter()) {
                this.getConverter().initialize(this, session);
            }
        }
    }

    public String getXPath() {
        return ((DatabaseField)this.getField()).getName();
    }

    @Override
    public void setXPath(String xpathString) {
        this.setField(new XMLField(xpathString));
    }

    @Override
    protected Object buildCompositeObject(ClassDescriptor descriptor, AbstractRecord nestedRow, ObjectBuildingQuery query, CacheKey parentCacheKey, JoinedAttributeManager joinManger, AbstractSession targetSession) {
        return descriptor.getObjectBuilder().buildObject(query, nestedRow, joinManger);
    }

    @Override
    protected AbstractRecord buildCompositeRow(Object attributeValue, AbstractSession session, AbstractRecord parentRow, DatabaseMapping.WriteType writeType) {
        ClassDescriptor classDesc = null;
        try {
            classDesc = this.getReferenceDescriptor(attributeValue, session);
        }
        catch (Exception exception) {}
        XMLField xmlFld = (XMLField)this.getField();
        if (xmlFld.hasLastXPathFragment() && xmlFld.getLastXPathFragment().hasLeafElementType()) {
            XMLRecord xmlRec = (XMLRecord)parentRow;
            xmlRec.setLeafElementType(xmlFld.getLastXPathFragment().getLeafElementType());
        }
        XMLRecord parent = (XMLRecord)parentRow;
        if (classDesc != null) {
            return this.buildCompositeRowForDescriptor(classDesc, attributeValue, session, parent, writeType);
        }
        if (attributeValue instanceof Element && this.getKeepAsElementPolicy() == UnmarshalKeepAsElementPolicy.KEEP_UNKNOWN_AS_ELEMENT) {
            return new DOMRecord((Element)attributeValue);
        }
        Node newNode = XPathEngine.getInstance().create((XMLField)this.getField(), parent.getDOM(), attributeValue, session);
        DOMRecord newRow = new DOMRecord(newNode);
        return newRow;
    }

    protected AbstractRecord buildCompositeRowForDescriptor(ClassDescriptor classDesc, Object attributeValue, AbstractSession session, XMLRecord parentRow, DatabaseMapping.WriteType writeType) {
        XMLObjectBuilder objectBuilder = (XMLObjectBuilder)classDesc.getObjectBuilder();
        XMLRecord child = (XMLRecord)objectBuilder.createRecordFor(attributeValue, (XMLField)this.getField(), parentRow, this);
        child.setNamespaceResolver(parentRow.getNamespaceResolver());
        child.setSession(session);
        objectBuilder.buildIntoNestedRow(child, attributeValue, session, (XMLDescriptor)this.getReferenceDescriptor(), (XMLField)this.getField());
        return child;
    }

    @Override
    public void writeFromObjectIntoRow(Object object, AbstractRecord row, AbstractSession session, DatabaseMapping.WriteType writeType) throws DescriptorException {
        if (this.isReadOnly()) {
            return;
        }
        Object attributeValue = this.getAttributeValueFromObject(object);
        if (attributeValue == null) {
            row.put((DatabaseField)this.getField(), (Object)null);
            return;
        }
        CoreContainerPolicy cp = this.getContainerPolicy();
        Vector<Object> nestedRows = new Vector<Object>(((ContainerPolicy)cp).sizeFor(attributeValue));
        Object iter = ((ContainerPolicy)cp).iteratorFor(attributeValue);
        if (iter != null) {
            while (((ContainerPolicy)cp).hasNext(iter)) {
                Object element = ((ContainerPolicy)cp).next(iter, session);
                if ((element = this.convertObjectValueToDataValue(element, session, ((XMLRecord)row).getMarshaller())) == null) {
                    XMLNullRepresentationType nullRepresentation = this.getNullPolicy().getMarshalNullRepresentation();
                    if (nullRepresentation == XMLNullRepresentationType.XSI_NIL) {
                        nestedRows.add(XMLRecord.NIL);
                        continue;
                    }
                    if (nullRepresentation != XMLNullRepresentationType.EMPTY_NODE) continue;
                    Element emptyNode = XPathEngine.getInstance().createUnownedElement(((XMLRecord)row).getDOM(), (XMLField)this.field);
                    DOMRecord nestedRow = new DOMRecord((Node)emptyNode);
                    nestedRows.add(nestedRow);
                    continue;
                }
                nestedRows.addElement(this.buildCompositeRow(element, session, row, writeType));
            }
        }
        Object fieldValue = null;
        if (!nestedRows.isEmpty()) {
            fieldValue = ((ClassDescriptor)this.getDescriptor()).buildFieldValueFromNestedRows(nestedRows, this.getStructureName(), session);
        }
        row.put((DatabaseField)this.getField(), fieldValue);
    }

    @Override
    public Object valueFromRow(AbstractRecord row, JoinedAttributeManager joinManager, ObjectBuildingQuery sourceQuery, CacheKey cacheKey, AbstractSession executionSession, boolean isTargetProtected, Boolean[] wasCacheUsed) throws DatabaseException {
        CoreContainerPolicy cp = this.getContainerPolicy();
        Object fieldValue = row.getValues((DatabaseField)this.getField());
        if (fieldValue == null || fieldValue instanceof String) {
            if (this.reuseContainer) {
                Object currentObject = ((XMLRecord)row).getCurrentObject();
                Object container = ((AttributeAccessor)this.getAttributeAccessor()).getAttributeValueFromObject(currentObject);
                return container != null ? container : ((ContainerPolicy)cp).containerInstance();
            }
            return ((ContainerPolicy)cp).containerInstance();
        }
        Vector nestedRows = ((ClassDescriptor)this.getDescriptor()).buildNestedRowsFromFieldValue(fieldValue, executionSession);
        if (nestedRows == null) {
            if (this.reuseContainer) {
                Object currentObject = ((XMLRecord)row).getCurrentObject();
                Object container = ((AttributeAccessor)this.getAttributeAccessor()).getAttributeValueFromObject(currentObject);
                return container != null ? container : ((ContainerPolicy)cp).containerInstance();
            }
            return ((ContainerPolicy)cp).containerInstance();
        }
        Object result = null;
        if (this.reuseContainer) {
            Object currentObject = ((XMLRecord)row).getCurrentObject();
            Object container = ((AttributeAccessor)this.getAttributeAccessor()).getAttributeValueFromObject(currentObject);
            result = container != null ? container : ((ContainerPolicy)cp).containerInstance();
        } else {
            result = ((ContainerPolicy)cp).containerInstance(nestedRows.size());
        }
        Enumeration stream = nestedRows.elements();
        while (stream.hasMoreElements()) {
            XMLRecord nestedRow = (XMLRecord)stream.nextElement();
            Object objectToAdd = this.getNullPolicy().valueIsNull((Element)nestedRow.getDOM()) ? null : this.buildObjectFromNestedRow(nestedRow, joinManager, sourceQuery, executionSession, isTargetProtected);
            ((ContainerPolicy)cp).addInto(objectToAdd, result, sourceQuery.getSession());
            if (this.getContainerAccessor() == null) continue;
            Object currentObject = ((XMLRecord)row).getCurrentObject();
            if (this.inverseReferenceMapping.getContainerPolicy() == null) {
                this.getContainerAccessor().setAttributeValueInObject(objectToAdd, currentObject);
                continue;
            }
            Object backpointerContainer = this.getContainerAccessor().getAttributeValueFromObject(objectToAdd);
            if (backpointerContainer == null) {
                backpointerContainer = this.inverseReferenceMapping.getContainerPolicy().containerInstance();
                this.getContainerAccessor().setAttributeValueInObject(objectToAdd, backpointerContainer);
            }
            this.inverseReferenceMapping.getContainerPolicy().addInto(currentObject, backpointerContainer, executionSession);
        }
        return result;
    }

    public Object buildObjectFromNestedRow(AbstractRecord nestedRow, JoinedAttributeManager joinManager, ObjectBuildingQuery sourceQuery, AbstractSession executionSession, boolean isTargetProtected) {
        Object objectToAdd = null;
        ClassDescriptor aDescriptor = this.getReferenceDescriptor((DOMRecord)nestedRow);
        if (aDescriptor == null) {
            if (this.getKeepAsElementPolicy() == UnmarshalKeepAsElementPolicy.KEEP_UNKNOWN_AS_ELEMENT || this.getKeepAsElementPolicy() == UnmarshalKeepAsElementPolicy.KEEP_ALL_AS_ELEMENT) {
                XMLPlatformFactory.getInstance().getXMLPlatform().namespaceQualifyFragment((Element)((DOMRecord)nestedRow).getDOM());
                objectToAdd = ((DOMRecord)nestedRow).getDOM();
                this.convertDataValueToObjectValue(objectToAdd, executionSession, ((XMLRecord)nestedRow).getUnmarshaller());
                objectToAdd = this.convertToSimpleTypeIfPresent(objectToAdd, nestedRow, executionSession);
            } else {
                NodeList children = ((Element)((DOMRecord)nestedRow).getDOM()).getChildNodes();
                int i = 0;
                while (i < children.getLength()) {
                    Node nextNode = children.item(i);
                    if (nextNode.getNodeType() == 1) {
                        String type = ((Element)((DOMRecord)nestedRow).getDOM()).getAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "type");
                        if (type != null && type.length() > 0) {
                            throw XMLMarshalException.unknownXsiTypeValue(type, this);
                        }
                        throw XMLMarshalException.noDescriptorFound(this);
                    }
                    ++i;
                }
                objectToAdd = this.convertToSimpleTypeIfPresent(objectToAdd, nestedRow, executionSession);
            }
        } else {
            if (aDescriptor.hasInheritance()) {
                QName leafElementType;
                Class newElementClass = aDescriptor.getInheritancePolicy().classFromRow(nestedRow, executionSession);
                if (newElementClass == null && (leafElementType = ((XMLField)this.getField()).getLeafElementType()) != null) {
                    XPathQName leafElementXPathQName = new XPathQName(leafElementType, ((XMLRecord)nestedRow).isNamespaceAware());
                    Object indicator = aDescriptor.getInheritancePolicy().getClassIndicatorMapping().get(leafElementXPathQName);
                    if (indicator != null) {
                        newElementClass = (Class)indicator;
                    }
                }
                if (newElementClass != null) {
                    aDescriptor = this.getReferenceDescriptor(newElementClass, executionSession);
                } else if (Modifier.isAbstract(aDescriptor.getJavaClass().getModifiers())) {
                    throw DescriptorException.missingClassIndicatorField(nestedRow, aDescriptor.getInheritancePolicy().getDescriptor());
                }
            }
            objectToAdd = this.buildCompositeObject(aDescriptor, nestedRow, sourceQuery, null, joinManager, executionSession);
            objectToAdd = this.convertDataValueToObjectValue(objectToAdd, executionSession, ((XMLRecord)nestedRow).getUnmarshaller());
        }
        return objectToAdd;
    }

    private Object convertToSimpleTypeIfPresent(Object objectToAdd, AbstractRecord nestedRow, AbstractSession executionSession) {
        String stringValue = null;
        Element theElement = (Element)((DOMRecord)nestedRow).getDOM();
        Node textchild = theElement.getFirstChild();
        if (textchild != null && textchild.getNodeType() == 3 && (stringValue = ((Text)textchild).getNodeValue()) != null && this.getKeepAsElementPolicy() != UnmarshalKeepAsElementPolicy.KEEP_UNKNOWN_AS_ELEMENT && this.getKeepAsElementPolicy() != UnmarshalKeepAsElementPolicy.KEEP_ALL_AS_ELEMENT) {
            objectToAdd = stringValue;
        }
        if (stringValue == null || stringValue.length() == 0) {
            return objectToAdd;
        }
        String type = theElement.getAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "type");
        if (type != null && type.length() > 0) {
            XPathFragment typeFragment = new XPathFragment(type);
            String namespaceURI = ((DOMRecord)nestedRow).resolveNamespacePrefix(typeFragment.getPrefix());
            typeFragment.setNamespaceURI(namespaceURI);
            QName schemaTypeQName = new QName(namespaceURI, typeFragment.getLocalName());
            ConversionManager conversionManager = (ConversionManager)((Object)executionSession.getDatasourcePlatform().getConversionManager());
            Class<?> theClass = conversionManager.javaType(schemaTypeQName);
            if (theClass != null) {
                objectToAdd = conversionManager.convertObject(stringValue, theClass, schemaTypeQName);
            }
        }
        return objectToAdd;
    }

    public ClassDescriptor getReferenceDescriptor(DOMRecord xmlRecord) {
        ClassDescriptor returnDescriptor = this.referenceDescriptor;
        if (returnDescriptor == null) {
            String type = ((Element)xmlRecord.getDOM()).getAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "type");
            if (type != null && type.length() > 0) {
                XPathFragment typeFragment = new XPathFragment(type);
                String namespaceURI = xmlRecord.resolveNamespacePrefix(typeFragment.getPrefix());
                typeFragment.setNamespaceURI(namespaceURI);
                returnDescriptor = xmlRecord.getUnmarshaller().getXMLContext().getDescriptorByGlobalType(typeFragment);
            } else {
                QName leafType = ((XMLField)this.getField()).getLastXPathFragment().getLeafElementType();
                if (leafType != null) {
                    XPathFragment frag = new XPathFragment();
                    String xpath2 = leafType.getLocalPart();
                    String uri = leafType.getNamespaceURI();
                    if (uri != null && uri.length() > 0) {
                        frag.setNamespaceURI(uri);
                        String prefix = ((XMLDescriptor)this.getDescriptor()).getNonNullNamespaceResolver().resolveNamespaceURI(uri);
                        if (prefix != null && prefix.length() > 0) {
                            xpath2 = String.valueOf(prefix) + ':' + xpath2;
                        }
                    }
                    frag.setXPath(xpath2);
                    returnDescriptor = xmlRecord.getUnmarshaller().getXMLContext().getDescriptorByGlobalType(frag);
                }
            }
        }
        return returnDescriptor;
    }

    @Override
    protected ClassDescriptor getReferenceDescriptor(Class theClass, AbstractSession session) {
        if (this.getReferenceDescriptor() != null && ((ClassDescriptor)this.getReferenceDescriptor()).getJavaClass().equals(theClass)) {
            return this.getReferenceDescriptor();
        }
        ClassDescriptor subDescriptor = session.getDescriptor(theClass);
        if (subDescriptor == null && this.getKeepAsElementPolicy() != UnmarshalKeepAsElementPolicy.KEEP_UNKNOWN_AS_ELEMENT) {
            throw DescriptorException.noSubClassMatch(theClass, this);
        }
        return subDescriptor;
    }

    @Override
    public void writeSingleValue(Object value, Object parent, XMLRecord record, AbstractSession session) {
        Object element = this.convertObjectValueToDataValue(value, session, record.getMarshaller());
        XMLRecord nestedRow = (XMLRecord)this.buildCompositeRow(element, session, record, DatabaseMapping.WriteType.UNDEFINED);
        record.add((DatabaseField)this.getField(), nestedRow);
    }

    @Override
    public void setNullPolicy(AbstractNullPolicy aNullPolicy) {
        this.nullPolicy = aNullPolicy;
    }

    @Override
    public AbstractNullPolicy getNullPolicy() {
        return this.nullPolicy;
    }

    @Override
    public UnmarshalKeepAsElementPolicy getKeepAsElementPolicy() {
        return this.keepAsElementPolicy;
    }

    @Override
    public void setKeepAsElementPolicy(UnmarshalKeepAsElementPolicy keepAsElementPolicy) {
        this.keepAsElementPolicy = keepAsElementPolicy;
    }

    protected XMLDescriptor getDescriptor(XMLRecord xmlRecord, AbstractSession session, QName rootQName) throws XMLMarshalException {
        XMLContext xmlContext;
        XMLDescriptor xmlDescriptor;
        if (rootQName == null) {
            rootQName = new QName(xmlRecord.getNamespaceURI(), xmlRecord.getLocalName());
        }
        if ((xmlDescriptor = (xmlContext = xmlRecord.getUnmarshaller().getXMLContext()).getDescriptor(rootQName)) == null && this.getKeepAsElementPolicy() != UnmarshalKeepAsElementPolicy.KEEP_UNKNOWN_AS_ELEMENT && this.getKeepAsElementPolicy() != UnmarshalKeepAsElementPolicy.KEEP_ALL_AS_ELEMENT) {
            throw XMLMarshalException.noDescriptorWithMatchingRootElement(xmlRecord.getLocalName());
        }
        return xmlDescriptor;
    }

    @Override
    public boolean isWriteOnly() {
        return this.isWriteOnly;
    }

    @Override
    public void setIsWriteOnly(boolean b) {
        this.isWriteOnly = b;
    }

    @Override
    public void preInitialize(AbstractSession session) throws DescriptorException {
        ((AttributeAccessor)this.getAttributeAccessor()).setIsWriteOnly(this.isWriteOnly());
        ((AttributeAccessor)this.getAttributeAccessor()).setIsReadOnly(this.isReadOnly());
        super.preInitialize(session);
    }

    @Override
    public void setAttributeValueInObject(Object object, Object value) throws DescriptorException {
        if (this.isWriteOnly()) {
            return;
        }
        super.setAttributeValueInObject(object, value);
    }

    @Override
    public boolean getReuseContainer() {
        return this.reuseContainer;
    }

    @Override
    public void setReuseContainer(boolean reuseContainer) {
        this.reuseContainer = reuseContainer;
    }

    @Override
    public XMLInverseReferenceMapping getInverseReferenceMapping() {
        return this.inverseReferenceMapping;
    }

    void setInverseReferenceMapping(XMLInverseReferenceMapping inverseReferenceMapping) {
        this.inverseReferenceMapping = inverseReferenceMapping;
    }

    @Override
    public boolean isDefaultEmptyContainer() {
        return this.defaultEmptyContainer;
    }

    @Override
    public void setDefaultEmptyContainer(boolean defaultEmptyContainer) {
        this.defaultEmptyContainer = defaultEmptyContainer;
    }

    @Override
    public AbstractNullPolicy getWrapperNullPolicy() {
        return this.wrapperNullPolicy;
    }

    @Override
    public void setWrapperNullPolicy(AbstractNullPolicy policy) {
        this.wrapperNullPolicy = policy;
    }

    @Override
    public Object convertObjectValueToDataValue(Object value, Session session, XMLMarshaller marshaller) {
        if (this.hasConverter()) {
            if (this.converter instanceof XMLConverter) {
                return ((XMLConverter)this.converter).convertObjectValueToDataValue(value, (AbstractSession)session, marshaller);
            }
            return this.converter.convertObjectValueToDataValue(value, (AbstractSession)session);
        }
        return value;
    }

    @Override
    public Object convertDataValueToObjectValue(Object value, Session session, XMLUnmarshaller unmarshaller) {
        if (this.hasConverter()) {
            if (this.converter instanceof XMLConverter) {
                return ((XMLConverter)this.converter).convertDataValueToObjectValue(value, session, unmarshaller);
            }
            return this.converter.convertDataValueToObjectValue(value, session);
        }
        return value;
    }
}

