/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.project;

import es.bsc.compss.types.project.Validator;
import es.bsc.compss.types.project.exceptions.InvalidElementException;
import es.bsc.compss.types.project.exceptions.ProjectFileValidationException;
import es.bsc.compss.types.project.jaxb.AdaptorType;
import es.bsc.compss.types.project.jaxb.AdaptorsListType;
import es.bsc.compss.types.project.jaxb.ApplicationType;
import es.bsc.compss.types.project.jaxb.BatchType;
import es.bsc.compss.types.project.jaxb.CloudPropertiesType;
import es.bsc.compss.types.project.jaxb.CloudPropertyType;
import es.bsc.compss.types.project.jaxb.CloudProviderType;
import es.bsc.compss.types.project.jaxb.CloudType;
import es.bsc.compss.types.project.jaxb.ComputeNodeType;
import es.bsc.compss.types.project.jaxb.DataNodeType;
import es.bsc.compss.types.project.jaxb.ExternalAdaptorProperties;
import es.bsc.compss.types.project.jaxb.ImageType;
import es.bsc.compss.types.project.jaxb.ImagesType;
import es.bsc.compss.types.project.jaxb.InstanceTypeType;
import es.bsc.compss.types.project.jaxb.InstanceTypesType;
import es.bsc.compss.types.project.jaxb.InteractiveType;
import es.bsc.compss.types.project.jaxb.MasterNodeType;
import es.bsc.compss.types.project.jaxb.MemoryType;
import es.bsc.compss.types.project.jaxb.NIOAdaptorProperties;
import es.bsc.compss.types.project.jaxb.OSType;
import es.bsc.compss.types.project.jaxb.OSTypeType;
import es.bsc.compss.types.project.jaxb.ObjectFactory;
import es.bsc.compss.types.project.jaxb.PackageType;
import es.bsc.compss.types.project.jaxb.ProcessorPropertyType;
import es.bsc.compss.types.project.jaxb.ProcessorType;
import es.bsc.compss.types.project.jaxb.ProjectType;
import es.bsc.compss.types.project.jaxb.PropertyAdaptorType;
import es.bsc.compss.types.project.jaxb.ServiceType;
import es.bsc.compss.types.project.jaxb.StorageType;
import es.bsc.compss.types.project.jaxb.SubmissionSystemType;
import java.io.File;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.logging.log4j.Logger;
import org.xml.sax.SAXException;

public class ProjectFile {
    public static final String PORTS = "Ports";
    public static final String BROKER_ADAPTOR = "BrokerAdaptor";
    public static final String PROPERTIES = "Properties";
    private JAXBContext context;
    private Schema xsd;
    private ProjectType project;
    private Validator validator;
    private Logger logger;

    public ProjectFile(File xml, Schema xsd, Logger logger) throws JAXBException, ProjectFileValidationException {
        this.logger = logger;
        this.logger.info("Init Project.xml parsing");
        this.context = JAXBContext.newInstance(ObjectFactory.class.getPackage().getName());
        this.xsd = xsd;
        Unmarshaller um = this.context.createUnmarshaller();
        um.setSchema(this.xsd);
        JAXBElement jaxbElem = (JAXBElement)um.unmarshal(xml);
        this.project = (ProjectType)jaxbElem.getValue();
        this.logger.info("Init Project.xml validation");
        this.validator = new Validator(this, this.logger);
        this.validator.validate();
        this.logger.info("Project.xml finished");
    }

    public ProjectFile(String xmlString, Schema xsd, Logger logger) throws JAXBException, ProjectFileValidationException {
        this.logger = logger;
        this.logger.info("Init Project.xml parsing");
        this.context = JAXBContext.newInstance(ObjectFactory.class.getPackage().getName());
        this.xsd = xsd;
        Unmarshaller um = this.context.createUnmarshaller();
        um.setSchema(this.xsd);
        JAXBElement jaxbElem = (JAXBElement)um.unmarshal(new StringReader(xmlString));
        this.project = (ProjectType)jaxbElem.getValue();
        this.logger.info("Init Project.xml validation");
        this.validator = new Validator(this, this.logger);
        this.validator.validate();
        this.logger.info("Project.xml finished");
    }

    public ProjectFile(File xml, String xsdPath, Logger logger) throws SAXException, JAXBException, ProjectFileValidationException {
        this.logger = logger;
        this.logger.info("Init Project.xml parsing");
        this.context = JAXBContext.newInstance(ObjectFactory.class.getPackage().getName());
        SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        this.xsd = sf.newSchema(new File(xsdPath));
        Unmarshaller um = this.context.createUnmarshaller();
        um.setSchema(this.xsd);
        JAXBElement jaxbElem = (JAXBElement)um.unmarshal(xml);
        this.project = (ProjectType)jaxbElem.getValue();
        this.logger.info("Init Project.xml validation");
        this.validator = new Validator(this, this.logger);
        this.validator.validate();
        this.logger.info("Project.xml finished");
    }

    public ProjectFile(String xmlString, String xsdPath, Logger logger) throws SAXException, JAXBException, ProjectFileValidationException {
        this.logger = logger;
        this.logger.info("Init Project.xml parsing");
        this.context = JAXBContext.newInstance(ObjectFactory.class.getPackage().getName());
        SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        this.xsd = sf.newSchema(new File(xsdPath));
        Unmarshaller um = this.context.createUnmarshaller();
        um.setSchema(this.xsd);
        JAXBElement jaxbElem = (JAXBElement)um.unmarshal(new StringReader(xmlString));
        this.project = (ProjectType)jaxbElem.getValue();
        this.logger.info("Init Project.xml validation");
        this.validator = new Validator(this, this.logger);
        this.validator.validate();
        this.logger.info("Project.xml finished");
    }

    public ProjectFile(String xsdPath, Logger logger) throws SAXException, JAXBException, ProjectFileValidationException {
        this.logger = logger;
        this.logger.info("Init Project.xml parsing");
        this.context = JAXBContext.newInstance(ObjectFactory.class.getPackage().getName());
        SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        this.xsd = sf.newSchema(new File(xsdPath));
        Unmarshaller um = this.context.createUnmarshaller();
        um.setSchema(this.xsd);
        this.project = new ProjectType();
        this.addEmptyMaster();
        this.logger.info("Init Project.xml validation");
        this.validator = new Validator(this, this.logger);
        this.logger.info("Project.xml finished");
    }

    public ProjectFile(Logger logger) throws JAXBException {
        this.logger = logger;
        this.project = new ProjectType();
        this.validator = new Validator(this, this.logger);
        this.context = JAXBContext.newInstance(ObjectFactory.class.getPackage().getName());
        this.addEmptyMaster();
    }

    private void addEmptyMaster() {
        MasterNodeType master = new MasterNodeType();
        this.project.getMasterNodeOrComputeNodeOrDataNode().add(master);
    }

    public void toFile(File file) throws JAXBException {
        this.logger.info("Project.xml to file");
        Marshaller m = this.context.createMarshaller();
        ObjectFactory objFact = new ObjectFactory();
        m.setSchema(this.xsd);
        m.setProperty("jaxb.formatted.output", Boolean.TRUE);
        m.marshal(objFact.createProject(this.project), file);
    }

    public String getString() throws JAXBException {
        this.logger.info("Project.xml to string");
        Marshaller m = this.context.createMarshaller();
        ObjectFactory objFact = new ObjectFactory();
        m.setSchema(this.xsd);
        m.setProperty("jaxb.formatted.output", Boolean.TRUE);
        StringWriter sw = new StringWriter();
        m.marshal(objFact.createProject(this.project), sw);
        return sw.getBuffer().toString();
    }

    public ProjectType getProject() {
        return this.project;
    }

    public MasterNodeType getMasterNode() {
        List<Object> objList = this.project.getMasterNodeOrComputeNodeOrDataNode();
        if (objList != null) {
            for (Object obj : objList) {
                if (!(obj instanceof MasterNodeType)) continue;
                return (MasterNodeType)obj;
            }
        }
        return null;
    }

    public CloudType getCloud() {
        List<Object> objList = this.project.getMasterNodeOrComputeNodeOrDataNode();
        if (objList != null) {
            for (Object obj : objList) {
                if (!(obj instanceof CloudType)) continue;
                return (CloudType)obj;
            }
        }
        return null;
    }

    public List<ComputeNodeType> getComputeNodes_list() {
        ArrayList<ComputeNodeType> list = new ArrayList<ComputeNodeType>();
        List<Object> objList = this.project.getMasterNodeOrComputeNodeOrDataNode();
        if (objList != null) {
            for (Object obj : objList) {
                if (!(obj instanceof ComputeNodeType)) continue;
                list.add((ComputeNodeType)obj);
            }
        }
        return list;
    }

    public List<DataNodeType> getDataNodes_list() {
        ArrayList<DataNodeType> list = new ArrayList<DataNodeType>();
        List<Object> objList = this.project.getMasterNodeOrComputeNodeOrDataNode();
        if (objList != null) {
            for (Object obj : objList) {
                if (!(obj instanceof DataNodeType)) continue;
                list.add((DataNodeType)obj);
            }
        }
        return list;
    }

    public List<ServiceType> getServices_list() {
        ArrayList<ServiceType> list = new ArrayList<ServiceType>();
        List<Object> objList = this.project.getMasterNodeOrComputeNodeOrDataNode();
        if (objList != null) {
            for (Object obj : objList) {
                if (!(obj instanceof ServiceType)) continue;
                list.add((ServiceType)obj);
            }
        }
        return list;
    }

    public List<CloudProviderType> getCloudProviders_list() {
        ArrayList<CloudProviderType> list = new ArrayList<CloudProviderType>();
        List<Object> objList = this.project.getMasterNodeOrComputeNodeOrDataNode();
        if (objList != null) {
            for (Object obj : objList) {
                CloudType cloud;
                List<JAXBElement<?>> cloudPropsList;
                if (!(obj instanceof CloudType) || (cloudPropsList = (cloud = (CloudType)obj).getCloudProviderOrInitialVMsOrMinimumVMs()) == null) continue;
                for (JAXBElement<?> jaxbelem : cloudPropsList) {
                    if (!jaxbelem.getName().equals(new QName("CloudProvider"))) continue;
                    list.add((CloudProviderType)jaxbelem.getValue());
                }
            }
        }
        return list;
    }

    public int getProcessorComputingUnits(ProcessorType p) {
        List<JAXBElement<?>> objList = p.getComputingUnitsOrArchitectureOrSpeed();
        if (objList != null) {
            for (JAXBElement<?> obj : objList) {
                if (!obj.getName().equals(new QName("ComputingUnits"))) continue;
                return (Integer)obj.getValue();
            }
        }
        return -1;
    }

    public String getProcessorArchitecture(ProcessorType p) {
        List<JAXBElement<?>> objList = p.getComputingUnitsOrArchitectureOrSpeed();
        if (objList != null) {
            for (JAXBElement<?> obj : objList) {
                if (!obj.getName().equals(new QName("Architecture"))) continue;
                return (String)obj.getValue();
            }
        }
        return null;
    }

    public float getProcessorSpeed(ProcessorType p) {
        List<JAXBElement<?>> objList = p.getComputingUnitsOrArchitectureOrSpeed();
        if (objList != null) {
            for (JAXBElement<?> obj : objList) {
                if (!obj.getName().equals(new QName("Speed"))) continue;
                return ((Float)obj.getValue()).floatValue();
            }
        }
        return -1.0f;
    }

    public String getProcessorType(ProcessorType p) {
        List<JAXBElement<?>> objList = p.getComputingUnitsOrArchitectureOrSpeed();
        if (objList != null) {
            for (JAXBElement<?> obj : objList) {
                if (!obj.getName().equals(new QName("Type"))) continue;
                return (String)obj.getValue();
            }
        }
        return null;
    }

    public float getProcessorMemorySize(ProcessorType p) {
        List<JAXBElement<?>> objList = p.getComputingUnitsOrArchitectureOrSpeed();
        if (objList != null) {
            for (JAXBElement<?> obj : objList) {
                if (!obj.getName().equals(new QName("InternalMemorySize"))) continue;
                return ((Float)obj.getValue()).floatValue();
            }
        }
        return -1.0f;
    }

    public ProcessorPropertyType getProcessorProperty(ProcessorType p) {
        List<JAXBElement<?>> objList = p.getComputingUnitsOrArchitectureOrSpeed();
        if (objList != null) {
            for (JAXBElement<?> obj : objList) {
                if (!obj.getName().equals(new QName("ProcessorProperty"))) continue;
                return (ProcessorPropertyType)obj.getValue();
            }
        }
        return null;
    }

    public float getMemorySize(MemoryType memNode) {
        List<Serializable> memProps = memNode.getSizeOrType();
        if (memProps != null) {
            for (Serializable prop : memProps) {
                if (!(prop instanceof Float)) continue;
                return ((Float)prop).floatValue();
            }
        }
        return -1.0f;
    }

    public String getMemoryType(MemoryType memNode) {
        List<Serializable> memProps = memNode.getSizeOrType();
        if (memProps != null) {
            for (Serializable prop : memProps) {
                if (!(prop instanceof String)) continue;
                return (String)((Object)prop);
            }
        }
        return null;
    }

    public float getStorageSize(StorageType strNode) {
        List<Serializable> storageProps = strNode.getSizeOrTypeOrBandwidth();
        if (storageProps != null) {
            for (Serializable prop : storageProps) {
                if (!(prop instanceof Float)) continue;
                return ((Float)prop).floatValue();
            }
        }
        return -1.0f;
    }

    public String getStorageType(StorageType strNode) {
        List<Serializable> storageProps = strNode.getSizeOrTypeOrBandwidth();
        if (storageProps != null) {
            for (Serializable prop : storageProps) {
                if (!(prop instanceof String)) continue;
                return (String)((Object)prop);
            }
        }
        return null;
    }

    public int getStorageBW(StorageType strNode) {
        List<Serializable> storageProps = strNode.getSizeOrTypeOrBandwidth();
        if (storageProps != null) {
            for (Serializable prop : storageProps) {
                if (!(prop instanceof Integer)) continue;
                return (Integer)prop;
            }
        }
        return -1;
    }

    public String getOperatingSystemType(OSType os) {
        List<JAXBElement<?>> innerElements = os.getTypeOrDistributionOrVersion();
        if (innerElements != null) {
            for (JAXBElement<?> elem : innerElements) {
                if (!elem.getName().equals(new QName("Type"))) continue;
                OSTypeType osType = (OSTypeType)((Object)elem.getValue());
                return osType.value();
            }
        }
        return null;
    }

    public String getOperatingSystemDistribution(OSType os) {
        List<JAXBElement<?>> innerElements = os.getTypeOrDistributionOrVersion();
        if (innerElements != null) {
            for (JAXBElement<?> elem : innerElements) {
                if (!elem.getName().equals(new QName("Distribution"))) continue;
                return (String)elem.getValue();
            }
        }
        return null;
    }

    public String getOperatingSystemVersion(OSType os) {
        List<JAXBElement<?>> innerElements = os.getTypeOrDistributionOrVersion();
        if (innerElements != null) {
            for (JAXBElement<?> elem : innerElements) {
                if (!elem.getName().equals(new QName("Version"))) continue;
                return (String)elem.getValue();
            }
        }
        return null;
    }

    public HashMap<String, ComputeNodeType> getComputeNodes_hashMap() {
        HashMap<String, ComputeNodeType> res = new HashMap<String, ComputeNodeType>();
        List<Object> objList = this.project.getMasterNodeOrComputeNodeOrDataNode();
        if (objList != null) {
            for (Object obj : objList) {
                if (!(obj instanceof ComputeNodeType)) continue;
                String name = ((ComputeNodeType)obj).getName();
                res.put(name, (ComputeNodeType)obj);
            }
        }
        return res;
    }

    public HashMap<String, DataNodeType> getDataNodes_hashMap() {
        HashMap<String, DataNodeType> res = new HashMap<String, DataNodeType>();
        List<Object> objList = this.project.getMasterNodeOrComputeNodeOrDataNode();
        if (objList != null) {
            for (Object obj : objList) {
                if (!(obj instanceof DataNodeType)) continue;
                String name = ((DataNodeType)obj).getName();
                res.put(name, (DataNodeType)obj);
            }
        }
        return res;
    }

    public HashMap<String, ServiceType> getServices_hashMap() {
        HashMap<String, ServiceType> res = new HashMap<String, ServiceType>();
        List<Object> objList = this.project.getMasterNodeOrComputeNodeOrDataNode();
        if (objList != null) {
            for (Object obj : objList) {
                if (!(obj instanceof ServiceType)) continue;
                String serviceWSDL = ((ServiceType)obj).getWsdl();
                res.put(serviceWSDL, (ServiceType)obj);
            }
        }
        return res;
    }

    public HashMap<String, CloudProviderType> getCloudProviders_hashMap() {
        HashMap<String, CloudProviderType> res = new HashMap<String, CloudProviderType>();
        List<Object> objList = this.project.getMasterNodeOrComputeNodeOrDataNode();
        if (objList != null) {
            for (Object obj : objList) {
                CloudType cloud;
                List<JAXBElement<?>> cloudPropsList;
                if (!(obj instanceof CloudType) || (cloudPropsList = (cloud = (CloudType)obj).getCloudProviderOrInitialVMsOrMinimumVMs()) == null) continue;
                for (JAXBElement<?> jaxbelem : cloudPropsList) {
                    if (!jaxbelem.getName().equals(new QName("CloudProvider"))) continue;
                    String providerName = ((CloudProviderType)jaxbelem.getValue()).getName();
                    res.put(providerName, (CloudProviderType)jaxbelem.getValue());
                }
            }
        }
        return res;
    }

    public List<String> getComputeNodes_names() {
        ArrayList<String> list = new ArrayList<String>();
        List<Object> objList = this.project.getMasterNodeOrComputeNodeOrDataNode();
        if (objList != null) {
            for (Object obj : objList) {
                if (!(obj instanceof ComputeNodeType)) continue;
                list.add(((ComputeNodeType)obj).getName());
            }
        }
        return list;
    }

    public List<String> getDataNodes_names() {
        ArrayList<String> list = new ArrayList<String>();
        List<Object> objList = this.project.getMasterNodeOrComputeNodeOrDataNode();
        if (objList != null) {
            for (Object obj : objList) {
                if (!(obj instanceof DataNodeType)) continue;
                list.add(((DataNodeType)obj).getName());
            }
        }
        return list;
    }

    public List<String> getServices_wsdls() {
        ArrayList<String> list = new ArrayList<String>();
        List<Object> objList = this.project.getMasterNodeOrComputeNodeOrDataNode();
        if (objList != null) {
            for (Object obj : objList) {
                if (!(obj instanceof ServiceType)) continue;
                list.add(((ServiceType)obj).getWsdl());
            }
        }
        return list;
    }

    public List<String> getCloudProviders_names() {
        ArrayList<String> list = new ArrayList<String>();
        List<Object> objList = this.project.getMasterNodeOrComputeNodeOrDataNode();
        if (objList != null) {
            for (Object obj : objList) {
                CloudType cloud;
                List<JAXBElement<?>> cloudPropsList;
                if (!(obj instanceof CloudType) || (cloudPropsList = (cloud = (CloudType)obj).getCloudProviderOrInitialVMsOrMinimumVMs()) == null) continue;
                for (JAXBElement<?> jaxbelem : cloudPropsList) {
                    if (!jaxbelem.getName().equals(new QName("CloudProvider"))) continue;
                    String providerName = ((CloudProviderType)jaxbelem.getValue()).getName();
                    list.add(providerName);
                }
            }
        }
        return list;
    }

    public ComputeNodeType getComputeNode(String name) {
        List<Object> objList = this.project.getMasterNodeOrComputeNodeOrDataNode();
        if (objList != null) {
            for (Object obj : objList) {
                ComputeNodeType cn;
                if (!(obj instanceof ComputeNodeType) || !(cn = (ComputeNodeType)obj).getName().equals(name)) continue;
                return cn;
            }
        }
        return null;
    }

    public String getUser(ComputeNodeType cn) {
        List<JAXBElement<?>> elementList = cn.getInstallDirOrWorkingDirOrUser();
        if (elementList != null) {
            for (JAXBElement<?> element : elementList) {
                if (!element.getName().equals(new QName("User"))) continue;
                return (String)element.getValue();
            }
        }
        return null;
    }

    public String getUser(ImageType image) {
        List<JAXBElement<?>> objList = image.getInstallDirOrWorkingDirOrUser();
        if (objList != null) {
            for (JAXBElement<?> obj : objList) {
                if (!obj.getName().equals(new QName("User"))) continue;
                return (String)obj.getValue();
            }
        }
        return null;
    }

    public String getInstallDir(ComputeNodeType cn) {
        List<JAXBElement<?>> elementList = cn.getInstallDirOrWorkingDirOrUser();
        if (elementList != null) {
            for (JAXBElement<?> element : elementList) {
                if (!element.getName().equals(new QName("InstallDir"))) continue;
                return (String)element.getValue();
            }
        }
        return null;
    }

    public String getInstallDir(ImageType image) {
        List<JAXBElement<?>> objList = image.getInstallDirOrWorkingDirOrUser();
        if (objList != null) {
            for (JAXBElement<?> obj : objList) {
                if (!obj.getName().equals(new QName("InstallDir"))) continue;
                return (String)obj.getValue();
            }
        }
        return null;
    }

    public String getWorkingDir(ImageType image) {
        List<JAXBElement<?>> objList = image.getInstallDirOrWorkingDirOrUser();
        if (objList != null) {
            for (JAXBElement<?> obj : objList) {
                if (!obj.getName().equals(new QName("WorkingDir"))) continue;
                return (String)obj.getValue();
            }
        }
        return null;
    }

    public String getWorkingDir(ComputeNodeType cn) {
        List<JAXBElement<?>> elementList = cn.getInstallDirOrWorkingDirOrUser();
        if (elementList != null) {
            for (JAXBElement<?> element : elementList) {
                if (!element.getName().equals(new QName("WorkingDir"))) continue;
                return (String)element.getValue();
            }
        }
        return null;
    }

    public int getLimitOfTasks(ImageType image) {
        List<JAXBElement<?>> objList = image.getInstallDirOrWorkingDirOrUser();
        if (objList != null) {
            for (JAXBElement<?> obj : objList) {
                if (!obj.getName().equals(new QName("LimitOfTasks"))) continue;
                return (Integer)obj.getValue();
            }
        }
        return -1;
    }

    public int getLimitOfTasks(ComputeNodeType cn) {
        List<JAXBElement<?>> elementList = cn.getInstallDirOrWorkingDirOrUser();
        if (elementList != null) {
            for (JAXBElement<?> element : elementList) {
                if (!element.getName().equals(new QName("LimitOfTasks"))) continue;
                return (Integer)element.getValue();
            }
        }
        return -1;
    }

    public ApplicationType getApplication(ImageType image) {
        List<JAXBElement<?>> objList = image.getInstallDirOrWorkingDirOrUser();
        if (objList != null) {
            for (JAXBElement<?> obj : objList) {
                if (!obj.getName().equals(new QName("Application"))) continue;
                return (ApplicationType)obj.getValue();
            }
        }
        return null;
    }

    public ApplicationType getApplication(ComputeNodeType cn) {
        List<JAXBElement<?>> elementList = cn.getInstallDirOrWorkingDirOrUser();
        if (elementList != null) {
            for (JAXBElement<?> element : elementList) {
                if (!element.getName().equals(new QName("Application"))) continue;
                return (ApplicationType)element.getValue();
            }
        }
        return null;
    }

    public List<String> getAdaptorQueues(ComputeNodeType cn, String adaptorName) {
        List<JAXBElement<?>> elementList = cn.getInstallDirOrWorkingDirOrUser();
        if (elementList != null) {
            for (JAXBElement<?> element : elementList) {
                if (!element.getName().equals(new QName("Adaptors"))) continue;
                List<AdaptorType> adaptors = ((AdaptorsListType)element.getValue()).getAdaptor();
                if (adaptors != null) {
                    for (AdaptorType adaptor : adaptors) {
                        if (!adaptor.getName().equals(adaptorName)) continue;
                        return this.getAdaptorQueues(adaptor);
                    }
                    continue;
                }
                return null;
            }
        }
        return null;
    }

    public List<String> getAdaptorQueues(ImageType image, String adaptorName) {
        ArrayList<String> adaptorQueues = new ArrayList<String>();
        List<JAXBElement<?>> objList = image.getInstallDirOrWorkingDirOrUser();
        if (objList != null) {
            for (JAXBElement<?> obj : objList) {
                if (!obj.getName().equals(new QName("Adaptors"))) continue;
                AdaptorsListType adaptorsList = (AdaptorsListType)obj.getValue();
                if (adaptorsList != null) {
                    List<AdaptorType> adaptors = adaptorsList.getAdaptor();
                    if (adaptors != null) {
                        for (AdaptorType adaptor : adaptors) {
                            if (!adaptor.getName().equals(adaptorName)) continue;
                            return this.getAdaptorQueues(adaptor);
                        }
                        continue;
                    }
                    return adaptorQueues;
                }
                return adaptorQueues;
            }
        }
        return adaptorQueues;
    }

    public List<String> getAdaptorQueues(AdaptorType adaptor) {
        ArrayList<String> adaptorQueues = new ArrayList<String>();
        List<JAXBElement<?>> innerElements = adaptor.getSubmissionSystemOrPortsOrBrokerAdaptor();
        if (innerElements != null) {
            for (JAXBElement<?> adaptorElement : innerElements) {
                if (!adaptorElement.getName().equals(new QName("SubmissionSystem"))) continue;
                SubmissionSystemType subSys = (SubmissionSystemType)adaptorElement.getValue();
                List<Object> subSysTypes = subSys.getBatchOrInteractive();
                if (subSysTypes != null) {
                    for (Object subSysType : subSysTypes) {
                        if (!(subSysType instanceof BatchType)) continue;
                        List<String> queues = ((BatchType)subSysType).getQueue();
                        if (queues != null) {
                            return queues;
                        }
                        return adaptorQueues;
                    }
                    continue;
                }
                return adaptorQueues;
            }
        }
        return adaptorQueues;
    }

    public Map<String, Object> getAdaptorProperties(ComputeNodeType cn, String adaptorName) {
        List<JAXBElement<?>> elementList = cn.getInstallDirOrWorkingDirOrUser();
        if (elementList != null) {
            for (JAXBElement<?> element : elementList) {
                if (!element.getName().equals(new QName("Adaptors"))) continue;
                List<AdaptorType> adaptors = ((AdaptorsListType)element.getValue()).getAdaptor();
                if (adaptors != null) {
                    for (AdaptorType adaptor : adaptors) {
                        if (!adaptor.getName().equals(adaptorName)) continue;
                        return this.getAdaptorProperties(adaptor);
                    }
                    continue;
                }
                return null;
            }
        }
        return null;
    }

    public Map<String, Object> getAdaptorProperties(AdaptorType adaptor) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        List<JAXBElement<?>> innerElements = adaptor.getSubmissionSystemOrPortsOrBrokerAdaptor();
        if (innerElements != null) {
            for (JAXBElement<?> adaptorElement : innerElements) {
                if (!adaptorElement.getName().equals(new QName(PORTS)) && !adaptorElement.getName().equals(new QName(BROKER_ADAPTOR)) && !adaptorElement.getName().equals(new QName(PROPERTIES))) continue;
                properties.put(adaptorElement.getName().getLocalPart(), adaptorElement.getValue());
            }
        }
        return properties;
    }

    public Map<String, Object> getAdaptorProperties(ImageType image, String adaptorName) {
        List<JAXBElement<?>> objList = image.getInstallDirOrWorkingDirOrUser();
        if (objList != null) {
            for (JAXBElement<?> obj : objList) {
                if (!obj.getName().equals(new QName("Adaptors"))) continue;
                AdaptorsListType adaptorsList = (AdaptorsListType)obj.getValue();
                if (adaptorsList != null) {
                    List<AdaptorType> adaptors = adaptorsList.getAdaptor();
                    if (adaptors != null) {
                        for (AdaptorType adaptor : adaptors) {
                            if (!adaptor.getName().equals(adaptorName)) continue;
                            return this.getAdaptorProperties(adaptor);
                        }
                        continue;
                    }
                    return null;
                }
                return null;
            }
        }
        return null;
    }

    public DataNodeType getDataNode(String name) {
        List<Object> objList = this.project.getMasterNodeOrComputeNodeOrDataNode();
        if (objList != null) {
            for (Object obj : objList) {
                DataNodeType dn;
                if (!(obj instanceof DataNodeType) || !(dn = (DataNodeType)obj).getName().equals(name)) continue;
                return dn;
            }
        }
        return null;
    }

    public ServiceType getService(String wsdl) {
        List<Object> objList = this.project.getMasterNodeOrComputeNodeOrDataNode();
        if (objList != null) {
            for (Object obj : objList) {
                ServiceType s;
                if (!(obj instanceof ServiceType) || !(s = (ServiceType)obj).getWsdl().equals(wsdl)) continue;
                return s;
            }
        }
        return null;
    }

    public CloudProviderType getCloudProvider(String name) {
        List<Object> objList = this.project.getMasterNodeOrComputeNodeOrDataNode();
        if (objList != null) {
            for (Object obj : objList) {
                CloudType cloud;
                List<JAXBElement<?>> cloudPropsList;
                if (!(obj instanceof CloudType) || (cloudPropsList = (cloud = (CloudType)obj).getCloudProviderOrInitialVMsOrMinimumVMs()) == null) continue;
                for (JAXBElement<?> jaxbelem : cloudPropsList) {
                    CloudProviderType cp;
                    if (!jaxbelem.getName().equals(new QName("CloudProvider")) || !(cp = (CloudProviderType)jaxbelem.getValue()).getName().equals(name)) continue;
                    return cp;
                }
            }
        }
        return null;
    }

    public Integer getInitialVMs(CloudType c) {
        List<JAXBElement<?>> elements = c.getCloudProviderOrInitialVMsOrMinimumVMs();
        if (elements != null) {
            for (JAXBElement<?> elem : elements) {
                if (!elem.getName().equals(new QName("InitialVMs"))) continue;
                return (Integer)elem.getValue();
            }
        }
        return null;
    }

    public Integer getMinVMs(CloudType c) {
        List<JAXBElement<?>> elements = c.getCloudProviderOrInitialVMsOrMinimumVMs();
        if (elements != null) {
            for (JAXBElement<?> elem : elements) {
                if (!elem.getName().equals(new QName("MinimumVMs"))) continue;
                return (Integer)elem.getValue();
            }
        }
        return null;
    }

    public Integer getMaxVMs(CloudType c) {
        List<JAXBElement<?>> elements = c.getCloudProviderOrInitialVMsOrMinimumVMs();
        if (elements != null) {
            for (JAXBElement<?> elem : elements) {
                if (!elem.getName().equals(new QName("MaximumVMs"))) continue;
                return (Integer)elem.getValue();
            }
        }
        return null;
    }

    public List<PackageType> getPackages(ImageType image) {
        ArrayList<PackageType> packages = new ArrayList<PackageType>();
        List<JAXBElement<?>> objList = image.getInstallDirOrWorkingDirOrUser();
        if (objList != null) {
            for (JAXBElement<?> obj : objList) {
                if (!obj.getName().equals(new QName("Package"))) continue;
                packages.add((PackageType)obj.getValue());
            }
        }
        return packages;
    }

    public ComputeNodeType addComputeNode(ComputeNodeType cn) throws InvalidElementException {
        this.validator.validateComputeNode(cn);
        this.project.getMasterNodeOrComputeNodeOrDataNode().add(cn);
        return cn;
    }

    public ComputeNodeType addComputeNode(String name, String installDir, String workingDir, String user, ApplicationType app, int limitOfTasks, AdaptorsListType adaptors) throws InvalidElementException {
        ComputeNodeType cn = new ComputeNodeType();
        cn.setName(name);
        JAXBElement<String> installDirJaxb = new JAXBElement<String>(new QName("InstallDir"), String.class, installDir);
        cn.getInstallDirOrWorkingDirOrUser().add(installDirJaxb);
        JAXBElement<String> workingDirJaxb = new JAXBElement<String>(new QName("WorkingDir"), String.class, workingDir);
        cn.getInstallDirOrWorkingDirOrUser().add(workingDirJaxb);
        if (user != null) {
            JAXBElement<String> userJaxb = new JAXBElement<String>(new QName("User"), String.class, user);
            cn.getInstallDirOrWorkingDirOrUser().add(userJaxb);
        }
        if (app != null) {
            JAXBElement<ApplicationType> appsJaxb = new JAXBElement<ApplicationType>(new QName("Application"), ApplicationType.class, app);
            cn.getInstallDirOrWorkingDirOrUser().add(appsJaxb);
        }
        if (limitOfTasks >= 0) {
            JAXBElement<Integer> limitOfTasksJaxb = new JAXBElement<Integer>(new QName("LimitOfTasks"), Integer.class, limitOfTasks);
            cn.getInstallDirOrWorkingDirOrUser().add(limitOfTasksJaxb);
        }
        if (adaptors != null) {
            JAXBElement<AdaptorsListType> adaptorsJaxb = new JAXBElement<AdaptorsListType>(new QName("Adaptors"), AdaptorsListType.class, adaptors);
            cn.getInstallDirOrWorkingDirOrUser().add(adaptorsJaxb);
        }
        return this.addComputeNode(cn);
    }

    public ComputeNodeType addComputeNode(String name, String installDir, String workingDir, String user, int limitOfTasks) throws InvalidElementException {
        return this.addComputeNode(name, installDir, workingDir, user, null, limitOfTasks, (AdaptorsListType)null);
    }

    public ComputeNodeType addComputeNode(String name, String installDir, String workingDir, String user) throws InvalidElementException {
        return this.addComputeNode(name, installDir, workingDir, user, null, -1, (AdaptorsListType)null);
    }

    public ComputeNodeType addComputeNode(String name, String installDir, String workingDir, String user, ApplicationType app, int limitOfTasks, List<AdaptorType> adaptors) throws InvalidElementException {
        AdaptorsListType adaptorsList = new AdaptorsListType();
        if (adaptors != null) {
            for (AdaptorType a : adaptors) {
                adaptorsList.getAdaptor().add(a);
            }
        }
        return this.addComputeNode(name, installDir, workingDir, user, app, limitOfTasks, adaptorsList);
    }

    public ComputeNodeType addComputeNode(String name, String installDir, String workingDir, String user, String appDir, String libPath, String cp, String pypath, int limitOfTasks, List<AdaptorType> adaptors) throws InvalidElementException {
        AdaptorsListType adaptorsList = new AdaptorsListType();
        if (adaptors != null) {
            for (AdaptorType a : adaptors) {
                adaptorsList.getAdaptor().add(a);
            }
        }
        return this.addComputeNode(name, installDir, workingDir, user, appDir, libPath, cp, pypath, limitOfTasks, adaptorsList);
    }

    public ComputeNodeType addComputeNode(String name, String installDir, String workingDir, String user, String appDir, String libPath, String cp, String pypath, int limitOfTasks, AdaptorsListType adaptors) throws InvalidElementException {
        ApplicationType app = ProjectFile.createApplication(appDir, libPath, cp, pypath);
        return this.addComputeNode(name, installDir, workingDir, user, app, limitOfTasks, adaptors);
    }

    public DataNodeType addDataNode(DataNodeType dn) throws InvalidElementException {
        this.validator.validateDataNode(dn);
        this.project.getMasterNodeOrComputeNodeOrDataNode().add(dn);
        return dn;
    }

    public DataNodeType addDataNode(String name) throws InvalidElementException {
        DataNodeType dn = new DataNodeType();
        dn.setName(name);
        return this.addDataNode(dn);
    }

    public DataNodeType addDataNode(String name, AdaptorsListType adaptors) throws InvalidElementException {
        DataNodeType dn = new DataNodeType();
        dn.setName(name);
        dn.getAdaptors().add(adaptors);
        return this.addDataNode(dn);
    }

    public DataNodeType addDataNode(String name, List<AdaptorType> adaptors) throws InvalidElementException {
        AdaptorsListType adaptorsList = new AdaptorsListType();
        if (adaptors != null) {
            for (AdaptorType a : adaptors) {
                adaptorsList.getAdaptor().add(a);
            }
        }
        return this.addDataNode(name, adaptorsList);
    }

    public ServiceType addService(ServiceType s) throws InvalidElementException {
        this.validator.validateService(s);
        this.project.getMasterNodeOrComputeNodeOrDataNode().add(s);
        return s;
    }

    public ServiceType addService(String wsdl) throws InvalidElementException {
        ServiceType s = new ServiceType();
        s.setWsdl(wsdl);
        return this.addService(s);
    }

    public ServiceType addService(String wsdl, int limitOfTasks) throws InvalidElementException {
        ServiceType s = new ServiceType();
        s.setWsdl(wsdl);
        if (limitOfTasks >= 0) {
            s.setLimitOfTasks(limitOfTasks);
        }
        return this.addService(s);
    }

    public CloudType addCloud(CloudType c) throws InvalidElementException {
        this.validator.validateCloud(c);
        this.project.getMasterNodeOrComputeNodeOrDataNode().add(c);
        return c;
    }

    public CloudType addCloud(List<CloudProviderType> cps) throws InvalidElementException {
        CloudType c = new CloudType();
        if (cps != null) {
            for (CloudProviderType cp : cps) {
                JAXBElement<CloudProviderType> cpJaxb = new JAXBElement<CloudProviderType>(new QName("CloudProvider"), CloudProviderType.class, cp);
                c.getCloudProviderOrInitialVMsOrMinimumVMs().add(cpJaxb);
            }
        }
        return this.addCloud(c);
    }

    public CloudType addCloud(List<CloudProviderType> cps, int initialVMs, int minVMs, int maxVMs) throws InvalidElementException {
        CloudType c = new CloudType();
        if (cps != null) {
            for (CloudProviderType cp : cps) {
                JAXBElement<CloudProviderType> cpJaxb = new JAXBElement<CloudProviderType>(new QName("CloudProvider"), CloudProviderType.class, cp);
                c.getCloudProviderOrInitialVMsOrMinimumVMs().add(cpJaxb);
            }
        }
        if (initialVMs >= 0) {
            JAXBElement<Integer> initialVMsJaxb = new JAXBElement<Integer>(new QName("InitialVMs"), Integer.class, initialVMs);
            c.getCloudProviderOrInitialVMsOrMinimumVMs().add(initialVMsJaxb);
        }
        if (minVMs >= 0) {
            JAXBElement<Integer> minVMsJaxb = new JAXBElement<Integer>(new QName("MinimumVMs"), Integer.class, minVMs);
            c.getCloudProviderOrInitialVMsOrMinimumVMs().add(minVMsJaxb);
        }
        if (maxVMs >= 0) {
            JAXBElement<Integer> maxVMsJaxb = new JAXBElement<Integer>(new QName("MaximumVMs"), Integer.class, maxVMs);
            c.getCloudProviderOrInitialVMsOrMinimumVMs().add(maxVMsJaxb);
        }
        return this.addCloud(c);
    }

    public CloudProviderType addCloudProvider(CloudProviderType cp) throws InvalidElementException {
        this.validator.validateCloudProvider(cp);
        boolean cloudTagFound = false;
        for (Object obj : this.project.getMasterNodeOrComputeNodeOrDataNode()) {
            if (!(obj instanceof CloudType)) continue;
            cloudTagFound = true;
            CloudType c = (CloudType)obj;
            JAXBElement<CloudProviderType> cpJaxb = new JAXBElement<CloudProviderType>(new QName("CloudProvider"), CloudProviderType.class, cp);
            c.getCloudProviderOrInitialVMsOrMinimumVMs().add(cpJaxb);
        }
        if (!cloudTagFound) {
            CloudType c = new CloudType();
            this.project.getMasterNodeOrComputeNodeOrDataNode().add(c);
            JAXBElement<CloudProviderType> cpJaxb = new JAXBElement<CloudProviderType>(new QName("CloudProvider"), CloudProviderType.class, cp);
            c.getCloudProviderOrInitialVMsOrMinimumVMs().add(cpJaxb);
        }
        return cp;
    }

    public CloudProviderType addCloudProvider(String name, ImagesType images, InstanceTypesType instances) throws InvalidElementException {
        return this.addCloudProvider(name, images, instances, -1, null);
    }

    public CloudProviderType addCloudProvider(String name, List<ImageType> images, InstanceTypesType instances) throws InvalidElementException {
        ImagesType imagesList = new ImagesType();
        if (images != null) {
            for (ImageType im : images) {
                imagesList.getImage().add(im);
            }
        }
        return this.addCloudProvider(name, imagesList, instances, -1, null);
    }

    public CloudProviderType addCloudProvider(String name, ImagesType images, List<InstanceTypeType> instances) throws InvalidElementException {
        InstanceTypesType instancesList = new InstanceTypesType();
        if (instances != null) {
            for (InstanceTypeType ins : instances) {
                instancesList.getInstanceType().add(ins);
            }
        }
        return this.addCloudProvider(name, images, instancesList, -1, null);
    }

    public CloudProviderType addCloudProvider(String name, List<ImageType> images, List<InstanceTypeType> instances) throws InvalidElementException {
        ImagesType imagesList = new ImagesType();
        if (images != null) {
            for (ImageType im : images) {
                imagesList.getImage().add(im);
            }
        }
        InstanceTypesType instancesList = new InstanceTypesType();
        if (instances != null) {
            for (InstanceTypeType ins : instances) {
                instancesList.getInstanceType().add(ins);
            }
        }
        return this.addCloudProvider(name, imagesList, instancesList, -1, null);
    }

    public CloudProviderType addCloudProvider(String name, List<ImageType> images, InstanceTypesType instances, int limitOfVMs, CloudPropertiesType properties) throws InvalidElementException {
        ImagesType imagesList = new ImagesType();
        if (images != null) {
            for (ImageType im : images) {
                imagesList.getImage().add(im);
            }
        }
        return this.addCloudProvider(name, imagesList, instances, limitOfVMs, properties);
    }

    public CloudProviderType addCloudProvider(String name, ImagesType images, List<InstanceTypeType> instances, int limitOfVMs, CloudPropertiesType properties) throws InvalidElementException {
        InstanceTypesType instancesList = new InstanceTypesType();
        if (instances != null) {
            for (InstanceTypeType ins : instances) {
                instancesList.getInstanceType().add(ins);
            }
        }
        return this.addCloudProvider(name, images, instancesList, limitOfVMs, properties);
    }

    public CloudProviderType addCloudProvider(String name, List<ImageType> images, List<InstanceTypeType> instances, int limitOfVMs, CloudPropertiesType properties) throws InvalidElementException {
        ImagesType imagesList = new ImagesType();
        if (images != null) {
            for (ImageType im : images) {
                imagesList.getImage().add(im);
            }
        }
        InstanceTypesType instancesList = new InstanceTypesType();
        if (instances != null) {
            for (InstanceTypeType ins : instances) {
                instancesList.getInstanceType().add(ins);
            }
        }
        return this.addCloudProvider(name, imagesList, instancesList, limitOfVMs, properties);
    }

    public CloudProviderType addCloudProvider(String name, ImagesType images, InstanceTypesType instances, int limitOfVMs, CloudPropertiesType properties) throws InvalidElementException {
        CloudProviderType cp = new CloudProviderType();
        cp.setName(name);
        cp.getImagesOrInstanceTypesOrLimitOfVMs().add(images);
        cp.getImagesOrInstanceTypesOrLimitOfVMs().add(instances);
        if (limitOfVMs >= 0) {
            cp.getImagesOrInstanceTypesOrLimitOfVMs().add(limitOfVMs);
        }
        if (properties != null) {
            cp.getImagesOrInstanceTypesOrLimitOfVMs().add(properties);
        }
        return this.addCloudProvider(cp);
    }

    public boolean setCloudProperties(int initialVMs, int minVMs, int maxVMs) throws InvalidElementException {
        CloudType cloud = null;
        List<Object> objList = this.project.getMasterNodeOrComputeNodeOrDataNode();
        if (objList != null) {
            for (Object obj : objList) {
                if (!(obj instanceof CloudType)) continue;
                cloud = (CloudType)obj;
                break;
            }
        }
        if (cloud == null) {
            return false;
        }
        if (initialVMs >= 0) {
            JAXBElement<Integer> initialVMsJaxb = new JAXBElement<Integer>(new QName("InitialVMs"), Integer.class, initialVMs);
            cloud.getCloudProviderOrInitialVMsOrMinimumVMs().add(initialVMsJaxb);
        }
        if (minVMs >= 0) {
            JAXBElement<Integer> minVMsJaxb = new JAXBElement<Integer>(new QName("MinimumVMs"), Integer.class, minVMs);
            cloud.getCloudProviderOrInitialVMsOrMinimumVMs().add(minVMsJaxb);
        }
        if (maxVMs >= 0) {
            JAXBElement<Integer> maxVMsJaxb = new JAXBElement<Integer>(new QName("MaximumVMs"), Integer.class, maxVMs);
            cloud.getCloudProviderOrInitialVMsOrMinimumVMs().add(maxVMsJaxb);
        }
        return true;
    }

    public boolean addImageToCloudProvider(String cloudProviderName, ImageType image) {
        CloudProviderType cp = this.getCloudProvider(cloudProviderName);
        if (cp != null) {
            List<Object> objList = cp.getImagesOrInstanceTypesOrLimitOfVMs();
            if (objList != null) {
                for (Object obj : objList) {
                    if (!(obj instanceof ImagesType)) continue;
                    ImagesType images = (ImagesType)obj;
                    images.getImage().add(image);
                    return true;
                }
                ImagesType images = new ImagesType();
                images.getImage().add(image);
                objList.add(images);
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean addInstanceToCloudProvider(String cloudProviderName, InstanceTypeType instance) {
        CloudProviderType cp = this.getCloudProvider(cloudProviderName);
        if (cp != null) {
            List<Object> objList = cp.getImagesOrInstanceTypesOrLimitOfVMs();
            if (objList != null) {
                for (Object obj : objList) {
                    if (!(obj instanceof InstanceTypesType)) continue;
                    InstanceTypesType instances = (InstanceTypesType)obj;
                    instances.getInstanceType().add(instance);
                    return true;
                }
                InstanceTypesType instances = new InstanceTypesType();
                instances.getInstanceType().add(instance);
                objList.add(instances);
                return true;
            }
            return false;
        }
        return false;
    }

    public static ApplicationType createApplication(String appDir, String libPath, String cp, String pypath) {
        ApplicationType app = new ApplicationType();
        if (appDir != null && !appDir.isEmpty()) {
            app.setAppDir(appDir);
        }
        if (libPath != null && !libPath.isEmpty()) {
            app.setLibraryPath(libPath);
        }
        if (cp != null && !cp.isEmpty()) {
            app.setClasspath(cp);
        }
        if (pypath != null && !pypath.isEmpty()) {
            app.setPythonpath(pypath);
        }
        return app;
    }

    public static CloudPropertiesType createCloudProperties(Map<String, String> properties) {
        CloudPropertiesType cloudProperties = new CloudPropertiesType();
        List<CloudPropertyType> propertyList = cloudProperties.getProperty();
        for (Map.Entry<String, String> e : properties.entrySet()) {
            CloudPropertyType prop = new CloudPropertyType();
            prop.setName(e.getKey());
            prop.setValue(e.getValue());
            propertyList.add(prop);
        }
        return cloudProperties;
    }

    public static ImageType createImage(String name, String installDir, String workingDir, int limitOfTasks) {
        return ProjectFile.createImage(name, installDir, workingDir, null, null, null, null, null, limitOfTasks, null, null);
    }

    public static ImageType createImage(String name, String installDir, String workingDir, String user, String appDir, String libPath, String cp, String pypath, int limitOfTasks, PackageType pack, AdaptorsListType adaptors) {
        ImageType image = new ImageType();
        image.setName(name);
        JAXBElement<String> installDirJaxb = new JAXBElement<String>(new QName("InstallDir"), String.class, installDir);
        image.getInstallDirOrWorkingDirOrUser().add(installDirJaxb);
        JAXBElement<String> workingDirJaxb = new JAXBElement<String>(new QName("WorkingDir"), String.class, workingDir);
        image.getInstallDirOrWorkingDirOrUser().add(workingDirJaxb);
        if (user != null) {
            JAXBElement<String> userJaxb = new JAXBElement<String>(new QName("User"), String.class, user);
            image.getInstallDirOrWorkingDirOrUser().add(userJaxb);
        }
        ApplicationType app = ProjectFile.createApplication(appDir, libPath, cp, pypath);
        JAXBElement<ApplicationType> appsJaxb = new JAXBElement<ApplicationType>(new QName("Application"), ApplicationType.class, app);
        image.getInstallDirOrWorkingDirOrUser().add(appsJaxb);
        if (limitOfTasks >= 0) {
            JAXBElement<Integer> limitOfTasksJaxb = new JAXBElement<Integer>(new QName("LimitOfTasks"), Integer.class, limitOfTasks);
            image.getInstallDirOrWorkingDirOrUser().add(limitOfTasksJaxb);
        }
        if (pack != null) {
            JAXBElement<PackageType> packJaxb = new JAXBElement<PackageType>(new QName("Package"), PackageType.class, pack);
            image.getInstallDirOrWorkingDirOrUser().add(packJaxb);
        }
        if (adaptors != null) {
            JAXBElement<AdaptorsListType> adaptorsJaxb = new JAXBElement<AdaptorsListType>(new QName("Adaptors"), AdaptorsListType.class, adaptors);
            image.getInstallDirOrWorkingDirOrUser().add(adaptorsJaxb);
        }
        return image;
    }

    public static InstanceTypeType createInstance(String name) {
        InstanceTypeType instance = new InstanceTypeType();
        instance.setName(name);
        return instance;
    }

    public static AdaptorType createAdaptor(String name, SubmissionSystemType subsys, NIOAdaptorProperties nioproperties, String user) {
        AdaptorType adaptor = new AdaptorType();
        adaptor.setName(name);
        JAXBElement<SubmissionSystemType> subsysElement = new JAXBElement<SubmissionSystemType>(new QName("SubmissionSystem"), SubmissionSystemType.class, subsys);
        adaptor.getSubmissionSystemOrPortsOrBrokerAdaptor().add(subsysElement);
        JAXBElement<NIOAdaptorProperties> propertiesElement = new JAXBElement<NIOAdaptorProperties>(new QName(PORTS), NIOAdaptorProperties.class, nioproperties);
        adaptor.getSubmissionSystemOrPortsOrBrokerAdaptor().add(propertiesElement);
        if (user != null) {
            JAXBElement<String> userElement = new JAXBElement<String>(new QName("User"), String.class, user);
            adaptor.getSubmissionSystemOrPortsOrBrokerAdaptor().add(userElement);
        }
        return adaptor;
    }

    public static AdaptorType createAdaptor(String name, SubmissionSystemType subsys, String gatproperties, String user) {
        AdaptorType adaptor = new AdaptorType();
        adaptor.setName(name);
        JAXBElement<SubmissionSystemType> subsysElement = new JAXBElement<SubmissionSystemType>(new QName("SubmissionSystem"), SubmissionSystemType.class, subsys);
        adaptor.getSubmissionSystemOrPortsOrBrokerAdaptor().add(subsysElement);
        JAXBElement<String> propertiesElement = new JAXBElement<String>(new QName(BROKER_ADAPTOR), String.class, gatproperties);
        adaptor.getSubmissionSystemOrPortsOrBrokerAdaptor().add(propertiesElement);
        if (user != null) {
            JAXBElement<String> userElement = new JAXBElement<String>(new QName("User"), String.class, user);
            adaptor.getSubmissionSystemOrPortsOrBrokerAdaptor().add(userElement);
        }
        return adaptor;
    }

    public static AdaptorType createAdaptor(String name, SubmissionSystemType subsys, ExternalAdaptorProperties externalproperties, String user) {
        AdaptorType adaptor = new AdaptorType();
        adaptor.setName(name);
        JAXBElement<SubmissionSystemType> subsysElement = new JAXBElement<SubmissionSystemType>(new QName("SubmissionSystem"), SubmissionSystemType.class, subsys);
        adaptor.getSubmissionSystemOrPortsOrBrokerAdaptor().add(subsysElement);
        JAXBElement<ExternalAdaptorProperties> propertiesElement = new JAXBElement<ExternalAdaptorProperties>(new QName(PROPERTIES), ExternalAdaptorProperties.class, externalproperties);
        adaptor.getSubmissionSystemOrPortsOrBrokerAdaptor().add(propertiesElement);
        if (user != null) {
            JAXBElement<String> userElement = new JAXBElement<String>(new QName("User"), String.class, user);
            adaptor.getSubmissionSystemOrPortsOrBrokerAdaptor().add(userElement);
        }
        return adaptor;
    }

    public static AdaptorType createAdaptor(String name, SubmissionSystemType subsys, List<PropertyAdaptorType> externalProperties, String user) {
        AdaptorType adaptor = new AdaptorType();
        adaptor.setName(name);
        JAXBElement<SubmissionSystemType> subsysElement = new JAXBElement<SubmissionSystemType>(new QName("SubmissionSystem"), SubmissionSystemType.class, subsys);
        adaptor.getSubmissionSystemOrPortsOrBrokerAdaptor().add(subsysElement);
        ExternalAdaptorProperties externalpropertiesList = new ExternalAdaptorProperties();
        if (externalProperties != null) {
            for (PropertyAdaptorType pa : externalProperties) {
                externalpropertiesList.getProperty().add(pa);
            }
        }
        JAXBElement<ExternalAdaptorProperties> propertiesElement = new JAXBElement<ExternalAdaptorProperties>(new QName(PROPERTIES), ExternalAdaptorProperties.class, externalpropertiesList);
        adaptor.getSubmissionSystemOrPortsOrBrokerAdaptor().add(propertiesElement);
        if (user != null) {
            JAXBElement<String> userElement = new JAXBElement<String>(new QName("User"), String.class, user);
            adaptor.getSubmissionSystemOrPortsOrBrokerAdaptor().add(userElement);
        }
        return adaptor;
    }

    public static AdaptorType createAdaptor(String name, boolean batch, List<String> queues, boolean interactive, NIOAdaptorProperties nioproperties, String user) {
        SubmissionSystemType subsys = new SubmissionSystemType();
        if (batch) {
            BatchType b = new BatchType();
            if (queues != null) {
                for (String q : queues) {
                    b.getQueue().add(q);
                }
            }
            subsys.getBatchOrInteractive().add(b);
        }
        if (interactive) {
            InteractiveType i = new InteractiveType();
            subsys.getBatchOrInteractive().add(i);
        }
        return ProjectFile.createAdaptor(name, subsys, nioproperties, user);
    }

    public static AdaptorType createAdaptor(String name, boolean batch, List<String> queues, boolean interactive, String gatproperties, String user) {
        SubmissionSystemType subsys = new SubmissionSystemType();
        if (batch) {
            BatchType b = new BatchType();
            if (queues != null) {
                for (String q : queues) {
                    b.getQueue().add(q);
                }
            }
            subsys.getBatchOrInteractive().add(b);
        }
        if (interactive) {
            InteractiveType i = new InteractiveType();
            subsys.getBatchOrInteractive().add(i);
        }
        return ProjectFile.createAdaptor(name, subsys, gatproperties, user);
    }

    public static AdaptorType createAdaptor(String name, boolean batch, List<String> queues, boolean interactive, ExternalAdaptorProperties externalProperties, String user) {
        SubmissionSystemType subsys = new SubmissionSystemType();
        if (batch) {
            BatchType b = new BatchType();
            if (queues != null) {
                for (String q : queues) {
                    b.getQueue().add(q);
                }
            }
            subsys.getBatchOrInteractive().add(b);
        }
        if (interactive) {
            InteractiveType i = new InteractiveType();
            subsys.getBatchOrInteractive().add(i);
        }
        return ProjectFile.createAdaptor(name, subsys, externalProperties, user);
    }

    public static AdaptorType createAdaptor(String name, boolean batch, List<String> queues, boolean interactive, List<PropertyAdaptorType> externalProperties, String user) {
        SubmissionSystemType subsys = new SubmissionSystemType();
        if (batch) {
            BatchType b = new BatchType();
            if (queues != null) {
                for (String q : queues) {
                    b.getQueue().add(q);
                }
            }
            JAXBElement<BatchType> batchElement = new JAXBElement<BatchType>(new QName("Batch"), BatchType.class, b);
            subsys.getBatchOrInteractive().add(batchElement);
        }
        if (interactive) {
            InteractiveType i = new InteractiveType();
            JAXBElement<InteractiveType> interactiveElement = new JAXBElement<InteractiveType>(new QName("Interactive"), InteractiveType.class, i);
            subsys.getBatchOrInteractive().add(interactiveElement);
        }
        return ProjectFile.createAdaptor(name, subsys, externalProperties, user);
    }

    public boolean deleteMasterNode() {
        List<Object> objList = this.project.getMasterNodeOrComputeNodeOrDataNode();
        if (objList != null) {
            for (int i = 0; i < objList.size(); ++i) {
                Object obj = objList.get(i);
                if (!(obj instanceof MasterNodeType)) continue;
                objList.remove(i);
                return true;
            }
        }
        return false;
    }

    public boolean deleteComputeNode(String name) {
        List<Object> objList = this.project.getMasterNodeOrComputeNodeOrDataNode();
        if (objList != null) {
            for (int i = 0; i < objList.size(); ++i) {
                ComputeNodeType cn;
                Object obj = objList.get(i);
                if (!(obj instanceof ComputeNodeType) || !(cn = (ComputeNodeType)obj).getName().equals(name)) continue;
                objList.remove(i);
                return true;
            }
        }
        return false;
    }

    public boolean deleteDataNode(String name) {
        List<Object> objList = this.project.getMasterNodeOrComputeNodeOrDataNode();
        if (objList != null) {
            for (int i = 0; i < objList.size(); ++i) {
                DataNodeType dn;
                Object obj = objList.get(i);
                if (!(obj instanceof DataNodeType) || !(dn = (DataNodeType)obj).getName().equals(name)) continue;
                objList.remove(i);
                return true;
            }
        }
        return false;
    }

    public boolean deleteService(String wsdl) {
        List<Object> objList = this.project.getMasterNodeOrComputeNodeOrDataNode();
        if (objList != null) {
            for (int i = 0; i < objList.size(); ++i) {
                ServiceType s;
                Object obj = objList.get(i);
                if (!(obj instanceof ServiceType) || !(s = (ServiceType)obj).getWsdl().equals(wsdl)) continue;
                objList.remove(i);
                return true;
            }
        }
        return false;
    }

    public boolean deleteCloud() {
        List<Object> objList = this.project.getMasterNodeOrComputeNodeOrDataNode();
        if (objList != null) {
            for (int i = 0; i < objList.size(); ++i) {
                Object obj = objList.get(i);
                if (!(obj instanceof CloudType)) continue;
                objList.remove(i);
                return true;
            }
        }
        return false;
    }

    public boolean deleteCloudProvider(String name) {
        List<Object> objList = this.project.getMasterNodeOrComputeNodeOrDataNode();
        if (objList != null) {
            for (Object obj : objList) {
                CloudType cloud;
                List<JAXBElement<?>> cloudPropsList;
                if (!(obj instanceof CloudType) || (cloudPropsList = (cloud = (CloudType)obj).getCloudProviderOrInitialVMsOrMinimumVMs()) == null) continue;
                for (int i = 0; i < cloudPropsList.size(); ++i) {
                    CloudProviderType cp;
                    JAXBElement<?> jaxbelem = cloudPropsList.get(i);
                    if (!jaxbelem.getName().equals(new QName("CloudProvider")) || !(cp = (CloudProviderType)jaxbelem.getValue()).getName().equals(name)) continue;
                    cloudPropsList.remove(i);
                    return true;
                }
            }
        }
        return false;
    }
}

