/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jaxb.compiler.builder;

import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.eclipse.persistence.exceptions.JAXBException;
import org.eclipse.persistence.jaxb.compiler.Property;
import org.eclipse.persistence.jaxb.compiler.TypeInfo;
import org.eclipse.persistence.jaxb.compiler.XMLProcessor;
import org.eclipse.persistence.jaxb.compiler.builder.helper.TransformerReflectionHelper;
import org.eclipse.persistence.jaxb.javamodel.Helper;
import org.eclipse.persistence.jaxb.javamodel.JavaClass;
import org.eclipse.persistence.jaxb.xmlmodel.XmlTransformation;

public class TransformerPropertyBuilder {
    private final Property property;
    private final TypeInfo typeInfo;
    private final Helper helper;
    private final String attributeToken;

    public TransformerPropertyBuilder(Property property, TypeInfo typeInfo, Helper helper, String attributeToken) {
        this.property = property;
        this.typeInfo = typeInfo;
        this.helper = helper;
        this.attributeToken = attributeToken;
    }

    public List<Property> buildProperties() {
        ArrayList<Property> props = new ArrayList<Property>();
        for (XmlTransformation.XmlWriteTransformer writeTransformer : this.property.getXmlTransformation().getXmlWriteTransformer()) {
            props.add(this.buildPropertyFromTransformer(this.getPropertyName(this.property, writeTransformer), this.typeInfo, writeTransformer));
        }
        return props;
    }

    private String getPropertyName(Property property, XmlTransformation.XmlWriteTransformer writeTransformer) {
        String xpath2 = writeTransformer.getXmlPath();
        return XMLProcessor.getNameFromXPath(xpath2, property.getPropertyName(), xpath2.contains(this.attributeToken));
    }

    private Property buildPropertyFromTransformer(String pname, TypeInfo typeInfo, XmlTransformation.XmlWriteTransformer writeTransformer) {
        Property prop = new Property(this.helper);
        prop.setPropertyName(pname);
        prop.setXmlPath(writeTransformer.getXmlPath());
        prop.setSchemaName(new QName(pname));
        prop.setType(this.getReturnTypeFromTransformer(typeInfo, writeTransformer));
        return prop;
    }

    private JavaClass getReturnTypeFromTransformer(TypeInfo typeInfo, XmlTransformation.XmlWriteTransformer writeTransformer) {
        JavaClass jClass = this.getTransformerJavaClass(typeInfo, writeTransformer);
        if (writeTransformer.isSetTransformerClass()) {
            return this.getTransformerReflectionHelper().getReturnTypeForWriteTransformationMethodTransformer(jClass);
        }
        return this.getTransformerReflectionHelper().getReturnTypeForWriteTransformationMethod(writeTransformer.getMethod(), jClass);
    }

    private JavaClass getTransformerJavaClass(TypeInfo typeInfo, XmlTransformation.XmlWriteTransformer writeTransformer) {
        if (writeTransformer.isSetTransformerClass()) {
            try {
                return this.helper.getJavaClass(writeTransformer.getTransformerClass());
            }
            catch (JAXBException jAXBException) {
                throw JAXBException.transformerClassNotFound(writeTransformer.getTransformerClass());
            }
        }
        return this.helper.getJavaClass(typeInfo.getJavaClassName());
    }

    private TransformerReflectionHelper getTransformerReflectionHelper() {
        return new TransformerReflectionHelper(this.helper);
    }
}

