/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.agent.rest.master;

import es.bsc.compss.agent.rest.master.AgentConfiguration;
import es.bsc.compss.agent.rest.master.RemoteRESTAgentJob;
import es.bsc.compss.comm.Comm;
import es.bsc.compss.exceptions.InitNodeException;
import es.bsc.compss.exceptions.UnstartedNodeException;
import es.bsc.compss.types.COMPSsWorker;
import es.bsc.compss.types.TaskDescription;
import es.bsc.compss.types.annotations.parameter.DataType;
import es.bsc.compss.types.data.LogicalData;
import es.bsc.compss.types.data.Transferable;
import es.bsc.compss.types.data.listener.EventListener;
import es.bsc.compss.types.data.location.DataLocation;
import es.bsc.compss.types.data.location.ProtocolType;
import es.bsc.compss.types.data.operation.DataOperation;
import es.bsc.compss.types.data.operation.OperationEndState;
import es.bsc.compss.types.data.operation.copy.DeferredCopy;
import es.bsc.compss.types.data.operation.copy.StorageCopy;
import es.bsc.compss.types.implementations.Implementation;
import es.bsc.compss.types.job.Job;
import es.bsc.compss.types.job.JobListener;
import es.bsc.compss.types.resources.ExecutorShutdownListener;
import es.bsc.compss.types.resources.Resource;
import es.bsc.compss.types.resources.ResourceDescription;
import es.bsc.compss.types.resources.ShutdownListener;
import es.bsc.compss.types.uri.MultiURI;
import es.bsc.compss.types.uri.SimpleURI;
import java.util.List;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import org.glassfish.jersey.client.ClientConfig;
import storage.StorageException;
import storage.StorageItf;
import storage.StubItf;

public class RemoteRESTAgent
extends COMPSsWorker {
    private final String name;
    private final AgentConfiguration config;
    private final WebTarget target;

    public RemoteRESTAgent(AgentConfiguration config) {
        this.config = config;
        this.name = this.config.getHost();
        String host = config.getHost();
        String port = config.getProperty("Port");
        System.out.println("Adding resource:" + host + " through port " + port);
        if (!host.startsWith("http://")) {
            host = "http://" + host + ":" + port;
        }
        Client client = ClientBuilder.newClient(new ClientConfig());
        this.target = client.target(host);
    }

    public String getName() {
        return this.name;
    }

    public WebTarget getTarget() {
        return this.target;
    }

    public String getUser() {
        return "";
    }

    public String getClasspath() {
        return "";
    }

    public String getPythonpath() {
        return "";
    }

    public void announceCreation() {
    }

    public void announceDestruction() {
    }

    public void updateTaskCount(int i) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void start() throws InitNodeException {
    }

    public void setInternalURI(MultiURI muri) throws UnstartedNodeException {
    }

    public Job<?> newJob(int taskId, TaskDescription taskParams, Implementation impl, Resource res, List<String> slaveWorkersNodeNames, JobListener listener) {
        return new RemoteRESTAgentJob(this, taskId, taskParams, impl, res, listener);
    }

    public void sendData(LogicalData ld, DataLocation source, DataLocation target, LogicalData tgtData, Transferable reason, EventListener listener) {
        if (target.getHosts().contains(Comm.getAppHost())) {
            MultiURI u;
            System.out.println("[DATA] Trying to fetch data " + ld.getName());
            if (tgtData != null && (u = ld.alreadyAvailable((Resource)Comm.getAppHost())) != null) {
                System.out.println("[DATA]  Already available!");
                reason.setDataTarget(u.getPath());
                listener.notifyEnd(null);
                return;
            }
        } else {
            System.out.println("[DATA] Trying to order a copy for data " + ld.getName() + " across workers");
        }
    }

    public void obtainData(LogicalData ld, DataLocation source, DataLocation target, LogicalData tgtData, Transferable reason, EventListener listener) {
        if (ld == null) {
            return;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Obtain Data " + ld.getName() + " as " + target);
        }
        if (ld.getPscoId() != null) {
            this.orderStorageCopy(new StorageCopy(ld, source, target, tgtData, reason, listener));
        } else if (ld.isInMemory() && ld.getValue() instanceof StubItf) {
            StubItf stub = (StubItf)ld.getValue();
            stub.makePersistent(ld.getName());
            String pscoId = stub.getID();
            System.out.println("Object " + ld.getName() + " registered as " + pscoId);
            ld.setPscoId(pscoId);
            this.orderStorageCopy(new StorageCopy(ld, source, target, tgtData, reason, listener));
        } else {
            listener.notifyFailure((DataOperation)new DeferredCopy(ld, source, target, tgtData, reason, listener), new Exception("Regular objects are not supported yet"));
        }
    }

    public void enforceDataObtaining(Transferable reason, EventListener listener) {
        listener.notifyEnd(null);
    }

    public void stop(ShutdownListener sl) {
        sl.notifyEnd();
    }

    public SimpleURI getCompletePath(DataType type, String name) {
        String path = null;
        switch (type) {
            case FILE_T: {
                path = ProtocolType.FILE_URI.getSchema() + Comm.getAppHost().getTempDirPath() + name;
                break;
            }
            case OBJECT_T: {
                path = ProtocolType.OBJECT_URI.getSchema() + name;
                break;
            }
            case STREAM_T: {
                path = ProtocolType.STREAM_URI.getSchema() + name;
                break;
            }
            case EXTERNAL_STREAM_T: {
                path = ProtocolType.EXTERNAL_STREAM_URI.getSchema() + Comm.getAppHost().getTempDirPath() + name;
                break;
            }
            case PSCO_T: 
            case EXTERNAL_PSCO_T: {
                path = ProtocolType.PERSISTENT_URI.getSchema() + name;
                break;
            }
            default: {
                return null;
            }
        }
        return new SimpleURI(path);
    }

    public void deleteTemporary() {
    }

    public boolean generatePackage() {
        return false;
    }

    public void shutdownExecutionManager(ExecutorShutdownListener sl) {
        sl.notifyEnd();
    }

    public boolean generateWorkersDebugInfo() {
        return false;
    }

    protected void orderStorageCopy(StorageCopy sc) {
        LOGGER.info("Order PSCO Copy for " + sc.getSourceData().getName());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("LD Target " + sc.getTargetData());
            LOGGER.debug("FROM: " + sc.getPreferredSource());
            LOGGER.debug("TO: " + sc.getTargetLoc());
            LOGGER.debug("MUST PRESERVE: " + sc.mustPreserveSourceData());
        }
        LogicalData source = sc.getSourceData();
        LogicalData target = sc.getTargetData();
        if (target != null) {
            if (target.getName().equals(source.getName())) {
                this.newReplica(sc);
            } else {
                this.newVersion(sc);
            }
        } else {
            this.newVersion(sc);
        }
    }

    private void newReplica(StorageCopy sc) {
        List<String> currentLocations;
        String targetHostname = this.getName();
        LogicalData srcLD = sc.getSourceData();
        System.out.println("STAGE IN Requesting Storage to place a new replica of " + srcLD.getPscoId() + " on " + targetHostname + ")");
        LOGGER.debug("Ask for new Replica of " + srcLD.getName() + " to " + targetHostname);
        String pscoId = srcLD.getPscoId();
        try {
            currentLocations = StorageItf.getLocations(pscoId);
        }
        catch (StorageException se) {
            sc.end(OperationEndState.OP_FAILED, (Exception)se);
            return;
        }
        if (!currentLocations.contains(targetHostname)) {
            LOGGER.debug("Performing new replica for PSCO " + pscoId);
        } else {
            LOGGER.debug("PSCO " + pscoId + " already present. Skip replica.");
        }
        sc.setFinalTarget(pscoId);
        LogicalData targetLD = sc.getTargetData();
        if (targetLD != null) {
            targetLD.setPscoId(pscoId);
        }
        sc.end(OperationEndState.OP_OK);
    }

    private void newVersion(StorageCopy sc) {
        String targetHostname = this.getName();
        LogicalData srcLD = sc.getSourceData();
        LogicalData targetLD = sc.getTargetData();
        boolean preserveSource = sc.mustPreserveSourceData();
        String pscoId = srcLD.getPscoId();
        System.out.println("STAGE IN Requesting Storage to create a new Version of " + pscoId + "(" + srcLD.getName() + ")");
        if (DEBUG) {
            LOGGER.debug("Ask for new Version of " + srcLD.getName() + " with id " + pscoId + " to " + targetHostname + " with must preserve " + preserveSource);
        }
        LOGGER.debug("Performing new version for PSCO " + pscoId);
        try {
            String newId = StorageItf.newVersion(pscoId, preserveSource, Comm.getAppHost().getName());
            LOGGER.debug("Register new new version of " + pscoId + " as " + newId);
            sc.setFinalTarget(newId);
            if (targetLD != null) {
                targetLD.setPscoId(newId);
            }
        }
        catch (Exception e) {
            sc.end(OperationEndState.OP_FAILED, e);
            return;
        }
        sc.end(OperationEndState.OP_OK);
    }

    public void increaseComputingCapabilities(ResourceDescription description) {
    }

    public void reduceComputingCapabilities(ResourceDescription description) {
    }

    public void removeObsoletes(List<MultiURI> obsoletes) {
    }
}

