/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.platform.database;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Hashtable;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.expressions.ExpressionOperator;
import org.eclipse.persistence.internal.databaseaccess.FieldTypeDefinition;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.platform.database.SybasePlatform;
import org.eclipse.persistence.queries.ValueReadQuery;

public class SQLAnywherePlatform
extends SybasePlatform {
    @Override
    protected Hashtable buildFieldTypes() {
        Hashtable fieldTypeMapping = super.buildFieldTypes();
        fieldTypeMapping.put(Boolean.class, new FieldTypeDefinition("BIT", false));
        return fieldTypeMapping;
    }

    @Override
    public ValueReadQuery buildSelectQueryForIdentity() {
        ValueReadQuery selectQuery = new ValueReadQuery();
        StringWriter writer = new StringWriter();
        writer.write("SELECT @@IDENTITY");
        selectQuery.setSQLString(writer.toString());
        return selectQuery;
    }

    public static ExpressionOperator createCurrentDateOperator() {
        return ExpressionOperator.simpleFunctionNoParentheses(123, "CURRENT DATE");
    }

    public static ExpressionOperator createCurrentTimeOperator() {
        return ExpressionOperator.simpleFunctionNoParentheses(128, "CURRENT TIME");
    }

    public static ExpressionOperator createLocate2Operator() {
        return ExpressionOperator.simpleThreeArgumentFunction(113, "LOCATE");
    }

    public static ExpressionOperator createConcatOperator() {
        return ExpressionOperator.simpleLogicalNoParens(31, "||");
    }

    public static ExpressionOperator createLocateOperator() {
        return ExpressionOperator.simpleTwoArgumentFunction(112, "LOCATE");
    }

    @Override
    protected String getCreateTempTableSqlPrefix() {
        return "DECLARE LOCAL TEMPORARY TABLE ";
    }

    @Override
    public String getInputProcedureToken() {
        return "IN";
    }

    @Override
    public String getInOutputProcedureToken() {
        return "";
    }

    @Override
    public String getCreationOutputProcedureToken() {
        return "OUT";
    }

    @Override
    public String getOutputProcedureToken() {
        return "";
    }

    @Override
    public int getMaxFieldNameSize() {
        return 128;
    }

    @Override
    public String getProcedureArgumentString() {
        return "";
    }

    @Override
    public String getStoredProcedureParameterPrefix() {
        return "";
    }

    @Override
    public String getStoredProcedureTerminationToken() {
        return ";";
    }

    @Override
    public String getProcedureAsString() {
        return "";
    }

    @Override
    public String getProcedureBeginString() {
        return "BEGIN";
    }

    @Override
    public String getProcedureEndString() {
        return "END";
    }

    @Override
    public String getBatchBeginString() {
        return "BEGIN ";
    }

    @Override
    public String getBatchEndString() {
        return "END;";
    }

    @Override
    public String getBatchDelimiterString() {
        return "; ";
    }

    @Override
    public String getProcedureCallHeader() {
        return "CALL ";
    }

    @Override
    public DatabaseTable getTempTableForTable(DatabaseTable table) {
        return new DatabaseTable("$" + table.getName(), table.getTableQualifier(), table.shouldUseDelimiters(), this.getStartDelimiter(), this.getEndDelimiter());
    }

    @Override
    protected void initializePlatformOperators() {
        super.initializePlatformOperators();
        this.addOperator(SQLAnywherePlatform.createConcatOperator());
        this.addOperator(SQLAnywherePlatform.createLocateOperator());
        this.addOperator(SQLAnywherePlatform.createLocate2Operator());
        this.addOperator(ExpressionOperator.charLength());
        this.addOperator(ExpressionOperator.mod());
    }

    @Override
    public boolean isSQLAnywhere() {
        return true;
    }

    @Override
    public boolean isSybase() {
        return false;
    }

    @Override
    public boolean requiresProcedureBrackets() {
        return true;
    }

    @Override
    public boolean requiresProcedureCallBrackets() {
        return true;
    }

    @Override
    public boolean requiresTypeNameToRegisterOutputParameter() {
        return false;
    }

    @Override
    public void printFieldIdentityClause(Writer writer) throws ValidationException {
        try {
            writer.write(" DEFAULT AUTOINCREMENT");
        }
        catch (IOException ioException) {
            throw ValidationException.fileError(ioException);
        }
    }

    @Override
    public void printFieldNullClause(Writer writer) throws ValidationException {
        try {
            writer.write(" NULL");
        }
        catch (IOException ioException) {
            throw ValidationException.fileError(ioException);
        }
    }

    @Override
    public boolean shouldPrintInputTokenAtStart() {
        return true;
    }

    @Override
    public boolean shouldPrintInOutputTokenBeforeType() {
        return false;
    }

    @Override
    public boolean shouldPrintOutputTokenAtStart() {
        return true;
    }

    @Override
    public boolean shouldPrintOutputTokenBeforeType() {
        return false;
    }

    @Override
    public boolean shouldPrintStoredProcedureArgumentNameInCall() {
        return false;
    }

    @Override
    public boolean shouldPrintStoredProcedureVariablesAfterBeginString() {
        return true;
    }

    @Override
    public boolean supportsIdentity() {
        return true;
    }

    @Override
    public boolean supportsLocalTempTables() {
        return true;
    }

    @Override
    public boolean supportsStoredFunctions() {
        return true;
    }

    @Override
    public boolean supportsDeleteOnCascade() {
        return true;
    }
}

