/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.internal.inject;

import java.io.Closeable;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import jersey.repackaged.com.google.common.collect.Sets;
import org.glassfish.hk2.utilities.binding.AbstractBinder;
import org.glassfish.jersey.process.internal.RequestScoped;
import org.glassfish.jersey.server.CloseableService;
import org.glassfish.jersey.server.internal.LocalizationMessages;

public class CloseableServiceBinder
extends AbstractBinder {
    @Override
    protected void configure() {
        this.bind(DefaultCloseableService.class).to(CloseableService.class).in(RequestScoped.class);
    }

    private static class DefaultCloseableService
    implements CloseableService {
        private static final Logger LOGGER = Logger.getLogger(DefaultCloseableService.class.getName());
        private final AtomicBoolean closed = new AtomicBoolean(false);
        private final Set<Closeable> closeables = Sets.newIdentityHashSet();

        private DefaultCloseableService() {
        }

        @Override
        public void add(Closeable closeable) {
            if (!this.closed.get()) {
                this.closeables.add(closeable);
            }
        }

        @Override
        public void close() {
            if (this.closed.compareAndSet(false, true)) {
                for (Closeable closeable : this.closeables) {
                    try {
                        closeable.close();
                    }
                    catch (Exception ex) {
                        LOGGER.log(Level.SEVERE, LocalizationMessages.CLOSEABLE_UNABLE_TO_CLOSE(closeable.getClass().getName()), ex);
                    }
                }
            }
        }
    }
}

