/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.internal.inject;

import java.lang.annotation.Annotation;
import java.security.AccessController;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.inject.Inject;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Configurable;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriBuilder;
import jersey.repackaged.com.google.common.base.Function;
import jersey.repackaged.com.google.common.base.Predicate;
import jersey.repackaged.com.google.common.collect.Collections2;
import jersey.repackaged.com.google.common.collect.Maps;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.internal.Errors;
import org.glassfish.jersey.internal.inject.Injections;
import org.glassfish.jersey.internal.util.Producer;
import org.glassfish.jersey.internal.util.PropertiesHelper;
import org.glassfish.jersey.internal.util.ReflectionHelper;
import org.glassfish.jersey.internal.util.collection.LazyValue;
import org.glassfish.jersey.internal.util.collection.Value;
import org.glassfish.jersey.internal.util.collection.Values;
import org.glassfish.jersey.server.ClientBinding;
import org.glassfish.jersey.server.ExtendedUriInfo;
import org.glassfish.jersey.server.Uri;
import org.glassfish.jersey.server.internal.LocalizationMessages;
import org.glassfish.jersey.server.internal.inject.AbstractContainerRequestValueFactory;
import org.glassfish.jersey.server.internal.inject.AbstractValueFactoryProvider;
import org.glassfish.jersey.server.internal.inject.ParamInjectionResolver;
import org.glassfish.jersey.server.model.Parameter;
import org.glassfish.jersey.uri.internal.JerseyUriBuilder;

final class WebTargetValueFactoryProvider
extends AbstractValueFactoryProvider {
    private final Configuration serverConfig;
    private final ConcurrentMap<BindingModel, Value<ManagedClient>> managedClients;

    @Inject
    public WebTargetValueFactoryProvider(ServiceLocator locator, final @Context Configuration serverConfig) {
        super(null, locator, Parameter.Source.URI);
        this.serverConfig = serverConfig;
        this.managedClients = new ConcurrentHashMap<BindingModel, Value<ManagedClient>>();
        this.managedClients.put(BindingModel.EMPTY, Values.lazy(new Value<ManagedClient>(){

            @Override
            public ManagedClient get() {
                Client client;
                if (serverConfig == null) {
                    client = ClientBuilder.newClient();
                } else {
                    ClientConfig clientConfig = new ClientConfig();
                    WebTargetValueFactoryProvider.this.copyProviders(serverConfig, clientConfig);
                    client = ClientBuilder.newClient(clientConfig);
                }
                return new ManagedClient(client, "");
            }
        }));
    }

    private void copyProviders(Configuration source, Configurable<?> target) {
        for (Class<?> c : source.getClasses()) {
            target.register(c, source.getContracts(c));
        }
        for (Object o : source.getInstances()) {
            Class<?> c = o.getClass();
            target.register(c, source.getContracts(c));
        }
    }

    protected AbstractContainerRequestValueFactory<?> createValueFactory(final Parameter parameter) {
        return (AbstractContainerRequestValueFactory)Errors.processWithException(new Producer<AbstractContainerRequestValueFactory<?>>(){

            @Override
            public AbstractContainerRequestValueFactory<?> call() {
                String targetUriTemplate = parameter.getSourceName();
                if (targetUriTemplate == null || targetUriTemplate.length() == 0) {
                    Errors.warning(this, LocalizationMessages.INJECTED_WEBTARGET_URI_INVALID(targetUriTemplate));
                    return null;
                }
                Class<?> rawParameterType = parameter.getRawType();
                if (rawParameterType == WebTarget.class) {
                    final BindingModel binding = BindingModel.create(Arrays.asList(parameter.getAnnotations()));
                    Value<ManagedClient> client = (LazyValue<ManagedClient>)WebTargetValueFactoryProvider.this.managedClients.get(binding);
                    if (client == null) {
                        client = Values.lazy(new Value<ManagedClient>(){

                            @Override
                            public ManagedClient get() {
                                String prefix = binding.getAnnotation().annotationType().getName() + ".";
                                String baseUriProperty = prefix + "baseUri";
                                Object bu = WebTargetValueFactoryProvider.this.serverConfig.getProperty(baseUriProperty);
                                String customBaseUri = bu != null ? bu.toString() : binding.baseUri();
                                String configClassProperty = prefix + "configClass";
                                ClientConfig cfg = WebTargetValueFactoryProvider.this.resolveConfig(configClassProperty, binding);
                                String inheritProvidersProperty = prefix + "inheritServerProviders";
                                if (PropertiesHelper.isProperty(WebTargetValueFactoryProvider.this.serverConfig.getProperty(inheritProvidersProperty)) || binding.inheritProviders()) {
                                    WebTargetValueFactoryProvider.this.copyProviders(WebTargetValueFactoryProvider.this.serverConfig, cfg);
                                }
                                final String propertyPrefix = prefix + "property.";
                                Collection<String> clientProperties = Collections2.filter(WebTargetValueFactoryProvider.this.serverConfig.getPropertyNames(), new Predicate<String>(){

                                    @Override
                                    public boolean apply(String property) {
                                        return property.startsWith(propertyPrefix);
                                    }
                                });
                                for (String property : clientProperties) {
                                    cfg.property(property.substring(propertyPrefix.length()), WebTargetValueFactoryProvider.this.serverConfig.getProperty(property));
                                }
                                return new ManagedClient(ClientBuilder.newClient(cfg), customBaseUri);
                            }
                        });
                        Value previous = WebTargetValueFactoryProvider.this.managedClients.putIfAbsent(binding, client);
                        if (previous != null) {
                            client = previous;
                        }
                    }
                    return new WebTargetValueFactory(targetUriTemplate, client);
                }
                Errors.warning(this, LocalizationMessages.UNSUPPORTED_CLIENT_ARTEFACT_INJECTION_TYPE(rawParameterType));
                return null;
            }
        });
    }

    private ClientConfig resolveConfig(String configClassProperty, BindingModel binding) {
        Configuration cfg;
        Class<? extends Configuration> configClass = binding.getConfigClass();
        Object _cc = this.serverConfig.getProperty(configClassProperty);
        if (_cc != null) {
            Class cc = _cc instanceof String ? AccessController.doPrivileged(ReflectionHelper.classForNamePA((String)_cc)) : (_cc instanceof Class ? (Class)_cc : null);
            if (cc != null && Configuration.class.isAssignableFrom(cc)) {
                configClass = cc.asSubclass(Configuration.class);
            } else {
                Errors.warning(this, LocalizationMessages.ILLEGAL_CLIENT_CONFIG_CLASS_PROPERTY_VALUE(configClassProperty, _cc, configClass.getName()));
            }
        }
        return (cfg = Injections.getOrCreate(this.getLocator(), configClass)) instanceof ClientConfig ? (ClientConfig)cfg : new ClientConfig().loadFrom(cfg);
    }

    private static final class WebTargetValueFactory
    extends AbstractContainerRequestValueFactory<WebTarget> {
        private final String uri;
        private final Value<ManagedClient> client;

        WebTargetValueFactory(String uri, Value<ManagedClient> client) {
            this.uri = uri;
            this.client = client;
        }

        @Override
        public WebTarget provide() {
            ExtendedUriInfo uriInfo = this.getContainerRequest().getUriInfo();
            Map<String, Object> pathParamValues = Maps.transformValues(uriInfo.getPathParameters(), new Function<List<String>, Object>(){

                @Override
                public Object apply(List<String> input) {
                    return input.isEmpty() ? null : input.get(0);
                }
            });
            UriBuilder uriBuilder = new JerseyUriBuilder().uri(this.uri).resolveTemplates((Map)pathParamValues);
            ManagedClient managedClient = this.client.get();
            if (!((JerseyUriBuilder)uriBuilder).isAbsolute()) {
                String customBaseUri = managedClient.customBaseUri;
                String rootUri = customBaseUri.isEmpty() ? uriInfo.getBaseUri().toString() : customBaseUri;
                uriBuilder = new JerseyUriBuilder().uri(rootUri).path(((JerseyUriBuilder)uriBuilder).toTemplate());
            }
            return managedClient.instance.target(uriBuilder);
        }
    }

    static final class InjectionResolver
    extends ParamInjectionResolver<Uri> {
        public InjectionResolver() {
            super(WebTargetValueFactoryProvider.class);
        }
    }

    private static class BindingModel {
        public static final BindingModel EMPTY = new BindingModel(null);
        private final Annotation annotation;
        private final Class<? extends Configuration> configClass;
        private final boolean inheritProviders;
        private final String baseUri;

        public static BindingModel create(Annotation binding) {
            if (binding == null || binding.annotationType().getAnnotation(ClientBinding.class) == null) {
                return EMPTY;
            }
            return new BindingModel(binding);
        }

        public static BindingModel create(Collection<Annotation> bindingCandidates) {
            Collection<Annotation> filtered = Collections2.filter(bindingCandidates, new Predicate<Annotation>(){

                @Override
                public boolean apply(Annotation input) {
                    return input != null && input.annotationType().getAnnotation(ClientBinding.class) != null;
                }
            });
            if (filtered.isEmpty()) {
                return EMPTY;
            }
            if (filtered.size() > 1) {
                throw new ProcessingException("Too many client binding annotations.");
            }
            return new BindingModel(filtered.iterator().next());
        }

        private BindingModel(Annotation annotation2) {
            if (annotation2 == null) {
                this.annotation = null;
                this.configClass = ClientConfig.class;
                this.inheritProviders = true;
                this.baseUri = "";
            } else {
                this.annotation = annotation2;
                ClientBinding cba = annotation2.annotationType().getAnnotation(ClientBinding.class);
                this.configClass = cba.configClass();
                this.inheritProviders = cba.inheritServerProviders();
                this.baseUri = cba.baseUri();
            }
        }

        public Annotation getAnnotation() {
            return this.annotation;
        }

        public Class<? extends Configuration> getConfigClass() {
            return this.configClass;
        }

        public boolean inheritProviders() {
            return this.inheritProviders;
        }

        public String baseUri() {
            return this.baseUri;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BindingModel that = (BindingModel)o;
            return this.annotation != null ? this.annotation.equals(that.annotation) : that.annotation == null;
        }

        public int hashCode() {
            return this.annotation != null ? this.annotation.hashCode() : 0;
        }

        public String toString() {
            return "BindingModel{binding=" + this.annotation + ", configClass=" + this.configClass + ", inheritProviders=" + this.inheritProviders + ", baseUri=" + this.baseUri + '}';
        }
    }

    private static class ManagedClient {
        private final Client instance;
        private final String customBaseUri;

        private ManagedClient(Client instance, String customBaseUri) {
            this.instance = instance;
            this.customBaseUri = customBaseUri;
        }
    }
}

