/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.agent.rest.types;

import java.lang.reflect.Array;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import storage.StorageException;
import storage.StorageItf;

public abstract class ApplicationParameterValue {
    private int paramId;

    public static final ApplicationParameterValue createParameterValue(Object obj) {
        if (obj.getClass().isArray()) {
            return new ArrayParameter(obj);
        }
        return new ElementParameter(obj);
    }

    @XmlAttribute
    public int getParamId() {
        return this.paramId;
    }

    public void setParamId(int paramId) {
        this.paramId = paramId;
    }

    public abstract Object getValue() throws ClassNotFoundException;

    public abstract Object getContent() throws Exception;

    public abstract String getType();

    @XmlRootElement(name="ElementParameter")
    public static class ElementParameter
    extends ApplicationParameterValue {
        private Object value;
        private String className;

        public ElementParameter() {
        }

        private ElementParameter(Object o) {
            this.value = o;
            this.className = o.getClass().getCanonicalName();
        }

        public void setClassName(String className) {
            this.className = className;
        }

        public String getClassName() {
            return this.className;
        }

        public void setValue(Object value) {
            this.value = value;
        }

        @Override
        public Object getValue() {
            return this.value;
        }

        @Override
        public Object getContent() throws StorageException {
            Object val = this.className.compareTo(this.value.getClass().getCanonicalName()) == 0 ? this.value : StorageItf.getByID((String)this.value);
            return val;
        }

        @Override
        public String getType() {
            return this.className;
        }
    }

    @XmlRootElement(name="ArrayParameter")
    public static class ArrayParameter
    extends ApplicationParameterValue {
        private String componentClassname;
        private ApplicationParameterValue[] elements;

        public ArrayParameter() {
        }

        @XmlElementWrapper(name="values")
        @XmlElements(value={@XmlElement(name="array", type=ArrayParameter.class, required=false), @XmlElement(name="element", type=ElementParameter.class, required=false)})
        public ApplicationParameterValue[] getElements() {
            return this.elements;
        }

        public void setElements(ApplicationParameterValue[] elements) {
            this.elements = elements;
        }

        public String getComponentClassname() {
            return this.componentClassname;
        }

        public void setComponentClassname(String componentClass) {
            this.componentClassname = componentClass;
        }

        private ArrayParameter(Object o) {
            Class<?> componentClass = o.getClass().getComponentType();
            this.componentClassname = componentClass.getCanonicalName();
            int numElements = Array.getLength(o);
            this.elements = new ApplicationParameterValue[numElements];
            for (int elementId = 0; elementId < numElements; ++elementId) {
                this.elements[elementId] = ApplicationParameterValue.createParameterValue(Array.get(o, elementId));
                this.elements[elementId].paramId = elementId;
            }
        }

        @Override
        public Object getValue() throws ClassNotFoundException {
            Class<?> componentClass = Class.forName(this.componentClassname);
            int numElements = this.elements.length;
            Object array = Array.newInstance(componentClass, numElements);
            for (ApplicationParameterValue element : this.elements) {
                int position = element.getParamId();
                Object value = element.getValue();
                Array.set(array, position, value);
            }
            return array;
        }

        @Override
        public Object getContent() throws ClassNotFoundException {
            return this.getValue();
        }

        @Override
        public String getType() {
            if (this.elements.length > 0) {
                return this.elements[0].getType() + "[";
            }
            return this.componentClassname + "[";
        }
    }
}

