/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.descriptors;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.internal.descriptors.InstanceVariableAttributeAccessor;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedGetClassLoaderForClass;
import org.eclipse.persistence.internal.security.PrivilegedGetClassLoaderFromCurrentThread;
import org.eclipse.persistence.internal.weaving.WeaverLogger;

public class PersistenceObjectAttributeAccessor
extends InstanceVariableAttributeAccessor {
    private final boolean shouldLogFinest;

    public PersistenceObjectAttributeAccessor(String attributeName) {
        this.attributeName = attributeName.intern();
        this.shouldLogFinest = WeaverLogger.shouldLog(1);
    }

    @Override
    public Object getAttributeValueFromObject(Object object) {
        if (this.shouldLogFinest) {
            ClassLoader objectClassLoader;
            ClassLoader contextClassLoader;
            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                try {
                    contextClassLoader = AccessController.doPrivileged(new PrivilegedGetClassLoaderFromCurrentThread());
                    objectClassLoader = AccessController.doPrivileged(new PrivilegedGetClassLoaderForClass(object.getClass()));
                }
                catch (PrivilegedActionException ex) {
                    throw (RuntimeException)ex.getCause();
                }
            } else {
                contextClassLoader = Thread.currentThread().getContextClassLoader();
                objectClassLoader = object.getClass().getClassLoader();
            }
            WeaverLogger.log(1, "weaving_call_persistence_get", object.getClass().getName(), Integer.toHexString(System.identityHashCode(contextClassLoader)), Integer.toHexString(System.identityHashCode(objectClassLoader)));
        }
        return ((PersistenceObject)object)._persistence_get(this.attributeName);
    }

    @Override
    public void initializeAttributes(Class descriptorClass) throws DescriptorException {
        this.attributeName = this.attributeName.intern();
        super.initializeAttributes(descriptorClass);
    }

    @Override
    public void setAttributeValueInObject(Object object, Object value) {
        if (this.shouldLogFinest) {
            ClassLoader objectClassLoader;
            ClassLoader contextClassLoader;
            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                try {
                    contextClassLoader = AccessController.doPrivileged(new PrivilegedGetClassLoaderFromCurrentThread());
                    objectClassLoader = AccessController.doPrivileged(new PrivilegedGetClassLoaderForClass(object.getClass()));
                }
                catch (PrivilegedActionException ex) {
                    throw (RuntimeException)ex.getCause();
                }
            } else {
                contextClassLoader = Thread.currentThread().getContextClassLoader();
                objectClassLoader = object.getClass().getClassLoader();
            }
            WeaverLogger.log(1, "weaving_call_persistence_set", object.getClass().getName(), Integer.toHexString(System.identityHashCode(contextClassLoader)), Integer.toHexString(System.identityHashCode(objectClassLoader)));
        }
        ((PersistenceObject)object)._persistence_set(this.attributeName, value);
    }
}

