/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.helper;

import java.security.AccessController;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.persistence.internal.helper.JavaSEPlatform;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedGetSystemProperty;

public final class JavaVersion {
    public static final char SEPARATOR = '.';
    public static final char PATCH_SEPARATOR = '_';
    private static final String VM_VERSION_PROPERTY = "java.specification.version";
    private static final String VM_VERSION_PATTERN = "[^0-9]*([0-9]+)(\\.([0-9]+))*";
    private static final int VM_MIN_VERSION_TOKENS = 1;
    private final int major;
    private final int minor;

    public static String vmVersionString() {
        if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
            return AccessController.doPrivileged(new PrivilegedGetSystemProperty(VM_VERSION_PROPERTY));
        }
        return System.getProperty(VM_VERSION_PROPERTY);
    }

    public static JavaVersion vmVersion() {
        String version = JavaVersion.vmVersionString();
        Pattern pattern = Pattern.compile(VM_VERSION_PATTERN);
        Matcher matcher = pattern.matcher(version);
        int major = 0;
        int minor = 0;
        if (matcher.find()) {
            major = Integer.parseInt(matcher.group(1));
            String min = matcher.group(3);
            minor = min != null ? Integer.parseInt(min) : 0;
        }
        return new JavaVersion(major, minor);
    }

    public JavaVersion(int major, int minor) {
        this.major = major;
        this.minor = minor;
    }

    public final int getMajor() {
        return this.major;
    }

    public final int getMinor() {
        return this.minor;
    }

    public final int comapreTo(JavaVersion version) {
        return this.major > version.major ? 1 : (this.major < version.major ? -1 : (this.minor > version.minor ? 1 : (this.minor < version.minor ? -1 : 0)));
    }

    public final String toString() {
        StringBuilder sb = new StringBuilder(3);
        sb.append(this.major);
        sb.append('.');
        sb.append(this.minor);
        return sb.toString();
    }

    public final JavaSEPlatform toPlatform() {
        return JavaSEPlatform.toValue(this.major, this.minor);
    }
}

