/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm;

import javax.activation.DataHandler;
import javax.xml.namespace.QName;
import org.eclipse.persistence.core.sessions.CoreSession;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.core.helper.CoreClassConstants;
import org.eclipse.persistence.internal.core.sessions.CoreAbstractSession;
import org.eclipse.persistence.internal.oxm.ConversionManager;
import org.eclipse.persistence.internal.oxm.Marshaller;
import org.eclipse.persistence.internal.oxm.NamespaceResolver;
import org.eclipse.persistence.internal.oxm.NodeValue;
import org.eclipse.persistence.internal.oxm.NullCapableValue;
import org.eclipse.persistence.internal.oxm.Root;
import org.eclipse.persistence.internal.oxm.Unmarshaller;
import org.eclipse.persistence.internal.oxm.XMLBinaryDataHelper;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.XPathNode;
import org.eclipse.persistence.internal.oxm.mappings.BinaryDataMapping;
import org.eclipse.persistence.internal.oxm.mappings.Field;
import org.eclipse.persistence.internal.oxm.record.BinaryDataUnmarshalRecord;
import org.eclipse.persistence.internal.oxm.record.MarshalContext;
import org.eclipse.persistence.internal.oxm.record.MarshalRecord;
import org.eclipse.persistence.internal.oxm.record.ObjectMarshalContext;
import org.eclipse.persistence.internal.oxm.record.UnmarshalRecord;
import org.eclipse.persistence.internal.oxm.record.XMLReader;
import org.eclipse.persistence.internal.oxm.record.deferred.BinaryMappingContentHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class XMLBinaryDataMappingNodeValue
extends NodeValue
implements NullCapableValue {
    private BinaryDataMapping xmlBinaryDataMapping;

    protected String getValueToWrite(QName schemaType, Object value, CoreAbstractSession session) {
        return (String)((ConversionManager)session.getDatasourcePlatform().getConversionManager()).convertObject(value, CoreClassConstants.STRING, schemaType);
    }

    @Override
    public boolean isOwningNode(XPathFragment xPathFragment) {
        return xPathFragment.getNextFragment() == null || xPathFragment.isAttribute();
    }

    public XMLBinaryDataMappingNodeValue(BinaryDataMapping mapping) {
        this.xmlBinaryDataMapping = mapping;
    }

    @Override
    public boolean marshal(XPathFragment xPathFragment, MarshalRecord marshalRecord, Object object, CoreAbstractSession session, NamespaceResolver namespaceResolver) {
        return this.marshal(xPathFragment, marshalRecord, object, session, namespaceResolver, ObjectMarshalContext.getInstance(), null);
    }

    @Override
    public boolean marshal(XPathFragment xPathFragment, MarshalRecord marshalRecord, Object object, CoreAbstractSession session, NamespaceResolver namespaceResolver, MarshalContext marshalContext, XPathFragment rootFragment) {
        if (this.xmlBinaryDataMapping.isReadOnly()) {
            return false;
        }
        Object objectValue = marshalContext.getAttributeValue(object, this.xmlBinaryDataMapping);
        return this.marshalSingleValue(xPathFragment, marshalRecord, object, objectValue, session, namespaceResolver, marshalContext, rootFragment);
    }

    @Override
    public boolean marshalSingleValue(XPathFragment xPathFragment, MarshalRecord marshalRecord, Object object, Object objectValue, CoreAbstractSession session, NamespaceResolver namespaceResolver, MarshalContext marshalContext) {
        return this.marshalSingleValue(xPathFragment, marshalRecord, object, objectValue, session, namespaceResolver, marshalContext, null);
    }

    @Override
    public boolean marshalSingleValue(XPathFragment xPathFragment, MarshalRecord marshalRecord, Object object, Object objectValue, CoreAbstractSession session, NamespaceResolver namespaceResolver, MarshalContext marshalContext, XPathFragment rootFragment) {
        String mimeType;
        XPathFragment xmlRootFrag = null;
        if (objectValue instanceof Root) {
            Root xmlRoot = (Root)objectValue;
            xmlRootFrag = new XPathFragment();
            if (xmlRoot.getNamespaceURI() != null && !xmlRoot.getNamespaceURI().equals(namespaceResolver.getDefaultNamespaceURI())) {
                String prefix = namespaceResolver.resolveNamespaceURI(xmlRoot.getNamespaceURI());
                xmlRootFrag.setXPath(String.valueOf(prefix) + ':' + xmlRoot.getLocalName());
                xmlRootFrag.setNamespaceURI(xmlRoot.getNamespaceURI());
            } else {
                xmlRootFrag.setXPath(xmlRoot.getLocalName());
                if (xmlRoot.getNamespaceURI() != null && xmlRoot.getNamespaceURI().length() > 0) {
                    xmlRootFrag.setNamespaceURI(xmlRoot.getNamespaceURI());
                }
            }
        }
        Object marshaller = marshalRecord.getMarshaller();
        objectValue = this.xmlBinaryDataMapping.convertObjectValueToDataValue(objectValue, session, marshaller);
        XPathFragment groupingFragment = marshalRecord.openStartGroupingElements(namespaceResolver);
        if (xPathFragment.isAttribute()) {
            if (objectValue == null) {
                marshalRecord.closeStartGroupingElements(groupingFragment);
                return true;
            }
        } else {
            marshalRecord.closeStartGroupingElements(groupingFragment);
            XPathFragment elementFragment = xPathFragment;
            if (xmlRootFrag != null) {
                elementFragment = xmlRootFrag;
            }
            if (objectValue == null) {
                XPathNode holderXPathNode = new XPathNode();
                holderXPathNode.setXPathFragment(elementFragment);
                marshalRecord.addGroupingElement(holderXPathNode);
                boolean returnVal = this.xmlBinaryDataMapping.getNullPolicy().directMarshal(xPathFragment, marshalRecord, object, session, namespaceResolver);
                if (returnVal) {
                    marshalRecord.endElement(elementFragment, namespaceResolver);
                }
                marshalRecord.removeGroupingElement(holderXPathNode);
                return returnVal;
            }
            if (!xPathFragment.isSelfFragment) {
                marshalRecord.openStartElement(elementFragment, namespaceResolver);
                marshalRecord.closeStartElement();
            }
        }
        String c_id = null;
        byte[] bytes = null;
        String attachmentType = mimeType = this.xmlBinaryDataMapping.getMimeType(object);
        if (mimeType == null) {
            mimeType = "";
            attachmentType = "application/octet-stream";
        }
        if (this.xmlBinaryDataMapping.isSwaRef() && ((Marshaller)marshaller).getAttachmentMarshaller() != null) {
            if (this.xmlBinaryDataMapping.getAttributeClassification() == XMLBinaryDataHelper.getXMLBinaryDataHelper().DATA_HANDLER) {
                c_id = ((Marshaller)marshaller).getAttachmentMarshaller().addSwaRefAttachment((DataHandler)objectValue);
            } else {
                XMLBinaryDataHelper.EncodedData data = XMLBinaryDataHelper.getXMLBinaryDataHelper().getBytesForBinaryValue(objectValue, (Marshaller)marshaller, this.xmlBinaryDataMapping.getMimeType(object));
                bytes = data.getData();
                c_id = ((Marshaller)marshaller).getAttachmentMarshaller().addSwaRefAttachment(bytes, 0, bytes.length);
            }
        } else if (marshalRecord.isXOPPackage() && !this.xmlBinaryDataMapping.shouldInlineBinaryData()) {
            XPathFragment lastFrag = ((Field)this.xmlBinaryDataMapping.getField()).getLastXPathFragment();
            if (xmlRootFrag != null) {
                lastFrag = xmlRootFrag;
            }
            String localName = null;
            String namespaceUri = null;
            if (rootFragment != null) {
                localName = rootFragment.getLocalName();
                namespaceUri = rootFragment.getNamespaceURI();
            }
            if (!lastFrag.isSelfFragment) {
                localName = lastFrag.getLocalName();
                namespaceUri = lastFrag.getNamespaceURI();
            }
            if (objectValue.getClass() == CoreClassConstants.APBYTE) {
                bytes = (byte[])objectValue;
                c_id = ((Marshaller)marshaller).getAttachmentMarshaller().addMtomAttachment(bytes, 0, bytes.length, attachmentType, localName, namespaceUri);
            } else if (this.xmlBinaryDataMapping.getAttributeClassification() == XMLBinaryDataHelper.getXMLBinaryDataHelper().DATA_HANDLER) {
                c_id = ((Marshaller)marshaller).getAttachmentMarshaller().addMtomAttachment((DataHandler)objectValue, localName, namespaceUri);
            } else {
                XMLBinaryDataHelper.EncodedData data = XMLBinaryDataHelper.getXMLBinaryDataHelper().getBytesForBinaryValue(objectValue, (Marshaller)marshaller, this.xmlBinaryDataMapping.getMimeType(object));
                bytes = data.getData();
                c_id = ((Marshaller)marshaller).getAttachmentMarshaller().addMtomAttachment(bytes, 0, bytes.length, data.getMimeType(), localName, namespaceUri);
            }
        }
        if (xPathFragment.isAttribute()) {
            if (c_id != null) {
                marshalRecord.attribute(xPathFragment, namespaceResolver, c_id);
            } else {
                String value = this.getValueToWrite(((Field)this.xmlBinaryDataMapping.getField()).getSchemaType(), objectValue, session);
                marshalRecord.attribute(xPathFragment, namespaceResolver, value);
            }
            marshalRecord.closeStartGroupingElements(groupingFragment);
            return true;
        }
        if (this.xmlBinaryDataMapping.isSwaRef() && ((Marshaller)marshaller).getAttachmentMarshaller() != null) {
            if (c_id != null) {
                marshalRecord.characters(c_id);
            } else {
                marshalRecord.characters(((Field)this.xmlBinaryDataMapping.getField()).getSchemaType(), objectValue, mimeType, false);
            }
        } else if (marshalRecord.isXOPPackage() && !this.xmlBinaryDataMapping.shouldInlineBinaryData()) {
            if (c_id == null) {
                marshalRecord.characters(((Field)this.xmlBinaryDataMapping.getField()).getSchemaType(), objectValue, mimeType, false);
            } else {
                String xopPrefix = null;
                if (namespaceResolver != null) {
                    xopPrefix = namespaceResolver.resolveNamespaceURI("http://www.w3.org/2004/08/xop/include");
                }
                boolean addDeclaration = false;
                if (xopPrefix == null || namespaceResolver == null) {
                    addDeclaration = true;
                    xopPrefix = "xop";
                }
                XPathFragment xopInclude = new XPathFragment();
                xopInclude.setLocalName("Include");
                xopInclude.setPrefix(xopPrefix);
                xopInclude.setNamespaceURI("http://www.w3.org/2004/08/xop/include");
                marshalRecord.openStartElement(xopInclude, namespaceResolver);
                marshalRecord.attribute("", "href", "href", c_id);
                if (addDeclaration) {
                    marshalRecord.namespaceDeclaration(xopPrefix, "http://www.w3.org/2004/08/xop/include");
                }
                marshalRecord.closeStartElement();
                marshalRecord.endElement(xopInclude, namespaceResolver);
            }
        } else {
            marshalRecord.characters(((Field)this.xmlBinaryDataMapping.getField()).getSchemaType(), objectValue, mimeType, false);
        }
        if (!xPathFragment.isSelfFragment()) {
            marshalRecord.endElement(xPathFragment, namespaceResolver);
        }
        return true;
    }

    @Override
    public boolean startElement(XPathFragment xPathFragment, UnmarshalRecord unmarshalRecord, Attributes atts) {
        try {
            unmarshalRecord.removeNullCapableValue(this);
            Field xmlField = (Field)this.xmlBinaryDataMapping.getField();
            xmlField.getLastXPathFragment();
            BinaryMappingContentHandler handler = new BinaryMappingContentHandler(unmarshalRecord, (NodeValue)this, this.xmlBinaryDataMapping);
            String qnameString = xPathFragment.getLocalName();
            if (xPathFragment.getPrefix() != null) {
                qnameString = String.valueOf(xPathFragment.getPrefix()) + ':' + qnameString;
            }
            handler.startElement(xPathFragment.getNamespaceURI(), xPathFragment.getLocalName(), qnameString, atts);
            XMLReader xmlReader = unmarshalRecord.getXMLReader();
            xmlReader.setContentHandler(handler);
            xmlReader.setLexicalHandler(handler);
            return true;
        }
        catch (SAXException ex) {
            throw XMLMarshalException.unmarshalException(ex);
        }
    }

    @Override
    public void endElement(XPathFragment xPathFragment, UnmarshalRecord unmarshalRecord) {
        unmarshalRecord.resetStringBuffer();
    }

    @Override
    public void attribute(UnmarshalRecord unmarshalRecord, String URI2, String localName, String value) {
        unmarshalRecord.removeNullCapableValue(this);
        Field xmlField = (Field)this.xmlBinaryDataMapping.getField();
        xmlField.getLastXPathFragment();
        Object fieldValue = null;
        if (this.xmlBinaryDataMapping.isSwaRef()) {
            if (((Unmarshaller)unmarshalRecord.getUnmarshaller()).getAttachmentUnmarshaller() != null) {
                fieldValue = this.xmlBinaryDataMapping.getAttributeClassification() == XMLBinaryDataHelper.getXMLBinaryDataHelper().DATA_HANDLER ? (Object)((Unmarshaller)unmarshalRecord.getUnmarshaller()).getAttachmentUnmarshaller().getAttachmentAsDataHandler(value) : ((Unmarshaller)unmarshalRecord.getUnmarshaller()).getAttachmentUnmarshaller().getAttachmentAsByteArray(value);
                this.xmlBinaryDataMapping.setAttributeValueInObject(unmarshalRecord.getCurrentObject(), XMLBinaryDataHelper.getXMLBinaryDataHelper().convertObject(fieldValue, this.xmlBinaryDataMapping.getAttributeClassification(), (CoreAbstractSession)unmarshalRecord.getSession(), null));
            }
        } else {
            fieldValue = ((ConversionManager)((CoreAbstractSession)unmarshalRecord.getSession()).getDatasourcePlatform().getConversionManager()).convertSchemaBase64ToByteArray(value);
            this.xmlBinaryDataMapping.setAttributeValueInObject(unmarshalRecord.getCurrentObject(), XMLBinaryDataHelper.getXMLBinaryDataHelper().convertObject(fieldValue, this.xmlBinaryDataMapping.getAttributeClassification(), (CoreAbstractSession)unmarshalRecord.getSession(), null));
        }
    }

    @Override
    public void setNullValue(Object object, CoreSession session) {
        Object value = this.xmlBinaryDataMapping.getObjectValue(null, session);
        this.xmlBinaryDataMapping.setAttributeValueInObject(object, value);
    }

    @Override
    public boolean isNullCapableValue() {
        return this.xmlBinaryDataMapping.getNullPolicy().getIsSetPerformedForAbsentNode();
    }

    public DataHandler getDataHandlerForObjectValue(Object obj, Class classification) {
        if (classification == DataHandler.class) {
            return (DataHandler)obj;
        }
        return null;
    }

    public BinaryDataMapping getMapping() {
        return this.xmlBinaryDataMapping;
    }

    @Override
    public UnmarshalRecord buildSelfRecord(UnmarshalRecord unmarshalRecord, Attributes atts) {
        unmarshalRecord.removeNullCapableValue(this);
        BinaryDataUnmarshalRecord newRecord = new BinaryDataUnmarshalRecord(null, unmarshalRecord, this, this.xmlBinaryDataMapping);
        return newRecord;
    }

    @Override
    public void endSelfNodeValue(UnmarshalRecord unmarshalRecord, UnmarshalRecord selfRecord, Attributes attributes) {
        unmarshalRecord.resetStringBuffer();
    }
}

