/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.agent.rest.master;

import es.bsc.compss.agent.RESTAgentConfig;
import es.bsc.compss.agent.rest.master.RemoteRESTAgent;
import es.bsc.compss.agent.rest.types.OrchestratorNotification;
import es.bsc.compss.agent.rest.types.RemoteJobListener;
import es.bsc.compss.agent.rest.types.messages.StartApplicationRequest;
import es.bsc.compss.agent.util.RemoteJobsRegistry;
import es.bsc.compss.comm.Comm;
import es.bsc.compss.types.COMPSsNode;
import es.bsc.compss.types.TaskDescription;
import es.bsc.compss.types.annotations.parameter.DataType;
import es.bsc.compss.types.data.DataAccessId;
import es.bsc.compss.types.data.accessid.RAccessId;
import es.bsc.compss.types.data.accessid.RWAccessId;
import es.bsc.compss.types.data.accessid.WAccessId;
import es.bsc.compss.types.data.location.DataLocation;
import es.bsc.compss.types.data.location.ProtocolType;
import es.bsc.compss.types.execution.exceptions.JobExecutionException;
import es.bsc.compss.types.implementations.Implementation;
import es.bsc.compss.types.implementations.TaskType;
import es.bsc.compss.types.implementations.definition.MethodDefinition;
import es.bsc.compss.types.job.Job;
import es.bsc.compss.types.job.JobEndStatus;
import es.bsc.compss.types.job.JobListener;
import es.bsc.compss.types.parameter.BasicTypeParameter;
import es.bsc.compss.types.parameter.DependencyParameter;
import es.bsc.compss.types.parameter.Parameter;
import es.bsc.compss.types.resources.Resource;
import es.bsc.compss.types.uri.SimpleURI;
import java.io.IOException;
import java.util.List;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;

public class RemoteRESTAgentJob
extends Job<RemoteRESTAgent> {
    private static final String REST_AGENT_URL = "http://" + COMPSsNode.getMasterName() + ":" + RESTAgentConfig.localAgentPort + "/";

    public RemoteRESTAgentJob(RemoteRESTAgent executor, int taskId, TaskDescription task, Implementation impl, Resource res, JobListener listener) {
        super(taskId, task, impl, res, listener);
    }

    public void submit() throws Exception {
        StartApplicationRequest sar = new StartApplicationRequest();
        RemoteRESTAgent executorNode = (RemoteRESTAgent)this.getResourceNode();
        WebTarget wt = executorNode.getTarget();
        wt = wt.path("/COMPSs/startApplication/");
        MethodDefinition mImpl = (MethodDefinition)this.impl.getDescription().getDefinition();
        String className = mImpl.getDeclaringClass();
        String methodName = mImpl.getAlternativeMethodName();
        if (methodName == null || methodName.isEmpty()) {
            methodName = this.taskParams.getName();
            mImpl.setAlternativeMethodName(this.taskParams.getName());
        }
        sar.setClassName(className);
        sar.setMethodName(methodName);
        sar.setCeiClass(null);
        List params = this.taskParams.getParameters();
        int numParams = params.size();
        boolean hasReturn = this.taskParams.getNumReturns() > 0;
        boolean hasTarget = this.taskParams.hasTargetObject();
        if (hasReturn) {
            sar.setHasResult(true);
            --numParams;
        }
        if (hasTarget) {
            String renaming;
            Parameter param;
            DependencyParameter dPar;
            DataAccessId faId;
            if ((faId = (dPar = (DependencyParameter)(param = (Parameter)params.get(--numParams))).getDataAccessId()) instanceof WAccessId) {
                WAccessId waId = (WAccessId)faId;
                renaming = waId.getWrittenDataInstance().getRenaming();
            } else if (faId instanceof RWAccessId) {
                RWAccessId rwaId = (RWAccessId)faId;
                renaming = rwaId.getWrittenDataInstance().getRenaming();
            } else {
                RAccessId raId = (RAccessId)faId;
                renaming = raId.getReadDataInstance().getRenaming();
            }
            Object target = Comm.getData((String)renaming).getValue();
            System.out.println("Target: " + target);
            throw new UnsupportedOperationException("Instance methods not supported yet.");
        }
        System.out.println("SUBMISSION[" + this.getJobId() + "] Remote Agent :" + executorNode.getName());
        System.out.println("SUBMISSION[" + this.getJobId() + "] Parameters:");
        block3: for (int parIdx = 0; parIdx < numParams; ++parIdx) {
            System.out.println("SUBMISSION[" + this.getJobId() + "]     * Parameter " + parIdx + ": ");
            Parameter param = (Parameter)params.get(parIdx);
            DataType type = param.getType();
            System.out.println("SUBMISSION[" + this.getJobId() + "]         Type " + type);
            switch (type) {
                case FILE_T: 
                case OBJECT_T: 
                case STREAM_T: 
                case EXTERNAL_STREAM_T: 
                case EXTERNAL_PSCO_T: 
                case PSCO_T: {
                    String pscoId;
                    String inRenaming;
                    DependencyParameter dPar = (DependencyParameter)param;
                    DataAccessId dAccId = dPar.getDataAccessId();
                    if (dAccId instanceof WAccessId) {
                        throw new JobExecutionException("Target parameter is a Write access", null);
                    }
                    if (dAccId instanceof RWAccessId) {
                        RWAccessId rwaId = (RWAccessId)dAccId;
                        inRenaming = rwaId.getReadDataInstance().getRenaming();
                    } else {
                        RAccessId raId = (RAccessId)dAccId;
                        inRenaming = raId.getReadDataInstance().getRenaming();
                    }
                    if (inRenaming != null && (pscoId = Comm.getData((String)inRenaming).getPscoId()) != null) {
                        if (type.equals((Object)DataType.OBJECT_T)) {
                            param.setType(DataType.PSCO_T);
                        }
                        if (type.equals((Object)DataType.FILE_T)) {
                            param.setType(DataType.EXTERNAL_PSCO_T);
                        }
                        type = param.getType();
                    }
                    if (type == DataType.PSCO_T || type == DataType.EXTERNAL_PSCO_T) {
                        System.out.println("SUBMISSION[" + this.getJobId() + "]         Access " + dAccId);
                        String value = dPar.getDataTarget();
                        System.out.println("SUBMISSION[" + this.getJobId() + "]         ID " + value);
                        sar.addPersistedParameter(param.getDirection(), value);
                        continue block3;
                    }
                    throw new UnsupportedOperationException("Non-persisted DependencyParameters are not supported yet");
                }
                default: {
                    BasicTypeParameter btParB = (BasicTypeParameter)param;
                    Object value = btParB.getValue();
                    System.out.println("SUBMISSION[" + this.getJobId() + "]         Value " + value);
                    sar.addParameter((Parameter)btParB, value);
                }
            }
        }
        System.out.println("SUBMISSION[" + this.getJobId() + "] Stage in completed.");
        sar.setOrchestratorNotification(REST_AGENT_URL, OrchestratorNotification.HttpMethod.PUT, "COMPSs/endApplication/");
        Response response = wt.request("application/json").put(Entity.xml(sar), Response.class);
        if (response.getStatusInfo().getStatusCode() != 200) {
            System.out.println(response.readEntity(String.class));
            this.getListener().jobFailed((Job)this, JobEndStatus.SUBMISSION_FAILED, null);
        } else {
            System.out.println("SUBMISSION[" + this.getJobId() + "] Job submitted.");
            String jobId = response.readEntity(String.class);
            RemoteJobsRegistry.registerJobListener(jobId, new RemoteJobListener(){

                @Override
                public void finishedExecution(JobEndStatus endStatus, DataType[] paramTypes, String[] paramLocations) {
                    System.out.println("SUBMISSION[" + RemoteRESTAgentJob.this.getJobId() + "] Job completed.");
                    RemoteRESTAgentJob.this.stageout(paramTypes, paramLocations);
                    if (endStatus == JobEndStatus.OK) {
                        RemoteRESTAgentJob.this.getListener().jobCompleted((Job)RemoteRESTAgentJob.this);
                    } else {
                        RemoteRESTAgentJob.this.getListener().jobFailed((Job)RemoteRESTAgentJob.this, endStatus, null);
                    }
                }
            });
        }
    }

    public void cancelJob() throws Exception {
    }

    private void stageout(DataType[] paramTypes, String[] paramLocations) {
        String pscoId;
        DataLocation loc;
        SimpleURI uri;
        String locString;
        DataType type;
        List params = this.taskParams.getParameters();
        int numParams = params.size();
        boolean hasReturn = this.taskParams.getNumReturns() > 0;
        boolean hasTarget = this.taskParams.hasTargetObject();
        if (hasReturn) {
            DependencyParameter returnParameter = (DependencyParameter)this.taskParams.getParameters().get(--numParams);
            type = paramTypes[numParams];
            locString = paramLocations[numParams];
            System.out.println("STAGE OUT[" + this.getJobId() + "]         * Return type: " + type + " Value: " + locString);
            if (locString != null) {
                uri = new SimpleURI(locString);
                try {
                    loc = DataLocation.createLocation((Resource)this.worker, (SimpleURI)uri);
                    if (loc.getProtocol() == ProtocolType.PERSISTENT_URI) {
                        type = returnParameter.getType();
                        if (type == DataType.OBJECT_T) {
                            type = DataType.PSCO_T;
                        }
                        returnParameter.setType(type);
                        pscoId = loc.getLocationKey();
                        returnParameter.setDataTarget(pscoId);
                        System.out.println("STAGE OUT[" + this.getJobId() + "]         * Return : ");
                        System.out.println("STAGE OUT[" + this.getJobId() + "]             Type: " + type);
                        System.out.println("STAGE OUT[" + this.getJobId() + "]             ID: " + pscoId);
                    } else {
                        returnParameter.setType(type);
                        System.out.println("STAGE OUT[" + this.getJobId() + "]         * Return : ");
                        System.out.println("STAGE OUT[" + this.getJobId() + "]             Type: " + type);
                        System.out.println("STAGE OUT[" + this.getJobId() + "]             Value location: " + loc);
                    }
                }
                catch (IOException ioe) {
                    System.err.println("STAGE OUT[" + this.getJobId() + "] ERROR PROCESSING TASK RESULT");
                }
            }
        }
        if (hasTarget) {
            DependencyParameter targetParameter = (DependencyParameter)this.taskParams.getParameters().get(--numParams);
            type = paramTypes[numParams];
            locString = paramLocations[numParams];
            if (locString != null) {
                uri = new SimpleURI(locString);
                try {
                    loc = DataLocation.createLocation((Resource)this.worker, (SimpleURI)uri);
                    if (loc.getProtocol() == ProtocolType.PERSISTENT_URI) {
                        type = targetParameter.getType();
                        if (type == DataType.OBJECT_T) {
                            type = DataType.PSCO_T;
                        }
                        targetParameter.setType(type);
                        pscoId = loc.getLocationKey();
                        targetParameter.setDataTarget(pscoId);
                        System.out.println("STAGE OUT[" + this.getJobId() + "]         * Target : ");
                        System.out.println("STAGE OUT[" + this.getJobId() + "]             Type: " + type);
                        System.out.println("STAGE OUT[" + this.getJobId() + "]             ID: " + pscoId);
                    } else {
                        targetParameter.setType(type);
                        System.out.println("STAGE OUT[" + this.getJobId() + "]         * Target : ");
                        System.out.println("STAGE OUT[" + this.getJobId() + "]             Type: " + type);
                        System.out.println("STAGE OUT[" + this.getJobId() + "]             Value location: " + loc);
                    }
                }
                catch (IOException ioe) {
                    System.err.println("STAGE OUT[" + this.getJobId() + "] ERROR PROCESSING TASK TARGET");
                }
            }
        }
        System.out.println("STAGE OUT[" + this.getJobId() + "]     Parameters:");
        block17: for (int parIdx = 0; parIdx < numParams; ++parIdx) {
            type = paramTypes[parIdx];
            switch (type) {
                case FILE_T: 
                case OBJECT_T: 
                case EXTERNAL_PSCO_T: 
                case PSCO_T: {
                    DependencyParameter dp = (DependencyParameter)params.get(parIdx);
                    String locString2 = paramLocations[parIdx];
                    if (locString2 == null) continue block17;
                    SimpleURI uri2 = new SimpleURI(locString2);
                    try {
                        DataLocation loc2 = DataLocation.createLocation((Resource)this.worker, (SimpleURI)uri2);
                        if (loc2.getProtocol() == ProtocolType.PERSISTENT_URI) {
                            String pscoId2 = loc2.getLocationKey();
                            switch (type) {
                                case FILE_T: {
                                    type = DataType.EXTERNAL_PSCO_T;
                                    break;
                                }
                                case OBJECT_T: {
                                    type = DataType.PSCO_T;
                                    break;
                                }
                            }
                            dp.setType(type);
                            dp.setDataTarget(pscoId2);
                            System.out.println("STAGE OUT[" + this.getJobId() + "]         * Parameter " + parIdx + ": ");
                            System.out.println("STAGE OUT[" + this.getJobId() + "]             Type: " + type);
                            System.out.println("STAGE OUT[" + this.getJobId() + "]             ID: " + pscoId2);
                            continue block17;
                        }
                        switch (type) {
                            case EXTERNAL_PSCO_T: {
                                type = DataType.FILE_T;
                                break;
                            }
                            case PSCO_T: {
                                type = DataType.OBJECT_T;
                                break;
                            }
                        }
                        dp.setType(type);
                        System.out.println("STAGE OUT[" + this.getJobId() + "]          * Parameter " + parIdx + ": ");
                        System.out.println("STAGE OUT[" + this.getJobId() + "]              Type: " + type);
                        System.out.println("STAGE OUT[" + this.getJobId() + "]              Value location: " + loc2);
                    }
                    catch (IOException ioe) {
                        System.err.println("STAGE OUT[" + this.getJobId() + "] ERROR PROCESSING TASK PARAMETER " + parIdx);
                    }
                    continue block17;
                }
            }
        }
    }

    public String getHostName() {
        return ((RemoteRESTAgent)this.getResourceNode()).getName();
    }

    public TaskType getType() {
        return TaskType.METHOD;
    }

    public String toString() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

