/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.core.queries;

import java.util.ArrayDeque;

public class CoreAttributeConverter {
    private static final String DOT = Character.toString('.');

    public static final String[] convert(String ... nameOrPath) throws IllegalArgumentException {
        if (nameOrPath == null) {
            throw new IllegalArgumentException("Name or path value is null");
        }
        switch (nameOrPath.length) {
            case 0: {
                throw new IllegalArgumentException("Name or path value size is zero");
            }
            case 1: {
                String str = nameOrPath[0];
                if (str == null) {
                    throw new IllegalArgumentException("Name or path value is null");
                }
                int len = str.length();
                if (!str.contains(DOT)) {
                    switch (len) {
                        case 0: {
                            throw new IllegalArgumentException("Empty name or path value");
                        }
                        case 1: {
                            switch (str.charAt(0)) {
                                case '\t': 
                                case '\n': 
                                case '\f': 
                                case '\r': 
                                case ' ': {
                                    throw new IllegalArgumentException("Name or path value starts with whitespace.");
                                }
                            }
                        }
                    }
                    switch (str.charAt(0)) {
                        case '\t': 
                        case '\n': 
                        case '\f': 
                        case '\r': 
                        case ' ': {
                            throw new IllegalArgumentException("Name or path value starts with whitespace.");
                        }
                    }
                    switch (str.charAt(len - 1)) {
                        case '\t': 
                        case '\n': 
                        case '\f': 
                        case '\r': 
                        case ' ': {
                            throw new IllegalArgumentException("Name or path value ends with whitespace.");
                        }
                    }
                    return nameOrPath;
                }
                char[] chars = nameOrPath[0].toCharArray();
                ConvertState s = ConvertState.DOT;
                int begIndex = 0;
                ArrayDeque<String> elements = null;
                int index = 0;
                while (index < len) {
                    char c = chars[index];
                    block17 : switch (s) {
                        case DOT: {
                            switch (c) {
                                case '.': {
                                    throw new IllegalArgumentException("Name or path value contains empty path element");
                                }
                                case '\t': 
                                case '\n': 
                                case '\f': 
                                case '\r': 
                                case ' ': {
                                    throw new IllegalArgumentException("Path element starts with whitespace.");
                                }
                            }
                            s = ConvertState.CH;
                            break;
                        }
                        case SP: {
                            switch (c) {
                                case '.': {
                                    throw new IllegalArgumentException("Path element ends with whitespace.");
                                }
                                case '\t': 
                                case '\n': 
                                case '\f': 
                                case '\r': 
                                case ' ': {
                                    break block17;
                                }
                            }
                            s = ConvertState.CH;
                            break;
                        }
                        case CH: {
                            switch (c) {
                                case '.': {
                                    if (elements == null) {
                                        elements = new ArrayDeque<String>(4);
                                    }
                                    elements.addLast(new String(chars, begIndex, index - begIndex));
                                    begIndex = index + 1;
                                    s = ConvertState.DOT;
                                    break block17;
                                }
                                case '\t': 
                                case '\n': 
                                case '\f': 
                                case '\r': 
                                case ' ': {
                                    s = ConvertState.SP;
                                }
                            }
                        }
                    }
                    ++index;
                }
                switch (s) {
                    case DOT: {
                        throw new IllegalArgumentException("Empty name or path value or last path element");
                    }
                    case SP: {
                        throw new IllegalArgumentException("Name or path value ends with space");
                    }
                }
                if (elements == null) {
                    return nameOrPath;
                }
                int n = 0;
                int count = elements.size();
                String[] paths = new String[count + 1];
                while ((paths[n++] = (String)elements.pollFirst()) != null) {
                }
                paths[count] = new String(chars, begIndex, index - begIndex);
                return paths;
            }
        }
        int i = 0;
        while (i < nameOrPath.length) {
            String item = nameOrPath[i];
            if (item == null) {
                throw new IllegalArgumentException("Name or path value at index " + Integer.toString(i) + " is null");
            }
            int itemLen = item.length();
            if (itemLen == 0) {
                throw new IllegalArgumentException("Name or path value at index " + Integer.toString(i) + " is empty String");
            }
            switch (item.charAt(0)) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    throw new IllegalArgumentException("Name or path value at index " + Integer.toString(i) + " starts with whitespace");
                }
            }
            if (itemLen > 0) {
                switch (item.charAt(itemLen - 1)) {
                    case '\t': 
                    case '\n': 
                    case '\f': 
                    case '\r': 
                    case ' ': {
                        throw new IllegalArgumentException("Name or path value at index " + Integer.toString(i) + " ends with whitespace");
                    }
                }
            }
            ++i;
        }
        return nameOrPath;
    }

    private CoreAttributeConverter() {
        throw new UnsupportedOperationException("Instances of CoreAttributeConverter are not allowed");
    }

    private static enum ConvertState {
        DOT,
        SP,
        CH;

    }
}

