/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.eis.interactions;

import java.io.StringWriter;
import java.util.Iterator;
import org.eclipse.persistence.eis.EISAccessor;
import org.eclipse.persistence.eis.interactions.XMLInteraction;
import org.eclipse.persistence.internal.databaseaccess.Accessor;
import org.eclipse.persistence.internal.databaseaccess.QueryStringCall;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.EmptyRecord;
import org.eclipse.persistence.oxm.record.XMLRecord;
import org.w3c.dom.Element;

public class XQueryInteraction
extends XMLInteraction
implements QueryStringCall {
    protected String xQueryString;

    public XQueryInteraction() {
        this.xQueryString = "";
    }

    public XQueryInteraction(String xQueryString) {
        this.xQueryString = xQueryString;
    }

    public String getXQueryString() {
        return this.xQueryString;
    }

    public void setXQueryString(String xQueryString) {
        this.xQueryString = xQueryString;
    }

    @Override
    public String getQueryString() {
        return this.getXQueryString();
    }

    @Override
    public void setQueryString(String queryString) {
        this.setXQueryString(queryString);
    }

    @Override
    public void translate(AbstractRecord translationRow, AbstractRecord modifyRow, AbstractSession session) {
        if (translationRow != EmptyRecord.getEmptyRecord() && this.getQuery() != null && this.getQuery().getDescriptor() != null) {
            ((XMLRecord)translationRow).setSession(session);
        }
        this.setInputRow(modifyRow);
        this.translateQueryString(translationRow, modifyRow, session);
    }

    @Override
    public Element createInputDOM(EISAccessor accessor) {
        if (this.getInputRow() != null && !this.hasArguments()) {
            return super.createInputDOM(accessor);
        }
        XMLRecord parameterRow = this.createXMLRecord(this.getInputRootElementName());
        int index = 0;
        while (index < this.getArgumentNames().size()) {
            String parameterName = (String)this.getArgumentNames().get(index);
            Object parameter = this.getInputRow().get(parameterName);
            parameterRow.put(parameterName, parameter);
            ++index;
        }
        return (Element)parameterRow.getDOM();
    }

    @Override
    public void prepare(AbstractSession session) {
        if (this.isPrepared()) {
            return;
        }
        super.prepare(session);
        this.translateCustomQuery();
        this.setIsPrepared(true);
    }

    @Override
    public String getLogString(Accessor accessor) {
        StringWriter writer = new StringWriter();
        writer.write("Executing ");
        writer.write(this.toString());
        writer.write(Helper.cr());
        writer.write("\tspec => ");
        writer.write(String.valueOf(this.getInteractionSpec()));
        writer.write(Helper.cr());
        writer.write("\txQuery => ");
        writer.write(this.getXQueryString());
        writer.write(Helper.cr());
        writer.write("\tinput => [");
        if (this.hasParameters()) {
            Iterator iterator = this.getParameters().iterator();
            while (iterator.hasNext()) {
                Object parameter = iterator.next();
                writer.write(String.valueOf(parameter));
                if (iterator.hasNext()) {
                    writer.write(", ");
                    continue;
                }
                writer.write("]");
            }
        } else {
            writer.write(String.valueOf(this.getInputRow()));
            writer.write("]");
        }
        return writer.toString();
    }

    @Override
    protected char argumentMarker() {
        return '#';
    }

    @Override
    protected String whitespace() {
        return ",;\"'< \n\t";
    }

    @Override
    public boolean isQueryStringCall() {
        return true;
    }
}

