/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm.record;

import java.io.IOException;
import javax.xml.namespace.QName;
import javax.xml.validation.ValidatorHandler;
import org.eclipse.persistence.internal.core.sessions.CoreAbstractSession;
import org.eclipse.persistence.internal.oxm.Constants;
import org.eclipse.persistence.internal.oxm.ConversionManager;
import org.eclipse.persistence.internal.oxm.MediaType;
import org.eclipse.persistence.internal.oxm.mappings.Field;
import org.eclipse.persistence.internal.oxm.mappings.Mapping;
import org.eclipse.persistence.internal.oxm.record.AbstractUnmarshalRecord;
import org.eclipse.persistence.internal.oxm.record.UnmarshalRecord;
import org.eclipse.persistence.oxm.mappings.nullpolicy.AbstractNullPolicy;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.ext.LexicalHandler;

public class XMLReader
implements org.xml.sax.XMLReader {
    public static final String NAMESPACE_PREFIXES_FEATURE = "http://xml.org/sax/features/namespace-prefixes";
    public static final String REPORT_IGNORED_ELEMENT_CONTENT_WHITESPACE_FEATURE = "http://java.sun.com/xml/schema/features/report-ignored-element-content-whitespace";
    private org.xml.sax.XMLReader reader;
    private boolean supportsLexicalHandler = true;
    private LexicalHandlerWrapper lexicalHandlerWrapper;
    protected ValidatingContentHandler validatingContentHandler;
    private boolean namespaceAware = true;
    private char namespaceSeparator = (char)58;
    protected Locator locator;

    public XMLReader(org.xml.sax.XMLReader internalReader) {
        this();
        this.reader = internalReader;
    }

    public XMLReader() {
    }

    public Locator getLocator() {
        return this.locator;
    }

    public void setLocator(Locator newLocator) {
        this.locator = newLocator;
    }

    @Override
    public ContentHandler getContentHandler() {
        return this.reader.getContentHandler();
    }

    @Override
    public void setContentHandler(ContentHandler handler) {
        if (this.validatingContentHandler != null) {
            this.validatingContentHandler.setContentHandler(handler);
        } else {
            this.reader.setContentHandler(handler);
        }
    }

    public boolean isNamespaceAware() {
        return this.namespaceAware;
    }

    public void setNamespaceAware(boolean namespaceAware) {
        this.namespaceAware = namespaceAware;
    }

    public char getNamespaceSeparator() {
        return this.namespaceSeparator;
    }

    public void setNamespaceSeparator(char namespaceSeparator) {
        this.namespaceSeparator = namespaceSeparator;
    }

    public MediaType getMediaType() {
        return Constants.APPLICATION_XML;
    }

    public Object convertValueBasedOnSchemaType(Field xmlField, Object value, ConversionManager conversionManager, AbstractUnmarshalRecord record) {
        return xmlField.convertValueBasedOnSchemaType(value, conversionManager, record);
    }

    @Override
    public DTDHandler getDTDHandler() {
        return this.reader.getDTDHandler();
    }

    @Override
    public void setDTDHandler(DTDHandler handler) {
        this.reader.setDTDHandler(handler);
    }

    @Override
    public void setEntityResolver(EntityResolver resolver) {
        this.reader.setEntityResolver(resolver);
    }

    @Override
    public EntityResolver getEntityResolver() {
        return this.reader.getEntityResolver();
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return this.reader.getErrorHandler();
    }

    @Override
    public void setErrorHandler(ErrorHandler handler) {
        if (this.validatingContentHandler != null) {
            this.validatingContentHandler.setErrorHandler(handler);
        } else {
            this.reader.setErrorHandler(handler);
        }
    }

    public LexicalHandler getLexicalHandler() {
        if (this.supportsLexicalHandler) {
            try {
                return (LexicalHandler)this.reader.getProperty("http://xml.org/sax/properties/lexical-handler");
            }
            catch (SAXException sAXException) {
                this.supportsLexicalHandler = false;
            }
        }
        return null;
    }

    public void setLexicalHandler(LexicalHandler lexicalHandler) {
        if (this.supportsLexicalHandler) {
            if (this.lexicalHandlerWrapper == null) {
                try {
                    this.lexicalHandlerWrapper = new LexicalHandlerWrapper(lexicalHandler);
                    this.reader.setProperty("http://xml.org/sax/properties/lexical-handler", this.lexicalHandlerWrapper);
                }
                catch (SAXException sAXException) {
                    this.supportsLexicalHandler = false;
                }
            } else {
                this.lexicalHandlerWrapper.setLexicalHandler(lexicalHandler);
            }
        }
    }

    @Override
    public boolean getFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        return this.reader.getFeature(name);
    }

    @Override
    public void setFeature(String name, boolean value) throws SAXNotRecognizedException, SAXNotSupportedException {
        this.reader.setFeature(name, value);
    }

    @Override
    public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        if ("http://xml.org/sax/properties/lexical-handler".equals(name)) {
            return this.getLexicalHandler();
        }
        return this.reader.getProperty(name);
    }

    @Override
    public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
        if ("http://xml.org/sax/properties/lexical-handler".equals(name)) {
            this.setLexicalHandler((LexicalHandler)value);
        } else {
            this.reader.setProperty(name, value);
        }
    }

    @Override
    public void parse(InputSource input) throws IOException, SAXException {
        try {
            this.reader.parse(input);
        }
        catch (SAXNotSupportedException e) {
            String message = e.getMessage();
            if (message != null && message.contains("namespace-prefix")) {
                this.reader.setFeature(NAMESPACE_PREFIXES_FEATURE, false);
                this.reader.parse(input);
            }
            throw e;
        }
    }

    @Override
    public void parse(String systemId) throws IOException, SAXException {
        try {
            this.reader.parse(systemId);
        }
        catch (SAXNotSupportedException e) {
            String message = e.getMessage();
            if (message != null && message.contains("namespace-prefix")) {
                this.reader.setFeature(NAMESPACE_PREFIXES_FEATURE, false);
                this.reader.parse(systemId);
            }
            throw e;
        }
    }

    public void setValidatorHandler(ValidatorHandler validatorHandler) {
        ContentHandler contentHandler;
        ErrorHandler errorHandler = this.getErrorHandler();
        if (this.validatingContentHandler == null) {
            contentHandler = this.getContentHandler();
        } else {
            contentHandler = validatorHandler.getContentHandler();
            this.validatingContentHandler = null;
        }
        ValidatingContentHandler validatingContentHandler = null;
        if (validatorHandler != null) {
            validatingContentHandler = new ValidatingContentHandler(validatorHandler);
            validatingContentHandler.setContentHandler(contentHandler);
            contentHandler = validatingContentHandler;
        }
        if (this.reader != null) {
            this.reader.setContentHandler(contentHandler);
        }
        this.setContentHandler(contentHandler);
        this.validatingContentHandler = validatingContentHandler;
        this.setErrorHandler(errorHandler);
    }

    public ValidatorHandler getValidatorHandler() {
        if (this.validatingContentHandler == null) {
            return null;
        }
        return this.validatingContentHandler.getValidatorHandler();
    }

    public void newObjectEvent(Object object, Object parent, Mapping selfRecordMapping) {
    }

    public Object getCurrentObject(CoreAbstractSession session, Mapping selfRecordMapping) {
        return null;
    }

    public Object getValue(CharSequence characters, Class<?> dataType) {
        return null;
    }

    public boolean isNullRepresentedByXsiNil(AbstractNullPolicy nullPolicy) {
        return nullPolicy.isNullRepresentedByXsiNil();
    }

    public boolean isNullRecord(AbstractNullPolicy nullPolicy, Attributes atts, UnmarshalRecord record) {
        boolean isNil;
        boolean bl = isNil = this.isNullRepresentedByXsiNil(nullPolicy) && record.isNil();
        if (!nullPolicy.ignoreAttributesForNil()) {
            return isNil && !this.hasAttributes(atts);
        }
        return isNil;
    }

    private boolean hasAttributes(Attributes attributes) {
        QName nilAttrName = new QName("http://www.w3.org/2001/XMLSchema-instance", "nil");
        int i = 0;
        while (i < attributes.getLength()) {
            if (!nilAttrName.getNamespaceURI().equals(attributes.getURI(i)) || !nilAttrName.getLocalPart().equals(attributes.getLocalName(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isInCollection() {
        return true;
    }

    private static class LexicalHandlerWrapper
    implements LexicalHandler {
        private LexicalHandler lexicalHandler;

        public LexicalHandlerWrapper(LexicalHandler lexicalHandler) {
            this.lexicalHandler = lexicalHandler;
        }

        public void setLexicalHandler(LexicalHandler lexicalHandler) {
            this.lexicalHandler = lexicalHandler;
        }

        @Override
        public void comment(char[] ch, int start, int length) throws SAXException {
            if (this.lexicalHandler != null) {
                this.lexicalHandler.comment(ch, start, length);
            }
        }

        @Override
        public void endCDATA() throws SAXException {
            if (this.lexicalHandler != null) {
                this.lexicalHandler.endCDATA();
            }
        }

        @Override
        public void endDTD() throws SAXException {
            if (this.lexicalHandler != null) {
                this.lexicalHandler.endDTD();
            }
        }

        @Override
        public void endEntity(String name) throws SAXException {
            if (this.lexicalHandler != null) {
                this.lexicalHandler.endEntity(name);
            }
        }

        @Override
        public void startCDATA() throws SAXException {
            if (this.lexicalHandler != null) {
                this.lexicalHandler.startCDATA();
            }
        }

        @Override
        public void startDTD(String name, String publicId, String systemId) throws SAXException {
            if (this.lexicalHandler != null) {
                this.lexicalHandler.startCDATA();
            }
        }

        @Override
        public void startEntity(String name) throws SAXException {
            if (this.lexicalHandler != null) {
                this.lexicalHandler.startEntity(name);
            }
        }
    }

    protected static class ValidatingContentHandler
    implements ContentHandler {
        private ValidatorHandler validatorHandler;
        private ContentHandler contentHandler;

        public ValidatingContentHandler(ValidatorHandler validatorHandler) {
            this.validatorHandler = validatorHandler;
        }

        public ContentHandler getContentHandler() {
            return this.contentHandler;
        }

        public void setContentHandler(ContentHandler contentHandler) {
            this.contentHandler = contentHandler;
        }

        public void setErrorHandler(ErrorHandler errorHandler) {
            this.validatorHandler.setErrorHandler(errorHandler);
        }

        public ValidatorHandler getValidatorHandler() {
            return this.validatorHandler;
        }

        public void setValidatorHandler(ValidatorHandler validatorHandler) {
            this.validatorHandler = validatorHandler;
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            this.validatorHandler.setDocumentLocator(locator);
            this.contentHandler.setDocumentLocator(locator);
        }

        @Override
        public void startDocument() throws SAXException {
            this.validatorHandler.startDocument();
            this.contentHandler.startDocument();
        }

        @Override
        public void endDocument() throws SAXException {
            this.validatorHandler.endDocument();
            this.contentHandler.endDocument();
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) throws SAXException {
            this.validatorHandler.startPrefixMapping(prefix, uri);
            this.contentHandler.startPrefixMapping(prefix, uri);
        }

        @Override
        public void endPrefixMapping(String prefix) throws SAXException {
            this.validatorHandler.endPrefixMapping(prefix);
            this.contentHandler.endPrefixMapping(prefix);
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            this.validatorHandler.startElement(uri, localName, qName, atts);
            this.contentHandler.startElement(uri, localName, qName, atts);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            this.validatorHandler.endElement(uri, localName, qName);
            this.contentHandler.endElement(uri, localName, qName);
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            this.validatorHandler.characters(ch, start, length);
            this.contentHandler.characters(ch, start, length);
        }

        @Override
        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
            this.validatorHandler.ignorableWhitespace(ch, start, length);
            this.contentHandler.characters(ch, start, length);
        }

        @Override
        public void processingInstruction(String target, String data) throws SAXException {
            this.validatorHandler.processingInstruction(target, data);
            this.contentHandler.processingInstruction(target, data);
        }

        @Override
        public void skippedEntity(String name) throws SAXException {
            this.validatorHandler.skippedEntity(name);
            this.contentHandler.skippedEntity(name);
        }
    }
}

