/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.mappings.foundation;

import java.util.Enumeration;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.internal.descriptors.DescriptorIterator;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.oxm.mappings.Field;
import org.eclipse.persistence.internal.queries.CollectionContainerPolicy;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.queries.JoinedAttributeManager;
import org.eclipse.persistence.internal.queries.ListContainerPolicy;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.ChangeRecord;
import org.eclipse.persistence.internal.sessions.DirectToFieldChangeRecord;
import org.eclipse.persistence.internal.sessions.MergeManager;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.mappings.ContainerMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.mappings.converters.TypeConversionConverter;
import org.eclipse.persistence.mappings.structures.ArrayCollectionMapping;
import org.eclipse.persistence.mappings.structures.ArrayCollectionMappingHelper;
import org.eclipse.persistence.queries.ObjectBuildingQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.WriteObjectQuery;
import org.eclipse.persistence.sessions.CopyGroup;
import org.eclipse.persistence.sessions.remote.DistributedSession;

public abstract class AbstractCompositeDirectCollectionMapping
extends DatabaseMapping
implements ContainerMapping,
ArrayCollectionMapping {
    protected DatabaseField field;
    protected String elementDataTypeName = "";
    protected Converter valueConverter;
    private ContainerPolicy containerPolicy = ContainerPolicy.buildDefaultPolicy();

    public AbstractCompositeDirectCollectionMapping() {
        this.setWeight(WEIGHT_AGGREGATE);
    }

    public Converter getValueConverter() {
        return this.valueConverter;
    }

    public boolean hasValueConverter() {
        return this.getValueConverter() != null;
    }

    public void setValueConverter(Converter valueConverter) {
        this.valueConverter = valueConverter;
    }

    @Override
    public Object buildAddedElementFromChangeSet(Object changeSet, MergeManager mergeManager, AbstractSession targetSession) {
        return this.buildElementFromChangeSet(changeSet, mergeManager, targetSession);
    }

    @Override
    public void buildBackupClone(Object clone, Object backup, UnitOfWorkImpl unitOfWork) {
        this.buildClone(clone, null, backup, null, unitOfWork);
    }

    @Override
    public Object buildChangeSet(Object element, ObjectChangeSet owner, AbstractSession session) {
        return element;
    }

    @Override
    public void buildClone(Object original, CacheKey cacheKey, Object clone, Integer refreshCascade, AbstractSession cloningSession) {
        Object attributeValue = this.getAttributeValueFromObject(original);
        this.setAttributeValueInObject(clone, this.buildClonePart(attributeValue, cacheKey, cloningSession));
    }

    @Override
    public void buildCloneFromRow(AbstractRecord row, JoinedAttributeManager joinManager, Object clone, CacheKey sharedCacheKey, ObjectBuildingQuery sourceQuery, UnitOfWorkImpl unitOfWork, AbstractSession executionSession) {
        Object cloneAttributeValue = this.valueFromRow(row, joinManager, sourceQuery, sharedCacheKey, executionSession, true, new Boolean[1]);
        this.setAttributeValueInObject(clone, cloneAttributeValue);
    }

    protected Object buildClonePart(Object attributeValue, CacheKey parentCacheKey, AbstractSession cloningSession) {
        if (attributeValue == null) {
            return this.getContainerPolicy().containerInstance();
        }
        if (this.getValueConverter() == null || !this.getValueConverter().isMutable()) {
            return this.getContainerPolicy().cloneFor(attributeValue);
        }
        Object cloneContainer = this.getContainerPolicy().containerInstance();
        Object iterator = this.getContainerPolicy().iteratorFor(attributeValue);
        while (this.getContainerPolicy().hasNext(iterator)) {
            Object originalValue = this.getContainerPolicy().next(iterator, cloningSession);
            Object cloneValue = this.getValueConverter().convertDataValueToObjectValue(this.getValueConverter().convertObjectValueToDataValue(originalValue, cloningSession), cloningSession);
            this.getContainerPolicy().addInto(cloneValue, cloneContainer, cloningSession);
        }
        return cloneContainer;
    }

    @Override
    public void buildCopy(Object copy, Object original, CopyGroup group) {
        Object attributeValue = this.getAttributeValueFromObject(original);
        attributeValue = attributeValue == null ? this.getContainerPolicy().containerInstance() : this.getContainerPolicy().cloneFor(attributeValue);
        this.setAttributeValueInObject(copy, attributeValue);
    }

    protected Object buildElementFromChangeSet(Object changeSet, MergeManager mergeManager, AbstractSession targetSession) {
        return changeSet;
    }

    @Override
    public Object buildElementFromElement(Object object, MergeManager mergeManager, AbstractSession targetSession) {
        return object;
    }

    @Override
    public Object buildRemovedElementFromChangeSet(Object changeSet, MergeManager mergeManager, AbstractSession targetSession) {
        return this.buildElementFromChangeSet(changeSet, mergeManager, targetSession);
    }

    @Override
    public void cascadePerformRemoveIfRequired(Object object, UnitOfWorkImpl uow, Map visitedObjects) {
    }

    @Override
    public void cascadeRegisterNewIfRequired(Object object, UnitOfWorkImpl uow, Map visitedObjects) {
    }

    protected Vector collectFields() {
        Vector<DatabaseField> fields = new Vector<DatabaseField>(1);
        fields.addElement(this.getField());
        return fields;
    }

    @Override
    public boolean compareElements(Object element1, Object element2, AbstractSession session) {
        return element1.equals(element2);
    }

    @Override
    public boolean compareElementsForChange(Object element1, Object element2, AbstractSession session) {
        return this.compareElements(element1, element2, session);
    }

    protected ChangeRecord convertToChangeRecord(Object cloneCollection, ObjectChangeSet owner, AbstractSession session) {
        ContainerPolicy cp = this.getContainerPolicy();
        Object container = cp.containerInstance();
        Object iter = cp.iteratorFor(cloneCollection);
        while (cp.hasNext(iter)) {
            cp.addInto(cp.next(iter, session), container, session);
        }
        DirectToFieldChangeRecord changeRecord = new DirectToFieldChangeRecord(owner);
        changeRecord.setAttribute(this.getAttributeName());
        changeRecord.setMapping(this);
        changeRecord.setNewValue(container);
        return changeRecord;
    }

    @Override
    public void fixObjectReferences(Object object, Map objectDescriptors, Map processedObjects, ObjectLevelReadQuery query, DistributedSession session) {
    }

    public Class getAttributeElementClass() {
        if (!(this.getValueConverter() instanceof TypeConversionConverter)) {
            return null;
        }
        return ((TypeConversionConverter)this.getValueConverter()).getObjectClass();
    }

    @Override
    public ContainerPolicy getContainerPolicy() {
        return this.containerPolicy;
    }

    @Override
    public DatabaseField getField() {
        return this.field;
    }

    @Override
    public boolean isAbstractCompositeDirectCollectionMapping() {
        return true;
    }

    public Class getFieldElementClass() {
        if (!(this.getValueConverter() instanceof TypeConversionConverter)) {
            return null;
        }
        return ((TypeConversionConverter)this.getValueConverter()).getDataClass();
    }

    public String getFieldName() {
        return this.getField().getName();
    }

    @Override
    public Object getRealCollectionAttributeValueFromObject(Object object, AbstractSession session) throws DescriptorException {
        Object value = this.getRealAttributeValueFromObject(object, session);
        if (value == null) {
            value = this.getContainerPolicy().containerInstance(1);
        }
        return value;
    }

    @Override
    public void initialize(AbstractSession session) throws DescriptorException {
        super.initialize(session);
        if (this.getField() == null) {
            throw DescriptorException.fieldNameNotSetInMapping(this);
        }
        this.setField(this.getDescriptor().buildField(this.getField()));
        this.setFields(this.collectFields());
        if (this.getValueConverter() != null) {
            this.getValueConverter().initialize(this, session);
        }
    }

    @Override
    public void iterate(DescriptorIterator iterator) {
        if (iterator.shouldIterateOnPrimitives()) {
            Object attributeValue = this.getAttributeValueFromObject(iterator.getVisitedParent());
            if (attributeValue == null) {
                return;
            }
            ContainerPolicy cp = this.getContainerPolicy();
            Object iter = cp.iteratorFor(attributeValue);
            while (cp.hasNext(iter)) {
                iterator.iteratePrimitiveForMapping(cp.next(iter, iterator.getSession()), this);
            }
        }
    }

    @Override
    public boolean mapKeyHasChanged(Object element, AbstractSession session) {
        return false;
    }

    public void setAttributeElementClass(Class attributeElementClass) {
        TypeConversionConverter converter;
        if (this.getValueConverter() instanceof TypeConversionConverter) {
            converter = (TypeConversionConverter)this.getValueConverter();
        } else {
            converter = new TypeConversionConverter();
            this.setValueConverter(converter);
        }
        converter.setObjectClass(attributeElementClass);
    }

    public void setAttributeElementClassName(String attributeElementClass) {
        TypeConversionConverter converter;
        if (this.getValueConverter() instanceof TypeConversionConverter) {
            converter = (TypeConversionConverter)this.getValueConverter();
        } else {
            converter = new TypeConversionConverter();
            this.setValueConverter(converter);
        }
        converter.setObjectClassName(attributeElementClass);
    }

    @Override
    public void setContainerPolicy(ContainerPolicy containerPolicy) {
        this.containerPolicy = containerPolicy;
    }

    public void setField(DatabaseField field) {
        this.field = field;
    }

    public void setFieldElementClass(Class fieldElementClass) {
        TypeConversionConverter converter;
        if (this.getValueConverter() instanceof TypeConversionConverter) {
            converter = (TypeConversionConverter)this.getValueConverter();
        } else {
            converter = new TypeConversionConverter();
            this.setValueConverter(converter);
        }
        converter.setDataClass(fieldElementClass);
    }

    @Override
    public void useCollectionClass(Class concreteClass) {
        this.setContainerPolicy(ContainerPolicy.buildPolicyFor(concreteClass));
    }

    @Override
    public void useCollectionClassName(String concreteClassName) {
        this.setContainerPolicy(new CollectionContainerPolicy(concreteClassName));
    }

    @Override
    public void useListClassName(String concreteClassName) {
        this.setContainerPolicy(new ListContainerPolicy(concreteClassName));
    }

    @Override
    public void useMapClass(Class concreteClass, String methodName) {
        throw new UnsupportedOperationException(String.valueOf(this.getClass().getName()) + ".useMapClass(Class, String)");
    }

    @Override
    public void useMapClassName(String concreteContainerClassName, String methodName) {
        throw new UnsupportedOperationException(String.valueOf(this.getClass().getName()) + ".useMapClass(String, String)");
    }

    public void setUsesSingleNode(boolean usesSingleNode) {
        if (this.getField() instanceof Field) {
            ((Field)((Object)this.getField())).setUsesSingleNode(usesSingleNode);
        }
    }

    public boolean usesSingleNode() {
        if (this.getField() instanceof Field) {
            return ((Field)((Object)this.getField())).usesSingleNode();
        }
        return false;
    }

    @Override
    public Object valueFromRow(AbstractRecord row, JoinedAttributeManager joinManager, ObjectBuildingQuery sourceQuery, CacheKey cacheKey, AbstractSession executionSession, boolean isTargetProtected, Boolean[] wasCacheUsed) throws DatabaseException {
        if (this.descriptor.getCachePolicy().isProtectedIsolation()) {
            if (this.isCacheable && isTargetProtected && cacheKey != null) {
                Object result = null;
                Object cached = cacheKey.getObject();
                if (cached != null) {
                    if (wasCacheUsed != null) {
                        wasCacheUsed[0] = Boolean.TRUE;
                    }
                    Object attributeValue = this.getAttributeValueFromObject(cached);
                    return this.buildClonePart(attributeValue, cacheKey, executionSession);
                }
                return result;
            }
            if (!this.isCacheable && !isTargetProtected && cacheKey != null) {
                return null;
            }
        }
        if (row.hasSopObject()) {
            return this.getAttributeValueFromObject(row.getSopObject());
        }
        ContainerPolicy cp = this.getContainerPolicy();
        Object fieldValue = row.getValues(this.getField());
        if (fieldValue == null) {
            return cp.containerInstance();
        }
        Vector fieldValues = this.getDescriptor().buildDirectValuesFromFieldValue(fieldValue);
        if (fieldValues == null) {
            return cp.containerInstance();
        }
        Object result = cp.containerInstance(fieldValues.size());
        Enumeration stream = fieldValues.elements();
        while (stream.hasMoreElements()) {
            Object element = stream.nextElement();
            if (this.getValueConverter() != null) {
                element = this.getValueConverter().convertDataValueToObjectValue(element, executionSession);
            }
            cp.addInto(element, result, sourceQuery.getSession());
        }
        return result;
    }

    @Override
    public void writeFromObjectIntoRow(Object object, AbstractRecord row, AbstractSession session, DatabaseMapping.WriteType writeType) {
        if (this.isReadOnly()) {
            return;
        }
        Object attributeValue = this.getAttributeValueFromObject(object);
        if (attributeValue == null) {
            row.put(this.getField(), (Object)null);
            return;
        }
        ContainerPolicy cp = this.getContainerPolicy();
        Vector<Object> elements = new Vector<Object>(cp.sizeFor(attributeValue));
        Object iter = cp.iteratorFor(attributeValue);
        while (cp.hasNext(iter)) {
            Object element = cp.next(iter, session);
            if (this.getValueConverter() != null) {
                element = this.getValueConverter().convertObjectValueToDataValue(element, session);
            }
            if (element == null) continue;
            elements.addElement(element);
        }
        Object fieldValue = null;
        if (!elements.isEmpty()) {
            fieldValue = this.getDescriptor().buildFieldValueFromDirectValues(elements, this.elementDataTypeName, session);
        }
        row.put(this.getField(), fieldValue);
    }

    @Override
    public void writeFromObjectIntoRowForUpdate(WriteObjectQuery writeQuery, AbstractRecord row) throws DescriptorException {
        AbstractSession session = writeQuery.getSession();
        if (session.isUnitOfWork() && this.compareObjects(writeQuery.getObject(), writeQuery.getBackupClone(), session)) {
            return;
        }
        this.writeFromObjectIntoRow(writeQuery.getObject(), row, session, DatabaseMapping.WriteType.UPDATE);
    }

    @Override
    public void writeFromObjectIntoRowWithChangeRecord(ChangeRecord changeRecord, AbstractRecord row, AbstractSession session, DatabaseMapping.WriteType writeType) {
        Object object = ((ObjectChangeSet)changeRecord.getOwner()).getUnitOfWorkClone();
        this.writeFromObjectIntoRow(object, row, session, writeType);
    }

    @Override
    public void writeInsertFieldsIntoRow(AbstractRecord row, AbstractSession session) {
        if (this.isReadOnly()) {
            return;
        }
        row.put(this.getField(), (Object)null);
    }

    @Override
    public Class getFieldClassification(DatabaseField fieldToClassify) {
        return this.getAttributeElementClass();
    }

    @Override
    public boolean isCollectionMapping() {
        return true;
    }

    @Override
    public void convertClassNamesToClasses(ClassLoader classLoader) {
        super.convertClassNamesToClasses(classLoader);
        this.containerPolicy.convertClassNamesToClasses(classLoader);
        this.convertConverterClassNamesToClasses(this.valueConverter, classLoader);
    }

    @Override
    public ChangeRecord compareForChange(Object clone, Object backup, ObjectChangeSet owner, AbstractSession session) {
        return new ArrayCollectionMappingHelper(this).compareForChange(clone, backup, owner, session);
    }

    @Override
    public boolean compareObjects(Object object1, Object object2, AbstractSession session) {
        return new ArrayCollectionMappingHelper(this).compareObjects(object1, object2, session);
    }

    @Override
    public void mergeChangesIntoObject(Object target, ChangeRecord changeRecord, Object source, MergeManager mergeManager, AbstractSession targetSession) {
        new ArrayCollectionMappingHelper(this).mergeChangesIntoObject(target, changeRecord, source, mergeManager, targetSession);
    }

    @Override
    public void mergeIntoObject(Object target, boolean isTargetUnInitialized, Object source, MergeManager mergeManager, AbstractSession targetSession) {
        new ArrayCollectionMappingHelper(this).mergeIntoObject(target, isTargetUnInitialized, source, mergeManager, targetSession);
    }

    @Override
    public void simpleAddToCollectionChangeRecord(Object referenceKey, Object changeSetToAdd, ObjectChangeSet changeSet, AbstractSession session) {
        new ArrayCollectionMappingHelper(this).simpleAddToCollectionChangeRecord(referenceKey, changeSetToAdd, changeSet, session);
    }

    @Override
    public void simpleRemoveFromCollectionChangeRecord(Object referenceKey, Object changeSetToRemove, ObjectChangeSet changeSet, AbstractSession session) {
        new ArrayCollectionMappingHelper(this).simpleRemoveFromCollectionChangeRecord(referenceKey, changeSetToRemove, changeSet, session);
    }

    public Object createMapComponentFromRow(AbstractRecord dbRow, ObjectBuildingQuery query, CacheKey parentCacheKey, AbstractSession session, boolean isTargetProtected) {
        Object key = dbRow.get(this.getField());
        if (this.getValueConverter() != null) {
            key = this.getValueConverter().convertDataValueToObjectValue(key, session);
        }
        return key;
    }
}

