/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.agent.rest.master;

import es.bsc.compss.agent.RESTAgentConfig;
import es.bsc.compss.agent.rest.master.RemoteRESTAgent;
import es.bsc.compss.agent.rest.types.OrchestratorNotification;
import es.bsc.compss.agent.rest.types.RESTResult;
import es.bsc.compss.agent.rest.types.RemoteJobListener;
import es.bsc.compss.agent.rest.types.TaskProfile;
import es.bsc.compss.agent.rest.types.messages.StartApplicationRequest;
import es.bsc.compss.agent.util.RemoteJobsRegistry;
import es.bsc.compss.comm.Comm;
import es.bsc.compss.types.COMPSsNode;
import es.bsc.compss.types.TaskDescription;
import es.bsc.compss.types.annotations.parameter.DataType;
import es.bsc.compss.types.data.DataAccessId;
import es.bsc.compss.types.execution.exceptions.JobExecutionException;
import es.bsc.compss.types.implementations.Implementation;
import es.bsc.compss.types.implementations.TaskType;
import es.bsc.compss.types.implementations.definition.MethodDefinition;
import es.bsc.compss.types.job.JobEndStatus;
import es.bsc.compss.types.job.JobHistory;
import es.bsc.compss.types.job.JobImpl;
import es.bsc.compss.types.job.JobListener;
import es.bsc.compss.types.parameter.BasicTypeParameter;
import es.bsc.compss.types.parameter.DependencyParameter;
import es.bsc.compss.types.parameter.Parameter;
import es.bsc.compss.types.resources.Resource;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Response;
import java.util.Iterator;
import java.util.List;

public class RemoteRESTAgentJob
extends JobImpl<RemoteRESTAgent> {
    private static final String REST_AGENT_URL = "http://" + COMPSsNode.getMasterName() + ":" + RESTAgentConfig.localAgentPort + "/";

    public RemoteRESTAgentJob(RemoteRESTAgent executor, int taskId, TaskDescription task, Implementation impl, Resource res, JobListener listener, List<Integer> predecessors, Integer numSuccessors) {
        super(taskId, task, impl, res, listener, predecessors, numSuccessors);
    }

    public void submitJob() throws Exception {
        StartApplicationRequest sar = new StartApplicationRequest();
        RemoteRESTAgent executorNode = (RemoteRESTAgent)this.getResourceNode();
        WebTarget wt = executorNode.getTarget();
        wt = wt.path("/COMPSs/startApplication/");
        MethodDefinition mImpl = (MethodDefinition)this.impl.getDescription().getDefinition();
        String className = mImpl.getDeclaringClass();
        String methodName = mImpl.getAlternativeMethodName();
        if (methodName == null || methodName.isEmpty()) {
            methodName = this.taskParams.getName();
            mImpl.setAlternativeMethodName(this.taskParams.getName());
        }
        sar.setClassName(className);
        sar.setMethodName(methodName);
        sar.setCeiClass(null);
        sar.setProlog(this.impl.getDescription().getProlog());
        sar.setEpilog(this.impl.getDescription().getEpilog());
        List params = this.taskParams.getParameters();
        int numParams = params.size();
        boolean hasReturn = this.taskParams.getNumReturns() > 0;
        boolean hasTarget = this.taskParams.hasTargetObject();
        if (hasReturn) {
            sar.setHasResult(true);
            --numParams;
        }
        if (hasTarget) {
            Parameter param;
            DependencyParameter dPar;
            DataAccessId faId;
            String renaming = (faId = (dPar = (DependencyParameter)(param = (Parameter)params.get(--numParams))).getDataAccessId()).isWrite() ? ((DataAccessId.WritingDataAccessId)faId).getWrittenDataInstance().getRenaming() : ((DataAccessId.ReadingDataAccessId)faId).getReadDataInstance().getRenaming();
            Object target = Comm.getData((String)renaming).getValue();
            System.out.println("Target: " + target);
            throw new UnsupportedOperationException("Instance methods not supported yet.");
        }
        System.out.println("SUBMISSION[" + this.getJobId() + "] Remote Agent :" + executorNode.getName());
        System.out.println("SUBMISSION[" + this.getJobId() + "] Parameters:");
        block3: for (int parIdx = 0; parIdx < numParams; ++parIdx) {
            System.out.println("SUBMISSION[" + this.getJobId() + "]     * Parameter " + parIdx + ": ");
            Parameter param = (Parameter)params.get(parIdx);
            DataType type = param.getType();
            System.out.println("SUBMISSION[" + this.getJobId() + "]         Type " + type);
            switch (type) {
                case FILE_T: 
                case OBJECT_T: 
                case STREAM_T: 
                case EXTERNAL_STREAM_T: 
                case EXTERNAL_PSCO_T: 
                case PSCO_T: {
                    String pscoId;
                    DependencyParameter dPar = (DependencyParameter)param;
                    DataAccessId dAccId = dPar.getDataAccessId();
                    if (!dAccId.isRead()) {
                        throw new JobExecutionException("Parameter" + Integer.toString(parIdx) + " is a Write access", null);
                    }
                    String inRenaming = ((DataAccessId.ReadingDataAccessId)dAccId).getReadDataInstance().getRenaming();
                    if (inRenaming != null && (pscoId = Comm.getData((String)inRenaming).getPscoId()) != null) {
                        if (type.equals((Object)DataType.OBJECT_T)) {
                            param.setType(DataType.PSCO_T);
                        }
                        if (type.equals((Object)DataType.FILE_T)) {
                            param.setType(DataType.EXTERNAL_PSCO_T);
                        }
                        type = param.getType();
                    }
                    if (type == DataType.PSCO_T || type == DataType.EXTERNAL_PSCO_T) {
                        System.out.println("SUBMISSION[" + this.getJobId() + "]         Access " + dAccId);
                        String value = dPar.getDataTarget();
                        System.out.println("SUBMISSION[" + this.getJobId() + "]         ID " + value);
                        sar.addPersistedParameter(param.getDirection(), value);
                        continue block3;
                    }
                    throw new UnsupportedOperationException("Non-persisted DependencyParameters are not supported yet");
                }
                default: {
                    BasicTypeParameter btParB = (BasicTypeParameter)param;
                    Object value = btParB.getValue();
                    System.out.println("SUBMISSION[" + this.getJobId() + "]         Value " + value);
                    sar.addParameter(value, btParB.getDirection(), btParB.getType(), btParB.getStream(), btParB.getPrefix(), btParB.getName(), btParB.getContentType(), btParB.getWeight(), btParB.isKeepRename());
                }
            }
        }
        System.out.println("SUBMISSION[" + this.getJobId() + "] Stage in completed.");
        sar.setOrchestratorNotification(REST_AGENT_URL, OrchestratorNotification.HttpMethod.PUT, "COMPSs/endApplication/");
        Response response = wt.request("application/json").put(Entity.xml(sar), Response.class);
        if (response.getStatusInfo().getStatusCode() != 200) {
            System.out.println(response.readEntity(String.class));
            this.failed(JobEndStatus.SUBMISSION_FAILED);
        } else {
            System.out.println("SUBMISSION[" + this.getJobId() + "] Job submitted.");
            String jobId = response.readEntity(String.class);
            RemoteJobsRegistry.registerJobListener(jobId, new RemoteJobListener(){

                @Override
                public void finishedExecution(JobEndStatus endStatus, RESTResult[] results, TaskProfile profile) {
                    RemoteRESTAgentJob.this.executionStartedAt(profile.getExecutionStart());
                    RemoteRESTAgentJob.this.executionEndsAt(profile.getExecutionEnd());
                    System.out.println("SUBMISSION[" + RemoteRESTAgentJob.this.getJobId() + "] Job completed.");
                    RemoteRESTAgentJob.this.taskFinished(endStatus, results);
                }
            });
        }
    }

    public void cancelJob() throws Exception {
    }

    private void taskFinished(JobEndStatus endStatus, RESTResult[] results) {
        if (this.history == JobHistory.CANCELLED) {
            LOGGER.error("Ignoring notification since the job was cancelled");
            this.removeTmpData();
            return;
        }
        if (endStatus == JobEndStatus.OK) {
            this.completed(results);
        } else {
            this.failed(results, endStatus);
        }
    }

    private void completed(RESTResult[] results) {
        this.registerAllJobOutputs(results);
        super.completed();
    }

    private void failed(RESTResult[] results, JobEndStatus status) {
        if (this.isBeingCancelled()) {
            this.registerAllJobOutputs(results);
        } else {
            switch (this.taskParams.getOnFailure()) {
                case IGNORE: 
                case CANCEL_SUCCESSORS: {
                    this.registerAllJobOutputs(results);
                    break;
                }
                default: {
                    this.removeTmpData();
                }
            }
        }
        super.failed(status);
    }

    private void registerAllJobOutputs(RESTResult[] results) {
        List taskParams = this.getTaskParams().getParameters();
        Iterator taskParamsItr = taskParams.iterator();
        int i = 0;
        while (taskParamsItr.hasNext()) {
            RESTResult result;
            Parameter param = (Parameter)taskParamsItr.next();
            if ((result = results[i++]) == null) continue;
            this.registerParameter(param, result);
        }
    }

    private void registerParameter(Parameter param, RESTResult result) {
        if (!param.isPotentialDependency()) {
            return;
        }
        DependencyParameter dp = (DependencyParameter)param;
        String rename = this.getOutputRename((Parameter)dp);
        if (rename != null) {
            for (String rloc : result.getLocations()) {
                this.registerResultPrivateLocation(rloc, rename, this.worker);
            }
            this.notifyResultAvailability(dp, rename);
        }
    }

    public TaskType getType() {
        return TaskType.METHOD;
    }

    public String toString() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

