/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.jetty;

import jakarta.ws.rs.ProcessingException;
import jakarta.ws.rs.SeBootstrap;
import jakarta.ws.rs.core.Application;
import org.glassfish.jersey.internal.util.JdkVersion;
import org.glassfish.jersey.jetty.JettyHttpServer;
import org.glassfish.jersey.jetty.internal.LocalizationMessages;
import org.glassfish.jersey.server.JerseySeBootstrapConfiguration;
import org.glassfish.jersey.server.spi.WebServer;
import org.glassfish.jersey.server.spi.WebServerProvider;

public final class JettyHttpServerProvider
implements WebServerProvider {
    @Override
    public <T extends WebServer> T createServer(Class<T> type, Application application, SeBootstrap.Configuration configuration) {
        if (JdkVersion.getJdkVersion().getMajor() < 17) {
            throw new ProcessingException(LocalizationMessages.NOT_SUPPORTED());
        }
        return (T)(WebServerProvider.isSupportedWebServer(JettyHttpServer.class, type, configuration) ? (WebServer)type.cast(new JettyHttpServer(application, JerseySeBootstrapConfiguration.from(configuration))) : null);
    }

    @Override
    public <T extends WebServer> T createServer(Class<T> type, Class<? extends Application> applicationClass, SeBootstrap.Configuration configuration) {
        if (JdkVersion.getJdkVersion().getMajor() < 17) {
            throw new ProcessingException(LocalizationMessages.NOT_SUPPORTED());
        }
        return (T)(WebServerProvider.isSupportedWebServer(JettyHttpServer.class, type, configuration) ? (WebServer)type.cast(new JettyHttpServer(applicationClass, JerseySeBootstrapConfiguration.from(configuration))) : null);
    }
}

